/*
 * Decompiled with CFR 0.152.
 */
package com.github.jy2.commandline.picocli.member;

import com.github.jy2.commandline.picocli.Main;
import com.github.jy2.commandline.picocli.member.MemberCommand;
import com.github.jy2.commandline.picocli.member.completion.MemberNameCompletionCandidates;
import java.util.ArrayList;
import picocli.CommandLine;

@CommandLine.Command(name="info", description={"Print information about member"})
public class MemberInfoCommand
implements Runnable {
    @CommandLine.ParentCommand
    MemberCommand parent;
    @CommandLine.Parameters(index="0", description={"Name of the member"}, completionCandidates=MemberNameCompletionCandidates.class)
    String memberName;

    @Override
    public void run() {
        ArrayList list = Main.introspector.getMemberList();
        if (!list.contains(this.memberName)) {
            System.out.println("Member " + this.memberName + " does not exist");
            return;
        }
        System.out.println("Created by: " + Main.introspector.getMemberCreatedBy(this.memberName));
        list = Main.introspector.getMemberNodeList(this.memberName);
        list.sort(String::compareToIgnoreCase);
        System.out.println("List of nodes:");
        for (String s : list) {
            System.out.println("\t" + s);
        }
    }
}

