/*
 * Decompiled with CFR 0.152.
 */
package com.github.jy2.commandline.picocli.member;

import com.github.jy2.Publisher;
import com.github.jy2.commandline.picocli.Main;
import com.github.jy2.commandline.picocli.member.MemberCommand;
import com.github.jy2.commandline.picocli.member.completion.MemberNameCompletionCandidates;
import java.util.ArrayList;
import picocli.CommandLine;

@CommandLine.Command(name="kill", description={"Kill member"})
public class MemberKillCommand
implements Runnable {
    @CommandLine.ParentCommand
    MemberCommand parent;
    @CommandLine.Parameters(index="0", description={"Name of the member"}, completionCandidates=MemberNameCompletionCandidates.class)
    String memberName;

    @Override
    public void run() {
        ArrayList list = Main.introspector.getMemberList();
        if (!list.contains(this.memberName)) {
            System.out.println("Member " + this.memberName + " does not exist");
            return;
        }
        System.out.println("Killing member: " + this.memberName);
        Publisher pub = Main.di.createPublisher("/operations" + this.memberName.replace('-', '_'), String.class);
        pub.publish((Object)"kill");
    }
}

