/*
 * Decompiled with CFR 0.152.
 */
package com.github.jy2.commandline.picocli.param;

import com.github.jy2.commandline.picocli.Main;
import com.github.jy2.commandline.picocli.param.ParamCommand;
import java.util.ArrayList;
import picocli.CommandLine;

@CommandLine.Command(name="getall", description={"List parameters and their values on screen"})
public class ParamGetAllCommand
implements Runnable {
    @CommandLine.ParentCommand
    ParamCommand parent;
    @CommandLine.Option(names={"--grep"}, description={"Character sequence to be expected in parameter name"})
    String grep;

    @Override
    public void run() {
        ArrayList list = Main.di.getParameterClient().getParameterNames();
        list.sort(String::compareToIgnoreCase);
        for (String s : list) {
            if (this.grep != null && !s.contains(this.grep)) continue;
            Object paramValue = Main.di.getParameterClient().getParameter(s);
            System.out.println("\t" + s + "\t" + paramValue.toString());
        }
    }
}

