/*
 * Decompiled with CFR 0.152.
 */
package com.github.jy2.commandline.picocli.tf;

import com.github.jy2.Subscriber;
import com.github.jy2.commandline.picocli.Main;
import com.github.jy2.commandline.picocli.tf.TfCommand;
import com.github.jy2.commandline.picocli.tf.completion.TfChildOptionCompletionCandidates;
import com.github.jy2.commandline.picocli.tf.completion.TfParentOptionCompletionCandidates;
import com.github.jy2.commandline.picocli.tf.format.TfDisplayFormat;
import com.github.jy2.commandline.picocli.tf.format.TfSerializer;
import com.github.jy2.tf.mat.TfManager;
import go.jyroscope.ros.geometry_msgs.TransformStamped;
import go.jyroscope.ros.tf2_msgs.TFMessage;
import java.util.ArrayList;
import java.util.function.Consumer;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"Print list of transforms on screen"})
public class TfListCommand
implements Runnable {
    @CommandLine.ParentCommand
    TfCommand parent;
    @CommandLine.Option(names={"--parent"}, description={"Parent frame id"}, completionCandidates=TfParentOptionCompletionCandidates.class)
    String parentFrameId;
    @CommandLine.Option(names={"--child"}, description={"Child frame id"}, completionCandidates=TfChildOptionCompletionCandidates.class)
    String childFrameId;
    @CommandLine.Option(names={"--grep"}, description={"Character sequence to be expected in parent frame id or child frame id"})
    String grep;
    @CommandLine.Option(names={"--format"}, description={"Format to display the transform"})
    TfDisplayFormat format = TfDisplayFormat.rpy;
    @CommandLine.Option(names={"--waitTime"}, description={"Define how long to wait for transforms in seconds"})
    double waitTime = 1.5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        System.out.println("Pausing for " + this.waitTime + " second(s) to collect transforms");
        Subscriber subscriber = null;
        try {
            subscriber = Main.di.createSubscriber("/tf", TFMessage.class);
            final TfManager tfManager = new TfManager();
            subscriber.addMessageListener((Consumer)new Consumer<TFMessage>(){

                @Override
                public void accept(TFMessage t) {
                    try {
                        tfManager.add(t);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            });
            try {
                Thread.sleep((long)(this.waitTime * 1000.0));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            subscriber.removeAllMessageListeners();
            System.out.println("List of transforms:");
            ArrayList list = tfManager.getTransformList();
            for (TransformStamped t : list) {
                if (this.parentFrameId != null && !t.header.frameId.equals(this.parentFrameId) || this.childFrameId != null && !t.childFrameId.equals(this.childFrameId) || this.grep != null && !t.header.frameId.contains(this.grep) && !t.childFrameId.contains(this.grep)) continue;
                System.out.println("\t" + TfSerializer.serialize(t, this.format));
            }
        }
        finally {
            if (subscriber != null) {
                subscriber.removeAllMessageListeners();
            }
        }
    }
}

