/*
 * Decompiled with CFR 0.152.
 */
package com.github.jy2.commandline.picocli.tf;

import com.github.jy2.commandline.picocli.Main;
import com.github.jy2.commandline.picocli.tf.TfCommand;
import com.github.jy2.commandline.picocli.tf.completion.TfChildPositionalCompletionCandidates;
import com.github.jy2.commandline.picocli.tf.completion.TfParentPositionalCompletionCandidates;
import go.jyroscope.ros.geometry_msgs.TransformStamped;
import go.jyroscope.ros.tf2_msgs.TFMessage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.Predicate;
import picocli.CommandLine;

@CommandLine.Command(name="who", description={"List of members who publish to the topic"})
public class TfWhoCommand
implements Runnable {
    @CommandLine.ParentCommand
    TfCommand parent;
    @CommandLine.Parameters(index="0", description={"Parent frame id"}, completionCandidates=TfParentPositionalCompletionCandidates.class)
    String parentFrameId;
    @CommandLine.Parameters(index="1", description={"Child frame id"}, completionCandidates=TfChildPositionalCompletionCandidates.class)
    String childFrameId;
    @CommandLine.Option(names={"--waitTime"}, description={"Define how long to wait for transforms in seconds"})
    double waitTime = 1.5;

    @Override
    public void run() {
        System.out.println("Pausing for " + this.waitTime + " second(s) to collect transform publishers");
        Predicate<Object> predicate = msg -> {
            boolean match = false;
            TFMessage list = (TFMessage)msg;
            for (TransformStamped t : list.transforms) {
                if (!this.parentFrameId.equals(t.header.frameId) || !this.childFrameId.equals(t.childFrameId)) continue;
                match = true;
                break;
            }
            return match;
        };
        HashSet set = Main.introspector.getPublishingMembers("/tf", (long)(this.waitTime * 1000.0), predicate);
        for (String m : set) {
            System.out.println("\t" + m);
            ArrayList list2 = Main.introspector.getMemberNodeList(m);
            list2.sort(String::compareToIgnoreCase);
            for (String s2 : list2) {
                System.out.println("\t\t" + s2);
            }
        }
    }
}

