/*
 * Decompiled with CFR 0.152.
 */
package com.github.jy2.commandline.picocli.topic;

import com.github.jy2.commandline.picocli.Main;
import com.github.jy2.commandline.picocli.topic.TopicCommand;
import com.github.jy2.commandline.picocli.topic.TopicEchoCommand;
import com.github.jy2.commandline.picocli.topic.completion.TopicNameCompletionCandidates;
import go.jyroscope.ros.std_msgs.Header;
import java.lang.reflect.Field;
import java.util.function.Consumer;
import picocli.CommandLine;

@CommandLine.Command(name="delay", description={"Print delay of the message time with respect to curent time"})
public class TopicDelayCommand
implements Runnable {
    @CommandLine.ParentCommand
    TopicCommand parent;
    @CommandLine.Parameters(index="0", description={"Name of the topic"}, completionCandidates=TopicNameCompletionCandidates.class)
    String topicName;

    @Override
    public void run() {
        System.out.println("Subscribed to topic: " + this.topicName);
        System.out.println("Press Crtl-C to stop");
        Class type = Main.introspector.getTopicType(this.topicName);
        TopicEchoCommand.subscriber = Main.di.createSubscriber(this.topicName, type, 5, 50);
        TopicEchoCommand.subscriber.addMessageListener((Consumer)new Consumer<Object>(){
            private Field timeField = null;
            private Field stampField = null;
            private Field headerField = null;

            @Override
            public void accept(Object t) {
                if (this.timeField == null && this.stampField == null && this.headerField == null) {
                    if (this.timeField == null) {
                        try {
                            this.timeField = t.getClass().getDeclaredField("time");
                        }
                        catch (NoSuchFieldException | SecurityException e) {
                            System.out.println("No field \"time\" in message");
                        }
                    }
                    if (this.stampField == null) {
                        try {
                            this.stampField = t.getClass().getDeclaredField("stamp");
                        }
                        catch (NoSuchFieldException | SecurityException e) {
                            System.out.println("No field \"stamp\" in message");
                        }
                    }
                    if (this.headerField == null) {
                        try {
                            this.headerField = t.getClass().getDeclaredField("header");
                        }
                        catch (NoSuchFieldException | SecurityException e) {
                            System.out.println("No field \"header\" in message");
                        }
                    }
                }
                if (this.timeField == null && this.stampField == null && this.headerField == null) {
                    return;
                }
                double messagetimeSeconds = 0.0;
                try {
                    if (this.headerField != null) {
                        Header h = (Header)this.headerField.get(t);
                        messagetimeSeconds = h.toSeconds();
                    }
                    if (this.timeField != null) {
                        messagetimeSeconds = this.timeField.getDouble(t);
                    } else if (this.stampField != null) {
                        messagetimeSeconds = this.stampField.getDouble(t);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    System.out.println("Problem obtaining field in message");
                    return;
                }
                double nowSeconds = (double)System.currentTimeMillis() * 0.001;
                double deltaMillis = (nowSeconds - messagetimeSeconds) * 1000.0;
                System.out.printf("Message delayed by %.3fms\n", deltaMillis);
            }
        });
    }
}

