/*
 * Decompiled with CFR 0.152.
 */
package com.github.jy2.logs.console.model;

import com.github.jy2.logs.console.collections.LimitedList;
import com.github.jy2.logs.console.utils.LogStringUtils;
import go.jyroscope.ros.rosgraph_msgs.Log;
import java.util.ArrayList;

public class Place
implements Comparable<Place> {
    public String file;
    public int line;
    public LimitedList<Log> entries = new LimitedList(20);

    public synchronized void add(Log item) {
        this.entries.add(item);
    }

    public synchronized void getEntries(ArrayList<Log> out) {
        out.clear();
        for (int i = 0; i < this.entries.size(); ++i) {
            out.add(this.entries.get(i));
        }
    }

    public int getNumEntries() {
        return this.entries.size();
    }

    public Log getEntry(int i) {
        return this.entries.get(i);
    }

    @Override
    public int compareTo(Place o) {
        int i = LogStringUtils.nullSafeStringComparator(this.file, o.file);
        if (i == 0) {
            return this.line - o.line;
        }
        return i;
    }

    public String toString() {
        return this.file + ":" + this.line;
    }
}

