/*
 * Decompiled with CFR 0.152.
 */
package com.github.jy2.logs.console.utils;

import com.github.jy2.logs.console.model.Level;
import com.github.jy2.logs.console.model.Model;
import com.github.jy2.logs.console.model.Node;
import com.github.jy2.logs.console.model.Place;
import com.github.jy2.logs.console.utils.LogStringUtils;
import go.jyroscope.ros.rosgraph_msgs.Log;

public class DisplayUtils {
    public static void display(Model model, boolean fullMessage, int maxMessages) {
        int numNodes = model.getNumNodes();
        for (int i = 0; i < numNodes; ++i) {
            Node node = model.getNode(i);
            System.out.println(node.name);
            int numLevels = node.getNumLevels();
            for (int j = 0; j < numLevels; ++j) {
                Level level = node.getLevel(j);
                int numPlaces = level.getNumPlaces();
                for (int k = 0; k < numPlaces; ++k) {
                    Place place = level.getPlace(k);
                    int numEntries = place.getNumEntries();
                    if (numEntries > maxMessages) {
                        numEntries = maxMessages;
                    }
                    for (int l = 0; l < numEntries; ++l) {
                        String text;
                        String str;
                        Log entry = place.getEntry(l);
                        if (fullMessage) {
                            str = entry.msg;
                            text = "    " + LogStringUtils.pad(level.toString(), 4) + " " + place.toString() + " " + entry.function + " " + str;
                        } else {
                            str = LogStringUtils.trim(entry.msg, 100);
                            text = "    " + LogStringUtils.pad(level.toString(), 4) + " " + str;
                        }
                        System.out.println(text);
                    }
                }
            }
        }
    }
}

