/*
 * Decompiled with CFR 0.152.
 */
package wseemann.media;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;

public class Metadata {
    public static final int STRING_VAL = 1;
    public static final int INTEGER_VAL = 2;
    public static final int BOOLEAN_VAL = 3;
    public static final int LONG_VAL = 4;
    public static final int DOUBLE_VAL = 5;
    public static final int DATE_VAL = 6;
    public static final int BYTE_ARRAY_VAL = 7;
    private HashMap<String, String> mParcel;

    public boolean parse(HashMap<String, String> metadata) {
        if (metadata == null) {
            return false;
        }
        this.mParcel = metadata;
        return true;
    }

    public boolean has(String metadataId) {
        if (!this.checkMetadataId(metadataId)) {
            throw new IllegalArgumentException("Invalid key: " + metadataId);
        }
        return this.mParcel.containsKey(metadataId);
    }

    public HashMap<String, String> getAll() {
        return this.mParcel;
    }

    public String getString(String key) {
        this.checkType(key, 1);
        return String.valueOf(this.mParcel.get(key));
    }

    public int getInt(String key) {
        this.checkType(key, 2);
        return Integer.valueOf(this.mParcel.get(key));
    }

    public boolean getBoolean(String key) {
        this.checkType(key, 3);
        return Integer.valueOf(this.mParcel.get(key)) == 1;
    }

    public long getLong(String key) {
        this.checkType(key, 4);
        return Long.valueOf(this.mParcel.get(key));
    }

    public double getDouble(String key) {
        this.checkType(key, 5);
        return Double.valueOf(this.mParcel.get(key));
    }

    public byte[] getByteArray(String key) {
        this.checkType(key, 7);
        return this.mParcel.get(key).getBytes();
    }

    public Date getDate(String key) {
        this.checkType(key, 6);
        long timeSinceEpoch = Long.valueOf(this.mParcel.get(key));
        String timeZone = this.mParcel.get(key);
        if (timeZone.length() == 0) {
            return new Date(timeSinceEpoch);
        }
        TimeZone tz = TimeZone.getTimeZone(timeZone);
        Calendar cal = Calendar.getInstance(tz);
        cal.setTimeInMillis(timeSinceEpoch);
        return cal.getTime();
    }

    private boolean checkMetadataId(String val) {
        return true;
    }

    private void checkType(String key, int expectedType) {
        String type = this.mParcel.get(key);
        if (type == null) {
            throw new IllegalStateException("Wrong type " + expectedType + " but got " + type);
        }
    }
}

