/*
 * Decompiled with CFR 0.152.
 */
package com.github.wujiuye.mybatisplus.generator.engine;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.FileOutConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.FileType;
import com.baomidou.mybatisplus.generator.engine.AbstractTemplateEngine;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class AbstractExTemplateEngine
extends AbstractTemplateEngine {
    public AbstractTemplateEngine batchOutput() {
        try {
            List tableInfoList = this.getConfigBuilder().getTableInfoList();
            for (TableInfo tableInfo : tableInfoList) {
                String xmlFile;
                String mapperFile;
                String entityFile;
                String entityName;
                Map objectMap = this.getObjectMap(tableInfo);
                Map pathInfo = this.getConfigBuilder().getPathInfo();
                TemplateConfig template = this.getConfigBuilder().getTemplate();
                InjectionConfig injectionConfig = this.getConfigBuilder().getInjectionConfig();
                if (null != injectionConfig) {
                    injectionConfig.initTableMap(tableInfo);
                    objectMap.put("cfg", injectionConfig.getMap());
                    List focList = injectionConfig.getFileOutConfigList();
                    if (CollectionUtils.isNotEmpty((Collection)focList)) {
                        for (FileOutConfig foc : focList) {
                            if (!this.isCreate(FileType.OTHER, foc.outputFile(tableInfo))) continue;
                            this.writerFile(objectMap, foc.getTemplatePath(), foc.outputFile(tableInfo));
                        }
                    }
                }
                if (null != (entityName = tableInfo.getEntityName()) && null != pathInfo.get("entity_path") && this.isCreate(FileType.ENTITY, entityFile = String.format((String)pathInfo.get("entity_path") + File.separator + "%s" + this.suffixJavaOrKt(), entityName))) {
                    this.writerFile(objectMap, this.templateFilePath(template.getEntity(this.getConfigBuilder().getGlobalConfig().isKotlin())), entityFile);
                }
                if (null != tableInfo.getMapperName() && null != pathInfo.get("mapper_path") && this.isCreate(FileType.MAPPER, mapperFile = String.format((String)pathInfo.get("mapper_path") + File.separator + tableInfo.getMapperName() + this.suffixJavaOrKt(), entityName))) {
                    this.writerFile(objectMap, this.templateFilePath(template.getMapper()), mapperFile);
                }
                if (null == tableInfo.getXmlName() || null == pathInfo.get("xml_path") || !this.isCreate(FileType.XML, xmlFile = String.format((String)pathInfo.get("xml_path") + File.separator + tableInfo.getXmlName() + ".xml", entityName))) continue;
                this.writerFile(objectMap, this.templateFilePath(template.getXml()), xmlFile);
            }
        }
        catch (Exception e) {
            logger.error("\u65e0\u6cd5\u521b\u5efa\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f\uff01", (Throwable)e);
        }
        return this;
    }

    protected void writerFile(Map<String, Object> objectMap, String templatePath, String outputFile) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)templatePath)) {
            this.writer(objectMap, templatePath, outputFile);
        }
    }

    public AbstractTemplateEngine mkdirs() {
        HashSet<String> filterPackages = new HashSet<String>();
        filterPackages.add("controller_path");
        filterPackages.add("service_impl_path");
        filterPackages.add("service_path");
        this.getConfigBuilder().getPathInfo().forEach((key, value) -> {
            boolean result;
            if (filterPackages.contains(key)) {
                return;
            }
            File dir = new File((String)value);
            if (!dir.exists() && (result = dir.mkdirs())) {
                logger.debug("\u521b\u5efa\u76ee\u5f55\uff1a [" + value + "]");
            }
        });
        return this;
    }
}

