/*
 * Decompiled with CFR 0.152.
 */
package com.github.wujiuye.mybatisplus.generator.util;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.util.Properties;

public class PropertiesUtils {
    public static <T> T getPropertiesConfig(Class<T> configClass, String prefix, String filePath) throws Exception {
        ClassLoader loader = configClass.getClassLoader();
        T obj = configClass.newInstance();
        Properties properties = new Properties();
        prefix = StringUtils.isBlank((CharSequence)prefix) ? "" : prefix + ".";
        try (InputStream in = loader.getResourceAsStream(filePath);
             InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
            properties.load(reader);
            PropertiesUtils.parsingPropertiesWithType(obj, prefix, properties);
        }
        return obj;
    }

    private static void parsingPropertiesWithType(Object obj, String prefix, Properties properties) throws Exception {
        Field[] fields = obj.getClass().getDeclaredFields();
        if (fields.length == 0) {
            return;
        }
        for (Field field : fields) {
            String value;
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || Modifier.isInterface(field.getModifiers()) || Modifier.isAbstract(field.getModifiers())) continue;
            field.setAccessible(true);
            if (field.getType() == Integer.class || field.getType() == Integer.TYPE) {
                value = properties.getProperty(prefix + field.getName());
                if (value == null) continue;
                field.set(obj, Integer.valueOf(value));
                continue;
            }
            if (field.getType() == Long.class || field.getType() == Long.TYPE) {
                value = properties.getProperty(prefix + field.getName());
                if (value == null) continue;
                field.set(obj, Long.valueOf(value));
                continue;
            }
            if (field.getType() == Boolean.class || field.getType() == Boolean.TYPE) {
                value = properties.getProperty(prefix + field.getName());
                if (value == null) continue;
                field.set(obj, Boolean.valueOf(value));
                continue;
            }
            if (field.getType() == String.class) {
                value = properties.getProperty(prefix + field.getName());
                if (value == null) continue;
                field.set(obj, value);
                continue;
            }
            try {
                Object fieldValue = field.getType().newInstance();
                if (fieldValue == null) continue;
                field.set(obj, fieldValue);
                PropertiesUtils.parsingPropertiesWithType(fieldValue, prefix + field.getName() + ".", properties);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

