/*
 * Decompiled with CFR 0.152.
 */
package com.github.xabgesagtx.bots;

import com.github.xabgesagtx.bots.TelegramProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.telegram.telegrambots.meta.TelegramBotsApi;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.meta.generics.Webhook;
import org.telegram.telegrambots.updatesreceivers.DefaultBotSession;
import org.telegram.telegrambots.updatesreceivers.DefaultWebhook;

@Component
@ConditionalOnMissingBean(value={TelegramApiFactory.class})
class TelegramApiFactory {
    private static final Logger log = LoggerFactory.getLogger(TelegramApiFactory.class);
    private final TelegramProperties properties;

    TelegramBotsApi create() throws TelegramApiException {
        TelegramBotsApi result;
        if (this.properties.hasInternalUrl()) {
            log.info("Initializing API with webhook support");
            result = new TelegramBotsApi(DefaultBotSession.class, (Webhook)this.createDefaultWebhook());
        } else {
            log.info("Initializing API without webhook support");
            result = new TelegramBotsApi(DefaultBotSession.class);
        }
        return result;
    }

    private DefaultWebhook createDefaultWebhook() throws TelegramApiException {
        DefaultWebhook webhook = new DefaultWebhook();
        webhook.setInternalUrl(this.properties.getInternalUrl());
        if (this.properties.hasKeyStore()) {
            webhook.setKeyStore(this.properties.getKeyStore(), this.properties.getKeyStorePassword());
        }
        return webhook;
    }

    public TelegramApiFactory(TelegramProperties properties) {
        this.properties = properties;
    }
}

