/*
 * Decompiled with CFR 0.152.
 */
package com.github.xabgesagtx.bots;

import com.github.xabgesagtx.bots.SetWebhookBuilderFactory;
import com.github.xabgesagtx.bots.TelegramApiFactory;
import com.github.xabgesagtx.bots.TelegramBotStarter;
import com.github.xabgesagtx.bots.TelegramProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.telegram.telegrambots.meta.TelegramBotsApi;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;

@Configuration
@ConditionalOnClass(value={TelegramBotsApi.class})
@Import(value={TelegramProperties.class, TelegramApiFactory.class, SetWebhookBuilderFactory.class, TelegramBotStarter.class})
public class TelegramBotAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TelegramBotAutoConfiguration.class);
    private final TelegramApiFactory apiFactory;

    @Bean
    @ConditionalOnMissingBean
    public TelegramBotsApi telegramBotsApi() throws TelegramApiException {
        return this.apiFactory.create();
    }

    public TelegramBotAutoConfiguration(TelegramApiFactory apiFactory) {
        this.apiFactory = apiFactory;
    }
}

