/*
 * Decompiled with CFR 0.152.
 */
package com.github.xabgesagtx.bots;

import com.github.xabgesagtx.bots.TelegramProxyProperties;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.telegram.telegrambots.bots.DefaultBotOptions;

@Configuration
@ConditionalOnProperty(value={"host", "port", "type"}, prefix="telegram.proxy")
@Import(value={TelegramProxyProperties.class})
public class TelegramBotOptionsAutoConfiguration {
    private final TelegramProxyProperties properties;

    @Bean
    public DefaultBotOptions defaultBotOptions() {
        if (this.properties.hasAuthData()) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(TelegramBotOptionsAutoConfiguration.this.properties.getUser(), TelegramBotOptionsAutoConfiguration.this.properties.getPassword().toCharArray());
                }
            });
        }
        DefaultBotOptions botOptions = new DefaultBotOptions();
        botOptions.setProxyHost(this.properties.getHost());
        botOptions.setProxyPort(this.properties.getPort().intValue());
        botOptions.setProxyType(this.properties.getType());
        return botOptions;
    }

    public TelegramBotOptionsAutoConfiguration(TelegramProxyProperties properties) {
        this.properties = properties;
    }
}

