/*
 * Decompiled with CFR 0.152.
 */
package com.github.xabgesagtx.bots;

import com.github.xabgesagtx.bots.CustomizableTelegramWebhookBot;
import com.github.xabgesagtx.bots.SetWebhookBuilderFactory;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.telegram.telegrambots.bots.TelegramWebhookBot;
import org.telegram.telegrambots.meta.TelegramBotsApi;
import org.telegram.telegrambots.meta.api.methods.updates.SetWebhook;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.meta.generics.BotSession;
import org.telegram.telegrambots.meta.generics.LongPollingBot;
import org.telegram.telegrambots.meta.generics.WebhookBot;

@Component
public class TelegramBotStarter {
    private static final Logger log = LoggerFactory.getLogger(TelegramBotStarter.class);
    private final List<BotSession> sessions = new ArrayList<BotSession>();
    private final List<LongPollingBot> pollingBots;
    private final List<TelegramWebhookBot> webHookBots;
    private final TelegramBotsApi api;
    private final SetWebhookBuilderFactory setWebhookFactory;

    @PostConstruct
    public void start() {
        log.info("Starting auto config for telegram bots");
        this.pollingBots.forEach(bot -> {
            try {
                log.info("Registering polling bot: {}", (Object)bot.getBotUsername());
                this.sessions.add(this.api.registerBot(bot));
            }
            catch (TelegramApiException e) {
                log.error("Failed to register bot {} due to error", (Object)bot.getBotUsername(), (Object)e);
            }
        });
        this.webHookBots.forEach(bot -> {
            try {
                log.info("Registering web hook bot: {}", (Object)bot.getBotUsername());
                SetWebhook.SetWebhookBuilder webhookBuilder = this.setWebhookFactory.create();
                if (bot instanceof CustomizableTelegramWebhookBot) {
                    ((CustomizableTelegramWebhookBot)((Object)bot)).customizeWebHook(webhookBuilder);
                }
                this.api.registerBot((WebhookBot)bot, webhookBuilder.build());
            }
            catch (TelegramApiException e) {
                log.error("Failed to register bot {} due to error", (Object)bot.getBotUsername(), (Object)e);
            }
        });
    }

    @PreDestroy
    public void stop() {
        this.sessions.forEach(session -> {
            if (session != null) {
                session.stop();
            }
        });
    }

    public TelegramBotStarter(List<LongPollingBot> pollingBots, List<TelegramWebhookBot> webHookBots, TelegramBotsApi api, SetWebhookBuilderFactory setWebhookFactory) {
        this.pollingBots = pollingBots;
        this.webHookBots = webHookBots;
        this.api = api;
        this.setWebhookFactory = setWebhookFactory;
    }
}

