/*
 * Decompiled with CFR 0.152.
 */
package org.xguzm.pathfinding.gdxbridge;

import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.maps.MapLayer;
import com.badlogic.gdx.maps.MapProperties;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTile;
import com.badlogic.gdx.maps.tiled.TiledMapTileSets;
import com.badlogic.gdx.maps.tiled.TmxMapLoader;
import com.badlogic.gdx.utils.XmlReader;
import org.xguzm.pathfinding.gdxbridge.NavigationTiledMapLayer;
import org.xguzm.pathfinding.grid.GridCell;

public class NavTmxMapLoader
extends TmxMapLoader {
    public String navigationLayerName;
    public String navigationProperty;
    public String navigationClosedValue;

    public NavTmxMapLoader() {
        this("navigation", "walkable", "0");
    }

    public NavTmxMapLoader(FileHandleResolver resolver) {
        this(resolver, "navigation", "walkable", "0");
    }

    public NavTmxMapLoader(String navigationLayerName, String navigationProperty, String navigationClosedValue) {
        this((FileHandleResolver)new InternalFileHandleResolver(), navigationLayerName, navigationProperty, navigationClosedValue);
    }

    public NavTmxMapLoader(FileHandleResolver handler, String navigationLayerName, String navigationProperty, String navigationClosedValue) {
        super(handler);
        this.navigationLayerName = navigationLayerName;
        this.navigationProperty = navigationProperty;
        this.navigationClosedValue = navigationClosedValue;
    }

    protected void loadTileLayer(TiledMap map, XmlReader.Element element) {
        String layerName = element.getAttribute("name", null);
        if (this.navigationLayerName.equals(layerName)) {
            this.loadNavigationLayer(map, element, layerName);
        } else {
            super.loadTileLayer(map, element);
        }
    }

    private void loadNavigationLayer(TiledMap map, XmlReader.Element element, String layerName) {
        int width = element.getIntAttribute("width", 0);
        int height = element.getIntAttribute("height", 0);
        int[] ids = NavTmxMapLoader.getTileIds((XmlReader.Element)element, (int)width, (int)height);
        TiledMapTileSets tilesets = map.getTileSets();
        GridCell[][] nodes = new GridCell[width][height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int id = ids[y * width + x];
                TiledMapTile tile = tilesets.getTile(id & 0x1FFFFFFF);
                GridCell cell = new GridCell(x, height - 1 - y, false);
                if (tile != null) {
                    MapProperties tileProp = tile.getProperties();
                    String walkableProp = (String)tileProp.get(this.navigationProperty, (Object)this.navigationClosedValue, String.class);
                    cell.setWalkable(!walkableProp.equals(this.navigationClosedValue));
                }
                nodes[cell.getX()][cell.getY()] = cell;
            }
        }
        NavigationTiledMapLayer layer = new NavigationTiledMapLayer(nodes);
        layer.setName(layerName);
        layer.setVisible(false);
        XmlReader.Element properties = element.getChildByName("properties");
        if (properties != null) {
            this.loadProperties(layer.getProperties(), properties);
        }
        map.getLayers().add((MapLayer)layer);
    }
}

