/*
 * Decompiled with CFR 0.152.
 */
package org.xguzm.pathfinding.grid;

import java.util.List;
import org.xguzm.pathfinding.NavigationGraph;
import org.xguzm.pathfinding.NavigationNode;
import org.xguzm.pathfinding.PathFinder;
import org.xguzm.pathfinding.grid.NavigationGridGraphNode;
import org.xguzm.pathfinding.util.ObjectIntMap;

public class GridCell
implements NavigationGridGraphNode {
    public int x;
    public int y;
    private float f;
    private float g;
    private float h;
    private boolean isWalkable;
    private GridCell parent;
    private ObjectIntMap<Class<? extends PathFinder>> closedOnJob = new ObjectIntMap();
    private ObjectIntMap<Class<? extends PathFinder>> openedOnJob = new ObjectIntMap();
    private int index;

    public GridCell() {
    }

    public GridCell(int x, int y) {
        this(x, y, true);
    }

    public GridCell(int x, int y, boolean isWalkable) {
        this.y = y;
        this.x = x;
        this.isWalkable = isWalkable;
    }

    public GridCell(boolean isWalkable) {
        this.isWalkable = isWalkable;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean isWalkable() {
        return this.isWalkable;
    }

    @Override
    public void setWalkable(boolean isWalkable) {
        this.isWalkable = isWalkable;
    }

    @Override
    public float getF() {
        return this.f;
    }

    @Override
    public void setF(float f) {
        this.f = f;
    }

    @Override
    public float getG() {
        return this.g;
    }

    @Override
    public void setG(float g) {
        this.g = g;
    }

    @Override
    public float getH() {
        return this.h;
    }

    @Override
    public void setH(float h) {
        this.h = h;
    }

    @Override
    public NavigationNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(NavigationNode parent) {
        this.parent = (GridCell)parent;
    }

    @Override
    public int getClosedOnJob() {
        return this.getClosedOnJob(DummyFinder.class);
    }

    @Override
    public void setClosedOnJob(int closedOnJob) {
        this.setClosedOnJob(closedOnJob, DummyFinder.class);
    }

    @Override
    public int getOpenedOnJob() {
        return this.getOpenedOnJob(DummyFinder.class);
    }

    @Override
    public void setOpenedOnJob(int openedOnJob) {
        this.setOpenedOnJob(openedOnJob, DummyFinder.class);
    }

    @Override
    public int getClosedOnJob(Class<? extends PathFinder> clazz) {
        return this.closedOnJob.get(clazz, 0);
    }

    @Override
    public void setClosedOnJob(int closedOnJob, Class<? extends PathFinder> clazz) {
        this.closedOnJob.put(clazz, closedOnJob);
    }

    @Override
    public int getOpenedOnJob(Class<? extends PathFinder> clazz) {
        return this.openedOnJob.get(clazz, 0);
    }

    @Override
    public void setOpenedOnJob(int openedOnJob, Class<? extends PathFinder> clazz) {
        this.openedOnJob.put(clazz, openedOnJob);
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + "]";
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    @Override
    public void setY(int y) {
        this.y = y;
    }

    private static final class DummyFinder<T extends GridCell>
    implements PathFinder<T> {
        private DummyFinder() {
        }

        @Override
        public List<T> findPath(T startNode, T endNode, NavigationGraph<T> grid) {
            return null;
        }
    }
}

