/*
 * Decompiled with CFR 0.152.
 */
package org.xguzm.pathfinding.grid;

import java.util.ArrayList;
import java.util.List;
import org.xguzm.pathfinding.NavigationNode;
import org.xguzm.pathfinding.PathFinderOptions;
import org.xguzm.pathfinding.grid.GridCell;
import org.xguzm.pathfinding.grid.NavigationGridGraph;
import org.xguzm.pathfinding.grid.NavigationGridGraphNode;
import org.xguzm.pathfinding.grid.finders.GridFinderOptions;

public class NavigationGrid<T extends NavigationGridGraphNode>
implements NavigationGridGraph<T> {
    protected int width;
    protected int height;
    private List<T> neighbors = new ArrayList<T>();
    protected T[][] nodes;

    public NavigationGrid() {
        this(null);
    }

    @Deprecated
    public NavigationGrid(T[][] nodes) {
        this((NavigationGridGraphNode[][])nodes, false);
    }

    public NavigationGrid(T[][] nodes, boolean autoAssignXY) {
        this.setNodes((NavigationGridGraphNode[][])nodes, autoAssignXY);
    }

    @Override
    public T getCell(int x, int y) {
        return this.contains(x, y) ? (T)this.nodes[x][y] : null;
    }

    @Override
    public void setCell(int x, int y, T cell) {
        if (this.contains(x, y)) {
            this.nodes[x][y] = cell;
        }
    }

    @Override
    public boolean isWalkable(int x, int y) {
        return this.contains(x, y) && this.nodes[x][y].isWalkable();
    }

    @Override
    public boolean contains(int x, int y) {
        return x >= 0 && x < this.width && y >= 0 && y < this.height;
    }

    @Override
    public void setWalkable(int x, int y, boolean walkable) {
        this.nodes[x][y].setWalkable(walkable);
    }

    @Override
    public List<T> getNeighbors(T cell) {
        return null;
    }

    @Override
    public List<T> getNeighbors(T node, PathFinderOptions opt) {
        GridFinderOptions options = (GridFinderOptions)opt;
        boolean allowDiagonal = options.allowDiagonal;
        boolean dontCrossCorners = options.dontCrossCorners;
        int yDir = options.isYDown ? -1 : 1;
        int x = node.getX();
        int y = node.getY();
        this.neighbors.clear();
        boolean s0 = false;
        boolean d0 = false;
        boolean s1 = false;
        boolean d1 = false;
        boolean s2 = false;
        boolean d2 = false;
        boolean s3 = false;
        boolean d3 = false;
        if (this.isWalkable(x, y + yDir)) {
            this.neighbors.add(this.nodes[x][y + yDir]);
            s0 = true;
        }
        if (this.isWalkable(x + 1, y)) {
            this.neighbors.add(this.nodes[x + 1][y]);
            s1 = true;
        }
        if (this.isWalkable(x, y - yDir)) {
            this.neighbors.add(this.nodes[x][y - yDir]);
            s2 = true;
        }
        if (this.isWalkable(x - 1, y)) {
            this.neighbors.add(this.nodes[x - 1][y]);
            s3 = true;
        }
        if (!allowDiagonal) {
            return this.neighbors;
        }
        if (dontCrossCorners) {
            d0 = s3 && s0;
            d1 = s0 && s1;
            d2 = s1 && s2;
            d3 = s2 && s3;
        } else {
            d0 = s3 || s0;
            d1 = s0 || s1;
            d2 = s1 || s2;
            boolean bl = d3 = s2 || s3;
        }
        if (d0 && this.isWalkable(x - 1, y + yDir)) {
            this.neighbors.add(this.nodes[x - 1][y + yDir]);
        }
        if (d1 && this.isWalkable(x + 1, y + yDir)) {
            this.neighbors.add(this.nodes[x + 1][y + yDir]);
        }
        if (d2 && this.isWalkable(x + 1, y - yDir)) {
            this.neighbors.add(this.nodes[x + 1][y - yDir]);
        }
        if (d3 && this.isWalkable(x - 1, y - yDir)) {
            this.neighbors.add(this.nodes[x - 1][y - yDir]);
        }
        return this.neighbors;
    }

    @Override
    public float getMovementCost(T node1, T node2, PathFinderOptions opt) {
        if (node1 == node2) {
            return 0.0f;
        }
        GridFinderOptions options = (GridFinderOptions)opt;
        GridCell cell1 = (GridCell)node1;
        GridCell cell2 = (GridCell)node2;
        return cell1.x == cell2.x || cell1.y == cell2.y ? options.orthogonalMovementCost : options.diagonalMovementCost;
    }

    @Override
    public boolean isWalkable(T node) {
        GridCell c = (GridCell)node;
        return this.isWalkable(c.x, c.y);
    }

    @Override
    public T[][] getNodes() {
        return this.nodes;
    }

    @Override
    public void setNodes(T[][] nodes) {
        this.setNodes((NavigationGridGraphNode[][])nodes, true);
    }

    public void setNodes(T[][] nodes, boolean autoAssignXY) {
        if (nodes != null) {
            this.width = nodes.length;
            this.height = nodes[0].length;
            if (autoAssignXY) {
                for (int x = 0; x < this.width; ++x) {
                    for (int y = 0; y < this.height; ++y) {
                        nodes[x][y].setX(x);
                        nodes[x][y].setY(y);
                    }
                }
            }
        } else {
            this.width = 0;
            this.height = 0;
        }
        this.nodes = nodes;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public boolean lineOfSight(NavigationNode from, NavigationNode to) {
        if (from == null || to == null) {
            return false;
        }
        NavigationGridGraphNode node = (NavigationGridGraphNode)from;
        NavigationGridGraphNode neigh = (NavigationGridGraphNode)to;
        int x1 = node.getX();
        int y1 = node.getY();
        int x2 = neigh.getX();
        int y2 = neigh.getY();
        int dx = Math.abs(x1 - x2);
        int dy = Math.abs(y1 - y2);
        int xinc = x1 < x2 ? 1 : -1;
        int yinc = y1 < y2 ? 1 : -1;
        int error = dx - dy;
        for (int n = dx + dy; n > 0; --n) {
            if (!this.isWalkable(x1, y1)) {
                return false;
            }
            int e2 = 2 * error;
            if (e2 > -dy) {
                error -= dy;
                x1 += xinc;
            }
            if (e2 >= dx) continue;
            error += dx;
            y1 += yinc;
        }
        return true;
    }
}

