/*
 * Accounting API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * OpenAPI spec version: 2.0.0
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.xero.models.accounting;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.models.accounting.Account;
import com.xero.models.accounting.Contact;
import com.xero.models.accounting.CurrencyCode;
import com.xero.models.accounting.LineAmountTypes;
import com.xero.models.accounting.LineItem;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

/**
 * BankTransaction
 */

public class BankTransaction {
  /**
   * See Bank Transaction Types
   */
  public enum TypeEnum {
    RECEIVE("RECEIVE"),
    
    RECEIVE_OVERPAYMENT("RECEIVE-OVERPAYMENT"),
    
    RECEIVE_PREPAYMENT("RECEIVE-PREPAYMENT"),
    
    SPEND("SPEND"),
    
    SPEND_OVERPAYMENT("SPEND-OVERPAYMENT"),
    
    SPEND_PREPAYMENT("SPEND-PREPAYMENT"),
    
    RECEIVE_TRANSFER("RECEIVE-TRANSFER"),
    
    SPEND_TRANSFER("SPEND-TRANSFER");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String text) {
      for (TypeEnum b : TypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + text + "'");
    }
  }

  
  @JsonProperty("Type")
  private TypeEnum type;

  
  @JsonProperty("Contact")
  private Contact contact = null;

  
  @JsonProperty("Lineitems")
  private List<LineItem> lineitems = new ArrayList<LineItem>();

  
  @JsonProperty("BankAccount")
  private Account bankAccount = null;

  
  @JsonProperty("IsReconciled")
  private Boolean isReconciled;

  @JsonDeserialize(using = com.xero.api.CustomDateDeserializer.class)
  @JsonProperty("Date")
  private LocalDate date;

  
  @JsonProperty("Reference")
  private String reference;

  
  @JsonProperty("CurrencyCode")
  private CurrencyCode currencyCode = null;

  
  @JsonProperty("CurrencyRate")
  private Float currencyRate;

  
  @JsonProperty("Url")
  private String url;

  /**
   * See Bank Transaction Status Codes
   */
  public enum StatusEnum {
    AUTHORISED("AUTHORISED"),
    
    DELETED("DELETED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String text) {
      for (StatusEnum b : StatusEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + text + "'");
    }
  }

  
  @JsonProperty("Status")
  private StatusEnum status;

  
  @JsonProperty("LineAmountTypes")
  private LineAmountTypes lineAmountTypes = null;

  
  @JsonProperty("SubTotal")
  private Float subTotal;

  
  @JsonProperty("TotalTax")
  private Float totalTax;

  
  @JsonProperty("Total")
  private Float total;

  
  @JsonProperty("BankTransactionID")
  private UUID bankTransactionID;

  
  @JsonProperty("PrepaymentID")
  private UUID prepaymentID;

  
  @JsonProperty("OverpaymentID")
  private UUID overpaymentID;

  @JsonDeserialize(using = com.xero.api.CustomOffsetDateTimeDeserializer.class)
  @JsonProperty("UpdatedDateUTC")
  private OffsetDateTime updatedDateUTC;

  
  @JsonProperty("HasAttachments")
  private Boolean hasAttachments;

  public BankTransaction type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * See Bank Transaction Types
   * @return type
  **/
  @ApiModelProperty(required = true, value = "See Bank Transaction Types")
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  public BankTransaction contact(Contact contact) {
    this.contact = contact;
    return this;
  }

   /**
   * Get contact
   * @return contact
  **/
  @ApiModelProperty(required = true, value = "")
  public Contact getContact() {
    return contact;
  }

  public void setContact(Contact contact) {
    this.contact = contact;
  }

  public BankTransaction lineitems(List<LineItem> lineitems) {
    this.lineitems = lineitems;
    return this;
  }

  public BankTransaction addLineitemsItem(LineItem lineitemsItem) {
    this.lineitems.add(lineitemsItem);
    return this;
  }

   /**
   * See LineItems
   * @return lineitems
  **/
  @ApiModelProperty(required = true, value = "See LineItems")
  public List<LineItem> getLineitems() {
    return lineitems;
  }

  public void setLineitems(List<LineItem> lineitems) {
    this.lineitems = lineitems;
  }

  public BankTransaction bankAccount(Account bankAccount) {
    this.bankAccount = bankAccount;
    return this;
  }

   /**
   * Get bankAccount
   * @return bankAccount
  **/
  @ApiModelProperty(required = true, value = "")
  public Account getBankAccount() {
    return bankAccount;
  }

  public void setBankAccount(Account bankAccount) {
    this.bankAccount = bankAccount;
  }

  public BankTransaction isReconciled(Boolean isReconciled) {
    this.isReconciled = isReconciled;
    return this;
  }

   /**
   * Boolean to show if transaction is reconciled
   * @return isReconciled
  **/
  @ApiModelProperty(value = "Boolean to show if transaction is reconciled")
  public Boolean getIsReconciled() {
    return isReconciled;
  }

  public void setIsReconciled(Boolean isReconciled) {
    this.isReconciled = isReconciled;
  }

  public BankTransaction date(LocalDate date) {
    this.date = date;
    return this;
  }

   /**
   * Date of transaction – YYYY-MM-DD
   * @return date
  **/
  @ApiModelProperty(value = "Date of transaction – YYYY-MM-DD")
  public LocalDate getDate() {
    return date;
  }

  public void setDate(LocalDate date) {
    this.date = date;
  }

  public BankTransaction reference(String reference) {
    this.reference = reference;
    return this;
  }

   /**
   * Reference for the transaction. Only supported for SPEND and RECEIVE transactions.
   * @return reference
  **/
  @ApiModelProperty(value = "Reference for the transaction. Only supported for SPEND and RECEIVE transactions.")
  public String getReference() {
    return reference;
  }

  public void setReference(String reference) {
    this.reference = reference;
  }

  public BankTransaction currencyCode(CurrencyCode currencyCode) {
    this.currencyCode = currencyCode;
    return this;
  }

   /**
   * Get currencyCode
   * @return currencyCode
  **/
  @ApiModelProperty(value = "")
  public CurrencyCode getCurrencyCode() {
    return currencyCode;
  }

  public void setCurrencyCode(CurrencyCode currencyCode) {
    this.currencyCode = currencyCode;
  }

  public BankTransaction currencyRate(Float currencyRate) {
    this.currencyRate = currencyRate;
    return this;
  }

   /**
   * Exchange rate to base currency when money is spent or received. e.g.0.7500 Only used for bank transactions in non base currency. If this isn’t specified for non base currency accounts then either the user-defined rate (preference) or the XE.com day rate will be used. Setting currency is only supported on overpayments.
   * @return currencyRate
  **/
  @ApiModelProperty(value = "Exchange rate to base currency when money is spent or received. e.g.0.7500 Only used for bank transactions in non base currency. If this isn’t specified for non base currency accounts then either the user-defined rate (preference) or the XE.com day rate will be used. Setting currency is only supported on overpayments.")
  public Float getCurrencyRate() {
    return currencyRate;
  }

  public void setCurrencyRate(Float currencyRate) {
    this.currencyRate = currencyRate;
  }

  public BankTransaction url(String url) {
    this.url = url;
    return this;
  }

   /**
   * URL link to a source document – shown as “Go to App Name”
   * @return url
  **/
  @ApiModelProperty(value = "URL link to a source document – shown as “Go to App Name”")
  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }

  public BankTransaction status(StatusEnum status) {
    this.status = status;
    return this;
  }

   /**
   * See Bank Transaction Status Codes
   * @return status
  **/
  @ApiModelProperty(value = "See Bank Transaction Status Codes")
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public BankTransaction lineAmountTypes(LineAmountTypes lineAmountTypes) {
    this.lineAmountTypes = lineAmountTypes;
    return this;
  }

   /**
   * Get lineAmountTypes
   * @return lineAmountTypes
  **/
  @ApiModelProperty(value = "")
  public LineAmountTypes getLineAmountTypes() {
    return lineAmountTypes;
  }

  public void setLineAmountTypes(LineAmountTypes lineAmountTypes) {
    this.lineAmountTypes = lineAmountTypes;
  }

  public BankTransaction subTotal(Float subTotal) {
    this.subTotal = subTotal;
    return this;
  }

   /**
   * Total of bank transaction excluding taxes
   * @return subTotal
  **/
  @ApiModelProperty(value = "Total of bank transaction excluding taxes")
  public Float getSubTotal() {
    return subTotal;
  }

  public void setSubTotal(Float subTotal) {
    this.subTotal = subTotal;
  }

  public BankTransaction totalTax(Float totalTax) {
    this.totalTax = totalTax;
    return this;
  }

   /**
   * Total tax on bank transaction
   * @return totalTax
  **/
  @ApiModelProperty(value = "Total tax on bank transaction")
  public Float getTotalTax() {
    return totalTax;
  }

  public void setTotalTax(Float totalTax) {
    this.totalTax = totalTax;
  }

  public BankTransaction total(Float total) {
    this.total = total;
    return this;
  }

   /**
   * Total of bank transaction tax inclusive
   * @return total
  **/
  @ApiModelProperty(value = "Total of bank transaction tax inclusive")
  public Float getTotal() {
    return total;
  }

  public void setTotal(Float total) {
    this.total = total;
  }

  public BankTransaction bankTransactionID(UUID bankTransactionID) {
    this.bankTransactionID = bankTransactionID;
    return this;
  }

   /**
   * Xero generated unique identifier for bank transaction
   * @return bankTransactionID
  **/
  @ApiModelProperty(value = "Xero generated unique identifier for bank transaction")
  public UUID getBankTransactionID() {
    return bankTransactionID;
  }

  public void setBankTransactionID(UUID bankTransactionID) {
    this.bankTransactionID = bankTransactionID;
  }

   /**
   * Xero generated unique identifier for a Prepayment. This will be returned on BankTransactions with a Type of SPEND-PREPAYMENT or RECEIVE-PREPAYMENT
   * @return prepaymentID
  **/
  @ApiModelProperty(value = "Xero generated unique identifier for a Prepayment. This will be returned on BankTransactions with a Type of SPEND-PREPAYMENT or RECEIVE-PREPAYMENT")
  public UUID getPrepaymentID() {
    return prepaymentID;
  }

   /**
   * Xero generated unique identifier for an Overpayment. This will be returned on BankTransactions with a Type of SPEND-OVERPAYMENT or RECEIVE-OVERPAYMENT
   * @return overpaymentID
  **/
  @ApiModelProperty(value = "Xero generated unique identifier for an Overpayment. This will be returned on BankTransactions with a Type of SPEND-OVERPAYMENT or RECEIVE-OVERPAYMENT")
  public UUID getOverpaymentID() {
    return overpaymentID;
  }

   /**
   * Last modified date UTC format
   * @return updatedDateUTC
  **/
  @ApiModelProperty(value = "Last modified date UTC format")
  public OffsetDateTime getUpdatedDateUTC() {
    return updatedDateUTC;
  }

   /**
   * Boolean to indicate if a bank transaction has an attachment
   * @return hasAttachments
  **/
  @ApiModelProperty(value = "Boolean to indicate if a bank transaction has an attachment")
  public Boolean getHasAttachments() {
    return hasAttachments;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BankTransaction bankTransaction = (BankTransaction) o;
    return Objects.equals(this.type, bankTransaction.type) &&
        Objects.equals(this.contact, bankTransaction.contact) &&
        Objects.equals(this.lineitems, bankTransaction.lineitems) &&
        Objects.equals(this.bankAccount, bankTransaction.bankAccount) &&
        Objects.equals(this.isReconciled, bankTransaction.isReconciled) &&
        Objects.equals(this.date, bankTransaction.date) &&
        Objects.equals(this.reference, bankTransaction.reference) &&
        Objects.equals(this.currencyCode, bankTransaction.currencyCode) &&
        Objects.equals(this.currencyRate, bankTransaction.currencyRate) &&
        Objects.equals(this.url, bankTransaction.url) &&
        Objects.equals(this.status, bankTransaction.status) &&
        Objects.equals(this.lineAmountTypes, bankTransaction.lineAmountTypes) &&
        Objects.equals(this.subTotal, bankTransaction.subTotal) &&
        Objects.equals(this.totalTax, bankTransaction.totalTax) &&
        Objects.equals(this.total, bankTransaction.total) &&
        Objects.equals(this.bankTransactionID, bankTransaction.bankTransactionID) &&
        Objects.equals(this.prepaymentID, bankTransaction.prepaymentID) &&
        Objects.equals(this.overpaymentID, bankTransaction.overpaymentID) &&
        Objects.equals(this.updatedDateUTC, bankTransaction.updatedDateUTC) &&
        Objects.equals(this.hasAttachments, bankTransaction.hasAttachments);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, contact, lineitems, bankAccount, isReconciled, date, reference, currencyCode, currencyRate, url, status, lineAmountTypes, subTotal, totalTax, total, bankTransactionID, prepaymentID, overpaymentID, updatedDateUTC, hasAttachments);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BankTransaction {\n");
    
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    contact: ").append(toIndentedString(contact)).append("\n");
    sb.append("    lineitems: ").append(toIndentedString(lineitems)).append("\n");
    sb.append("    bankAccount: ").append(toIndentedString(bankAccount)).append("\n");
    sb.append("    isReconciled: ").append(toIndentedString(isReconciled)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    currencyRate: ").append(toIndentedString(currencyRate)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    lineAmountTypes: ").append(toIndentedString(lineAmountTypes)).append("\n");
    sb.append("    subTotal: ").append(toIndentedString(subTotal)).append("\n");
    sb.append("    totalTax: ").append(toIndentedString(totalTax)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    bankTransactionID: ").append(toIndentedString(bankTransactionID)).append("\n");
    sb.append("    prepaymentID: ").append(toIndentedString(prepaymentID)).append("\n");
    sb.append("    overpaymentID: ").append(toIndentedString(overpaymentID)).append("\n");
    sb.append("    updatedDateUTC: ").append(toIndentedString(updatedDateUTC)).append("\n");
    sb.append("    hasAttachments: ").append(toIndentedString(hasAttachments)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

