/*
 * Accounting API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * OpenAPI spec version: 2.0.0
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.xero.models.accounting;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.models.accounting.LineAmountTypes;
import com.xero.models.accounting.ManualJournalLine;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

/**
 * ManualJournal
 */

public class ManualJournal {
  
  @JsonProperty("Narration")
  private String narration;

  
  @JsonProperty("JournalLines")
  private List<ManualJournalLine> journalLines = new ArrayList<ManualJournalLine>();

  @JsonDeserialize(using = com.xero.api.CustomDateDeserializer.class)
  @JsonProperty("Date")
  private LocalDate date;

  
  @JsonProperty("LineAmountTypes")
  private LineAmountTypes lineAmountTypes = null;

  /**
   * See Manual Journal Status Codes
   */
  public enum StatusEnum {
    DRAFT("DRAFT"),
    
    POSTED("POSTED"),
    
    DELETED("DELETED"),
    
    VOIDED("VOIDED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String text) {
      for (StatusEnum b : StatusEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + text + "'");
    }
  }

  
  @JsonProperty("Status")
  private StatusEnum status;

  
  @JsonProperty("Url")
  private String url;

  
  @JsonProperty("ShowOnCashBasisReports")
  private Boolean showOnCashBasisReports;

  
  @JsonProperty("HasAttachments")
  private Boolean hasAttachments;

  @JsonDeserialize(using = com.xero.api.CustomOffsetDateTimeDeserializer.class)
  @JsonProperty("UpdatedDateUTC")
  private OffsetDateTime updatedDateUTC;

  
  @JsonProperty("ManualJournalID")
  private UUID manualJournalID;

  public ManualJournal narration(String narration) {
    this.narration = narration;
    return this;
  }

   /**
   * Description of journal being posted
   * @return narration
  **/
  @ApiModelProperty(required = true, value = "Description of journal being posted")
  public String getNarration() {
    return narration;
  }

  public void setNarration(String narration) {
    this.narration = narration;
  }

  public ManualJournal journalLines(List<ManualJournalLine> journalLines) {
    this.journalLines = journalLines;
    return this;
  }

  public ManualJournal addJournalLinesItem(ManualJournalLine journalLinesItem) {
    this.journalLines.add(journalLinesItem);
    return this;
  }

   /**
   * See JournalLines
   * @return journalLines
  **/
  @ApiModelProperty(required = true, value = "See JournalLines")
  public List<ManualJournalLine> getJournalLines() {
    return journalLines;
  }

  public void setJournalLines(List<ManualJournalLine> journalLines) {
    this.journalLines = journalLines;
  }

  public ManualJournal date(LocalDate date) {
    this.date = date;
    return this;
  }

   /**
   * Date journal was posted – YYYY-MM-DD
   * @return date
  **/
  @ApiModelProperty(value = "Date journal was posted – YYYY-MM-DD")
  public LocalDate getDate() {
    return date;
  }

  public void setDate(LocalDate date) {
    this.date = date;
  }

  public ManualJournal lineAmountTypes(LineAmountTypes lineAmountTypes) {
    this.lineAmountTypes = lineAmountTypes;
    return this;
  }

   /**
   * Get lineAmountTypes
   * @return lineAmountTypes
  **/
  @ApiModelProperty(value = "")
  public LineAmountTypes getLineAmountTypes() {
    return lineAmountTypes;
  }

  public void setLineAmountTypes(LineAmountTypes lineAmountTypes) {
    this.lineAmountTypes = lineAmountTypes;
  }

  public ManualJournal status(StatusEnum status) {
    this.status = status;
    return this;
  }

   /**
   * See Manual Journal Status Codes
   * @return status
  **/
  @ApiModelProperty(value = "See Manual Journal Status Codes")
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public ManualJournal url(String url) {
    this.url = url;
    return this;
  }

   /**
   * Url link to a source document – shown as “Go to [appName]” in the Xero app
   * @return url
  **/
  @ApiModelProperty(value = "Url link to a source document – shown as “Go to [appName]” in the Xero app")
  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }

  public ManualJournal showOnCashBasisReports(Boolean showOnCashBasisReports) {
    this.showOnCashBasisReports = showOnCashBasisReports;
    return this;
  }

   /**
   * Boolean – default is true if not specified
   * @return showOnCashBasisReports
  **/
  @ApiModelProperty(value = "Boolean – default is true if not specified")
  public Boolean getShowOnCashBasisReports() {
    return showOnCashBasisReports;
  }

  public void setShowOnCashBasisReports(Boolean showOnCashBasisReports) {
    this.showOnCashBasisReports = showOnCashBasisReports;
  }

   /**
   * Boolean to indicate if a manual journal has an attachment
   * @return hasAttachments
  **/
  @ApiModelProperty(value = "Boolean to indicate if a manual journal has an attachment")
  public Boolean getHasAttachments() {
    return hasAttachments;
  }

   /**
   * Last modified date UTC format
   * @return updatedDateUTC
  **/
  @ApiModelProperty(value = "Last modified date UTC format")
  public OffsetDateTime getUpdatedDateUTC() {
    return updatedDateUTC;
  }

  public ManualJournal manualJournalID(UUID manualJournalID) {
    this.manualJournalID = manualJournalID;
    return this;
  }

   /**
   * The Xero identifier for a Manual Journal
   * @return manualJournalID
  **/
  @ApiModelProperty(value = "The Xero identifier for a Manual Journal")
  public UUID getManualJournalID() {
    return manualJournalID;
  }

  public void setManualJournalID(UUID manualJournalID) {
    this.manualJournalID = manualJournalID;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ManualJournal manualJournal = (ManualJournal) o;
    return Objects.equals(this.narration, manualJournal.narration) &&
        Objects.equals(this.journalLines, manualJournal.journalLines) &&
        Objects.equals(this.date, manualJournal.date) &&
        Objects.equals(this.lineAmountTypes, manualJournal.lineAmountTypes) &&
        Objects.equals(this.status, manualJournal.status) &&
        Objects.equals(this.url, manualJournal.url) &&
        Objects.equals(this.showOnCashBasisReports, manualJournal.showOnCashBasisReports) &&
        Objects.equals(this.hasAttachments, manualJournal.hasAttachments) &&
        Objects.equals(this.updatedDateUTC, manualJournal.updatedDateUTC) &&
        Objects.equals(this.manualJournalID, manualJournal.manualJournalID);
  }

  @Override
  public int hashCode() {
    return Objects.hash(narration, journalLines, date, lineAmountTypes, status, url, showOnCashBasisReports, hasAttachments, updatedDateUTC, manualJournalID);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ManualJournal {\n");
    
    sb.append("    narration: ").append(toIndentedString(narration)).append("\n");
    sb.append("    journalLines: ").append(toIndentedString(journalLines)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    lineAmountTypes: ").append(toIndentedString(lineAmountTypes)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    showOnCashBasisReports: ").append(toIndentedString(showOnCashBasisReports)).append("\n");
    sb.append("    hasAttachments: ").append(toIndentedString(hasAttachments)).append("\n");
    sb.append("    updatedDateUTC: ").append(toIndentedString(updatedDateUTC)).append("\n");
    sb.append("    manualJournalID: ").append(toIndentedString(manualJournalID)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

