/*
 * Accounting API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * OpenAPI spec version: 2.0.0
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.xero.models.accounting;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.models.accounting.Allocation;
import com.xero.models.accounting.Contact;
import com.xero.models.accounting.CurrencyCode;
import com.xero.models.accounting.LineAmountTypes;
import com.xero.models.accounting.LineItem;
import com.xero.models.accounting.Payment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

/**
 * Overpayment
 */

public class Overpayment {
  /**
   * See Overpayment Types
   */
  public enum TypeEnum {
    RECEIVE_OVERPAYMENT("RECEIVE-OVERPAYMENT"),
    
    SPEND_OVERPAYMENT("SPEND-OVERPAYMENT");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String text) {
      for (TypeEnum b : TypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + text + "'");
    }
  }

  
  @JsonProperty("Type")
  private TypeEnum type;

  
  @JsonProperty("Contact")
  private Contact contact = null;

  @JsonDeserialize(using = com.xero.api.CustomDateDeserializer.class)
  @JsonProperty("Date")
  private LocalDate date;

  /**
   * See Overpayment Status Codes
   */
  public enum StatusEnum {
    AUTHORISED("AUTHORISED"),
    
    PAID("PAID"),
    
    VOIDED("VOIDED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String text) {
      for (StatusEnum b : StatusEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + text + "'");
    }
  }

  
  @JsonProperty("Status")
  private StatusEnum status;

  
  @JsonProperty("LineAmountTypes")
  private LineAmountTypes lineAmountTypes = null;

  
  @JsonProperty("LineItems")
  private List<LineItem> lineItems = null;

  
  @JsonProperty("SubTotal")
  private Float subTotal;

  
  @JsonProperty("TotalTax")
  private Float totalTax;

  
  @JsonProperty("Total")
  private Float total;

  @JsonDeserialize(using = com.xero.api.CustomOffsetDateTimeDeserializer.class)
  @JsonProperty("UpdatedDateUTC")
  private OffsetDateTime updatedDateUTC;

  
  @JsonProperty("CurrencyCode")
  private CurrencyCode currencyCode = null;

  
  @JsonProperty("OverpaymentID")
  private UUID overpaymentID;

  
  @JsonProperty("CurrencyRate")
  private Float currencyRate;

  
  @JsonProperty("RemainingCredit")
  private String remainingCredit;

  
  @JsonProperty("Allocations")
  private List<Allocation> allocations = null;

  
  @JsonProperty("Payments")
  private List<Payment> payments = null;

  
  @JsonProperty("HasAttachments")
  private Boolean hasAttachments;

  public Overpayment type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * See Overpayment Types
   * @return type
  **/
  @ApiModelProperty(value = "See Overpayment Types")
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  public Overpayment contact(Contact contact) {
    this.contact = contact;
    return this;
  }

   /**
   * Get contact
   * @return contact
  **/
  @ApiModelProperty(value = "")
  public Contact getContact() {
    return contact;
  }

  public void setContact(Contact contact) {
    this.contact = contact;
  }

  public Overpayment date(LocalDate date) {
    this.date = date;
    return this;
  }

   /**
   * The date the overpayment is created YYYY-MM-DD
   * @return date
  **/
  @ApiModelProperty(value = "The date the overpayment is created YYYY-MM-DD")
  public LocalDate getDate() {
    return date;
  }

  public void setDate(LocalDate date) {
    this.date = date;
  }

  public Overpayment status(StatusEnum status) {
    this.status = status;
    return this;
  }

   /**
   * See Overpayment Status Codes
   * @return status
  **/
  @ApiModelProperty(value = "See Overpayment Status Codes")
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public Overpayment lineAmountTypes(LineAmountTypes lineAmountTypes) {
    this.lineAmountTypes = lineAmountTypes;
    return this;
  }

   /**
   * Get lineAmountTypes
   * @return lineAmountTypes
  **/
  @ApiModelProperty(value = "")
  public LineAmountTypes getLineAmountTypes() {
    return lineAmountTypes;
  }

  public void setLineAmountTypes(LineAmountTypes lineAmountTypes) {
    this.lineAmountTypes = lineAmountTypes;
  }

  public Overpayment lineItems(List<LineItem> lineItems) {
    this.lineItems = lineItems;
    return this;
  }

  public Overpayment addLineItemsItem(LineItem lineItemsItem) {
    if (this.lineItems == null) {
      this.lineItems = new ArrayList<LineItem>();
    }
    this.lineItems.add(lineItemsItem);
    return this;
  }

   /**
   * See Overpayment Line Items
   * @return lineItems
  **/
  @ApiModelProperty(value = "See Overpayment Line Items")
  public List<LineItem> getLineItems() {
    return lineItems;
  }

  public void setLineItems(List<LineItem> lineItems) {
    this.lineItems = lineItems;
  }

  public Overpayment subTotal(Float subTotal) {
    this.subTotal = subTotal;
    return this;
  }

   /**
   * The subtotal of the overpayment excluding taxes
   * @return subTotal
  **/
  @ApiModelProperty(value = "The subtotal of the overpayment excluding taxes")
  public Float getSubTotal() {
    return subTotal;
  }

  public void setSubTotal(Float subTotal) {
    this.subTotal = subTotal;
  }

  public Overpayment totalTax(Float totalTax) {
    this.totalTax = totalTax;
    return this;
  }

   /**
   * The total tax on the overpayment
   * @return totalTax
  **/
  @ApiModelProperty(value = "The total tax on the overpayment")
  public Float getTotalTax() {
    return totalTax;
  }

  public void setTotalTax(Float totalTax) {
    this.totalTax = totalTax;
  }

  public Overpayment total(Float total) {
    this.total = total;
    return this;
  }

   /**
   * The total of the overpayment (subtotal + total tax)
   * @return total
  **/
  @ApiModelProperty(value = "The total of the overpayment (subtotal + total tax)")
  public Float getTotal() {
    return total;
  }

  public void setTotal(Float total) {
    this.total = total;
  }

  public Overpayment updatedDateUTC(OffsetDateTime updatedDateUTC) {
    this.updatedDateUTC = updatedDateUTC;
    return this;
  }

   /**
   * UTC timestamp of last update to the overpayment
   * @return updatedDateUTC
  **/
  @ApiModelProperty(value = "UTC timestamp of last update to the overpayment")
  public OffsetDateTime getUpdatedDateUTC() {
    return updatedDateUTC;
  }

  public void setUpdatedDateUTC(OffsetDateTime updatedDateUTC) {
    this.updatedDateUTC = updatedDateUTC;
  }

  public Overpayment currencyCode(CurrencyCode currencyCode) {
    this.currencyCode = currencyCode;
    return this;
  }

   /**
   * Get currencyCode
   * @return currencyCode
  **/
  @ApiModelProperty(value = "")
  public CurrencyCode getCurrencyCode() {
    return currencyCode;
  }

  public void setCurrencyCode(CurrencyCode currencyCode) {
    this.currencyCode = currencyCode;
  }

  public Overpayment overpaymentID(UUID overpaymentID) {
    this.overpaymentID = overpaymentID;
    return this;
  }

   /**
   * Xero generated unique identifier
   * @return overpaymentID
  **/
  @ApiModelProperty(value = "Xero generated unique identifier")
  public UUID getOverpaymentID() {
    return overpaymentID;
  }

  public void setOverpaymentID(UUID overpaymentID) {
    this.overpaymentID = overpaymentID;
  }

  public Overpayment currencyRate(Float currencyRate) {
    this.currencyRate = currencyRate;
    return this;
  }

   /**
   * The currency rate for a multicurrency overpayment. If no rate is specified, the XE.com day rate is used
   * @return currencyRate
  **/
  @ApiModelProperty(value = "The currency rate for a multicurrency overpayment. If no rate is specified, the XE.com day rate is used")
  public Float getCurrencyRate() {
    return currencyRate;
  }

  public void setCurrencyRate(Float currencyRate) {
    this.currencyRate = currencyRate;
  }

  public Overpayment remainingCredit(String remainingCredit) {
    this.remainingCredit = remainingCredit;
    return this;
  }

   /**
   * The remaining credit balance on the overpayment
   * @return remainingCredit
  **/
  @ApiModelProperty(value = "The remaining credit balance on the overpayment")
  public String getRemainingCredit() {
    return remainingCredit;
  }

  public void setRemainingCredit(String remainingCredit) {
    this.remainingCredit = remainingCredit;
  }

  public Overpayment allocations(List<Allocation> allocations) {
    this.allocations = allocations;
    return this;
  }

  public Overpayment addAllocationsItem(Allocation allocationsItem) {
    if (this.allocations == null) {
      this.allocations = new ArrayList<Allocation>();
    }
    this.allocations.add(allocationsItem);
    return this;
  }

   /**
   * See Allocations
   * @return allocations
  **/
  @ApiModelProperty(value = "See Allocations")
  public List<Allocation> getAllocations() {
    return allocations;
  }

  public void setAllocations(List<Allocation> allocations) {
    this.allocations = allocations;
  }

  public Overpayment payments(List<Payment> payments) {
    this.payments = payments;
    return this;
  }

  public Overpayment addPaymentsItem(Payment paymentsItem) {
    if (this.payments == null) {
      this.payments = new ArrayList<Payment>();
    }
    this.payments.add(paymentsItem);
    return this;
  }

   /**
   * See Payments
   * @return payments
  **/
  @ApiModelProperty(value = "See Payments")
  public List<Payment> getPayments() {
    return payments;
  }

  public void setPayments(List<Payment> payments) {
    this.payments = payments;
  }

  public Overpayment hasAttachments(Boolean hasAttachments) {
    this.hasAttachments = hasAttachments;
    return this;
  }

   /**
   * boolean to indicate if a overpayment has an attachment
   * @return hasAttachments
  **/
  @ApiModelProperty(value = "boolean to indicate if a overpayment has an attachment")
  public Boolean getHasAttachments() {
    return hasAttachments;
  }

  public void setHasAttachments(Boolean hasAttachments) {
    this.hasAttachments = hasAttachments;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Overpayment overpayment = (Overpayment) o;
    return Objects.equals(this.type, overpayment.type) &&
        Objects.equals(this.contact, overpayment.contact) &&
        Objects.equals(this.date, overpayment.date) &&
        Objects.equals(this.status, overpayment.status) &&
        Objects.equals(this.lineAmountTypes, overpayment.lineAmountTypes) &&
        Objects.equals(this.lineItems, overpayment.lineItems) &&
        Objects.equals(this.subTotal, overpayment.subTotal) &&
        Objects.equals(this.totalTax, overpayment.totalTax) &&
        Objects.equals(this.total, overpayment.total) &&
        Objects.equals(this.updatedDateUTC, overpayment.updatedDateUTC) &&
        Objects.equals(this.currencyCode, overpayment.currencyCode) &&
        Objects.equals(this.overpaymentID, overpayment.overpaymentID) &&
        Objects.equals(this.currencyRate, overpayment.currencyRate) &&
        Objects.equals(this.remainingCredit, overpayment.remainingCredit) &&
        Objects.equals(this.allocations, overpayment.allocations) &&
        Objects.equals(this.payments, overpayment.payments) &&
        Objects.equals(this.hasAttachments, overpayment.hasAttachments);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, contact, date, status, lineAmountTypes, lineItems, subTotal, totalTax, total, updatedDateUTC, currencyCode, overpaymentID, currencyRate, remainingCredit, allocations, payments, hasAttachments);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Overpayment {\n");
    
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    contact: ").append(toIndentedString(contact)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    lineAmountTypes: ").append(toIndentedString(lineAmountTypes)).append("\n");
    sb.append("    lineItems: ").append(toIndentedString(lineItems)).append("\n");
    sb.append("    subTotal: ").append(toIndentedString(subTotal)).append("\n");
    sb.append("    totalTax: ").append(toIndentedString(totalTax)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    updatedDateUTC: ").append(toIndentedString(updatedDateUTC)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    overpaymentID: ").append(toIndentedString(overpaymentID)).append("\n");
    sb.append("    currencyRate: ").append(toIndentedString(currencyRate)).append("\n");
    sb.append("    remainingCredit: ").append(toIndentedString(remainingCredit)).append("\n");
    sb.append("    allocations: ").append(toIndentedString(allocations)).append("\n");
    sb.append("    payments: ").append(toIndentedString(payments)).append("\n");
    sb.append("    hasAttachments: ").append(toIndentedString(hasAttachments)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

