/*
 * Accounting API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * OpenAPI spec version: 2.0.0
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.xero.models.accounting;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.models.accounting.TenNinteyNineContact;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.threeten.bp.OffsetDateTime;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

/**
 * Report
 */

public class Report {
  
  @JsonProperty("ReportID")
  private String reportID;

  
  @JsonProperty("ReportName")
  private String reportName;

  /**
   * See Prepayment Types
   */
  public enum ReportTypeEnum {
    AGEDPAYABLESBYCONTACT("AgedPayablesByContact");

    private String value;

    ReportTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ReportTypeEnum fromValue(String text) {
      for (ReportTypeEnum b : ReportTypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + text + "'");
    }
  }

  
  @JsonProperty("ReportType")
  private ReportTypeEnum reportType;

  
  @JsonProperty("ReportTitle")
  private String reportTitle;

  
  @JsonProperty("ReportDate")
  private String reportDate;

  @JsonDeserialize(using = com.xero.api.CustomOffsetDateTimeDeserializer.class)
  @JsonProperty("UpdatedDateUTC")
  private OffsetDateTime updatedDateUTC;

  
  @JsonProperty("Contacts")
  private List<TenNinteyNineContact> contacts = null;

  public Report reportID(String reportID) {
    this.reportID = reportID;
    return this;
  }

   /**
   * See Prepayment Types
   * @return reportID
  **/
  @ApiModelProperty(value = "See Prepayment Types")
  public String getReportID() {
    return reportID;
  }

  public void setReportID(String reportID) {
    this.reportID = reportID;
  }

  public Report reportName(String reportName) {
    this.reportName = reportName;
    return this;
  }

   /**
   * See Prepayment Types
   * @return reportName
  **/
  @ApiModelProperty(value = "See Prepayment Types")
  public String getReportName() {
    return reportName;
  }

  public void setReportName(String reportName) {
    this.reportName = reportName;
  }

  public Report reportType(ReportTypeEnum reportType) {
    this.reportType = reportType;
    return this;
  }

   /**
   * See Prepayment Types
   * @return reportType
  **/
  @ApiModelProperty(value = "See Prepayment Types")
  public ReportTypeEnum getReportType() {
    return reportType;
  }

  public void setReportType(ReportTypeEnum reportType) {
    this.reportType = reportType;
  }

  public Report reportTitle(String reportTitle) {
    this.reportTitle = reportTitle;
    return this;
  }

   /**
   * See Prepayment Types
   * @return reportTitle
  **/
  @ApiModelProperty(value = "See Prepayment Types")
  public String getReportTitle() {
    return reportTitle;
  }

  public void setReportTitle(String reportTitle) {
    this.reportTitle = reportTitle;
  }

  public Report reportDate(String reportDate) {
    this.reportDate = reportDate;
    return this;
  }

   /**
   * Date of report
   * @return reportDate
  **/
  @ApiModelProperty(value = "Date of report")
  public String getReportDate() {
    return reportDate;
  }

  public void setReportDate(String reportDate) {
    this.reportDate = reportDate;
  }

  public Report updatedDateUTC(OffsetDateTime updatedDateUTC) {
    this.updatedDateUTC = updatedDateUTC;
    return this;
  }

   /**
   * Updated Date
   * @return updatedDateUTC
  **/
  @ApiModelProperty(value = "Updated Date")
  public OffsetDateTime getUpdatedDateUTC() {
    return updatedDateUTC;
  }

  public void setUpdatedDateUTC(OffsetDateTime updatedDateUTC) {
    this.updatedDateUTC = updatedDateUTC;
  }

  public Report contacts(List<TenNinteyNineContact> contacts) {
    this.contacts = contacts;
    return this;
  }

  public Report addContactsItem(TenNinteyNineContact contactsItem) {
    if (this.contacts == null) {
      this.contacts = new ArrayList<TenNinteyNineContact>();
    }
    this.contacts.add(contactsItem);
    return this;
  }

   /**
   * Get contacts
   * @return contacts
  **/
  @ApiModelProperty(value = "")
  public List<TenNinteyNineContact> getContacts() {
    return contacts;
  }

  public void setContacts(List<TenNinteyNineContact> contacts) {
    this.contacts = contacts;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Report report = (Report) o;
    return Objects.equals(this.reportID, report.reportID) &&
        Objects.equals(this.reportName, report.reportName) &&
        Objects.equals(this.reportType, report.reportType) &&
        Objects.equals(this.reportTitle, report.reportTitle) &&
        Objects.equals(this.reportDate, report.reportDate) &&
        Objects.equals(this.updatedDateUTC, report.updatedDateUTC) &&
        Objects.equals(this.contacts, report.contacts);
  }

  @Override
  public int hashCode() {
    return Objects.hash(reportID, reportName, reportType, reportTitle, reportDate, updatedDateUTC, contacts);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Report {\n");
    
    sb.append("    reportID: ").append(toIndentedString(reportID)).append("\n");
    sb.append("    reportName: ").append(toIndentedString(reportName)).append("\n");
    sb.append("    reportType: ").append(toIndentedString(reportType)).append("\n");
    sb.append("    reportTitle: ").append(toIndentedString(reportTitle)).append("\n");
    sb.append("    reportDate: ").append(toIndentedString(reportDate)).append("\n");
    sb.append("    updatedDateUTC: ").append(toIndentedString(updatedDateUTC)).append("\n");
    sb.append("    contacts: ").append(toIndentedString(contacts)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

