/*
 * Accounting API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * OpenAPI spec version: 2.0.0
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.xero.models.accounting;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.models.accounting.ReportFields;
import com.xero.models.accounting.ReportRows;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.threeten.bp.OffsetDateTime;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

/**
 * ReportWithRow
 */

public class ReportWithRow {
  
  @JsonProperty("ReportID")
  private String reportID;

  
  @JsonProperty("ReportName")
  private String reportName;

  
  @JsonProperty("ReportTitle")
  private String reportTitle;

  
  @JsonProperty("ReportType")
  private String reportType;

  
  @JsonProperty("ReportTitles")
  private List<String> reportTitles = null;

  
  @JsonProperty("ReportDate")
  private String reportDate;

  @JsonDeserialize(using = com.xero.api.CustomOffsetDateTimeDeserializer.class)
  @JsonProperty("UpdatedDateUTC")
  private OffsetDateTime updatedDateUTC;

  
  @JsonProperty("Rows")
  private List<ReportRows> rows = null;

  
  @JsonProperty("Fields")
  private List<ReportFields> fields = null;

  public ReportWithRow reportID(String reportID) {
    this.reportID = reportID;
    return this;
  }

   /**
   * Report id
   * @return reportID
  **/
  @ApiModelProperty(value = "Report id")
  public String getReportID() {
    return reportID;
  }

  public void setReportID(String reportID) {
    this.reportID = reportID;
  }

  public ReportWithRow reportName(String reportName) {
    this.reportName = reportName;
    return this;
  }

   /**
   * Name of the report
   * @return reportName
  **/
  @ApiModelProperty(value = "Name of the report")
  public String getReportName() {
    return reportName;
  }

  public void setReportName(String reportName) {
    this.reportName = reportName;
  }

  public ReportWithRow reportTitle(String reportTitle) {
    this.reportTitle = reportTitle;
    return this;
  }

   /**
   * Title of the report
   * @return reportTitle
  **/
  @ApiModelProperty(value = "Title of the report")
  public String getReportTitle() {
    return reportTitle;
  }

  public void setReportTitle(String reportTitle) {
    this.reportTitle = reportTitle;
  }

  public ReportWithRow reportType(String reportType) {
    this.reportType = reportType;
    return this;
  }

   /**
   * The type of report (BalanceSheet,ProfitLoss, etc)
   * @return reportType
  **/
  @ApiModelProperty(value = "The type of report (BalanceSheet,ProfitLoss, etc)")
  public String getReportType() {
    return reportType;
  }

  public void setReportType(String reportType) {
    this.reportType = reportType;
  }

  public ReportWithRow reportTitles(List<String> reportTitles) {
    this.reportTitles = reportTitles;
    return this;
  }

  public ReportWithRow addReportTitlesItem(String reportTitlesItem) {
    if (this.reportTitles == null) {
      this.reportTitles = new ArrayList<String>();
    }
    this.reportTitles.add(reportTitlesItem);
    return this;
  }

   /**
   * Report titles array (3 to 4 strings with the report name, orgnisation name and time frame of report)
   * @return reportTitles
  **/
  @ApiModelProperty(value = "Report titles array (3 to 4 strings with the report name, orgnisation name and time frame of report)")
  public List<String> getReportTitles() {
    return reportTitles;
  }

  public void setReportTitles(List<String> reportTitles) {
    this.reportTitles = reportTitles;
  }

  public ReportWithRow reportDate(String reportDate) {
    this.reportDate = reportDate;
    return this;
  }

   /**
   * Date of report
   * @return reportDate
  **/
  @ApiModelProperty(value = "Date of report")
  public String getReportDate() {
    return reportDate;
  }

  public void setReportDate(String reportDate) {
    this.reportDate = reportDate;
  }

  public ReportWithRow updatedDateUTC(OffsetDateTime updatedDateUTC) {
    this.updatedDateUTC = updatedDateUTC;
    return this;
  }

   /**
   * Updated Date
   * @return updatedDateUTC
  **/
  @ApiModelProperty(value = "Updated Date")
  public OffsetDateTime getUpdatedDateUTC() {
    return updatedDateUTC;
  }

  public void setUpdatedDateUTC(OffsetDateTime updatedDateUTC) {
    this.updatedDateUTC = updatedDateUTC;
  }

  public ReportWithRow rows(List<ReportRows> rows) {
    this.rows = rows;
    return this;
  }

  public ReportWithRow addRowsItem(ReportRows rowsItem) {
    if (this.rows == null) {
      this.rows = new ArrayList<ReportRows>();
    }
    this.rows.add(rowsItem);
    return this;
  }

   /**
   * Get rows
   * @return rows
  **/
  @ApiModelProperty(value = "")
  public List<ReportRows> getRows() {
    return rows;
  }

  public void setRows(List<ReportRows> rows) {
    this.rows = rows;
  }

  public ReportWithRow fields(List<ReportFields> fields) {
    this.fields = fields;
    return this;
  }

  public ReportWithRow addFieldsItem(ReportFields fieldsItem) {
    if (this.fields == null) {
      this.fields = new ArrayList<ReportFields>();
    }
    this.fields.add(fieldsItem);
    return this;
  }

   /**
   * Get fields
   * @return fields
  **/
  @ApiModelProperty(value = "")
  public List<ReportFields> getFields() {
    return fields;
  }

  public void setFields(List<ReportFields> fields) {
    this.fields = fields;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ReportWithRow reportWithRow = (ReportWithRow) o;
    return Objects.equals(this.reportID, reportWithRow.reportID) &&
        Objects.equals(this.reportName, reportWithRow.reportName) &&
        Objects.equals(this.reportTitle, reportWithRow.reportTitle) &&
        Objects.equals(this.reportType, reportWithRow.reportType) &&
        Objects.equals(this.reportTitles, reportWithRow.reportTitles) &&
        Objects.equals(this.reportDate, reportWithRow.reportDate) &&
        Objects.equals(this.updatedDateUTC, reportWithRow.updatedDateUTC) &&
        Objects.equals(this.rows, reportWithRow.rows) &&
        Objects.equals(this.fields, reportWithRow.fields);
  }

  @Override
  public int hashCode() {
    return Objects.hash(reportID, reportName, reportTitle, reportType, reportTitles, reportDate, updatedDateUTC, rows, fields);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ReportWithRow {\n");
    
    sb.append("    reportID: ").append(toIndentedString(reportID)).append("\n");
    sb.append("    reportName: ").append(toIndentedString(reportName)).append("\n");
    sb.append("    reportTitle: ").append(toIndentedString(reportTitle)).append("\n");
    sb.append("    reportType: ").append(toIndentedString(reportType)).append("\n");
    sb.append("    reportTitles: ").append(toIndentedString(reportTitles)).append("\n");
    sb.append("    reportDate: ").append(toIndentedString(reportDate)).append("\n");
    sb.append("    updatedDateUTC: ").append(toIndentedString(updatedDateUTC)).append("\n");
    sb.append("    rows: ").append(toIndentedString(rows)).append("\n");
    sb.append("    fields: ").append(toIndentedString(fields)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

