/*
 * Accounting API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * OpenAPI spec version: 2.0.0
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.xero.models.accounting;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.models.accounting.TrackingOption;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

/**
 * TrackingCategory
 */

public class TrackingCategory {
  
  @JsonProperty("TrackingCategoryID")
  private UUID trackingCategoryID;

  
  @JsonProperty("Name")
  private String name;

  /**
   * The status of a tracking category
   */
  public enum StatusEnum {
    ACTIVE("ACTIVE"),
    
    ARCHIVED("ARCHIVED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String text) {
      for (StatusEnum b : StatusEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + text + "'");
    }
  }

  
  @JsonProperty("Status")
  private StatusEnum status;

  
  @JsonProperty("Options")
  private List<TrackingOption> options = null;

  public TrackingCategory trackingCategoryID(UUID trackingCategoryID) {
    this.trackingCategoryID = trackingCategoryID;
    return this;
  }

   /**
   * The Xero identifier for a tracking categorye.g. 297c2dc5-cc47-4afd-8ec8-74990b8761e9
   * @return trackingCategoryID
  **/
  @ApiModelProperty(value = "The Xero identifier for a tracking categorye.g. 297c2dc5-cc47-4afd-8ec8-74990b8761e9")
  public UUID getTrackingCategoryID() {
    return trackingCategoryID;
  }

  public void setTrackingCategoryID(UUID trackingCategoryID) {
    this.trackingCategoryID = trackingCategoryID;
  }

  public TrackingCategory name(String name) {
    this.name = name;
    return this;
  }

   /**
   * The name of the tracking category e.g. Department, Region (max length &#x3D; 100)
   * @return name
  **/
  @ApiModelProperty(value = "The name of the tracking category e.g. Department, Region (max length = 100)")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public TrackingCategory status(StatusEnum status) {
    this.status = status;
    return this;
  }

   /**
   * The status of a tracking category
   * @return status
  **/
  @ApiModelProperty(value = "The status of a tracking category")
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public TrackingCategory options(List<TrackingOption> options) {
    this.options = options;
    return this;
  }

  public TrackingCategory addOptionsItem(TrackingOption optionsItem) {
    if (this.options == null) {
      this.options = new ArrayList<TrackingOption>();
    }
    this.options.add(optionsItem);
    return this;
  }

   /**
   * See Tracking Options
   * @return options
  **/
  @ApiModelProperty(value = "See Tracking Options")
  public List<TrackingOption> getOptions() {
    return options;
  }

  public void setOptions(List<TrackingOption> options) {
    this.options = options;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TrackingCategory trackingCategory = (TrackingCategory) o;
    return Objects.equals(this.trackingCategoryID, trackingCategory.trackingCategoryID) &&
        Objects.equals(this.name, trackingCategory.name) &&
        Objects.equals(this.status, trackingCategory.status) &&
        Objects.equals(this.options, trackingCategory.options);
  }

  @Override
  public int hashCode() {
    return Objects.hash(trackingCategoryID, name, status, options);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TrackingCategory {\n");
    
    sb.append("    trackingCategoryID: ").append(toIndentedString(trackingCategoryID)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    options: ").append(toIndentedString(options)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

