/*
 * Xero Assets API
 * This the Xero Assets API
 *
 * OpenAPI spec version: 1.0.0
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.xero.models.assets;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.models.assets.BookDepreciationDetail;
import com.xero.models.assets.BookDepreciationSetting;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.UUID;
import org.threeten.bp.LocalDate;

/**
 * Asset
 */

public class Asset {
  @JsonProperty("assetId")
  private UUID assetId = null;

  @JsonProperty("assetName")
  private String assetName = null;

  @JsonProperty("assetNumber")
  private String assetNumber = null;

  @JsonProperty("purchaseDate")
  private LocalDate purchaseDate = null;

  @JsonProperty("purchasePrice")
  private Integer purchasePrice = null;

  @JsonProperty("disposalPrice")
  private Integer disposalPrice = null;

  /**
   * See Asset Status Codes.
   */
  public enum AssetStatusEnum {
    DRAFT("Draft"),
    
    REGISTERED("Registered"),
    
    DISPOSED("Disposed");

    private String value;

    AssetStatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AssetStatusEnum fromValue(String text) {
      for (AssetStatusEnum b : AssetStatusEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

  @JsonProperty("assetStatus")
  private AssetStatusEnum assetStatus = null;

  @JsonProperty("warrantyExpiryDate")
  private String warrantyExpiryDate = null;

  @JsonProperty("serialNumber")
  private String serialNumber = null;

  @JsonProperty("bookDepreciationSetting")
  private BookDepreciationSetting bookDepreciationSetting = null;

  @JsonProperty("bookDepreciationDetail")
  private BookDepreciationDetail bookDepreciationDetail = null;

  @JsonProperty("canRollBack")
  private Boolean canRollBack = null;

  @JsonProperty("AccountingBookValue")
  private Integer accountingBookValue = null;

  public Asset assetId(UUID assetId) {
    this.assetId = assetId;
    return this;
  }

   /**
   * The Xero-generated Id for the asset
   * @return assetId
  **/
  @ApiModelProperty(example = "3b5b3a38-5649-495f-87a1-14a4e5918634", required = true, value = "The Xero-generated Id for the asset")
  public UUID getAssetId() {
    return assetId;
  }

  public void setAssetId(UUID assetId) {
    this.assetId = assetId;
  }

  public Asset assetName(String assetName) {
    this.assetName = assetName;
    return this;
  }

   /**
   * The name of the asset
   * @return assetName
  **/
  @ApiModelProperty(example = "Awesome Truck 3", required = true, value = "The name of the asset")
  public String getAssetName() {
    return assetName;
  }

  public void setAssetName(String assetName) {
    this.assetName = assetName;
  }

  public Asset assetNumber(String assetNumber) {
    this.assetNumber = assetNumber;
    return this;
  }

   /**
   * Must be unique.
   * @return assetNumber
  **/
  @ApiModelProperty(example = "FA-0013", value = "Must be unique.")
  public String getAssetNumber() {
    return assetNumber;
  }

  public void setAssetNumber(String assetNumber) {
    this.assetNumber = assetNumber;
  }

  public Asset purchaseDate(LocalDate purchaseDate) {
    this.purchaseDate = purchaseDate;
    return this;
  }

   /**
   * The date the asset was purchased YYYY-MM-DD
   * @return purchaseDate
  **/
  @ApiModelProperty(value = "The date the asset was purchased YYYY-MM-DD")
  public LocalDate getPurchaseDate() {
    return purchaseDate;
  }

  public void setPurchaseDate(LocalDate purchaseDate) {
    this.purchaseDate = purchaseDate;
  }

  public Asset purchasePrice(Integer purchasePrice) {
    this.purchasePrice = purchasePrice;
    return this;
  }

   /**
   * The purchase price of the asset
   * @return purchasePrice
  **/
  @ApiModelProperty(example = "1000", value = "The purchase price of the asset")
  public Integer getPurchasePrice() {
    return purchasePrice;
  }

  public void setPurchasePrice(Integer purchasePrice) {
    this.purchasePrice = purchasePrice;
  }

  public Asset disposalPrice(Integer disposalPrice) {
    this.disposalPrice = disposalPrice;
    return this;
  }

   /**
   * The price the asset was disposed at
   * @return disposalPrice
  **/
  @ApiModelProperty(example = "0", value = "The price the asset was disposed at")
  public Integer getDisposalPrice() {
    return disposalPrice;
  }

  public void setDisposalPrice(Integer disposalPrice) {
    this.disposalPrice = disposalPrice;
  }

  public Asset assetStatus(AssetStatusEnum assetStatus) {
    this.assetStatus = assetStatus;
    return this;
  }

   /**
   * See Asset Status Codes.
   * @return assetStatus
  **/
  @ApiModelProperty(example = "Draft", value = "See Asset Status Codes.")
  public AssetStatusEnum getAssetStatus() {
    return assetStatus;
  }

  public void setAssetStatus(AssetStatusEnum assetStatus) {
    this.assetStatus = assetStatus;
  }

  public Asset warrantyExpiryDate(String warrantyExpiryDate) {
    this.warrantyExpiryDate = warrantyExpiryDate;
    return this;
  }

   /**
   * The date the asset’s warranty expires (if needed) YYYY-MM-DD
   * @return warrantyExpiryDate
  **/
  @ApiModelProperty(example = "ca4c6b39-4f4f-43e8-98da-5e1f350a6694", value = "The date the asset’s warranty expires (if needed) YYYY-MM-DD")
  public String getWarrantyExpiryDate() {
    return warrantyExpiryDate;
  }

  public void setWarrantyExpiryDate(String warrantyExpiryDate) {
    this.warrantyExpiryDate = warrantyExpiryDate;
  }

  public Asset serialNumber(String serialNumber) {
    this.serialNumber = serialNumber;
    return this;
  }

   /**
   * The asset&#39;s serial number
   * @return serialNumber
  **/
  @ApiModelProperty(example = "ca4c6b39-4f4f-43e8-98da-5e1f350a6694", value = "The asset's serial number")
  public String getSerialNumber() {
    return serialNumber;
  }

  public void setSerialNumber(String serialNumber) {
    this.serialNumber = serialNumber;
  }

  public Asset bookDepreciationSetting(BookDepreciationSetting bookDepreciationSetting) {
    this.bookDepreciationSetting = bookDepreciationSetting;
    return this;
  }

   /**
   * Get bookDepreciationSetting
   * @return bookDepreciationSetting
  **/
  @ApiModelProperty(required = true, value = "")
  public BookDepreciationSetting getBookDepreciationSetting() {
    return bookDepreciationSetting;
  }

  public void setBookDepreciationSetting(BookDepreciationSetting bookDepreciationSetting) {
    this.bookDepreciationSetting = bookDepreciationSetting;
  }

  public Asset bookDepreciationDetail(BookDepreciationDetail bookDepreciationDetail) {
    this.bookDepreciationDetail = bookDepreciationDetail;
    return this;
  }

   /**
   * Get bookDepreciationDetail
   * @return bookDepreciationDetail
  **/
  @ApiModelProperty(value = "")
  public BookDepreciationDetail getBookDepreciationDetail() {
    return bookDepreciationDetail;
  }

  public void setBookDepreciationDetail(BookDepreciationDetail bookDepreciationDetail) {
    this.bookDepreciationDetail = bookDepreciationDetail;
  }

  public Asset canRollBack(Boolean canRollBack) {
    this.canRollBack = canRollBack;
    return this;
  }

   /**
   * Boolean to indicate whether depreciation can be rolled back for this asset individually. This is true if it doesn&#39;t have &#39;legacy&#39; journal entries and if there is no lock period that would prevent this asset from rolling back.
   * @return canRollBack
  **/
  @ApiModelProperty(value = "Boolean to indicate whether depreciation can be rolled back for this asset individually. This is true if it doesn't have 'legacy' journal entries and if there is no lock period that would prevent this asset from rolling back.")
  public Boolean getCanRollBack() {
    return canRollBack;
  }

  public void setCanRollBack(Boolean canRollBack) {
    this.canRollBack = canRollBack;
  }

  public Asset accountingBookValue(Integer accountingBookValue) {
    this.accountingBookValue = accountingBookValue;
    return this;
  }

   /**
   * The accounting value of the asset
   * @return accountingBookValue
  **/
  @ApiModelProperty(example = "0", value = "The accounting value of the asset")
  public Integer getAccountingBookValue() {
    return accountingBookValue;
  }

  public void setAccountingBookValue(Integer accountingBookValue) {
    this.accountingBookValue = accountingBookValue;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Asset asset = (Asset) o;
    return Objects.equals(this.assetId, asset.assetId) &&
        Objects.equals(this.assetName, asset.assetName) &&
        Objects.equals(this.assetNumber, asset.assetNumber) &&
        Objects.equals(this.purchaseDate, asset.purchaseDate) &&
        Objects.equals(this.purchasePrice, asset.purchasePrice) &&
        Objects.equals(this.disposalPrice, asset.disposalPrice) &&
        Objects.equals(this.assetStatus, asset.assetStatus) &&
        Objects.equals(this.warrantyExpiryDate, asset.warrantyExpiryDate) &&
        Objects.equals(this.serialNumber, asset.serialNumber) &&
        Objects.equals(this.bookDepreciationSetting, asset.bookDepreciationSetting) &&
        Objects.equals(this.bookDepreciationDetail, asset.bookDepreciationDetail) &&
        Objects.equals(this.canRollBack, asset.canRollBack) &&
        Objects.equals(this.accountingBookValue, asset.accountingBookValue);
  }

  @Override
  public int hashCode() {
    return Objects.hash(assetId, assetName, assetNumber, purchaseDate, purchasePrice, disposalPrice, assetStatus, warrantyExpiryDate, serialNumber, bookDepreciationSetting, bookDepreciationDetail, canRollBack, accountingBookValue);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Asset {\n");
    
    sb.append("    assetId: ").append(toIndentedString(assetId)).append("\n");
    sb.append("    assetName: ").append(toIndentedString(assetName)).append("\n");
    sb.append("    assetNumber: ").append(toIndentedString(assetNumber)).append("\n");
    sb.append("    purchaseDate: ").append(toIndentedString(purchaseDate)).append("\n");
    sb.append("    purchasePrice: ").append(toIndentedString(purchasePrice)).append("\n");
    sb.append("    disposalPrice: ").append(toIndentedString(disposalPrice)).append("\n");
    sb.append("    assetStatus: ").append(toIndentedString(assetStatus)).append("\n");
    sb.append("    warrantyExpiryDate: ").append(toIndentedString(warrantyExpiryDate)).append("\n");
    sb.append("    serialNumber: ").append(toIndentedString(serialNumber)).append("\n");
    sb.append("    bookDepreciationSetting: ").append(toIndentedString(bookDepreciationSetting)).append("\n");
    sb.append("    bookDepreciationDetail: ").append(toIndentedString(bookDepreciationDetail)).append("\n");
    sb.append("    canRollBack: ").append(toIndentedString(canRollBack)).append("\n");
    sb.append("    accountingBookValue: ").append(toIndentedString(accountingBookValue)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

