/*
 * Xero Assets API
 * This the Xero Assets API
 *
 * OpenAPI spec version: 1.0.0
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.xero.models.assets;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.threeten.bp.LocalDate;

/**
 * BookDepreciationDetail
 */

public class BookDepreciationDetail {
  @JsonProperty("currentCapitalGain")
  private Integer currentCapitalGain = null;

  @JsonProperty("currentGainLoss")
  private Integer currentGainLoss = null;

  @JsonProperty("depreciationStartDate")
  private LocalDate depreciationStartDate = null;

  @JsonProperty("costLimit")
  private Integer costLimit = null;

  @JsonProperty("residualValue")
  private Integer residualValue = null;

  @JsonProperty("priorAccumDepreciationAmount")
  private Integer priorAccumDepreciationAmount = null;

  @JsonProperty("currentAccumDepreciationAmount")
  private Integer currentAccumDepreciationAmount = null;

  public BookDepreciationDetail currentCapitalGain(Integer currentCapitalGain) {
    this.currentCapitalGain = currentCapitalGain;
    return this;
  }

   /**
   * When an asset is disposed, this will be the sell price minus the purchase price if a profit was made.
   * @return currentCapitalGain
  **/
  @ApiModelProperty(example = "0", value = "When an asset is disposed, this will be the sell price minus the purchase price if a profit was made.")
  public Integer getCurrentCapitalGain() {
    return currentCapitalGain;
  }

  public void setCurrentCapitalGain(Integer currentCapitalGain) {
    this.currentCapitalGain = currentCapitalGain;
  }

  public BookDepreciationDetail currentGainLoss(Integer currentGainLoss) {
    this.currentGainLoss = currentGainLoss;
    return this;
  }

   /**
   * When an asset is disposed, this will be the lowest one of sell price or purchase price, minus the current book value.
   * @return currentGainLoss
  **/
  @ApiModelProperty(example = "0", value = "When an asset is disposed, this will be the lowest one of sell price or purchase price, minus the current book value.")
  public Integer getCurrentGainLoss() {
    return currentGainLoss;
  }

  public void setCurrentGainLoss(Integer currentGainLoss) {
    this.currentGainLoss = currentGainLoss;
  }

  public BookDepreciationDetail depreciationStartDate(LocalDate depreciationStartDate) {
    this.depreciationStartDate = depreciationStartDate;
    return this;
  }

   /**
   * YYYY-MM-DD
   * @return depreciationStartDate
  **/
  @ApiModelProperty(value = "YYYY-MM-DD")
  public LocalDate getDepreciationStartDate() {
    return depreciationStartDate;
  }

  public void setDepreciationStartDate(LocalDate depreciationStartDate) {
    this.depreciationStartDate = depreciationStartDate;
  }

  public BookDepreciationDetail costLimit(Integer costLimit) {
    this.costLimit = costLimit;
    return this;
  }

   /**
   * The value of the asset you want to depreciate, if this is less than the cost of the asset.
   * @return costLimit
  **/
  @ApiModelProperty(example = "100000", value = "The value of the asset you want to depreciate, if this is less than the cost of the asset.")
  public Integer getCostLimit() {
    return costLimit;
  }

  public void setCostLimit(Integer costLimit) {
    this.costLimit = costLimit;
  }

  public BookDepreciationDetail residualValue(Integer residualValue) {
    this.residualValue = residualValue;
    return this;
  }

   /**
   * The value of the asset remaining when you&#39;ve fully depreciated it.
   * @return residualValue
  **/
  @ApiModelProperty(example = "10000", value = "The value of the asset remaining when you've fully depreciated it.")
  public Integer getResidualValue() {
    return residualValue;
  }

  public void setResidualValue(Integer residualValue) {
    this.residualValue = residualValue;
  }

  public BookDepreciationDetail priorAccumDepreciationAmount(Integer priorAccumDepreciationAmount) {
    this.priorAccumDepreciationAmount = priorAccumDepreciationAmount;
    return this;
  }

   /**
   * All depreciation prior to the current financial year.
   * @return priorAccumDepreciationAmount
  **/
  @ApiModelProperty(example = "0", value = "All depreciation prior to the current financial year.")
  public Integer getPriorAccumDepreciationAmount() {
    return priorAccumDepreciationAmount;
  }

  public void setPriorAccumDepreciationAmount(Integer priorAccumDepreciationAmount) {
    this.priorAccumDepreciationAmount = priorAccumDepreciationAmount;
  }

  public BookDepreciationDetail currentAccumDepreciationAmount(Integer currentAccumDepreciationAmount) {
    this.currentAccumDepreciationAmount = currentAccumDepreciationAmount;
    return this;
  }

   /**
   * All depreciation occurring in the current financial year.
   * @return currentAccumDepreciationAmount
  **/
  @ApiModelProperty(example = "0", value = "All depreciation occurring in the current financial year.")
  public Integer getCurrentAccumDepreciationAmount() {
    return currentAccumDepreciationAmount;
  }

  public void setCurrentAccumDepreciationAmount(Integer currentAccumDepreciationAmount) {
    this.currentAccumDepreciationAmount = currentAccumDepreciationAmount;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BookDepreciationDetail bookDepreciationDetail = (BookDepreciationDetail) o;
    return Objects.equals(this.currentCapitalGain, bookDepreciationDetail.currentCapitalGain) &&
        Objects.equals(this.currentGainLoss, bookDepreciationDetail.currentGainLoss) &&
        Objects.equals(this.depreciationStartDate, bookDepreciationDetail.depreciationStartDate) &&
        Objects.equals(this.costLimit, bookDepreciationDetail.costLimit) &&
        Objects.equals(this.residualValue, bookDepreciationDetail.residualValue) &&
        Objects.equals(this.priorAccumDepreciationAmount, bookDepreciationDetail.priorAccumDepreciationAmount) &&
        Objects.equals(this.currentAccumDepreciationAmount, bookDepreciationDetail.currentAccumDepreciationAmount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(currentCapitalGain, currentGainLoss, depreciationStartDate, costLimit, residualValue, priorAccumDepreciationAmount, currentAccumDepreciationAmount);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BookDepreciationDetail {\n");
    
    sb.append("    currentCapitalGain: ").append(toIndentedString(currentCapitalGain)).append("\n");
    sb.append("    currentGainLoss: ").append(toIndentedString(currentGainLoss)).append("\n");
    sb.append("    depreciationStartDate: ").append(toIndentedString(depreciationStartDate)).append("\n");
    sb.append("    costLimit: ").append(toIndentedString(costLimit)).append("\n");
    sb.append("    residualValue: ").append(toIndentedString(residualValue)).append("\n");
    sb.append("    priorAccumDepreciationAmount: ").append(toIndentedString(priorAccumDepreciationAmount)).append("\n");
    sb.append("    currentAccumDepreciationAmount: ").append(toIndentedString(currentAccumDepreciationAmount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

