/*
 * Xero Assets API
 * This the Xero Assets API
 *
 * OpenAPI spec version: 1.0.0
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.xero.models.assets;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * BookDepreciationSetting
 */

public class BookDepreciationSetting {
  /**
   * The method of depreciation applied to this asset. See Depreciation Methods
   */
  public enum DepreciationMethodEnum {
    NODEPRECIATION("NoDepreciation"),
    
    STRAIGHTLINE("StraightLine"),
    
    DIMINISHINGVALUE100("DiminishingValue100"),
    
    DIMINISHINGVALUE150("DiminishingValue150"),
    
    DIMINISHINGVALUE200("DiminishingValue200"),
    
    FULLDEPRECIATION("FullDepreciation");

    private String value;

    DepreciationMethodEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DepreciationMethodEnum fromValue(String text) {
      for (DepreciationMethodEnum b : DepreciationMethodEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

  @JsonProperty("depreciationMethod")
  private DepreciationMethodEnum depreciationMethod = null;

  /**
   * The method of averaging applied to this asset. See Averaging Methods
   */
  public enum AveragingMethodEnum {
    FULLMONTH("FullMonth"),
    
    ACTUALDAYS("ActualDays");

    private String value;

    AveragingMethodEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AveragingMethodEnum fromValue(String text) {
      for (AveragingMethodEnum b : AveragingMethodEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

  @JsonProperty("averagingMethod")
  private AveragingMethodEnum averagingMethod = null;

  @JsonProperty("depreciationRate")
  private Float depreciationRate = null;

  @JsonProperty("effectiveLifeYears")
  private Integer effectiveLifeYears = null;

  /**
   * See Depreciation Calculation Methods
   */
  public enum DepreciationCalculationMethodEnum {
    RATE("Rate"),
    
    LIFE("Life"),
    
    NONE("None");

    private String value;

    DepreciationCalculationMethodEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DepreciationCalculationMethodEnum fromValue(String text) {
      for (DepreciationCalculationMethodEnum b : DepreciationCalculationMethodEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

  @JsonProperty("depreciationCalculationMethod")
  private DepreciationCalculationMethodEnum depreciationCalculationMethod = null;

  public BookDepreciationSetting depreciationMethod(DepreciationMethodEnum depreciationMethod) {
    this.depreciationMethod = depreciationMethod;
    return this;
  }

   /**
   * The method of depreciation applied to this asset. See Depreciation Methods
   * @return depreciationMethod
  **/
  @ApiModelProperty(example = "StraightLine", value = "The method of depreciation applied to this asset. See Depreciation Methods")
  public DepreciationMethodEnum getDepreciationMethod() {
    return depreciationMethod;
  }

  public void setDepreciationMethod(DepreciationMethodEnum depreciationMethod) {
    this.depreciationMethod = depreciationMethod;
  }

  public BookDepreciationSetting averagingMethod(AveragingMethodEnum averagingMethod) {
    this.averagingMethod = averagingMethod;
    return this;
  }

   /**
   * The method of averaging applied to this asset. See Averaging Methods
   * @return averagingMethod
  **/
  @ApiModelProperty(example = "ActualDays", value = "The method of averaging applied to this asset. See Averaging Methods")
  public AveragingMethodEnum getAveragingMethod() {
    return averagingMethod;
  }

  public void setAveragingMethod(AveragingMethodEnum averagingMethod) {
    this.averagingMethod = averagingMethod;
  }

  public BookDepreciationSetting depreciationRate(Float depreciationRate) {
    this.depreciationRate = depreciationRate;
    return this;
  }

   /**
   * The rate of depreciation (e.g. 0.05)
   * @return depreciationRate
  **/
  @ApiModelProperty(example = "0.05", value = "The rate of depreciation (e.g. 0.05)")
  public Float getDepreciationRate() {
    return depreciationRate;
  }

  public void setDepreciationRate(Float depreciationRate) {
    this.depreciationRate = depreciationRate;
  }

  public BookDepreciationSetting effectiveLifeYears(Integer effectiveLifeYears) {
    this.effectiveLifeYears = effectiveLifeYears;
    return this;
  }

   /**
   * Effective life of the asset in years (e.g. 5)
   * @return effectiveLifeYears
  **/
  @ApiModelProperty(example = "5", value = "Effective life of the asset in years (e.g. 5)")
  public Integer getEffectiveLifeYears() {
    return effectiveLifeYears;
  }

  public void setEffectiveLifeYears(Integer effectiveLifeYears) {
    this.effectiveLifeYears = effectiveLifeYears;
  }

  public BookDepreciationSetting depreciationCalculationMethod(DepreciationCalculationMethodEnum depreciationCalculationMethod) {
    this.depreciationCalculationMethod = depreciationCalculationMethod;
    return this;
  }

   /**
   * See Depreciation Calculation Methods
   * @return depreciationCalculationMethod
  **/
  @ApiModelProperty(example = "None", value = "See Depreciation Calculation Methods")
  public DepreciationCalculationMethodEnum getDepreciationCalculationMethod() {
    return depreciationCalculationMethod;
  }

  public void setDepreciationCalculationMethod(DepreciationCalculationMethodEnum depreciationCalculationMethod) {
    this.depreciationCalculationMethod = depreciationCalculationMethod;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BookDepreciationSetting bookDepreciationSetting = (BookDepreciationSetting) o;
    return Objects.equals(this.depreciationMethod, bookDepreciationSetting.depreciationMethod) &&
        Objects.equals(this.averagingMethod, bookDepreciationSetting.averagingMethod) &&
        Objects.equals(this.depreciationRate, bookDepreciationSetting.depreciationRate) &&
        Objects.equals(this.effectiveLifeYears, bookDepreciationSetting.effectiveLifeYears) &&
        Objects.equals(this.depreciationCalculationMethod, bookDepreciationSetting.depreciationCalculationMethod);
  }

  @Override
  public int hashCode() {
    return Objects.hash(depreciationMethod, averagingMethod, depreciationRate, effectiveLifeYears, depreciationCalculationMethod);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BookDepreciationSetting {\n");
    
    sb.append("    depreciationMethod: ").append(toIndentedString(depreciationMethod)).append("\n");
    sb.append("    averagingMethod: ").append(toIndentedString(averagingMethod)).append("\n");
    sb.append("    depreciationRate: ").append(toIndentedString(depreciationRate)).append("\n");
    sb.append("    effectiveLifeYears: ").append(toIndentedString(effectiveLifeYears)).append("\n");
    sb.append("    depreciationCalculationMethod: ").append(toIndentedString(depreciationCalculationMethod)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

