/*
 * Xero Files API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * OpenAPI spec version: 1.0.0
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.xero.models.files;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.UUID;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

/**
 * Folder
 */

public class Folder {
  
  @JsonProperty("Name")
  private String name = null;

  
  @JsonProperty("FileCount")
  private Integer fileCount = null;

  
  @JsonProperty("Email")
  private String email = null;

  
  @JsonProperty("IsInbox")
  private Boolean isInbox = null;

  
  @JsonProperty("Id")
  private UUID id = null;

  public Folder name(String name) {
    this.name = name;
    return this;
  }

   /**
   * The name of the folder
   * @return name
  **/
  @ApiModelProperty(example = "assets", value = "The name of the folder")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Folder fileCount(Integer fileCount) {
    this.fileCount = fileCount;
    return this;
  }

   /**
   * The number of files in the folder
   * @return fileCount
  **/
  @ApiModelProperty(example = "5", value = "The number of files in the folder")
  public Integer getFileCount() {
    return fileCount;
  }

  public void setFileCount(Integer fileCount) {
    this.fileCount = fileCount;
  }

  public Folder email(String email) {
    this.email = email;
    return this;
  }

   /**
   * The email address used to email files to the inbox. Only the inbox will have this element.
   * @return email
  **/
  @ApiModelProperty(example = "foo@bar.com", value = "The email address used to email files to the inbox. Only the inbox will have this element.")
  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  public Folder isInbox(Boolean isInbox) {
    this.isInbox = isInbox;
    return this;
  }

   /**
   * to indicate if the folder is the Inbox. The Inbox cannot be renamed or deleted.
   * @return isInbox
  **/
  @ApiModelProperty(value = "to indicate if the folder is the Inbox. The Inbox cannot be renamed or deleted.")
  public Boolean getIsInbox() {
    return isInbox;
  }

  public void setIsInbox(Boolean isInbox) {
    this.isInbox = isInbox;
  }

  public Folder id(UUID id) {
    this.id = id;
    return this;
  }

   /**
   * Xero unique identifier for a folder  Files
   * @return id
  **/
  @ApiModelProperty(example = "4ff1e5cc-9835-40d5-bb18-09fdb118db9c", value = "Xero unique identifier for a folder  Files")
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Folder folder = (Folder) o;
    return Objects.equals(this.name, folder.name) &&
        Objects.equals(this.fileCount, folder.fileCount) &&
        Objects.equals(this.email, folder.email) &&
        Objects.equals(this.isInbox, folder.isInbox) &&
        Objects.equals(this.id, folder.id);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, fileCount, email, isInbox, id);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Folder {\n");
    
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    fileCount: ").append(toIndentedString(fileCount)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    isInbox: ").append(toIndentedString(isInbox)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

