/*
 * Xero Files API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * OpenAPI spec version: 1.0.0
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.xero.models.files;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.UUID;
import org.threeten.bp.OffsetDateTime;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

/**
 * User
 */

public class User {
  
  @JsonProperty("UserID")
  private UUID userID = null;

  
  @JsonProperty("EmailAddress")
  private String emailAddress = null;

  
  @JsonProperty("FirstName")
  private String firstName = null;

  
  @JsonProperty("LastName")
  private String lastName = null;

  @JsonDeserialize(using = com.xero.api.CustomOffsetDateTimeDeserializer.class)
  @JsonProperty("UpdatedDateUTC")
  private OffsetDateTime updatedDateUTC = null;

  
  @JsonProperty("IsSubscriber")
  private Boolean isSubscriber = null;

  /**
   * Boolean to indicate if user is the subscriber
   */
  public enum OrganisationRoleEnum {
    READONLY("READONLY"),
    
    INVOICEONLY("INVOICEONLY"),
    
    STANDARD("STANDARD"),
    
    FINANCIALADVISER("FINANCIALADVISER"),
    
    MANAGEDCLIENT("MANAGEDCLIENT"),
    
    CASHBOOKCLIENT("CASHBOOKCLIENT");

    private String value;

    OrganisationRoleEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static OrganisationRoleEnum fromValue(String text) {
      for (OrganisationRoleEnum b : OrganisationRoleEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + text + "'");
    }
  }

  
  @JsonProperty("OrganisationRole")
  private OrganisationRoleEnum organisationRole = null;

  public User userID(UUID userID) {
    this.userID = userID;
    return this;
  }

   /**
   * Xero identifier
   * @return userID
  **/
  @ApiModelProperty(example = "4ff1e5cc-9835-40d5-bb18-09fdb118db9c", value = "Xero identifier")
  public UUID getUserID() {
    return userID;
  }

  public void setUserID(UUID userID) {
    this.userID = userID;
  }

  public User emailAddress(String emailAddress) {
    this.emailAddress = emailAddress;
    return this;
  }

   /**
   * Email address of user
   * @return emailAddress
  **/
  @ApiModelProperty(example = "john.smith@mail.com", value = "Email address of user")
  public String getEmailAddress() {
    return emailAddress;
  }

  public void setEmailAddress(String emailAddress) {
    this.emailAddress = emailAddress;
  }

  public User firstName(String firstName) {
    this.firstName = firstName;
    return this;
  }

   /**
   * First name of user
   * @return firstName
  **/
  @ApiModelProperty(example = "John", required = true, value = "First name of user")
  public String getFirstName() {
    return firstName;
  }

  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }

  public User lastName(String lastName) {
    this.lastName = lastName;
    return this;
  }

   /**
   * Last name of user
   * @return lastName
  **/
  @ApiModelProperty(example = "Smith", required = true, value = "Last name of user")
  public String getLastName() {
    return lastName;
  }

  public void setLastName(String lastName) {
    this.lastName = lastName;
  }

  public User updatedDateUTC(OffsetDateTime updatedDateUTC) {
    this.updatedDateUTC = updatedDateUTC;
    return this;
  }

   /**
   * Last name of user
   * @return updatedDateUTC
  **/
  @ApiModelProperty(value = "Last name of user")
  public OffsetDateTime getUpdatedDateUTC() {
    return updatedDateUTC;
  }

  public void setUpdatedDateUTC(OffsetDateTime updatedDateUTC) {
    this.updatedDateUTC = updatedDateUTC;
  }

  public User isSubscriber(Boolean isSubscriber) {
    this.isSubscriber = isSubscriber;
    return this;
  }

   /**
   * Boolean to indicate if user is the subscriber
   * @return isSubscriber
  **/
  @ApiModelProperty(value = "Boolean to indicate if user is the subscriber")
  public Boolean getIsSubscriber() {
    return isSubscriber;
  }

  public void setIsSubscriber(Boolean isSubscriber) {
    this.isSubscriber = isSubscriber;
  }

  public User organisationRole(OrganisationRoleEnum organisationRole) {
    this.organisationRole = organisationRole;
    return this;
  }

   /**
   * Boolean to indicate if user is the subscriber
   * @return organisationRole
  **/
  @ApiModelProperty(example = "STANDARD", value = "Boolean to indicate if user is the subscriber")
  public OrganisationRoleEnum getOrganisationRole() {
    return organisationRole;
  }

  public void setOrganisationRole(OrganisationRoleEnum organisationRole) {
    this.organisationRole = organisationRole;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    User user = (User) o;
    return Objects.equals(this.userID, user.userID) &&
        Objects.equals(this.emailAddress, user.emailAddress) &&
        Objects.equals(this.firstName, user.firstName) &&
        Objects.equals(this.lastName, user.lastName) &&
        Objects.equals(this.updatedDateUTC, user.updatedDateUTC) &&
        Objects.equals(this.isSubscriber, user.isSubscriber) &&
        Objects.equals(this.organisationRole, user.organisationRole);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userID, emailAddress, firstName, lastName, updatedDateUTC, isSubscriber, organisationRole);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class User {\n");
    
    sb.append("    userID: ").append(toIndentedString(userID)).append("\n");
    sb.append("    emailAddress: ").append(toIndentedString(emailAddress)).append("\n");
    sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
    sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
    sb.append("    updatedDateUTC: ").append(toIndentedString(updatedDateUTC)).append("\n");
    sb.append("    isSubscriber: ").append(toIndentedString(isSubscriber)).append("\n");
    sb.append("    organisationRole: ").append(toIndentedString(organisationRole)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

