/*
 * Decompiled with CFR 0.152.
 */
package com.xero.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.threetenbp.ThreeTenModule;
import com.google.api.client.googleapis.util.Utils;
import com.google.api.client.http.AbstractHttpContent;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.xero.api.CustomInstantDeserializer;
import com.xero.api.RFC3339DateFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import org.threeten.bp.Instant;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZonedDateTime;

public class ApiClient {
    private final String basePath;
    private final HttpRequestFactory httpRequestFactory;
    private final ObjectMapper objectMapper;
    private static final String defaultBasePath = "https://virtserver.swaggerhub.com/SidneyAllen/assets-api/1.0.0";

    private static ObjectMapper createDefaultObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).setDateFormat((DateFormat)((Object)new RFC3339DateFormat())).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        ThreeTenModule module = new ThreeTenModule();
        module.addDeserializer(Instant.class, CustomInstantDeserializer.INSTANT);
        module.addDeserializer(OffsetDateTime.class, CustomInstantDeserializer.OFFSET_DATE_TIME);
        module.addDeserializer(ZonedDateTime.class, CustomInstantDeserializer.ZONED_DATE_TIME);
        objectMapper.registerModule((Module)module);
        return objectMapper;
    }

    public ApiClient() {
        this(null, null, null, null);
    }

    public ApiClient(String basePath, HttpTransport httpTransport, HttpRequestInitializer initializer, ObjectMapper objectMapper) {
        this.basePath = basePath == null ? defaultBasePath : (basePath.endsWith("/") ? basePath.substring(0, basePath.length() - 1) : basePath);
        this.httpRequestFactory = (httpTransport == null ? Utils.getDefaultTransport() : httpTransport).createRequestFactory(initializer);
        this.objectMapper = objectMapper == null ? ApiClient.createDefaultObjectMapper() : objectMapper;
    }

    public HttpRequestFactory getHttpRequestFactory() {
        return this.httpRequestFactory;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public class JacksonJsonHttpContent
    extends AbstractHttpContent {
        private final Object data;

        public JacksonJsonHttpContent(Object data) {
            super("application/json; charset=UTF-8");
            this.data = data;
        }

        public void writeTo(OutputStream out) throws IOException {
            ApiClient.this.objectMapper.writeValue(out, this.data);
        }
    }
}

