/*
 * Decompiled with CFR 0.152.
 */
package com.xero.api;

import com.google.api.client.auth.oauth.OAuthSigner;
import com.xero.api.Config;
import com.xero.api.HmacSignerFactory;
import com.xero.api.RsaSignerFactory;
import com.xero.api.SignerFactory;

public class ConfigBasedSignerFactory
implements SignerFactory {
    private static final String PUBLIC_APP = "PUBLIC";
    private Config config;

    public ConfigBasedSignerFactory(Config config) {
        this.config = config;
    }

    @Override
    public OAuthSigner createSigner(String tokenSharedSecret) {
        if (this.config.getAppType().equals(PUBLIC_APP)) {
            return new HmacSignerFactory(this.config.getConsumerSecret()).createSigner(tokenSharedSecret);
        }
        return new RsaSignerFactory(this.config.getPathToPrivateKey(), this.config.getPrivateKeyPassword()).createSigner(tokenSharedSecret);
    }
}

