/*
 * Decompiled with CFR 0.152.
 */
package com.xero.api;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.threeten.bp.Instant;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZoneId;

public class CustomOffsetDateTimeDeserializer
extends StdDeserializer<OffsetDateTime> {
    private static final long serialVersionUID = 1L;

    public CustomOffsetDateTimeDeserializer() {
        this(null);
    }

    public CustomOffsetDateTimeDeserializer(Class<?> vc) {
        super(vc);
    }

    public OffsetDateTime deserialize(JsonParser jsonparser, DeserializationContext context) throws IOException, JsonProcessingException {
        String date = jsonparser.getText();
        Pattern datePatt = Pattern.compile("^/Date\\((\\d+)([+-]\\d+)?\\)/$");
        Matcher m = datePatt.matcher(date);
        if (!m.matches()) {
            throw new IllegalArgumentException("Wrong date format");
        }
        Long l = Long.parseLong(m.group(1));
        OffsetDateTime formattedDate = Instant.ofEpochMilli((long)l).atZone(ZoneId.systemDefault()).toOffsetDateTime();
        return formattedDate;
    }
}

