/*
 * Decompiled with CFR 0.152.
 */
package com.xero.api;

import com.xero.api.Config;
import com.xero.api.XeroClientException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class JsonConfig
implements Config {
    private String SDK_VERSION = "2.2.18";
    private String APP_TYPE = "Public";
    private String USER_AGENT = "Xero-Java-SDK";
    private String ACCEPT = "application/xml";
    private String CONSUMER_KEY;
    private String CONSUMER_SECRET;
    private String API_BASE_URL = "https://api.xero.com";
    private String API_ENDPOINT_URL = "https://api.xero.com/api.xro/2.0/";
    private String FILES_ENDPOINT_URL = "https://api.xero.com/files.xro/1.0/";
    private String ASSETS_ENDPOINT_URL = "https://api.xero.com/assets.xro/1.0";
    private String BANKFEEDS_ENDPOINT_URL = "https://api.xero.com/bankfeeds.xro/1.0";
    private String REQUEST_TOKEN_URL = "https://api.xero.com/oauth/RequestToken";
    private String AUTHENTICATE_URL = "https://api.xero.com/oauth/Authorize";
    private String ACCESS_TOKEN_URL = "https://api.xero.com/oauth/AccessToken";
    private String API_ENDPOINT_STEM = "/api.xro/2.0/";
    private String FILES_ENDPOINT_STEM = "/files.xro/1.0/";
    private String ASSETS_ENDPOINT_STEM = "/assets.xro/1.0/";
    private String BANKFEEDS_ENDPOINT_STEM = "/bankfeeds.xro/1.0/";
    private String REQUEST_TOKEN_STEM = "/oauth/RequestToken";
    private String AUTHENTICATE_STEM = "/oauth/Authorize";
    private String ACCESS_TOKEN_STEM = "/oauth/AccessToken";
    private String CALLBACK_BASE_URL;
    private String AUTH_CALLBACK_URL;
    private String PATH_TO_PRIVATE_KEY_CERT;
    private String PRIVATE_KEY_PASSWORD;
    private String PROXY_HOST;
    private long PROXY_PORT = 80L;
    private boolean PROXY_HTTPS_ENABLED = false;
    private int CONNECT_TIMEOUT = 60;
    private int READ_TIMEOUT = 60;
    private String DECIMAL_PLACES = null;
    private boolean USING_APP_FIREWALL = false;
    private String APP_FIREWALL_HOSTNAME;
    private String APP_FIREWALL_URL_PREFIX;
    private String KEY_STORE_PATH;
    private String KEY_STORE_PASSWORD;
    private String configFile;
    private static Config instance = null;
    static final Logger logger = LogManager.getLogger(JsonConfig.class);

    public JsonConfig(String configFile) {
        this.configFile = configFile;
        this.load();
    }

    public static Config getInstance() {
        if (instance == null) {
            instance = new JsonConfig("config.json");
        }
        return instance;
    }

    @Override
    public String getAppType() {
        return this.APP_TYPE;
    }

    @Override
    public String getPrivateKeyPassword() {
        return this.PRIVATE_KEY_PASSWORD;
    }

    @Override
    public String getPathToPrivateKey() {
        return this.PATH_TO_PRIVATE_KEY_CERT;
    }

    @Override
    public String getConsumerKey() {
        return this.CONSUMER_KEY;
    }

    @Override
    public String getConsumerSecret() {
        return this.CONSUMER_SECRET;
    }

    @Override
    public String getApiUrl() {
        return this.API_ENDPOINT_URL;
    }

    @Override
    public String getFilesUrl() {
        return this.FILES_ENDPOINT_URL;
    }

    @Override
    public String getAssetsUrl() {
        return this.ASSETS_ENDPOINT_URL;
    }

    @Override
    public String getBankFeedsUrl() {
        return this.BANKFEEDS_ENDPOINT_URL;
    }

    @Override
    public String getRequestTokenUrl() {
        return this.REQUEST_TOKEN_URL;
    }

    @Override
    public String getAuthorizeUrl() {
        return this.AUTHENTICATE_URL;
    }

    @Override
    public String getAccessTokenUrl() {
        return this.ACCESS_TOKEN_URL;
    }

    @Override
    public String getUserAgent() {
        return this.USER_AGENT + " " + this.CONSUMER_KEY + " [Xero-Java-" + this.SDK_VERSION + "]";
    }

    @Override
    public String getAccept() {
        return this.ACCEPT;
    }

    @Override
    public String getRedirectUri() {
        return this.AUTH_CALLBACK_URL;
    }

    @Override
    public String getProxyHost() {
        return this.PROXY_HOST;
    }

    @Override
    public long getProxyPort() {
        return this.PROXY_PORT;
    }

    @Override
    public boolean getProxyHttpsEnabled() {
        return this.PROXY_HTTPS_ENABLED;
    }

    @Override
    public int getConnectTimeout() {
        return this.CONNECT_TIMEOUT;
    }

    @Override
    public int getReadTimeout() {
        return this.READ_TIMEOUT;
    }

    @Override
    public String getDecimalPlaces() {
        return this.DECIMAL_PLACES;
    }

    @Override
    public boolean isUsingAppFirewall() {
        return this.USING_APP_FIREWALL;
    }

    @Override
    public String getAppFirewallHostname() {
        return this.APP_FIREWALL_HOSTNAME;
    }

    @Override
    public String getAppFirewallUrlPrefix() {
        return this.APP_FIREWALL_URL_PREFIX;
    }

    @Override
    public String getKeyStorePath() {
        return this.KEY_STORE_PATH;
    }

    @Override
    public String getKeyStorePassword() {
        return this.KEY_STORE_PASSWORD;
    }

    @Override
    public void setConsumerKey(String consumerKey) {
        this.CONSUMER_KEY = consumerKey;
    }

    @Override
    public void setConsumerSecret(String consumerSecret) {
        this.CONSUMER_SECRET = consumerSecret;
    }

    @Override
    public void setAppType(String appType) {
        this.APP_TYPE = appType;
    }

    @Override
    public void setAuthCallBackUrl(String authCallbackUrl) {
        this.AUTH_CALLBACK_URL = authCallbackUrl;
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        this.CONNECT_TIMEOUT = connectTimeout;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this.READ_TIMEOUT = readTimeout;
    }

    @Override
    public void setDecimalPlaces(String decimalPlaces) {
        this.DECIMAL_PLACES = decimalPlaces;
    }

    @Override
    public void setUsingAppFirewall(boolean usingAppFirewall) {
        this.USING_APP_FIREWALL = usingAppFirewall;
    }

    @Override
    public void setAppFirewallHostname(String appFirewallHostname) {
        this.APP_FIREWALL_HOSTNAME = appFirewallHostname;
    }

    @Override
    public void setAppFirewallUrlPrefix(String appFirewallUrlPrefix) {
        this.APP_FIREWALL_URL_PREFIX = appFirewallUrlPrefix;
    }

    @Override
    public void setKeyStorePath(String keyStorePath) {
        this.KEY_STORE_PATH = keyStorePath;
    }

    @Override
    public void setKeyStorePassword(String keyStorePassword) {
        this.KEY_STORE_PASSWORD = keyStorePassword;
    }

    private void load() {
        JSONObject jsonObject;
        InputStream inputStream = JsonConfig.class.getResourceAsStream("/" + this.configFile);
        if (inputStream == null) {
            logger.error(String.format("Config file '%s' could not be found in src/resources folder. Missing file?", this.configFile));
            throw new XeroClientException(String.format("Config file '%s' could not be opened. Missing file?", this.configFile));
        }
        try (InputStreamReader reader = new InputStreamReader(inputStream);){
            JSONParser parser = new JSONParser();
            jsonObject = (JSONObject)parser.parse((Reader)reader);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e);
            throw new XeroClientException(String.format("Config file '%s' not found", this.configFile), e);
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw new XeroClientException(String.format("IO error reading config file '%s' not found", this.configFile), e);
        }
        catch (ParseException e) {
            logger.error((Object)e);
            throw new XeroClientException(String.format("Parse error reading config file '%s' not found", this.configFile), e);
        }
        if (jsonObject.containsKey((Object)"AppType")) {
            this.APP_TYPE = (String)jsonObject.get((Object)"AppType");
        }
        if (jsonObject.containsKey((Object)"UserAgent")) {
            this.USER_AGENT = (String)jsonObject.get((Object)"UserAgent");
        }
        if (jsonObject.containsKey((Object)"Accept")) {
            this.ACCEPT = (String)jsonObject.get((Object)"Accept");
        }
        if (jsonObject.containsKey((Object)"ConsumerKey")) {
            this.CONSUMER_KEY = (String)jsonObject.get((Object)"ConsumerKey");
        }
        if (jsonObject.containsKey((Object)"ConsumerSecret")) {
            this.CONSUMER_SECRET = (String)jsonObject.get((Object)"ConsumerSecret");
        }
        if (jsonObject.containsKey((Object)"ApiBaseUrl")) {
            this.API_BASE_URL = (String)jsonObject.get((Object)"ApiBaseUrl");
            if (jsonObject.containsKey((Object)"ApiEndpointPath")) {
                String endpointPath = (String)jsonObject.get((Object)"ApiEndpointPath");
                this.API_ENDPOINT_URL = this.API_BASE_URL + endpointPath;
            } else {
                this.API_ENDPOINT_URL = this.API_BASE_URL + this.API_ENDPOINT_STEM;
            }
            if (jsonObject.containsKey((Object)"FilesEndpointPath")) {
                String filesEndpointPath = (String)jsonObject.get((Object)"FilesEndpointPath");
                this.FILES_ENDPOINT_URL = this.API_BASE_URL + filesEndpointPath;
            } else {
                this.FILES_ENDPOINT_URL = this.API_BASE_URL + this.FILES_ENDPOINT_STEM;
            }
            if (jsonObject.containsKey((Object)"AssetsEndpointPath")) {
                String assetsEndpointPath = (String)jsonObject.get((Object)"AssetsEndpointPath");
                this.ASSETS_ENDPOINT_URL = this.API_BASE_URL + assetsEndpointPath;
            } else {
                this.ASSETS_ENDPOINT_URL = this.API_BASE_URL + this.ASSETS_ENDPOINT_STEM;
            }
            if (jsonObject.containsKey((Object)"BankFeedsEndpointPath")) {
                String BankFeedsEndpointPath = (String)jsonObject.get((Object)"BankFeedsEndpointPath");
                this.BANKFEEDS_ENDPOINT_URL = this.API_BASE_URL + BankFeedsEndpointPath;
            } else {
                this.BANKFEEDS_ENDPOINT_URL = this.API_BASE_URL + this.BANKFEEDS_ENDPOINT_STEM;
            }
            if (jsonObject.containsKey((Object)"RequestTokenPath")) {
                String requestPath = (String)jsonObject.get((Object)"RequestTokenPath");
                this.REQUEST_TOKEN_URL = this.API_BASE_URL + requestPath;
            } else {
                this.REQUEST_TOKEN_URL = this.API_BASE_URL + this.REQUEST_TOKEN_STEM;
            }
            if (jsonObject.containsKey((Object)"AccessTokenPath")) {
                String accessPath = (String)jsonObject.get((Object)"AccessTokenPath");
                this.ACCESS_TOKEN_URL = this.API_BASE_URL + accessPath;
            } else {
                this.ACCESS_TOKEN_URL = this.API_BASE_URL + this.ACCESS_TOKEN_STEM;
            }
            if (jsonObject.containsKey((Object)"AuthenticateUrl")) {
                String authenticatePath = (String)jsonObject.get((Object)"AuthenticateUrl");
                this.AUTHENTICATE_URL = this.API_BASE_URL + authenticatePath;
            } else {
                this.AUTHENTICATE_URL = this.API_BASE_URL + this.AUTHENTICATE_STEM;
            }
        }
        if (jsonObject.containsKey((Object)"CallbackBaseUrl")) {
            this.CALLBACK_BASE_URL = (String)jsonObject.get((Object)"CallbackBaseUrl");
            if (jsonObject.containsKey((Object)"CallbackPath")) {
                String callbackPath = (String)jsonObject.get((Object)"CallbackPath");
                this.AUTH_CALLBACK_URL = this.CALLBACK_BASE_URL + callbackPath;
            }
        }
        if (jsonObject.containsKey((Object)"PrivateKeyCert")) {
            this.PATH_TO_PRIVATE_KEY_CERT = (String)jsonObject.get((Object)"PrivateKeyCert");
            this.PRIVATE_KEY_PASSWORD = (String)jsonObject.get((Object)"PrivateKeyPassword");
        }
        if (jsonObject.containsKey((Object)"ProxyHost")) {
            this.PROXY_HOST = (String)jsonObject.get((Object)"ProxyHost");
            if (jsonObject.containsKey((Object)"ProxyPort")) {
                this.PROXY_PORT = (Long)jsonObject.get((Object)"ProxyPort");
            }
            if (jsonObject.containsKey((Object)"ProxyHttpsEnabled")) {
                this.PROXY_HTTPS_ENABLED = (Boolean)jsonObject.get((Object)"ProxyHttpsEnabled");
            }
        }
        if (jsonObject.containsKey((Object)"DecimalPlaces")) {
            this.DECIMAL_PLACES = (String)jsonObject.get((Object)"DecimalPlaces");
        }
        if (jsonObject.containsKey((Object)"KeyStorePath")) {
            this.KEY_STORE_PATH = (String)jsonObject.get((Object)"KeyStorePath");
        }
        if (jsonObject.containsKey((Object)"KeyStorePassword")) {
            this.KEY_STORE_PASSWORD = (String)jsonObject.get((Object)"KeyStorePassword");
        }
        if (jsonObject.containsKey((Object)"usingAppFirewall")) {
            this.USING_APP_FIREWALL = (Boolean)jsonObject.get((Object)"usingAppFirewall");
            if (jsonObject.containsKey((Object)"appFirewallHostname")) {
                this.APP_FIREWALL_HOSTNAME = (String)jsonObject.get((Object)"appFirewallHostname");
            }
            if (jsonObject.containsKey((Object)"appFirewallUrlPrefix")) {
                this.APP_FIREWALL_URL_PREFIX = (String)jsonObject.get((Object)"appFirewallUrlPrefix");
            }
        }
    }
}

