/*
 * Decompiled with CFR 0.152.
 */
package com.xero.api;

import com.google.api.client.auth.oauth.OAuthCredentialsResponse;
import com.google.api.client.auth.oauth.OAuthSigner;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.UrlEncodedParser;
import com.xero.api.Config;
import com.xero.api.ConfigBasedSignerFactory;
import com.xero.api.OAuthParameters;
import com.xero.api.SignerFactory;
import com.xero.api.XeroHttpContext;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class OAuthAccessToken {
    private String token = null;
    private String tokenSecret = null;
    private String sessionHandle = null;
    private long tokenTimestamp;
    private boolean isSuccess;
    private String problem = null;
    private String advice = null;
    private Config config;
    private SignerFactory signerFactory;
    private CloseableHttpClient httpclient;
    public String verifier;
    public String tempToken;
    private String tempTokenSecret;
    private int connectTimeout = 20;
    private int readTimeout = 20;
    private GenericUrl requestUrl;
    private HttpGet httpget;

    public OAuthAccessToken(Config config) {
        this(config, new ConfigBasedSignerFactory(config));
    }

    public OAuthAccessToken(Config config, SignerFactory signerFactory) {
        this.config = config;
        this.signerFactory = signerFactory;
    }

    public OAuthAccessToken build(String verifier, String tempToken, String tempTokenSecret) throws IOException {
        this.verifier = verifier;
        this.tempToken = tempToken;
        this.tempTokenSecret = tempTokenSecret;
        this.connectTimeout = this.config.getConnectTimeout() * 1000;
        this.readTimeout = this.config.getReadTimeout() * 1000;
        this.httpclient = new XeroHttpContext(this.config).getHttpClient();
        this.requestUrl = new GenericUrl(this.config.getAccessTokenUrl());
        this.httpget = new HttpGet(this.config.getAccessTokenUrl());
        this.createParameters().intercept(this.httpget, this.requestUrl);
        return this;
    }

    public OAuthAccessToken build() throws IOException {
        this.connectTimeout = this.config.getConnectTimeout() * 1000;
        this.readTimeout = this.config.getReadTimeout() * 1000;
        this.httpclient = new XeroHttpContext(this.config).getHttpClient();
        this.requestUrl = new GenericUrl(this.config.getAccessTokenUrl());
        this.httpget = new HttpGet(this.config.getAccessTokenUrl());
        this.createRefreshParameters().intercept(this.httpget, this.requestUrl);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws IOException {
        RequestConfig.Builder requestConfig = RequestConfig.custom().setConnectTimeout(this.connectTimeout).setConnectionRequestTimeout(this.readTimeout).setSocketTimeout(this.connectTimeout);
        if (!"".equals(this.config.getProxyHost()) && this.config.getProxyHost() != null) {
            int port = (int)(this.config.getProxyPort() == 80L && this.config.getProxyHttpsEnabled() ? 443L : this.config.getProxyPort());
            HttpHost proxy = new HttpHost(this.config.getProxyHost(), port, this.config.getProxyHttpsEnabled() ? "https" : "http");
            requestConfig.setProxy(proxy);
        }
        this.httpget.setConfig(requestConfig.build());
        try (CloseableHttpResponse response = this.httpclient.execute((HttpUriRequest)this.httpget);){
            HttpEntity entity = response.getEntity();
            String retSrc = EntityUtils.toString((HttpEntity)entity);
            OAuthCredentialsResponse oauthResponse = new OAuthCredentialsResponse();
            UrlEncodedParser.parse((String)retSrc, (Object)oauthResponse);
            if (!(oauthResponse.token != null && oauthResponse.token.length() != 0 || this.config.getKeyStorePassword() != null && this.config.getKeyStorePassword().length() != 0)) {
                Map<String, String> oauthError = OAuthAccessToken.getQueryMap(retSrc);
                this.problem = oauthError.get("oauth_problem");
                this.advice = oauthError.get("oauth_problem_advice");
                this.isSuccess = false;
            } else {
                Map<String, String> oauthKeys = OAuthAccessToken.getQueryMap(retSrc);
                this.token = oauthKeys.get("oauth_token");
                this.tokenSecret = oauthKeys.get("oauth_token_secret");
                this.sessionHandle = oauthKeys.get("oauth_session_handle");
                this.tokenTimestamp = System.currentTimeMillis() / 1000L;
                this.isSuccess = true;
            }
            EntityUtils.consume((HttpEntity)entity);
        }
        finally {
            this.httpclient.close();
        }
        return this.isSuccess;
    }

    public void setToken(String token) {
        this.token = token;
        if (this.config.getAppType().equals("PRIVATE")) {
            this.token = this.config.getConsumerKey();
        }
    }

    public String getToken() {
        return this.token;
    }

    public void setTokenSecret(String secret) {
        this.tokenSecret = secret;
    }

    public String getTokenSecret() {
        return this.tokenSecret;
    }

    public Boolean isSuccess() {
        return this.isSuccess;
    }

    public String getProblem() {
        return this.problem;
    }

    public String getAdvice() {
        return this.advice;
    }

    public void setSessionHandle(String sessionHandle) {
        this.sessionHandle = sessionHandle;
    }

    public String getSessionHandle() {
        return this.sessionHandle;
    }

    public String getTokenTimestamp() {
        String s = Objects.toString(this.tokenTimestamp, null);
        return s;
    }

    private static Map<String, String> getQueryMap(String query) {
        String[] params = query.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params) {
            String name = param.split("=")[0];
            String value = param.split("=")[1];
            map.put(name, value);
        }
        return map;
    }

    public HashMap<String, String> getAll() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("token", this.getToken());
        map.put("tokenSecret", this.getTokenSecret());
        map.put("sessionHandle", this.getSessionHandle());
        map.put("tokenTimestamp", this.getTokenTimestamp());
        return map;
    }

    private OAuthParameters createParameters() {
        OAuthSigner signer = this.signerFactory.createSigner(this.tempTokenSecret);
        OAuthParameters result = new OAuthParameters();
        result.consumerKey = this.config.getConsumerKey();
        result.usingAppFirewall = this.config.isUsingAppFirewall();
        result.appFirewallHostname = this.config.getAppFirewallHostname();
        result.appFirewallUrlPrefix = this.config.getAppFirewallUrlPrefix();
        result.token = this.tempToken;
        result.verifier = this.verifier;
        result.signer = signer;
        return result;
    }

    private OAuthParameters createRefreshParameters() {
        OAuthSigner signer = this.signerFactory.createSigner(null);
        OAuthParameters result = new OAuthParameters();
        result.consumerKey = this.config.getConsumerKey();
        result.usingAppFirewall = this.config.isUsingAppFirewall();
        result.appFirewallHostname = this.config.getAppFirewallHostname();
        result.appFirewallUrlPrefix = this.config.getAppFirewallUrlPrefix();
        result.token = this.token;
        result.sessionHandle = this.sessionHandle;
        result.signer = signer;
        return result;
    }

    public boolean isStale(String timestamp) {
        boolean bool = false;
        if (timestamp == null || timestamp.isEmpty()) {
            bool = false;
        } else {
            long tokenTimestamp;
            long currentTime = System.currentTimeMillis() / 1000L;
            long secondsElapsed = currentTime - (tokenTimestamp = Long.parseLong(timestamp));
            if (secondsElapsed >= 1800L) {
                bool = true;
            }
        }
        return bool;
    }
}

