/*
 * Decompiled with CFR 0.152.
 */
package com.xero.api;

import com.google.api.client.auth.oauth.OAuthCredentialsResponse;
import com.google.api.client.auth.oauth.OAuthSigner;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.UrlEncodedParser;
import com.xero.api.Config;
import com.xero.api.OAuthParameters;
import com.xero.api.XeroApiException;
import com.xero.api.XeroHttpContext;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class OAuthGetTemporaryToken
extends GenericUrl {
    public String callback;
    public String consumerKey;
    public OAuthSigner signer;
    protected boolean usePost;
    private boolean usingAppFirewall;
    private String appFirewallHostname = "";
    private String appFirewallUrlPrefix = "";
    public Config config;
    private CloseableHttpClient httpclient;
    private int connectTimeout = 20;
    private int readTimeout = 20;

    public OAuthGetTemporaryToken(String authorizationServerUrl) {
        super(authorizationServerUrl);
    }

    public OAuthGetTemporaryToken(String authorizationServerUrl, boolean usingAppFirewall, String appFirewallHostname, String appFirewallUrlPrefix) {
        super(authorizationServerUrl);
        this.usingAppFirewall = usingAppFirewall;
        this.appFirewallHostname = appFirewallHostname;
        this.appFirewallUrlPrefix = appFirewallUrlPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final OAuthCredentialsResponse execute() throws IOException, XeroApiException {
        this.connectTimeout = this.config.getConnectTimeout() * 1000;
        this.readTimeout = this.config.getReadTimeout() * 1000;
        this.httpclient = new XeroHttpContext(this.config).getHttpClient();
        GenericUrl requestUrl = new GenericUrl(this.config.getRequestTokenUrl());
        HttpGet httpget = new HttpGet(this.config.getRequestTokenUrl());
        RequestConfig.Builder requestConfig = RequestConfig.custom().setConnectTimeout(this.connectTimeout).setConnectionRequestTimeout(this.readTimeout).setSocketTimeout(this.connectTimeout);
        if (!"".equals(this.config.getProxyHost()) && this.config.getProxyHost() != null) {
            int port = (int)(this.config.getProxyPort() == 80L && this.config.getProxyHttpsEnabled() ? 443L : this.config.getProxyPort());
            HttpHost proxy = new HttpHost(this.config.getProxyHost(), port, this.config.getProxyHttpsEnabled() ? "https" : "http");
            requestConfig.setProxy(proxy);
        }
        this.createParameters().intercept(httpget, requestUrl);
        httpget.setConfig(requestConfig.build());
        try {
            OAuthCredentialsResponse oAuthCredentialsResponse;
            CloseableHttpResponse response = this.httpclient.execute((HttpUriRequest)httpget);
            try {
                HttpEntity entity = response.getEntity();
                String content = EntityUtils.toString((HttpEntity)entity);
                OAuthCredentialsResponse oauthResponse = new OAuthCredentialsResponse();
                UrlEncodedParser.parse((String)content, (Object)oauthResponse);
                int code = response.getStatusLine().getStatusCode();
                if (oauthResponse.token == null) {
                    XeroApiException e = new XeroApiException(400, content);
                    throw e;
                }
                if (code != 200) {
                    XeroApiException e = new XeroApiException(code, content);
                    throw e;
                }
                EntityUtils.consume((HttpEntity)entity);
                oAuthCredentialsResponse = oauthResponse;
            }
            catch (Throwable throwable) {
                response.close();
                throw throwable;
            }
            response.close();
            return oAuthCredentialsResponse;
        }
        finally {
            this.httpclient.close();
        }
    }

    public OAuthParameters createParameters() {
        OAuthParameters result = new OAuthParameters();
        result.usingAppFirewall = this.usingAppFirewall;
        result.appFirewallHostname = this.appFirewallHostname;
        result.appFirewallUrlPrefix = this.appFirewallUrlPrefix;
        result.consumerKey = this.consumerKey;
        result.signer = this.signer;
        result.callback = this.callback;
        return result;
    }

    public void setConfig(Config config) {
        this.config = config;
        this.consumerKey = config.getConsumerKey();
        this.callback = config.getRedirectUri();
    }
}

