/*
 * Decompiled with CFR 0.152.
 */
package com.xero.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.auth.oauth.OAuthSigner;
import com.google.api.client.http.GenericUrl;
import com.xero.api.Config;
import com.xero.api.OAuthParameters;
import com.xero.api.SignerFactory;
import com.xero.api.XeroApiException;
import com.xero.api.XeroHttpContext;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.format.DateTimeFormatter;

public class OAuthRequestResource {
    private String token;
    private String tokenSecret;
    private GenericUrl url;
    private byte[] requestBody = null;
    public String contentType = null;
    public String ifModifiedSince = null;
    public String accept = null;
    private String body = null;
    private String httpMethod = "GET";
    private String resource;
    private int connectTimeout = 20;
    private int readTimeout = 20;
    private Map<? extends String, ?> params = null;
    private Config config;
    private SignerFactory signerFactory;
    private String fileName;
    static final Logger logger = LogManager.getLogger(OAuthRequestResource.class);

    private OAuthRequestResource(Config config, SignerFactory signerFactory, String resource, String method, Map<? extends String, ?> params) {
        this.config = config;
        this.signerFactory = signerFactory;
        this.resource = resource;
        this.httpMethod = method;
        this.params = params;
        this.connectTimeout = config.getConnectTimeout() * 1000;
        this.readTimeout = config.getReadTimeout() * 1000;
    }

    public OAuthRequestResource(Config config, SignerFactory signerFactory, String resource, String method, String body, Map<? extends String, ?> params) {
        this(config, signerFactory, resource, method, params);
        this.body = body;
    }

    public OAuthRequestResource(Config config, SignerFactory signerFactory, String resource, String method, String body, Map<? extends String, ?> params, String accept, String contentType) {
        this(config, signerFactory, resource, method, params);
        this.accept = accept;
        this.contentType = contentType;
        this.body = body;
    }

    public OAuthRequestResource(Config config, SignerFactory signerFactory, String resource, String method, String body, Map<? extends String, ?> params, String accept) {
        this(config, signerFactory, resource, method, params);
        this.accept = accept;
        this.body = body;
    }

    public OAuthRequestResource(Config config, SignerFactory signerFactory, String resource, String method, String contentType, byte[] bytes, Map<? extends String, ?> params) {
        this(config, signerFactory, resource, method, params);
        this.contentType = contentType;
        this.requestBody = bytes;
    }

    public OAuthRequestResource(Config config, SignerFactory signerFactory, String resource, String method, String contentType, byte[] bytes, Map<? extends String, ?> params, String accept) {
        this(config, signerFactory, resource, method, params);
        this.contentType = contentType;
        this.requestBody = bytes;
        this.accept = accept;
    }

    public OAuthRequestResource(Config config, SignerFactory signerFactory, String resource, String method, String contentType, File file, Map<? extends String, ?> params) {
        this(config, signerFactory, resource, method, params);
        this.contentType = contentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ByteArrayInputStream executefile() throws UnsupportedOperationException, IOException {
        CloseableHttpClient httpclient = null;
        httpclient = new XeroHttpContext(this.config, this.accept, this.ifModifiedSince).getHttpClient();
        if (this.resource.indexOf("https") == -1) {
            this.resource = this.config.getApiUrl() + this.resource;
        }
        this.url = new GenericUrl(this.resource);
        if (this.params != null) {
            this.url.putAll(this.params);
        }
        RequestConfig.Builder requestConfig = RequestConfig.custom().setConnectTimeout(this.connectTimeout).setConnectionRequestTimeout(this.readTimeout).setSocketTimeout(this.connectTimeout);
        if (!"".equals(this.config.getProxyHost()) && this.config.getProxyHost() != null) {
            int port = (int)(this.config.getProxyPort() == 80L && this.config.getProxyHttpsEnabled() ? 443L : this.config.getProxyPort());
            HttpHost proxy = new HttpHost(this.config.getProxyHost(), port, this.config.getProxyHttpsEnabled() ? "https" : "http");
            requestConfig.setProxy(proxy);
        }
        HttpGet httpget = new HttpGet(this.url.toString());
        if (this.httpMethod == "GET") {
            this.createParameters().intercept(httpget, this.url);
            httpget.setConfig(requestConfig.build());
        }
        HttpPost httppost = new HttpPost(this.url.toString());
        if (this.httpMethod == "POST") {
            httppost.setEntity((HttpEntity)new StringEntity(this.body, "utf-8"));
            httppost.addHeader("Content-Type", this.contentType);
            this.createParameters().intercept(httppost, this.url);
            httppost.setConfig(requestConfig.build());
        }
        HttpPut httpput = new HttpPut(this.url.toString());
        if (this.httpMethod == "PUT") {
            httpput.setEntity((HttpEntity)new StringEntity(this.body, "utf-8"));
            httpput.addHeader("Content-Type", this.contentType);
            this.createParameters().intercept(httpput, this.url);
            httpput.setConfig(requestConfig.build());
        }
        try {
            ByteArrayInputStream byteArrayInputStream;
            CloseableHttpResponse response = null;
            if (this.httpMethod == "GET") {
                response = httpclient.execute((HttpUriRequest)httpget);
            }
            if (this.httpMethod == "POST") {
                response = httpclient.execute((HttpUriRequest)httppost);
            }
            if (this.httpMethod == "PUT") {
                response = httpclient.execute((HttpUriRequest)httpput);
            }
            try {
                HttpEntity entity = response.getEntity();
                List<Header> httpHeaders = Arrays.asList(response.getAllHeaders());
                for (Header header : httpHeaders) {
                    if (header.getName() != "Content-Disposition") continue;
                    this.fileName = this.parseFileName(header.getValue());
                }
                InputStream is = entity.getContent();
                byte[] bytes = IOUtils.toByteArray((InputStream)is);
                is.close();
                byteArrayInputStream = new ByteArrayInputStream(bytes);
            }
            catch (Throwable throwable) {
                response.close();
                throw throwable;
            }
            response.close();
            return byteArrayInputStream;
        }
        finally {
            httpclient.close();
        }
    }

    private String parseFileName(String param) {
        String fileName = null;
        Pattern regex = Pattern.compile("(?<=filename=\").*?(?=\")");
        Matcher regexMatcher = regex.matcher(param);
        if (regexMatcher.find()) {
            fileName = regexMatcher.group();
        }
        return fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, String> execute() throws IOException, XeroApiException {
        CloseableHttpClient httpclient = null;
        httpclient = new XeroHttpContext(this.config, this.accept, this.ifModifiedSince).getHttpClient();
        if (this.resource.indexOf("https") == -1) {
            this.resource = this.config.getApiUrl() + this.resource;
        }
        this.url = new GenericUrl(this.resource);
        if (this.params != null) {
            this.url.putAll(this.params);
        }
        RequestConfig.Builder requestConfig = RequestConfig.custom().setConnectTimeout(this.connectTimeout).setConnectionRequestTimeout(this.readTimeout).setSocketTimeout(this.connectTimeout);
        if (!"".equals(this.config.getProxyHost()) && this.config.getProxyHost() != null) {
            int port = (int)(this.config.getProxyPort() == 80L && this.config.getProxyHttpsEnabled() ? 443L : this.config.getProxyPort());
            HttpHost proxy = new HttpHost(this.config.getProxyHost(), port, this.config.getProxyHttpsEnabled() ? "https" : "http");
            requestConfig.setProxy(proxy);
        }
        HttpGet httpget = new HttpGet(this.url.toString());
        if (this.httpMethod == "GET") {
            this.createParameters().intercept(httpget, this.url);
            httpget.setConfig(requestConfig.build());
            if (logger.isInfoEnabled()) {
                logger.info("------------------ GET : URL -------------------");
                logger.info(this.url.toString());
            }
        }
        HttpPost httppost = new HttpPost(this.url.toString());
        if (this.httpMethod == "POST") {
            if (logger.isInfoEnabled()) {
                logger.info("------------------ POST: BODY  -------------------");
                logger.info(this.body);
            }
            if (this.requestBody != null) {
                httppost.setEntity((HttpEntity)new ByteArrayEntity(this.requestBody));
            } else {
                httppost.setEntity((HttpEntity)new StringEntity(this.body, "utf-8"));
            }
            httppost.addHeader("Content-Type", this.contentType);
            this.createParameters().intercept(httppost, this.url);
            httppost.setConfig(requestConfig.build());
        }
        HttpPut httpput = new HttpPut(this.url.toString());
        if (this.httpMethod == "PUT") {
            if (logger.isInfoEnabled()) {
                logger.info("------------------ PUT : BODY  -------------------");
                logger.info(this.body);
            }
            if (this.requestBody != null) {
                httpput.setEntity((HttpEntity)new ByteArrayEntity(this.requestBody));
            } else {
                httpput.setEntity((HttpEntity)new StringEntity(this.body, "utf-8"));
            }
            httpput.addHeader("Content-Type", this.contentType);
            this.createParameters().intercept(httpput, this.url);
            httpput.setConfig(requestConfig.build());
        }
        HttpDelete httpdelete = new HttpDelete(this.url.toString());
        if (this.httpMethod == "DELETE") {
            this.createParameters().intercept(httpdelete, this.url);
            httpdelete.setConfig(requestConfig.build());
            if (logger.isInfoEnabled()) {
                logger.info("------------------ DELTE : URL -------------------");
                logger.info(this.url.toString());
            }
        }
        try {
            HashMap<String, String> hashMap;
            CloseableHttpResponse response = null;
            if (this.httpMethod == "GET") {
                response = httpclient.execute((HttpUriRequest)httpget);
            }
            if (this.httpMethod == "POST") {
                response = httpclient.execute((HttpUriRequest)httppost);
            }
            if (this.httpMethod == "PUT") {
                response = httpclient.execute((HttpUriRequest)httpput);
            }
            if (this.httpMethod == "DELETE") {
                response = httpclient.execute((HttpUriRequest)httpdelete);
            }
            try {
                int code;
                String content = "";
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    content = EntityUtils.toString((HttpEntity)entity);
                }
                if ((code = response.getStatusLine().getStatusCode()) == 204) {
                    content = this.contentType == "application/json" ? "{\"Status\": \"DELETED\" }" : "<Response><Status>DELETED</Status></Response>";
                }
                if (code != 200 && code != 201 && code != 202 && code != 204) {
                    Header rateHeader = response.getFirstHeader("x-rate-limit-problem");
                    if (rateHeader != null) {
                        content = content + "&rate=" + rateHeader.getValue().toLowerCase();
                    }
                    XeroApiException e = new XeroApiException(code, content);
                    throw e;
                }
                HashMap<String, String> responseMap = new HashMap<String, String>();
                this.addToMapIfNotNull(responseMap, "content", content);
                this.addToMapIfNotNull(responseMap, "code", code);
                if (entity != null) {
                    EntityUtils.consume((HttpEntity)entity);
                }
                hashMap = responseMap;
            }
            catch (Throwable throwable) {
                response.close();
                throw throwable;
            }
            response.close();
            return hashMap;
        }
        finally {
            httpclient.close();
        }
    }

    protected void addToMapIfNotNull(Map<String, String> map, String key, Object value) {
        if (value != null) {
            map.put(key, value.toString());
        }
    }

    public void setMethod(String method) {
        this.httpMethod = method;
    }

    public void setToken(String token) {
        this.token = token;
        if (this.config.getAppType().equals("PRIVATE")) {
            this.token = this.config.getConsumerKey();
        }
    }

    public void setTokenSecret(String secret) {
        this.tokenSecret = secret;
    }

    public void setIfModifiedSince(OffsetDateTime modifiedAfter) {
        this.ifModifiedSince = modifiedAfter.format(DateTimeFormatter.ofPattern((String)"yyyy-MM-dd'T'HH:mm:ss"));
    }

    public void setIfModifiedSince(Date modifiedAfter) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        this.ifModifiedSince = formatter.format(modifiedAfter);
    }

    public OAuthParameters createParameters() {
        OAuthSigner signer = this.signerFactory.createSigner(this.tokenSecret);
        OAuthParameters result = new OAuthParameters();
        result.consumerKey = this.config.getConsumerKey();
        result.usingAppFirewall = this.config.isUsingAppFirewall();
        result.appFirewallHostname = this.config.getAppFirewallHostname();
        result.appFirewallUrlPrefix = this.config.getAppFirewallUrlPrefix();
        result.token = this.token;
        result.signer = signer;
        return result;
    }

    @Deprecated
    public void setProxy(String host, int port, boolean httpsEnabled) {
    }

    public static boolean isJSONValid(String jsonInString) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.readTree(jsonInString);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

