/*
 * Decompiled with CFR 0.152.
 */
package com.xero.api;

import com.google.api.client.auth.oauth.OAuthCredentialsResponse;
import com.google.api.client.auth.oauth.OAuthSigner;
import com.xero.api.Config;
import com.xero.api.ConfigBasedSignerFactory;
import com.xero.api.OAuthGetTemporaryToken;
import com.xero.api.SignerFactory;
import com.xero.api.XeroApiException;
import java.io.IOException;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OAuthRequestToken {
    private String tempToken = null;
    private String tempTokenSecret = null;
    private OAuthGetTemporaryToken tokenRequest = null;
    private Config config;
    private SignerFactory signerFactory;
    static final Logger logger = LogManager.getLogger(OAuthRequestToken.class);

    public OAuthRequestToken(Config config) {
        this(config, new ConfigBasedSignerFactory(config));
    }

    public OAuthRequestToken(Config config, SignerFactory signerFactory) {
        this.config = config;
        this.signerFactory = signerFactory;
    }

    public void execute() throws XeroApiException, IOException {
        OAuthSigner signer = this.signerFactory.createSigner(null);
        this.tokenRequest = this.config.isUsingAppFirewall() ? new OAuthGetTemporaryToken(this.config.getRequestTokenUrl(), this.config.isUsingAppFirewall(), this.config.getAppFirewallHostname(), this.config.getAppFirewallUrlPrefix()) : new OAuthGetTemporaryToken(this.config.getRequestTokenUrl());
        this.tokenRequest.setConfig(this.config);
        this.tokenRequest.signer = signer;
        OAuthCredentialsResponse temporaryTokenResponse = null;
        try {
            temporaryTokenResponse = this.tokenRequest.execute();
            this.tempToken = temporaryTokenResponse.token;
            this.tempTokenSecret = temporaryTokenResponse.tokenSecret;
        }
        catch (XeroApiException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw e;
        }
    }

    public String getTempToken() {
        return this.tempToken;
    }

    public String getTempTokenSecret() {
        return this.tempTokenSecret;
    }

    public HashMap<String, String> getAll() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tempToken", this.getTempToken());
        map.put("tempTokenSecret", this.getTempTokenSecret());
        map.put("sessionHandle", "");
        map.put("tokenTimestamp", "");
        return map;
    }
}

