/*
 * Decompiled with CFR 0.152.
 */
package com.xero.api;

import com.google.api.client.auth.oauth.OAuthRsaSigner;
import com.xero.api.SignerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RsaSignerFactory
implements SignerFactory {
    private OAuthRsaSigner signer = new OAuthRsaSigner();
    static final Logger logger = LogManager.getLogger(RsaSignerFactory.class);

    public RsaSignerFactory(String pathToPrivateKey, String privateKeyPassword) {
        try (InputStream privateKeyInputStream = RsaSignerFactory.getInputStreamForPath(pathToPrivateKey);){
            this.signer.privateKey = RsaSignerFactory.loadPrivateKey(privateKeyInputStream, privateKeyPassword.toCharArray());
        }
        catch (IOException ex) {
            logger.error((Object)ex);
            throw new RuntimeException(ex);
        }
    }

    public RsaSignerFactory(InputStream privateKeyInputStream, String privateKeyPassword) {
        this.signer.privateKey = RsaSignerFactory.loadPrivateKey(privateKeyInputStream, privateKeyPassword.toCharArray());
    }

    public OAuthRsaSigner createSigner(String tokenSharedSecret) {
        return this.signer;
    }

    private static PrivateKey loadPrivateKey(InputStream stream, char[] password) {
        PrivateKey oauthKey = null;
        try {
            KeyStore oauthKeyStore = KeyStore.getInstance("PKCS12");
            oauthKeyStore.load(stream, password);
            for (String alias : Collections.list(oauthKeyStore.aliases())) {
                if (!oauthKeyStore.isKeyEntry(alias)) continue;
                oauthKey = (PrivateKey)oauthKeyStore.getKey(alias, password);
            }
        }
        catch (IOException | RuntimeException | GeneralSecurityException ex) {
            logger.error((Object)ex);
            throw new RuntimeException(ex);
        }
        return oauthKey;
    }

    private static InputStream getInputStreamForPath(String path) {
        File f = new File(path);
        if (f.isFile()) {
            try {
                return new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                logger.info("Could not open file from file system, defaulting to classpath.");
            }
        }
        return RsaSignerFactory.class.getResourceAsStream(path);
    }
}

