/*
 * Decompiled with CFR 0.152.
 */
package com.xero.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xero.api.ApiClient;
import com.xero.api.Config;
import com.xero.api.ConfigBasedSignerFactory;
import com.xero.api.JsonConfig;
import com.xero.api.OAuthRequestResource;
import com.xero.api.SignerFactory;
import com.xero.api.XeroApiException;
import com.xero.api.exception.XeroExceptionHandler;
import com.xero.api.jaxb.XeroJAXBMarshaller;
import com.xero.model.Account;
import com.xero.model.Allocation;
import com.xero.model.ArrayOfAccount;
import com.xero.model.ArrayOfAllocation;
import com.xero.model.ArrayOfBankTransaction;
import com.xero.model.ArrayOfBankTransfer;
import com.xero.model.ArrayOfBrandingTheme;
import com.xero.model.ArrayOfContact;
import com.xero.model.ArrayOfContactGroup;
import com.xero.model.ArrayOfCreditNote;
import com.xero.model.ArrayOfCurrency;
import com.xero.model.ArrayOfEmployee;
import com.xero.model.ArrayOfExpenseClaim;
import com.xero.model.ArrayOfInvoice;
import com.xero.model.ArrayOfInvoiceReminder;
import com.xero.model.ArrayOfItem;
import com.xero.model.ArrayOfJournal;
import com.xero.model.ArrayOfLinkedTransaction;
import com.xero.model.ArrayOfManualJournal;
import com.xero.model.ArrayOfOverpayment;
import com.xero.model.ArrayOfPayment;
import com.xero.model.ArrayOfPrepayment;
import com.xero.model.ArrayOfPurchaseOrder;
import com.xero.model.ArrayOfReceipt;
import com.xero.model.ArrayOfRepeatingInvoice;
import com.xero.model.ArrayOfTaxRate;
import com.xero.model.ArrayOfTrackingCategory;
import com.xero.model.ArrayOfTrackingCategoryOption;
import com.xero.model.ArrayOfUser;
import com.xero.model.Attachment;
import com.xero.model.BankTransaction;
import com.xero.model.BankTransfer;
import com.xero.model.BrandingTheme;
import com.xero.model.Contact;
import com.xero.model.ContactGroup;
import com.xero.model.ContactGroupStatus;
import com.xero.model.CreditNote;
import com.xero.model.Currency;
import com.xero.model.Employee;
import com.xero.model.ExpenseClaim;
import com.xero.model.Invoice;
import com.xero.model.InvoiceReminder;
import com.xero.model.Item;
import com.xero.model.Journal;
import com.xero.model.LinkedTransaction;
import com.xero.model.ManualJournal;
import com.xero.model.ObjectFactory;
import com.xero.model.OnlineInvoice;
import com.xero.model.Organisation;
import com.xero.model.Overpayment;
import com.xero.model.Payment;
import com.xero.model.PaymentStatus;
import com.xero.model.Prepayment;
import com.xero.model.PurchaseOrder;
import com.xero.model.Receipt;
import com.xero.model.RepeatingInvoice;
import com.xero.model.Report;
import com.xero.model.Response;
import com.xero.model.TaxRate;
import com.xero.model.TrackingCategory;
import com.xero.model.TrackingCategoryOption;
import com.xero.model.User;
import com.xero.models.assets.Assets;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBElement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.simple.parser.ParseException;

public class XeroClient {
    private XeroExceptionHandler xeroExceptionHandler;
    private Config config;
    private SignerFactory signerFactory;
    private String token = null;
    private String tokenSecret = null;
    static final Logger logger = LogManager.getLogger(XeroClient.class);
    static XeroJAXBMarshaller u = new XeroJAXBMarshaller();
    protected static final DateFormat utcFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    protected static final Pattern MESSAGE_PATTERN;
    protected final ObjectFactory objFactory = new ObjectFactory();

    public XeroClient() {
        this(JsonConfig.getInstance());
        this.xeroExceptionHandler = new XeroExceptionHandler();
    }

    public XeroClient(Config config) {
        this(config, new ConfigBasedSignerFactory(config));
        this.xeroExceptionHandler = new XeroExceptionHandler();
    }

    public XeroClient(Config config, SignerFactory signerFactory) {
        this.config = config;
        this.signerFactory = signerFactory;
        this.xeroExceptionHandler = new XeroExceptionHandler();
    }

    public void setOAuthToken(String token, String tokenSecret) {
        this.token = token;
        this.tokenSecret = tokenSecret;
    }

    protected Response get(String endPoint) throws IOException {
        return this.get(endPoint, null, null);
    }

    protected Response get(String endPoint, Date modifiedAfter, Map<String, String> params) throws IOException {
        OAuthRequestResource req = new OAuthRequestResource(this.config, this.signerFactory, endPoint, "GET", null, params);
        req.setToken(this.token);
        req.setTokenSecret(this.tokenSecret);
        if (modifiedAfter != null) {
            req.setIfModifiedSince(modifiedAfter);
        }
        try {
            Map<String, String> resp = req.execute();
            String r = resp.get("content");
            return u.unmarshall(r.toString(), Response.class);
        }
        catch (IOException ioe) {
            logger.error((Object)ioe);
            throw this.xeroExceptionHandler.convertException(ioe);
        }
        catch (XeroApiException e) {
            logger.error((Object)e);
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode());
        }
    }

    @Deprecated
    protected String getFile(String endPoint, Date modifiedAfter, Map<String, String> params, String accept, String dirPath) throws IOException {
        OAuthRequestResource req = new OAuthRequestResource(this.config, this.signerFactory, endPoint, "GET", null, params, accept);
        req.setToken(this.token);
        req.setTokenSecret(this.tokenSecret);
        if (modifiedAfter != null) {
            req.setIfModifiedSince(modifiedAfter);
        }
        String saveFilePath = null;
        String fileName = null;
        try {
            ByteArrayInputStream input = req.executefile();
            fileName = req.getFileName();
            saveFilePath = dirPath + File.separator + fileName;
            FileOutputStream output = new FileOutputStream(saveFilePath);
            int DEFAULT_BUFFER_SIZE = 1024;
            byte[] buffer = new byte[DEFAULT_BUFFER_SIZE];
            int n = 0;
            n = input.read(buffer, 0, DEFAULT_BUFFER_SIZE);
            while (n >= 0) {
                output.write(buffer, 0, n);
                n = input.read(buffer, 0, DEFAULT_BUFFER_SIZE);
            }
            input.close();
            output.close();
            return saveFilePath;
        }
        catch (IOException ioe) {
            logger.error((Object)ioe);
            throw this.xeroExceptionHandler.convertException(ioe);
        }
        catch (XeroApiException e) {
            logger.error((Object)e);
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode());
        }
    }

    protected ByteArrayInputStream getInputStream(String endPoint, Date modifiedAfter, Map<String, String> params, String accept) throws IOException {
        OAuthRequestResource req = new OAuthRequestResource(this.config, this.signerFactory, endPoint, "GET", null, params, accept);
        req.setToken(this.token);
        req.setTokenSecret(this.tokenSecret);
        if (modifiedAfter != null) {
            req.setIfModifiedSince(modifiedAfter);
        }
        try {
            ByteArrayInputStream byteStream = req.executefile();
            return byteStream;
        }
        catch (IOException ioe) {
            logger.error((Object)ioe);
            throw this.xeroExceptionHandler.convertException(ioe);
        }
        catch (XeroApiException e) {
            logger.error((Object)e);
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode());
        }
    }

    protected Response put(String endPoint, JAXBElement<?> object) {
        String contents = u.marshall(object);
        OAuthRequestResource req = new OAuthRequestResource(this.config, this.signerFactory, endPoint, "PUT", contents, null);
        req.setToken(this.token);
        req.setTokenSecret(this.tokenSecret);
        try {
            Map<String, String> resp = req.execute();
            String r = resp.get("content");
            return u.unmarshall(r.toString(), Response.class);
        }
        catch (IOException ioe) {
            logger.error((Object)ioe);
            throw this.xeroExceptionHandler.convertException(ioe);
        }
        catch (XeroApiException e) {
            logger.error((Object)e);
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode());
        }
    }

    protected Response put(String endPoint, String contentType, byte[] bytes) throws IOException {
        return this.put(endPoint, contentType, bytes, null);
    }

    protected Response put(String endPoint, String contentType, byte[] bytes, Map<? extends String, ?> params) throws IOException {
        OAuthRequestResource req = new OAuthRequestResource(this.config, this.signerFactory, endPoint, "PUT", contentType, bytes, params);
        req.setToken(this.token);
        req.setTokenSecret(this.tokenSecret);
        try {
            Map<String, String> resp = req.execute();
            String r = resp.get("content");
            return u.unmarshall(r.toString(), Response.class);
        }
        catch (IOException ioe) {
            logger.error((Object)ioe);
            throw this.xeroExceptionHandler.convertException(ioe);
        }
        catch (XeroApiException e) {
            logger.error((Object)e);
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode());
        }
    }

    protected Response put(String endPoint, JAXBElement<?> object, Map<String, String> params) {
        String contents = u.marshall(object);
        OAuthRequestResource req = new OAuthRequestResource(this.config, this.signerFactory, endPoint, "PUT", contents, params);
        req.setToken(this.token);
        req.setTokenSecret(this.tokenSecret);
        try {
            Map<String, String> resp = req.execute();
            String r = resp.get("content");
            return u.unmarshall(r.toString(), Response.class);
        }
        catch (IOException ioe) {
            logger.error((Object)ioe);
            throw this.xeroExceptionHandler.convertException(ioe);
        }
        catch (XeroApiException e) {
            logger.error((Object)e);
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode());
        }
    }

    protected Response put(String endPoint, String contentType, File file) throws IOException {
        OAuthRequestResource req = new OAuthRequestResource(this.config, this.signerFactory, endPoint, "PUT", contentType, file, null);
        req.setToken(this.token);
        req.setTokenSecret(this.tokenSecret);
        try {
            Map<String, String> resp = req.execute();
            String r = resp.get("content");
            return u.unmarshall(r.toString(), Response.class);
        }
        catch (IOException ioe) {
            logger.error((Object)ioe);
            throw this.xeroExceptionHandler.convertException(ioe);
        }
        catch (XeroApiException e) {
            logger.error((Object)e);
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode());
        }
    }

    protected Response post(String endPoint, JAXBElement<?> object) throws IOException {
        String contents = u.marshall(object);
        OAuthRequestResource req = new OAuthRequestResource(this.config, this.signerFactory, endPoint, "POST", contents, null);
        req.setToken(this.token);
        req.setTokenSecret(this.tokenSecret);
        try {
            Map<String, String> resp = req.execute();
            String r = resp.get("content");
            return u.unmarshall(r.toString(), Response.class);
        }
        catch (IOException ioe) {
            logger.error((Object)ioe);
            throw this.xeroExceptionHandler.convertException(ioe);
        }
        catch (XeroApiException e) {
            logger.error((Object)e);
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode());
        }
    }

    protected Response post(String endPoint, JAXBElement<?> object, Map<String, String> params) throws IOException {
        String contents = u.marshall(object);
        OAuthRequestResource req = new OAuthRequestResource(this.config, this.signerFactory, endPoint, "POST", contents, params);
        req.setToken(this.token);
        req.setTokenSecret(this.tokenSecret);
        try {
            Map<String, String> resp = req.execute();
            String r = resp.get("content");
            return u.unmarshall(r.toString(), Response.class);
        }
        catch (IOException ioe) {
            logger.error((Object)ioe);
            throw this.xeroExceptionHandler.convertException(ioe);
        }
        catch (XeroApiException e) {
            logger.error((Object)e);
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode());
        }
    }

    protected Response delete(String endPoint) throws IOException {
        OAuthRequestResource req = new OAuthRequestResource(this.config, this.signerFactory, endPoint, "DELETE", null, null);
        req.setToken(this.token);
        req.setTokenSecret(this.tokenSecret);
        try {
            Map<String, String> resp = req.execute();
            String r = resp.get("content");
            return u.unmarshall(r.toString(), Response.class);
        }
        catch (IOException ioe) {
            logger.error((Object)ioe);
            throw this.xeroExceptionHandler.convertException(ioe);
        }
        catch (XeroApiException e) {
            logger.error((Object)e);
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode());
        }
    }

    protected void addToMapIfNotNull(Map<String, String> map, String key, Object value) {
        if (value != null) {
            map.put(key, value.toString());
        }
    }

    protected <T> T singleResult(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            throw new IllegalStateException("Got multiple results for query");
        }
        return list.get(0);
    }

    public List<Account> getAccounts() throws IOException {
        Response responseObj = this.get("Accounts");
        if (responseObj.getAccounts() == null) {
            ArrayOfAccount array = new ArrayOfAccount();
            return array.getAccount();
        }
        return responseObj.getAccounts().getAccount();
    }

    public List<Account> getAccounts(Date modifiedAfter, String where, String order) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "Where", where);
        this.addToMapIfNotNull(params, "order", order);
        Response responseObj = this.get("Accounts", modifiedAfter, params);
        if (responseObj.getAccounts() == null) {
            ArrayOfAccount array = new ArrayOfAccount();
            return array.getAccount();
        }
        return responseObj.getAccounts().getAccount();
    }

    public List<Account> createAccounts(List<Account> objects) throws IOException {
        ArrayOfAccount array = new ArrayOfAccount();
        array.getAccount().addAll(objects);
        return this.put("Accounts", this.objFactory.createAccounts(array)).getAccounts().getAccount();
    }

    public List<Account> updateAccount(List<Account> objects) throws IOException {
        ArrayOfAccount array = new ArrayOfAccount();
        array.getAccount().addAll(objects);
        return this.post("Accounts", this.objFactory.createAccounts(array)).getAccounts().getAccount();
    }

    public Account getAccount(String id) throws IOException {
        return (Account)this.singleResult(this.get("Accounts/" + id).getAccounts().getAccount());
    }

    public String deleteAccount(String id) throws IOException {
        return this.delete("Accounts/" + id).getStatus();
    }

    public List<BankTransaction> getBankTransactions() throws IOException {
        Response responseObj = this.get("BankTransactions");
        if (responseObj.getBankTransactions() == null) {
            ArrayOfBankTransaction array = new ArrayOfBankTransaction();
            return array.getBankTransaction();
        }
        return responseObj.getBankTransactions().getBankTransaction();
    }

    public List<BankTransaction> getBankTransactions(Date modifiedAfter, String where, String order) throws IOException {
        return this.getBankTransactions(modifiedAfter, where, order, null);
    }

    public List<BankTransaction> getBankTransactions(Date modifiedAfter, String where, String order, String page) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "Where", where);
        this.addToMapIfNotNull(params, "order", order);
        this.addToMapIfNotNull(params, "page", page);
        Response responseObj = this.get("BankTransactions", modifiedAfter, params);
        if (responseObj.getBankTransactions() == null) {
            ArrayOfBankTransaction array = new ArrayOfBankTransaction();
            return array.getBankTransaction();
        }
        return responseObj.getBankTransactions().getBankTransaction();
    }

    public List<BankTransaction> getBankTransactions(Date modifiedAfter, String where, String order, String page, String unitdp) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "Where", where);
        this.addToMapIfNotNull(params, "order", order);
        this.addToMapIfNotNull(params, "page", page);
        this.addToMapIfNotNull(params, "unitdp", unitdp);
        Response responseObj = this.get("BankTransactions", modifiedAfter, params);
        if (responseObj.getBankTransactions() == null) {
            ArrayOfBankTransaction array = new ArrayOfBankTransaction();
            return array.getBankTransaction();
        }
        return responseObj.getBankTransactions().getBankTransaction();
    }

    public List<BankTransaction> createBankTransactions(List<BankTransaction> bankTransactions) throws IOException {
        ArrayOfBankTransaction array = new ArrayOfBankTransaction();
        array.getBankTransaction().addAll(bankTransactions);
        return this.put("BankTransactions", this.objFactory.createBankTransactions(array)).getBankTransactions().getBankTransaction();
    }

    public List<BankTransaction> createBankTransactions(List<BankTransaction> bankTransactions, String unitdp) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "unitdp", unitdp);
        ArrayOfBankTransaction array = new ArrayOfBankTransaction();
        array.getBankTransaction().addAll(bankTransactions);
        return this.put("BankTransactions", this.objFactory.createBankTransactions(array), params).getBankTransactions().getBankTransaction();
    }

    public List<BankTransaction> updateBankTransactions(List<BankTransaction> bankTransactions) throws IOException {
        ArrayOfBankTransaction array = new ArrayOfBankTransaction();
        array.getBankTransaction().addAll(bankTransactions);
        return this.post("BankTransactions", this.objFactory.createBankTransactions(array)).getBankTransactions().getBankTransaction();
    }

    public List<BankTransaction> updateBankTransactions(List<BankTransaction> bankTransactions, String unitdp) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "unitdp", unitdp);
        ArrayOfBankTransaction array = new ArrayOfBankTransaction();
        array.getBankTransaction().addAll(bankTransactions);
        return this.post("BankTransactions", this.objFactory.createBankTransactions(array), params).getBankTransactions().getBankTransaction();
    }

    public BankTransaction getBankTransaction(String id) throws IOException {
        return (BankTransaction)this.singleResult(this.get("BankTransactions/" + id).getBankTransactions().getBankTransaction());
    }

    public BankTransaction getBankTransaction(String id, String unitdp) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "unitdp", unitdp);
        return (BankTransaction)this.singleResult(this.get("BankTransactions/" + id, null, params).getBankTransactions().getBankTransaction());
    }

    public List<BankTransfer> getBankTransfers() throws IOException {
        Response responseObj = this.get("BankTransfers");
        if (responseObj.getBankTransfers() == null) {
            ArrayOfBankTransfer array = new ArrayOfBankTransfer();
            return array.getBankTransfer();
        }
        return responseObj.getBankTransfers().getBankTransfer();
    }

    public List<BankTransfer> getBankTransfers(Date modifiedAfter, String where, String order) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "Where", where);
        this.addToMapIfNotNull(params, "order", order);
        Response responseObj = this.get("BankTransfers", modifiedAfter, params);
        if (responseObj.getBankTransfers() == null) {
            ArrayOfBankTransfer array = new ArrayOfBankTransfer();
            return array.getBankTransfer();
        }
        return responseObj.getBankTransfers().getBankTransfer();
    }

    public List<BankTransfer> createBankTransfers(List<BankTransfer> bankTransfers) throws IOException {
        ArrayOfBankTransfer array = new ArrayOfBankTransfer();
        array.getBankTransfer().addAll(bankTransfers);
        return this.put("BankTransfers", this.objFactory.createBankTransfers(array)).getBankTransfers().getBankTransfer();
    }

    public BankTransfer getBankTransfer(String id) throws IOException {
        return (BankTransfer)this.singleResult(this.get("BankTransfers/" + id).getBankTransfers().getBankTransfer());
    }

    public List<BrandingTheme> getBrandingThemes() throws IOException {
        Response responseObj = this.get("BrandingThemes");
        if (responseObj.getBrandingThemes() == null) {
            ArrayOfBrandingTheme array = new ArrayOfBrandingTheme();
            return array.getBrandingTheme();
        }
        return responseObj.getBrandingThemes().getBrandingTheme();
    }

    public List<BrandingTheme> getBrandingThemes(Date modifiedAfter, String where, String order) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "Where", where);
        this.addToMapIfNotNull(params, "order", order);
        Response responseObj = this.get("BrandingThemes", modifiedAfter, params);
        if (responseObj.getBrandingThemes() == null) {
            ArrayOfBrandingTheme array = new ArrayOfBrandingTheme();
            return array.getBrandingTheme();
        }
        return responseObj.getBrandingThemes().getBrandingTheme();
    }

    public BrandingTheme getBrandingTheme(String id) throws IOException {
        return (BrandingTheme)this.singleResult(this.get("BrandingThemes/" + id).getBrandingThemes().getBrandingTheme());
    }

    public List<Contact> getContacts() throws IOException {
        Response responseObj = this.get("Contacts");
        if (responseObj.getContacts() == null) {
            ArrayOfContact array = new ArrayOfContact();
            return array.getContact();
        }
        return responseObj.getContacts().getContact();
    }

    public List<Contact> getContacts(Date modifiedAfter, String where, String order) throws IOException {
        return this.getContacts(modifiedAfter, where, order, null, null);
    }

    public List<Contact> getContacts(Date modifiedAfter, String where, String order, String page) throws IOException {
        return this.getContacts(modifiedAfter, where, order, page, null);
    }

    public List<Contact> getContacts(Date modifiedAfter, String where, String order, String page, Boolean includeArchived) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "Where", where);
        this.addToMapIfNotNull(params, "order", order);
        this.addToMapIfNotNull(params, "page", page);
        this.addToMapIfNotNull(params, "includeArchived", includeArchived);
        Response responseObj = this.get("Contacts", modifiedAfter, params);
        if (responseObj.getContacts() == null) {
            ArrayOfContact array = new ArrayOfContact();
            return array.getContact();
        }
        return responseObj.getContacts().getContact();
    }

    public List<Contact> createContact(List<Contact> contacts) throws IOException {
        ArrayOfContact array = new ArrayOfContact();
        array.getContact().addAll(contacts);
        return this.put("Contacts", this.objFactory.createContacts(array)).getContacts().getContact();
    }

    public List<Contact> updateContact(List<Contact> contacts) throws IOException {
        ArrayOfContact array = new ArrayOfContact();
        array.getContact().addAll(contacts);
        return this.post("Contacts", this.objFactory.createContacts(array)).getContacts().getContact();
    }

    public Contact getContact(String id) throws IOException {
        return (Contact)this.singleResult(this.get("Contacts/" + id).getContacts().getContact());
    }

    public List<ContactGroup> getContactGroups() throws IOException {
        Response responseObj = this.get("ContactGroups");
        if (responseObj.getContactGroups() == null) {
            ArrayOfContactGroup array = new ArrayOfContactGroup();
            return array.getContactGroup();
        }
        return responseObj.getContactGroups().getContactGroup();
    }

    public List<ContactGroup> getContactGroups(Date modifiedAfter, String where, String order) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "Where", where);
        this.addToMapIfNotNull(params, "order", order);
        Response responseObj = this.get("ContactGroups", modifiedAfter, params);
        if (responseObj.getContactGroups() == null) {
            ArrayOfContactGroup array = new ArrayOfContactGroup();
            return array.getContactGroup();
        }
        return responseObj.getContactGroups().getContactGroup();
    }

    public List<ContactGroup> createContactGroups(List<ContactGroup> ContactGroups2) throws IOException {
        ArrayOfContactGroup array = new ArrayOfContactGroup();
        array.getContactGroup().addAll(ContactGroups2);
        return this.put("ContactGroups", this.objFactory.createContactGroups(array)).getContactGroups().getContactGroup();
    }

    public List<ContactGroup> updateContactGroup(List<ContactGroup> objects) throws IOException {
        ArrayOfContactGroup array = new ArrayOfContactGroup();
        array.getContactGroup().addAll(objects);
        return this.post("ContactGroups", this.objFactory.createContactGroups(array)).getContactGroups().getContactGroup();
    }

    public ContactGroup getContactGroup(String id) throws IOException {
        return (ContactGroup)this.singleResult(this.get("ContactGroups/" + id).getContactGroups().getContactGroup());
    }

    public List<ContactGroup> deleteContactGroup(ContactGroup object) throws IOException {
        object.setStatus(ContactGroupStatus.DELETED);
        ArrayOfContactGroup array = new ArrayOfContactGroup();
        array.getContactGroup().add(object);
        return this.post("ContactGroups", this.objFactory.createContactGroups(array)).getContactGroups().getContactGroup();
    }

    public List<Contact> createContactGroupContacts(List<Contact> objects, String id) throws IOException {
        ArrayOfContact array = new ArrayOfContact();
        array.getContact().addAll(objects);
        return this.put("ContactGroups/" + id + "/Contacts", this.objFactory.createContacts(array)).getContacts().getContact();
    }

    public String deleteSingleContactFromContactGroup(String ContactGroupId, String ContactId) throws IOException {
        System.out.println(ContactGroupId);
        System.out.println(ContactId);
        return this.delete("ContactGroups/" + ContactGroupId + "/Contacts/" + ContactId).getStatus();
    }

    public String deleteAllContactsFromContactGroup(String ContactGroupId) throws IOException {
        return this.delete("ContactGroups/" + ContactGroupId + "/Contacts").getStatus();
    }

    public List<CreditNote> getCreditNotes() throws IOException {
        Response responseObj = this.get("CreditNotes");
        if (responseObj.getCreditNotes() == null) {
            ArrayOfCreditNote array = new ArrayOfCreditNote();
            return array.getCreditNote();
        }
        return responseObj.getCreditNotes().getCreditNote();
    }

    public List<CreditNote> getCreditNotes(Date modifiedAfter, String where, String order) throws IOException {
        return this.getCreditNotes(modifiedAfter, where, order, null);
    }

    public List<CreditNote> getCreditNotes(Date modifiedAfter, String where, String order, String page) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "where", where);
        this.addToMapIfNotNull(params, "order", order);
        this.addToMapIfNotNull(params, "page", page);
        Response responseObj = this.get("CreditNotes", modifiedAfter, params);
        if (responseObj.getCreditNotes() == null) {
            ArrayOfCreditNote array = new ArrayOfCreditNote();
            return array.getCreditNote();
        }
        return responseObj.getCreditNotes().getCreditNote();
    }

    public List<CreditNote> createCreditNotes(List<CreditNote> objects) throws IOException {
        ArrayOfCreditNote array = new ArrayOfCreditNote();
        array.getCreditNote().addAll(objects);
        return this.put("CreditNote", this.objFactory.createCreditNotes(array)).getCreditNotes().getCreditNote();
    }

    public List<CreditNote> createCreditNotes(List<CreditNote> objects, String unitdp) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "unitdp", unitdp);
        ArrayOfCreditNote array = new ArrayOfCreditNote();
        array.getCreditNote().addAll(objects);
        return this.put("CreditNote", this.objFactory.createCreditNotes(array), params).getCreditNotes().getCreditNote();
    }

    public List<CreditNote> updateCreditNote(List<CreditNote> objects) throws IOException {
        ArrayOfCreditNote array = new ArrayOfCreditNote();
        array.getCreditNote().addAll(objects);
        return this.post("CreditNotes", this.objFactory.createCreditNotes(array)).getCreditNotes().getCreditNote();
    }

    public CreditNote getCreditNote(String id) throws IOException {
        return (CreditNote)this.singleResult(this.get("CreditNotes/" + id).getCreditNotes().getCreditNote());
    }

    @Deprecated
    public String getCreditNotePdf(String id, String dirPath) throws IOException {
        return this.getFile("CreditNotes/" + id, null, null, "application/pdf", dirPath);
    }

    public ByteArrayInputStream getCreditNotePdfContent(String id) throws IOException {
        return this.getInputStream("CreditNotes/" + id, null, null, "application/pdf");
    }

    public List<Allocation> createCreditNoteAllocations(List<Allocation> objects, String id) throws IOException {
        ArrayOfAllocation array = new ArrayOfAllocation();
        array.getAllocation().addAll(objects);
        return this.put("CreditNotes/" + id + "/Allocations", this.objFactory.createAllocations(array)).getAllocations().getAllocation();
    }

    public List<Currency> getCurrencies() throws IOException {
        Response responseObj = this.get("Currencies");
        if (responseObj.getCurrencies() == null) {
            ArrayOfCurrency array = new ArrayOfCurrency();
            return array.getCurrency();
        }
        return responseObj.getCurrencies().getCurrency();
    }

    public List<Currency> getCurrencies(Date modifiedAfter, String where, String order) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "Where", where);
        this.addToMapIfNotNull(params, "order", order);
        Response responseObj = this.get("Currencies", modifiedAfter, params);
        if (responseObj.getCurrencies() == null) {
            ArrayOfCurrency array = new ArrayOfCurrency();
            return array.getCurrency();
        }
        return responseObj.getCurrencies().getCurrency();
    }

    public Currency getCurrency(String id) throws IOException {
        return (Currency)this.singleResult(this.get("Currencies/" + id).getCurrencies().getCurrency());
    }

    public List<Currency> createCurrencies(List<Currency> objects) {
        ArrayOfCurrency array = new ArrayOfCurrency();
        array.getCurrency().addAll(objects);
        return this.put("Currencies", this.objFactory.createCurrencies(array)).getCurrencies().getCurrency();
    }

    public List<Employee> getEmployees() throws IOException {
        Response responseObj = this.get("Employees");
        if (responseObj.getEmployees() == null) {
            ArrayOfEmployee array = new ArrayOfEmployee();
            return array.getEmployee();
        }
        return responseObj.getEmployees().getEmployee();
    }

    public List<Employee> getEmployees(Date modifiedAfter, String where, String order) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "Where", where);
        this.addToMapIfNotNull(params, "order", order);
        Response responseObj = this.get("Employees", modifiedAfter, params);
        if (responseObj.getEmployees() == null) {
            ArrayOfEmployee array = new ArrayOfEmployee();
            return array.getEmployee();
        }
        return responseObj.getEmployees().getEmployee();
    }

    public List<Employee> createEmployees(List<Employee> objects) throws IOException {
        ArrayOfEmployee array = new ArrayOfEmployee();
        array.getEmployee().addAll(objects);
        return this.put("Employee", this.objFactory.createEmployees(array)).getEmployees().getEmployee();
    }

    public List<Employee> updateEmployee(List<Employee> objects) throws IOException {
        ArrayOfEmployee array = new ArrayOfEmployee();
        array.getEmployee().addAll(objects);
        return this.post("Employees", this.objFactory.createEmployees(array)).getEmployees().getEmployee();
    }

    public Employee getEmployee(String id) throws IOException {
        return (Employee)this.singleResult(this.get("Employees/" + id).getEmployees().getEmployee());
    }

    public List<ExpenseClaim> getExpenseClaims() throws IOException {
        Response responseObj = this.get("ExpenseClaims");
        if (responseObj.getExpenseClaims() == null) {
            ArrayOfExpenseClaim array = new ArrayOfExpenseClaim();
            return array.getExpenseClaim();
        }
        return responseObj.getExpenseClaims().getExpenseClaim();
    }

    public List<ExpenseClaim> getExpenseClaims(Date modifiedAfter, String where, String order) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "Where", where);
        this.addToMapIfNotNull(params, "order", order);
        Response responseObj = this.get("ExpenseClaims", modifiedAfter, params);
        if (responseObj.getExpenseClaims() == null) {
            ArrayOfExpenseClaim array = new ArrayOfExpenseClaim();
            return array.getExpenseClaim();
        }
        return responseObj.getExpenseClaims().getExpenseClaim();
    }

    public List<ExpenseClaim> createExpenseClaims(List<ExpenseClaim> objects) throws IOException {
        ArrayOfExpenseClaim array = new ArrayOfExpenseClaim();
        array.getExpenseClaim().addAll(objects);
        return this.put("ExpenseClaim", this.objFactory.createExpenseClaims(array)).getExpenseClaims().getExpenseClaim();
    }

    public List<ExpenseClaim> updateExpenseClaim(List<ExpenseClaim> objects) throws IOException {
        ArrayOfExpenseClaim array = new ArrayOfExpenseClaim();
        array.getExpenseClaim().addAll(objects);
        return this.post("ExpenseClaims", this.objFactory.createExpenseClaims(array)).getExpenseClaims().getExpenseClaim();
    }

    public ExpenseClaim getExpenseClaim(String id) throws IOException {
        return (ExpenseClaim)this.singleResult(this.get("ExpenseClaims/" + id).getExpenseClaims().getExpenseClaim());
    }

    public List<Invoice> getInvoices() throws IOException {
        Response responseObj = this.get("Invoices");
        if (responseObj.getInvoices() == null) {
            ArrayOfInvoice array = new ArrayOfInvoice();
            return array.getInvoice();
        }
        return responseObj.getInvoices().getInvoice();
    }

    public List<Invoice> getInvoices(Date modifiedAfter, String where, String order) throws IOException {
        HashMap<String, String> filter = new HashMap<String, String>();
        return this.getInvoices(modifiedAfter, where, order, null, null, filter);
    }

    public List<Invoice> getInvoices(Date modifiedAfter, String where, String order, String page) throws IOException {
        HashMap<String, String> filter = new HashMap<String, String>();
        return this.getInvoices(modifiedAfter, where, order, page, null, filter);
    }

    public List<Invoice> getInvoices(Date modifiedAfter, String where, String order, String page, String ids) throws IOException {
        return this.getInvoices(modifiedAfter, where, order, page, null, ids);
    }

    public List<Invoice> getInvoices(Date modifiedAfter, String where, String order, String page, String unitdp, Map<String, String> filter) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "Where", where);
        this.addToMapIfNotNull(params, "order", order);
        this.addToMapIfNotNull(params, "page", page);
        this.addToMapIfNotNull(params, "unitdp", unitdp);
        for (Map.Entry<String, String> entry : filter.entrySet()) {
            this.addToMapIfNotNull(params, entry.getKey(), entry.getValue());
        }
        Response responseObj = this.get("Invoices", modifiedAfter, params);
        if (responseObj.getInvoices() == null) {
            ArrayOfInvoice array = new ArrayOfInvoice();
            return array.getInvoice();
        }
        return responseObj.getInvoices().getInvoice();
    }

    @Deprecated
    public List<Invoice> getInvoices(Date modifiedAfter, String where, String order, String page, String unitdp, String ids) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "Where", where);
        this.addToMapIfNotNull(params, "order", order);
        this.addToMapIfNotNull(params, "page", page);
        this.addToMapIfNotNull(params, "Ids", ids);
        this.addToMapIfNotNull(params, "unitdp", unitdp);
        Response responseObj = this.get("Invoices", modifiedAfter, params);
        if (responseObj.getInvoices() == null) {
            ArrayOfInvoice array = new ArrayOfInvoice();
            return array.getInvoice();
        }
        return responseObj.getInvoices().getInvoice();
    }

    public List<Invoice> createInvoices(List<Invoice> invoices) throws IOException {
        ArrayOfInvoice array = new ArrayOfInvoice();
        array.getInvoice().addAll(invoices);
        return this.put("Invoices", this.objFactory.createInvoices(array)).getInvoices().getInvoice();
    }

    public List<Invoice> createInvoices(List<Invoice> invoices, String unitdp) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "unitdp", unitdp);
        ArrayOfInvoice array = new ArrayOfInvoice();
        array.getInvoice().addAll(invoices);
        return this.put("Invoices", this.objFactory.createInvoices(array), params).getInvoices().getInvoice();
    }

    public List<Invoice> createInvoices(List<Invoice> invoices, String unitdp, Boolean summarizeErrors) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "unitdp", unitdp);
        this.addToMapIfNotNull(params, "SummarizeErrors", summarizeErrors);
        ArrayOfInvoice array = new ArrayOfInvoice();
        array.getInvoice().addAll(invoices);
        return this.put("Invoices", this.objFactory.createInvoices(array), params).getInvoices().getInvoice();
    }

    public List<Invoice> updateInvoice(List<Invoice> objects) throws IOException {
        ArrayOfInvoice array = new ArrayOfInvoice();
        array.getInvoice().addAll(objects);
        return this.post("Invoices", this.objFactory.createInvoices(array)).getInvoices().getInvoice();
    }

    public List<Invoice> updateInvoice(List<Invoice> objects, String unitdp) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "unitdp", unitdp);
        ArrayOfInvoice array = new ArrayOfInvoice();
        array.getInvoice().addAll(objects);
        return this.post("Invoices", this.objFactory.createInvoices(array), params).getInvoices().getInvoice();
    }

    public Invoice getInvoice(String id) throws IOException {
        return (Invoice)this.singleResult(this.get("Invoices/" + id).getInvoices().getInvoice());
    }

    public Invoice getInvoice(String id, String unitdp) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "unitdp", unitdp);
        return (Invoice)this.singleResult(this.get("Invoices/" + id, null, params).getInvoices().getInvoice());
    }

    @Deprecated
    public String getInvoicePdf(String id, String dirPath) throws IOException {
        return this.getFile("Invoices/" + id, null, null, "application/pdf", dirPath);
    }

    public ByteArrayInputStream getInvoicePdfContent(String id) throws IOException {
        return this.getInputStream("Invoices/" + id, null, null, "application/pdf");
    }

    public OnlineInvoice getOnlineInvoice(String id) throws IOException {
        return (OnlineInvoice)this.singleResult(this.get("Invoices/" + id + "/OnlineInvoice").getOnlineInvoices().getOnlineInvoice());
    }

    public List<InvoiceReminder> getInvoiceReminders() throws IOException {
        Response responseObj = this.get("InvoiceReminders/Settings");
        if (responseObj.getInvoiceReminders() == null) {
            ArrayOfInvoiceReminder array = new ArrayOfInvoiceReminder();
            return array.getInvoiceReminder();
        }
        return responseObj.getInvoiceReminders().getInvoiceReminder();
    }

    public List<Item> getItems() throws IOException {
        Response responseObj = this.get("Items");
        if (responseObj.getItems() == null) {
            ArrayOfItem array = new ArrayOfItem();
            return array.getItem();
        }
        return responseObj.getItems().getItem();
    }

    public List<Item> getItems(Date modifiedAfter, String where, String order) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "Where", where);
        this.addToMapIfNotNull(params, "order", order);
        Response responseObj = this.get("Items", modifiedAfter, params);
        if (responseObj.getItems() == null) {
            ArrayOfItem array = new ArrayOfItem();
            return array.getItem();
        }
        return responseObj.getItems().getItem();
    }

    public List<Item> getItems(Date modifiedAfter, String where, String order, String unitdp) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "Where", where);
        this.addToMapIfNotNull(params, "order", order);
        this.addToMapIfNotNull(params, "unitdp", unitdp);
        Response responseObj = this.get("Items", modifiedAfter, params);
        if (responseObj.getItems() == null) {
            ArrayOfItem array = new ArrayOfItem();
            return array.getItem();
        }
        return responseObj.getItems().getItem();
    }

    public List<Item> createItems(List<Item> objects) throws IOException {
        ArrayOfItem array = new ArrayOfItem();
        array.getItem().addAll(objects);
        return this.put("Items", this.objFactory.createItems(array)).getItems().getItem();
    }

    public List<Item> createItems(List<Item> objects, String unitdp) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "unitdp", unitdp);
        ArrayOfItem array = new ArrayOfItem();
        array.getItem().addAll(objects);
        return this.put("Items", this.objFactory.createItems(array), params).getItems().getItem();
    }

    public List<Item> updateItem(List<Item> objects) throws IOException {
        ArrayOfItem array = new ArrayOfItem();
        array.getItem().addAll(objects);
        return this.post("Items", this.objFactory.createItems(array)).getItems().getItem();
    }

    public List<Item> updateItem(List<Item> objects, String unitdp) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "unitdp", unitdp);
        ArrayOfItem array = new ArrayOfItem();
        array.getItem().addAll(objects);
        return this.post("Items", this.objFactory.createItems(array), params).getItems().getItem();
    }

    public Item getItem(String id) throws IOException {
        return (Item)this.singleResult(this.get("Items/" + id).getItems().getItem());
    }

    public Item getItem(String id, String unitdp) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "unitdp", unitdp);
        return (Item)this.singleResult(this.get("Items/" + id, null, params).getItems().getItem());
    }

    public String deleteItem(String id) throws IOException {
        return this.delete("Items/" + id).getStatus();
    }

    public List<Journal> getJournals() throws IOException {
        Response responseObj = this.get("Journals");
        if (responseObj.getJournals() == null) {
            ArrayOfJournal array = new ArrayOfJournal();
            return array.getJournal();
        }
        return responseObj.getJournals().getJournal();
    }

    public List<Journal> getJournals(Date modifiedAfter, String where, String order) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "Where", where);
        this.addToMapIfNotNull(params, "order", order);
        Response responseObj = this.get("Journals", modifiedAfter, params);
        if (responseObj.getJournals() == null) {
            ArrayOfJournal array = new ArrayOfJournal();
            return array.getJournal();
        }
        return responseObj.getJournals().getJournal();
    }

    public List<Journal> getJournals(Date modifiedAfter, String offset, boolean paymentsOnly) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "offset", offset);
        this.addToMapIfNotNull(params, "paymentsOnly", paymentsOnly);
        Response responseObj = this.get("Journals", modifiedAfter, params);
        if (responseObj.getJournals() == null) {
            ArrayOfJournal array = new ArrayOfJournal();
            return array.getJournal();
        }
        return responseObj.getJournals().getJournal();
    }

    public Journal getJournal(String id) throws IOException {
        return (Journal)this.singleResult(this.get("Journals/" + id).getJournals().getJournal());
    }

    public List<LinkedTransaction> getLinkedTransactions() throws IOException {
        Response responseObj = this.get("LinkedTransactions");
        if (responseObj.getLinkedTransactions() == null) {
            ArrayOfLinkedTransaction array = new ArrayOfLinkedTransaction();
            return array.getLinkedTransaction();
        }
        return responseObj.getLinkedTransactions().getLinkedTransaction();
    }

    public List<LinkedTransaction> getLinkedTransactions(Date modifiedAfter, String where, String order) throws IOException {
        return this.getLinkedTransactions(modifiedAfter, where, order, null);
    }

    public List<LinkedTransaction> getLinkedTransactions(Date modifiedAfter, String where, String order, String page) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "Where", where);
        this.addToMapIfNotNull(params, "order", order);
        this.addToMapIfNotNull(params, "page", page);
        Response responseObj = this.get("LinkedTransactions", modifiedAfter, params);
        if (responseObj.getLinkedTransactions() == null) {
            ArrayOfLinkedTransaction array = new ArrayOfLinkedTransaction();
            return array.getLinkedTransaction();
        }
        return responseObj.getLinkedTransactions().getLinkedTransaction();
    }

    public List<LinkedTransaction> createLinkedTransactions(List<LinkedTransaction> objects) throws IOException {
        ArrayOfLinkedTransaction array = new ArrayOfLinkedTransaction();
        array.getLinkedTransaction().addAll(objects);
        return this.put("LinkedTransactions", this.objFactory.createLinkedTransactions(array)).getLinkedTransactions().getLinkedTransaction();
    }

    public List<LinkedTransaction> updateLinkedTransaction(List<LinkedTransaction> objects) throws IOException {
        ArrayOfLinkedTransaction array = new ArrayOfLinkedTransaction();
        array.getLinkedTransaction().addAll(objects);
        return this.post("LinkedTransactions", this.objFactory.createLinkedTransactions(array)).getLinkedTransactions().getLinkedTransaction();
    }

    public LinkedTransaction getLinkedTransaction(String id) throws IOException {
        return (LinkedTransaction)this.singleResult(this.get("LinkedTransactions/" + id).getLinkedTransactions().getLinkedTransaction());
    }

    public String deleteLinkedTransaction(String id) throws IOException {
        return this.delete("LinkedTransactions/" + id).getStatus();
    }

    public List<ManualJournal> getManualJournals() throws IOException {
        Response responseObj = this.get("ManualJournal");
        if (responseObj.getManualJournals() == null) {
            ArrayOfManualJournal array = new ArrayOfManualJournal();
            return array.getManualJournal();
        }
        return responseObj.getManualJournals().getManualJournal();
    }

    public List<ManualJournal> getManualJournals(Date modifiedAfter, String where, String order) throws IOException {
        return this.getManualJournals(modifiedAfter, where, order, null);
    }

    public List<ManualJournal> getManualJournals(Date modifiedAfter, String where, String order, String page) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "Where", where);
        this.addToMapIfNotNull(params, "order", order);
        this.addToMapIfNotNull(params, "page", page);
        Response responseObj = this.get("ManualJournals", modifiedAfter, params);
        if (responseObj.getManualJournals() == null) {
            ArrayOfManualJournal array = new ArrayOfManualJournal();
            return array.getManualJournal();
        }
        return responseObj.getManualJournals().getManualJournal();
    }

    public List<ManualJournal> createManualJournals(List<ManualJournal> objects) throws IOException {
        ArrayOfManualJournal array = new ArrayOfManualJournal();
        array.getManualJournal().addAll(objects);
        return this.put("ManualJournal", this.objFactory.createManualjournals(array)).getManualJournals().getManualJournal();
    }

    public List<ManualJournal> updateManualJournal(List<ManualJournal> objects) throws IOException {
        ArrayOfManualJournal array = new ArrayOfManualJournal();
        array.getManualJournal().addAll(objects);
        return this.post("ManualJournals", this.objFactory.createManualjournals(array)).getManualJournals().getManualJournal();
    }

    public ManualJournal getManualJournal(String id) throws IOException {
        return (ManualJournal)this.singleResult(this.get("ManualJournals/" + id).getManualJournals().getManualJournal());
    }

    public List<Organisation> getOrganisations() throws IOException {
        return this.get("Organisations").getOrganisations().getOrganisation();
    }

    public List<Overpayment> getOverpayments() throws IOException {
        Response responseObj = this.get("Overpayments");
        if (responseObj.getOverpayments() == null) {
            ArrayOfOverpayment array = new ArrayOfOverpayment();
            return array.getOverpayment();
        }
        return responseObj.getOverpayments().getOverpayment();
    }

    public List<Overpayment> getOverpayments(Date modifiedAfter, String where, String order) throws IOException {
        return this.getOverpayments(modifiedAfter, where, order, null);
    }

    public List<Overpayment> getOverpayments(Date modifiedAfter, String where, String order, String page) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "Where", where);
        this.addToMapIfNotNull(params, "order", order);
        this.addToMapIfNotNull(params, "page", page);
        Response responseObj = this.get("Overpayments", modifiedAfter, params);
        if (responseObj.getOverpayments() == null) {
            ArrayOfOverpayment array = new ArrayOfOverpayment();
            return array.getOverpayment();
        }
        return responseObj.getOverpayments().getOverpayment();
    }

    public List<Allocation> createOverpaymentAllocations(List<Allocation> objects, String id) throws IOException {
        ArrayOfAllocation array = new ArrayOfAllocation();
        array.getAllocation().addAll(objects);
        return this.put("Overpayments/" + id + "/Allocations", this.objFactory.createAllocations(array)).getAllocations().getAllocation();
    }

    public Overpayment getOverpayment(String id) throws IOException {
        return (Overpayment)this.singleResult(this.get("Overpayments/" + id).getOverpayments().getOverpayment());
    }

    public List<Payment> getPayments() throws IOException {
        Response responseObj = this.get("Payments");
        if (responseObj.getPayments() == null) {
            ArrayOfPayment array = new ArrayOfPayment();
            return array.getPayment();
        }
        return responseObj.getPayments().getPayment();
    }

    public List<Payment> getPayments(Date modifiedAfter, String where, String order) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "Where", where);
        this.addToMapIfNotNull(params, "order", order);
        Response responseObj = this.get("Payments", modifiedAfter, params);
        if (responseObj.getPayments() == null) {
            ArrayOfPayment array = new ArrayOfPayment();
            return array.getPayment();
        }
        return responseObj.getPayments().getPayment();
    }

    public List<Payment> createPayments(List<Payment> objects) throws IOException {
        ArrayOfPayment array = new ArrayOfPayment();
        array.getPayment().addAll(objects);
        return this.put("Payments", this.objFactory.createPayments(array)).getPayments().getPayment();
    }

    public List<Payment> deletePayment(Payment object) throws IOException {
        Payment payment = new Payment();
        payment.setStatus(PaymentStatus.DELETED);
        return this.post("Payments/" + object.getPaymentID(), this.objFactory.createPayment(payment)).getPayments().getPayment();
    }

    public List<Payment> deletePayment(List<Payment> objects) throws IOException {
        ArrayOfPayment array = new ArrayOfPayment();
        array.getPayment().addAll(objects);
        return this.post("Payments", this.objFactory.createPayments(array)).getPayments().getPayment();
    }

    public Payment getPayment(String id) throws IOException {
        return (Payment)this.singleResult(this.get("Payments/" + id).getPayments().getPayment());
    }

    public List<Prepayment> getPrepayments() throws IOException {
        Response responseObj = this.get("Prepayments");
        if (responseObj.getPrepayments() == null) {
            ArrayOfPrepayment array = new ArrayOfPrepayment();
            return array.getPrepayment();
        }
        return responseObj.getPrepayments().getPrepayment();
    }

    public List<Prepayment> getPrepayments(Date modifiedAfter, String where, String order) throws IOException {
        return this.getPrepayments(modifiedAfter, where, order, null);
    }

    public List<Prepayment> getPrepayments(Date modifiedAfter, String where, String order, String page) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "Where", where);
        this.addToMapIfNotNull(params, "order", order);
        this.addToMapIfNotNull(params, "page", page);
        Response responseObj = this.get("Prepayments", modifiedAfter, params);
        if (responseObj.getPrepayments() == null) {
            ArrayOfPrepayment array = new ArrayOfPrepayment();
            return array.getPrepayment();
        }
        return responseObj.getPrepayments().getPrepayment();
    }

    public List<Allocation> createPrepaymentAllocations(List<Allocation> objects, String id) throws IOException {
        ArrayOfAllocation array = new ArrayOfAllocation();
        array.getAllocation().addAll(objects);
        return this.put("Prepayments/" + id + "/Allocations", this.objFactory.createAllocations(array)).getAllocations().getAllocation();
    }

    public Prepayment getPrepayment(String id) throws IOException {
        return (Prepayment)this.singleResult(this.get("Prepayments/" + id).getPrepayments().getPrepayment());
    }

    public List<PurchaseOrder> getPurchaseOrders() throws IOException {
        Response responseObj = this.get("PurchaseOrders");
        if (responseObj.getPurchaseOrders() == null) {
            ArrayOfPurchaseOrder array = new ArrayOfPurchaseOrder();
            return array.getPurchaseOrder();
        }
        return responseObj.getPurchaseOrders().getPurchaseOrder();
    }

    public List<PurchaseOrder> getPurchaseOrders(Date modifiedAfter, String where, String order) throws IOException {
        return this.getPurchaseOrders(modifiedAfter, where, order, null);
    }

    public List<PurchaseOrder> getPurchaseOrders(Date modifiedAfter, String where, String order, String page) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "Where", where);
        this.addToMapIfNotNull(params, "order", order);
        this.addToMapIfNotNull(params, "page", page);
        Response responseObj = this.get("PurchaseOrders", modifiedAfter, params);
        if (responseObj.getPurchaseOrders() == null) {
            ArrayOfPurchaseOrder array = new ArrayOfPurchaseOrder();
            return array.getPurchaseOrder();
        }
        return responseObj.getPurchaseOrders().getPurchaseOrder();
    }

    public List<PurchaseOrder> createPurchaseOrders(List<PurchaseOrder> objects) throws IOException {
        ArrayOfPurchaseOrder array = new ArrayOfPurchaseOrder();
        array.getPurchaseOrder().addAll(objects);
        return this.put("PurchaseOrders", this.objFactory.createPurchaseOrders(array)).getPurchaseOrders().getPurchaseOrder();
    }

    public List<PurchaseOrder> updatePurchaseOrder(List<PurchaseOrder> objects) throws IOException {
        ArrayOfPurchaseOrder array = new ArrayOfPurchaseOrder();
        array.getPurchaseOrder().addAll(objects);
        return this.post("PurchaseOrders", this.objFactory.createPurchaseOrders(array)).getPurchaseOrders().getPurchaseOrder();
    }

    public PurchaseOrder getPurchaseOrder(String id) throws IOException {
        return (PurchaseOrder)this.singleResult(this.get("PurchaseOrders/" + id).getPurchaseOrders().getPurchaseOrder());
    }

    @Deprecated
    public String getPurchaseOrderPdf(String id, String dirPath) throws IOException {
        return this.getFile("PurchaseOrders/" + id, null, null, "application/pdf", dirPath);
    }

    public ByteArrayInputStream getPurchaseOrderPdfContent(String id) throws IOException {
        return this.getInputStream("PurchaseOrders/" + id, null, null, "application/pdf");
    }

    public List<Receipt> getReceipts() throws IOException {
        Response responseObj = this.get("Receipts");
        if (responseObj.getReceipts() == null) {
            ArrayOfReceipt array = new ArrayOfReceipt();
            return array.getReceipt();
        }
        return responseObj.getReceipts().getReceipt();
    }

    public List<Receipt> getReceipts(Date modifiedAfter, String where, String order) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "Where", where);
        this.addToMapIfNotNull(params, "order", order);
        Response responseObj = this.get("Receipts", modifiedAfter, params);
        if (responseObj.getReceipts() == null) {
            ArrayOfReceipt array = new ArrayOfReceipt();
            return array.getReceipt();
        }
        return responseObj.getReceipts().getReceipt();
    }

    public List<Receipt> createReceipts(List<Receipt> objects) throws IOException {
        ArrayOfReceipt array = new ArrayOfReceipt();
        array.getReceipt().addAll(objects);
        return this.put("Receipts", this.objFactory.createReceipts(array)).getReceipts().getReceipt();
    }

    public List<Receipt> createReceipts(List<Receipt> objects, String unitdp) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "unitdp", unitdp);
        ArrayOfReceipt array = new ArrayOfReceipt();
        array.getReceipt().addAll(objects);
        return this.put("Receipts", this.objFactory.createReceipts(array), params).getReceipts().getReceipt();
    }

    public List<Receipt> updateReceipt(List<Receipt> objects) throws IOException {
        ArrayOfReceipt array = new ArrayOfReceipt();
        array.getReceipt().addAll(objects);
        return this.post("Receipts", this.objFactory.createReceipts(array)).getReceipts().getReceipt();
    }

    public Receipt getReceipt(String id) throws IOException {
        return (Receipt)this.singleResult(this.get("Receipts/" + id).getReceipts().getReceipt());
    }

    public List<RepeatingInvoice> getRepeatingInvoices() throws IOException {
        Response responseObj = this.get("RepeatingInvoices");
        if (responseObj.getRepeatingInvoices() == null) {
            ArrayOfRepeatingInvoice array = new ArrayOfRepeatingInvoice();
            return array.getRepeatingInvoice();
        }
        return responseObj.getRepeatingInvoices().getRepeatingInvoice();
    }

    public List<RepeatingInvoice> getRepeatingInvoices(Date modifiedAfter, String where, String order) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "Where", where);
        this.addToMapIfNotNull(params, "order", order);
        Response responseObj = this.get("RepeatingInvoices", modifiedAfter, params);
        if (responseObj.getRepeatingInvoices() == null) {
            ArrayOfRepeatingInvoice array = new ArrayOfRepeatingInvoice();
            return array.getRepeatingInvoice();
        }
        return responseObj.getRepeatingInvoices().getRepeatingInvoice();
    }

    public RepeatingInvoice getRepeatingInvoice(String id) throws IOException {
        return (RepeatingInvoice)this.singleResult(this.get("RepeatingInvoices/" + id).getRepeatingInvoices().getRepeatingInvoice());
    }

    public Report getReport(String id, String where, String order) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "where", where);
        this.addToMapIfNotNull(params, "order", order);
        return (Report)this.singleResult(this.get("reports/" + id, null, params).getReports().getReport());
    }

    public Report getReportAgedPayablesByContact(String contactId, String where, String order, String date, String fromDate, String toDate) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "where", where);
        this.addToMapIfNotNull(params, "order", order);
        this.addToMapIfNotNull(params, "contactID", contactId);
        this.addToMapIfNotNull(params, "date", date);
        this.addToMapIfNotNull(params, "fromDate", fromDate);
        this.addToMapIfNotNull(params, "toDate", toDate);
        return (Report)this.singleResult(this.get("reports/AgedPayablesByContact", null, params).getReports().getReport());
    }

    public Report getReportAgedReceivablesByContact(String contactId, String where, String order, String date, String fromDate, String toDate) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "where", where);
        this.addToMapIfNotNull(params, "order", order);
        this.addToMapIfNotNull(params, "contactID", contactId);
        this.addToMapIfNotNull(params, "date", date);
        this.addToMapIfNotNull(params, "fromDate", fromDate);
        this.addToMapIfNotNull(params, "toDate", toDate);
        return (Report)this.singleResult(this.get("reports/AgedReceivablesByContact", null, params).getReports().getReport());
    }

    public Report getReportBalanceSheet(String where, String order, String date, String trackingOptionId1, String trackingOptionId2, boolean standardLayout, boolean paymentsOnly, Integer periods, String timeframe) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "where", where);
        this.addToMapIfNotNull(params, "order", order);
        this.addToMapIfNotNull(params, "date", date);
        this.addToMapIfNotNull(params, "trackingOptionID1", trackingOptionId1);
        this.addToMapIfNotNull(params, "trackingOptionID2", trackingOptionId2);
        this.addToMapIfNotNull(params, "standardLayout", standardLayout);
        this.addToMapIfNotNull(params, "paymentsOnly", paymentsOnly);
        this.addToMapIfNotNull(params, "periods", periods);
        this.addToMapIfNotNull(params, "timeframe", timeframe);
        return (Report)this.singleResult(this.get("reports/BalanceSheet", null, params).getReports().getReport());
    }

    public Report getReportBalanceSheet(String where, String order, String date, String trackingOptionId1, String trackingOptionId2, boolean standardLayout, boolean paymentsOnly) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "where", where);
        this.addToMapIfNotNull(params, "order", order);
        this.addToMapIfNotNull(params, "date", date);
        this.addToMapIfNotNull(params, "trackingOptionID1", trackingOptionId1);
        this.addToMapIfNotNull(params, "trackingOptionID2", trackingOptionId2);
        this.addToMapIfNotNull(params, "standardLayout", standardLayout);
        this.addToMapIfNotNull(params, "paymentsOnly", paymentsOnly);
        return (Report)this.singleResult(this.get("reports/BalanceSheet", null, params).getReports().getReport());
    }

    public Report getReportBankStatement(String accountId, String where, String order, String fromDate, String toDate) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "bankAccountID", accountId);
        this.addToMapIfNotNull(params, "where", where);
        this.addToMapIfNotNull(params, "order", order);
        this.addToMapIfNotNull(params, "fromDate", fromDate);
        this.addToMapIfNotNull(params, "toDate", toDate);
        return (Report)this.singleResult(this.get("reports/BankStatement", null, params).getReports().getReport());
    }

    public Report getReportBudgetSummary(String where, String order, String date, Integer periods, Integer timeframe) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "where", where);
        this.addToMapIfNotNull(params, "order", order);
        this.addToMapIfNotNull(params, "date", date);
        this.addToMapIfNotNull(params, "timeframe", timeframe);
        this.addToMapIfNotNull(params, "periods", periods);
        return (Report)this.singleResult(this.get("reports/BudgetSummary", null, params).getReports().getReport());
    }

    public Report getExecutiveSummary(String where, String order, String date) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "where", where);
        this.addToMapIfNotNull(params, "order", order);
        this.addToMapIfNotNull(params, "date", date);
        return (Report)this.singleResult(this.get("reports/ExecutiveSummary", null, params).getReports().getReport());
    }

    public Report getReportProfitLoss(String where, String order, String fromDate, String toDate, String trackingCategoryId, String trackingOptionId1, String trackingCategoryId2, String trackingOptionId2, boolean standardLayout, boolean paymentsOnly) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "where", where);
        this.addToMapIfNotNull(params, "order", order);
        this.addToMapIfNotNull(params, "fromDate", fromDate);
        this.addToMapIfNotNull(params, "toDate", toDate);
        this.addToMapIfNotNull(params, "trackingCategoryID", trackingCategoryId);
        this.addToMapIfNotNull(params, "trackingOptionID1", trackingOptionId1);
        this.addToMapIfNotNull(params, "trackingCategoryID2", trackingCategoryId2);
        this.addToMapIfNotNull(params, "trackingOptionID2", trackingOptionId2);
        this.addToMapIfNotNull(params, "standardLayout", standardLayout);
        this.addToMapIfNotNull(params, "paymentsOnly", paymentsOnly);
        return (Report)this.singleResult(this.get("reports/ProfitAndLoss", null, params).getReports().getReport());
    }

    public Report getReportProfitLoss(String where, String order, String fromDate, String toDate, String trackingCategoryId, String trackingOptionId1, String trackingCategoryId2, String trackingOptionId2, boolean standardLayout, boolean paymentsOnly, Integer periods, String timeframe) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "where", where);
        this.addToMapIfNotNull(params, "order", order);
        this.addToMapIfNotNull(params, "fromDate", fromDate);
        this.addToMapIfNotNull(params, "toDate", toDate);
        this.addToMapIfNotNull(params, "trackingCategoryID", trackingCategoryId);
        this.addToMapIfNotNull(params, "trackingOptionID1", trackingOptionId1);
        this.addToMapIfNotNull(params, "trackingCategoryID2", trackingCategoryId2);
        this.addToMapIfNotNull(params, "trackingOptionID2", trackingOptionId2);
        this.addToMapIfNotNull(params, "standardLayout", standardLayout);
        this.addToMapIfNotNull(params, "paymentsOnly", paymentsOnly);
        this.addToMapIfNotNull(params, "periods", periods);
        this.addToMapIfNotNull(params, "timeframe", timeframe);
        return (Report)this.singleResult(this.get("reports/ProfitAndLoss", null, params).getReports().getReport());
    }

    public Report getReportTrialBalance(String date, boolean paymentsOnly) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "date", date);
        this.addToMapIfNotNull(params, "paymentsOnly", paymentsOnly);
        return (Report)this.singleResult(this.get("reports/TrialBalance", null, params).getReports().getReport());
    }

    public List<TaxRate> getTaxRates() throws IOException {
        Response responseObj = this.get("TaxRates");
        if (responseObj.getTaxRates() == null) {
            ArrayOfTaxRate array = new ArrayOfTaxRate();
            return array.getTaxRate();
        }
        return responseObj.getTaxRates().getTaxRate();
    }

    public List<TaxRate> getTaxRates(Date modifiedAfter, String where, String order) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "Where", where);
        this.addToMapIfNotNull(params, "order", order);
        Response responseObj = this.get("TaxRates", modifiedAfter, params);
        if (responseObj.getTaxRates() == null) {
            ArrayOfTaxRate array = new ArrayOfTaxRate();
            return array.getTaxRate();
        }
        return responseObj.getTaxRates().getTaxRate();
    }

    public List<TaxRate> createTaxRates(List<TaxRate> objects) throws IOException {
        ArrayOfTaxRate array = new ArrayOfTaxRate();
        array.getTaxRate().addAll(objects);
        return this.put("TaxRates", this.objFactory.createTaxRates(array)).getTaxRates().getTaxRate();
    }

    public List<TaxRate> updateTaxRate(List<TaxRate> objects) throws IOException {
        ArrayOfTaxRate array = new ArrayOfTaxRate();
        array.getTaxRate().addAll(objects);
        return this.post("TaxRates", this.objFactory.createTaxRates(array)).getTaxRates().getTaxRate();
    }

    public TaxRate getTaxRate(String id) throws IOException {
        return (TaxRate)this.singleResult(this.get("TaxRates/" + id).getTaxRates().getTaxRate());
    }

    public List<TrackingCategory> getTrackingCategories() throws IOException {
        Response responseObj = this.get("TrackingCategories");
        if (responseObj.getTrackingCategories() == null) {
            ArrayOfTrackingCategory array = new ArrayOfTrackingCategory();
            return array.getTrackingCategory();
        }
        return responseObj.getTrackingCategories().getTrackingCategory();
    }

    public List<TrackingCategory> getTrackingCategories(Date modifiedAfter, String where, String order, Boolean includeArchived) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "Where", where);
        this.addToMapIfNotNull(params, "order", order);
        this.addToMapIfNotNull(params, "includeArchived", includeArchived);
        Response responseObj = this.get("TrackingCategories", modifiedAfter, params);
        if (responseObj.getTrackingCategories() == null) {
            ArrayOfTrackingCategory array = new ArrayOfTrackingCategory();
            return array.getTrackingCategory();
        }
        return responseObj.getTrackingCategories().getTrackingCategory();
    }

    public List<TrackingCategory> createTrackingCategories(List<TrackingCategory> objects) throws IOException {
        ArrayOfTrackingCategory array = new ArrayOfTrackingCategory();
        array.getTrackingCategory().addAll(objects);
        return this.put("TrackingCategories", this.objFactory.createTrackingCategories(array)).getTrackingCategories().getTrackingCategory();
    }

    public List<TrackingCategory> createTrackingCategories(List<TrackingCategory> objects, boolean summarizeErrors) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "summarizeErrors", summarizeErrors);
        ArrayOfTrackingCategory array = new ArrayOfTrackingCategory();
        array.getTrackingCategory().addAll(objects);
        return this.put("TrackingCategories", this.objFactory.createTrackingCategories(array), params).getTrackingCategories().getTrackingCategory();
    }

    public List<TrackingCategory> updateTrackingCategory(List<TrackingCategory> objects) throws IOException {
        ArrayOfTrackingCategory array = new ArrayOfTrackingCategory();
        array.getTrackingCategory().addAll(objects);
        return this.post("TrackingCategories", this.objFactory.createTrackingCategories(array)).getTrackingCategories().getTrackingCategory();
    }

    public List<TrackingCategory> updateTrackingCategory(List<TrackingCategory> objects, boolean summarizeErrors) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "summarizeErrors", summarizeErrors);
        ArrayOfTrackingCategory array = new ArrayOfTrackingCategory();
        array.getTrackingCategory().addAll(objects);
        return this.post("TrackingCategories", this.objFactory.createTrackingCategories(array)).getTrackingCategories().getTrackingCategory();
    }

    public TrackingCategory getTrackingCategory(String id) throws IOException {
        return (TrackingCategory)this.singleResult(this.get("TrackingCategories/" + id).getTrackingCategories().getTrackingCategory());
    }

    public String deleteTrackingCategory(String id) throws IOException {
        return this.delete("TrackingCategories/" + id).getStatus();
    }

    public List<TrackingCategoryOption> createTrackingCategoryOption(List<TrackingCategoryOption> objects, String id) throws IOException {
        ArrayOfTrackingCategoryOption array = new ArrayOfTrackingCategoryOption();
        array.getOption().addAll(objects);
        return this.put("TrackingCategories/" + id + "/Options", this.objFactory.createTrackingCategoryOptions(array)).getOptions().getOption();
    }

    public List<TrackingCategoryOption> createTrackingCategoryOption(List<TrackingCategoryOption> objects, String id, boolean summarizeErrors) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "summarizeErrors", summarizeErrors);
        System.out.println("SIZE " + objects.size());
        ArrayOfTrackingCategoryOption array = new ArrayOfTrackingCategoryOption();
        array.getOption().addAll(objects);
        return this.put("TrackingCategories/" + id + "/Options", this.objFactory.createTrackingCategoryOptions(array), params).getOptions().getOption();
    }

    public TrackingCategoryOption updateTrackingCategoryOption(TrackingCategoryOption object, String TrackingCategoryID, String TrackingOptionID) throws IOException {
        ArrayOfTrackingCategoryOption array = new ArrayOfTrackingCategoryOption();
        array.getOption().add(object);
        return (TrackingCategoryOption)this.post("TrackingCategories/" + TrackingCategoryID + "/Options/" + TrackingOptionID, this.objFactory.createTrackingCategoryOptions(array)).getOptions().getOption().get(0);
    }

    public TrackingCategoryOption updateTrackingCategoryOption(TrackingCategoryOption object, String TrackingCategoryID, String TrackingOptionID, boolean summarizeErrors) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "summarizeErrors", summarizeErrors);
        ArrayOfTrackingCategoryOption array = new ArrayOfTrackingCategoryOption();
        array.getOption().add(object);
        return (TrackingCategoryOption)this.post("TrackingCategories/" + TrackingCategoryID + "/Options/" + TrackingOptionID, this.objFactory.createTrackingCategoryOptions(array)).getOptions().getOption().get(0);
    }

    public String deleteTrackingCategoryOption(String TrackingCategoryID, String TrackingOptionID) throws IOException {
        return this.delete("TrackingCategories/" + TrackingCategoryID + "/Options/" + TrackingOptionID).getStatus();
    }

    public List<User> getUsers() throws IOException {
        Response responseObj = this.get("Users");
        if (responseObj.getUsers() == null) {
            ArrayOfUser array = new ArrayOfUser();
            return array.getUser();
        }
        return responseObj.getUsers().getUser();
    }

    public List<User> getUsers(Date modifiedAfter, String where, String order) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addToMapIfNotNull(params, "Where", where);
        this.addToMapIfNotNull(params, "order", order);
        Response responseObj = this.get("Users", modifiedAfter, params);
        if (responseObj.getUsers() == null) {
            ArrayOfUser array = new ArrayOfUser();
            return array.getUser();
        }
        return responseObj.getUsers().getUser();
    }

    public User getUser(String id) throws IOException {
        return (User)this.singleResult(this.get("Users/" + id).getUsers().getUser());
    }

    public List<Attachment> getAttachments(String endpoint, String guid) throws IOException {
        return this.get(endpoint + "/" + guid + "/Attachments/", null, null).getAttachments().getAttachment();
    }

    public Attachment createAttachment(String endpoint, String guid, String filename, String contentType, byte[] bytes) throws IOException {
        return this.createAttachment(endpoint, guid, filename, contentType, bytes, false);
    }

    public Attachment createAttachment(String endpoint, String guid, String filename, String contentType, byte[] bytes, boolean includeOnline) throws IOException {
        Objects.requireNonNull(endpoint, "endpoint must not be null");
        Objects.requireNonNull(guid, "guid must not be null");
        Objects.requireNonNull(filename, "filename must not be null");
        Objects.requireNonNull(contentType, "contentType must not be null");
        Objects.requireNonNull(bytes, "bytes must not be null");
        HashMap<String, String> params = new HashMap<String, String>();
        if (includeOnline) {
            params.put("IncludeOnline", Boolean.toString(true));
        }
        String alphaNumericFileName = this.normalizeFileNameForURI(filename);
        return (Attachment)this.singleResult(this.put(String.format("%s/%s/Attachments/%s", endpoint, guid, alphaNumericFileName), contentType, bytes, params).getAttachments().getAttachment());
    }

    protected String normalizeFileNameForURI(String fileName) {
        return fileName.trim().replaceAll(" ", "_").replaceAll("[^\\p{Alnum}\\-_.~]", "");
    }

    public String getAttachmentContent(String endpoint, String guid, String filename, String accept, String dirPath) throws IOException {
        String encodedFileName = URLEncoder.encode(filename, "UTF-8").replace("+", "%20");
        return this.getFile(endpoint + "/" + guid + "/Attachments/" + encodedFileName, null, null, accept, dirPath);
    }

    public ByteArrayInputStream getAttachmentContent(String endpoint, String guid, String filename, String accept) throws IOException {
        String encodedFileName = URLEncoder.encode(filename, "UTF-8").replace("+", "%20");
        return this.getInputStream(endpoint + "/" + guid + "/Attachments/" + encodedFileName, null, null, accept);
    }

    public ByteArrayInputStream getAttachmentContentById(String endpoint, String guid, String attachmentid, String accept) throws IOException {
        return this.getInputStream(endpoint + "/" + guid + "/Attachments/" + attachmentid, null, null, accept);
    }

    public Assets getAssets() throws XeroApiException, ParseException {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("Status", "REGISTERED");
            String resource = "https://api.xero.com/assets.xro/1.0/Assets";
            String response = this.get2(resource, null, params);
            TypeReference<Assets> typeRef = new TypeReference<Assets>(){};
            ApiClient apiClient = new ApiClient();
            return (Assets)apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.convertException(e);
        }
    }

    protected String get2(String resource, Date modifiedAfter, Map<String, String> params) throws IOException {
        OAuthRequestResource req = new OAuthRequestResource(this.config, this.signerFactory, resource, "GET", null, params, "application/json");
        req.setToken(this.token);
        req.setTokenSecret(this.tokenSecret);
        if (modifiedAfter != null) {
            req.setIfModifiedSince(modifiedAfter);
        }
        try {
            Map<String, String> resp = req.execute();
            String r = resp.get("content");
            return r.toString();
        }
        catch (IOException ioe) {
            throw this.xeroExceptionHandler.convertException(ioe);
        }
    }

    static {
        utcFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        MESSAGE_PATTERN = Pattern.compile("<Message>(.*)</Message>");
    }
}

