/*
 * Decompiled with CFR 0.152.
 */
package com.xero.api.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xero.api.ApiClient;
import com.xero.api.Config;
import com.xero.api.ConfigBasedSignerFactory;
import com.xero.api.JSONUtils;
import com.xero.api.JsonConfig;
import com.xero.api.OAuthRequestResource;
import com.xero.api.SignerFactory;
import com.xero.api.XeroApiException;
import com.xero.api.XeroClient;
import com.xero.api.exception.XeroExceptionHandler;
import com.xero.model.ObjectFactory;
import com.xero.models.accounting.Account;
import com.xero.models.accounting.Accounts;
import com.xero.models.accounting.Allocations;
import com.xero.models.accounting.Attachments;
import com.xero.models.accounting.BankTransactions;
import com.xero.models.accounting.BankTransfers;
import com.xero.models.accounting.BatchPayments;
import com.xero.models.accounting.BrandingThemes;
import com.xero.models.accounting.CISSettings;
import com.xero.models.accounting.Contact;
import com.xero.models.accounting.ContactGroups;
import com.xero.models.accounting.Contacts;
import com.xero.models.accounting.CreditNotes;
import com.xero.models.accounting.Currencies;
import com.xero.models.accounting.Employees;
import com.xero.models.accounting.ExpenseClaims;
import com.xero.models.accounting.HistoryRecords;
import com.xero.models.accounting.InvoiceReminders;
import com.xero.models.accounting.Invoices;
import com.xero.models.accounting.Items;
import com.xero.models.accounting.Journals;
import com.xero.models.accounting.LinkedTransactions;
import com.xero.models.accounting.ManualJournals;
import com.xero.models.accounting.OnlineInvoices;
import com.xero.models.accounting.Organisations;
import com.xero.models.accounting.Overpayments;
import com.xero.models.accounting.PaymentService;
import com.xero.models.accounting.PaymentServices;
import com.xero.models.accounting.Payments;
import com.xero.models.accounting.Prepayments;
import com.xero.models.accounting.PurchaseOrders;
import com.xero.models.accounting.Receipts;
import com.xero.models.accounting.RepeatingInvoices;
import com.xero.models.accounting.ReportWithRows;
import com.xero.models.accounting.Reports;
import com.xero.models.accounting.RequestEmpty;
import com.xero.models.accounting.Response204;
import com.xero.models.accounting.TaxRates;
import com.xero.models.accounting.TrackingCategories;
import com.xero.models.accounting.TrackingCategory;
import com.xero.models.accounting.TrackingOption;
import com.xero.models.accounting.TrackingOptions;
import com.xero.models.accounting.Users;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.ws.rs.core.UriBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

public class AccountingApi {
    private ApiClient apiClient;
    private XeroExceptionHandler xeroExceptionHandler;
    private Config config;
    private SignerFactory signerFactory;
    private String token = null;
    private String tokenSecret = null;
    static final Logger logger = LogManager.getLogger(XeroClient.class);
    protected static final DateFormat utcFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    protected static final Pattern MESSAGE_PATTERN;
    protected final ObjectFactory objFactory = new ObjectFactory();

    public AccountingApi(Config config) {
        this(config, new ConfigBasedSignerFactory(config));
        this.xeroExceptionHandler = new XeroExceptionHandler();
    }

    public AccountingApi(Config config, SignerFactory signerFactory) {
        this.config = config;
        this.signerFactory = signerFactory;
        this.xeroExceptionHandler = new XeroExceptionHandler();
    }

    public AccountingApi(ApiClient apiClient) {
        this(JsonConfig.getInstance());
        this.xeroExceptionHandler = new XeroExceptionHandler();
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void setOAuthToken(String token, String tokenSecret) {
        this.token = token;
        this.tokenSecret = tokenSecret;
    }

    protected String DATA(String url, String body, Map<String, String> params, String method) throws IOException {
        return this.DATA(url, body, params, method, null, "application/json");
    }

    protected String DATA(String url, String body, Map<String, String> params, String method, OffsetDateTime ifModifiedSince) throws IOException {
        return this.DATA(url, body, params, method, ifModifiedSince, "application/json");
    }

    protected String DATA(String url, String body, Map<String, String> params, String method, String contentType) throws IOException {
        return this.DATA(url, body, params, method, null, contentType);
    }

    protected String DATA(String url, String body, Map<String, String> params, String method, OffsetDateTime ifModifiedSince, String contentType) throws IOException {
        OAuthRequestResource req = new OAuthRequestResource(this.config, this.signerFactory, url, method, body, params, contentType, "application/json");
        req.setToken(this.token);
        req.setTokenSecret(this.tokenSecret);
        if (ifModifiedSince != null) {
            req.setIfModifiedSince(ifModifiedSince);
        }
        try {
            Map<String, String> resp = req.execute();
            String r = resp.get("content");
            return r.toString();
        }
        catch (IOException ioe) {
            throw this.xeroExceptionHandler.convertException(ioe);
        }
    }

    protected String DATA(String url, String body, Map<String, String> params, String method, String xeroApplicationId, String xeroTenantId, String xeroUserId) throws IOException {
        OAuthRequestResource req = new OAuthRequestResource(this.config, this.signerFactory, url, method, body, params, null, "application/json");
        req.setToken(this.token);
        req.setTokenSecret(this.tokenSecret);
        try {
            Map<String, String> resp = req.execute();
            String r = resp.get("content");
            return r.toString();
        }
        catch (IOException ioe) {
            throw this.xeroExceptionHandler.convertException(ioe);
        }
    }

    protected ByteArrayInputStream FILE(String url, String body, Map<String, String> params, String method) throws IOException {
        return this.FILE(url, body, params, method, "application/octet-stream");
    }

    protected ByteArrayInputStream FILE(String url, String body, Map<String, String> params, String method, String accept) throws IOException {
        OAuthRequestResource req = new OAuthRequestResource(this.config, this.signerFactory, url, method, body, params, accept, "application/json");
        req.setToken(this.token);
        req.setTokenSecret(this.tokenSecret);
        try {
            ByteArrayInputStream resp = req.executefile();
            return resp;
        }
        catch (IOException ioe) {
            throw this.xeroExceptionHandler.convertException(ioe);
        }
    }

    protected String FILE(String url, String body, Map<String, String> params, String method, byte[] byteBody) throws IOException {
        return this.FILE(url, body, params, method, byteBody, "application/octet-stream");
    }

    protected String FILE(String url, String body, Map<String, String> params, String method, byte[] byteBody, String contentType) throws IOException {
        OAuthRequestResource req = new OAuthRequestResource(this.config, this.signerFactory, url, method, contentType, byteBody, params, "application/json");
        req.setToken(this.token);
        req.setTokenSecret(this.tokenSecret);
        try {
            Map<String, String> resp = req.execute();
            String r = resp.get("content");
            return r.toString();
        }
        catch (IOException ioe) {
            throw this.xeroExceptionHandler.convertException(ioe);
        }
    }

    public Accounts createAccount(Account account) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Accounts";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)account);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<Accounts> typeRef = new TypeReference<Accounts>(){};
            return (Accounts)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Attachments createAccountAttachmentByFileName(UUID accountID, String fileName, byte[] body) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Accounts/{AccountID}/Attachments/{FileName}";
            String path = "/Accounts/{AccountID}/Attachments/{FileName}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("AccountID", accountID.toString());
            uriVariables.put("FileName", fileName.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.FILE(url, strBody, params, "PUT", body);
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            return (Attachments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public BankTransactions createBankTransaction(BankTransactions bankTransactions, Boolean summarizeErrors) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/BankTransactions";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (summarizeErrors != null) {
                this.addToMapIfNotNull(params, "SummarizeErrors", summarizeErrors);
            }
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)bankTransactions);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<BankTransactions> typeRef = new TypeReference<BankTransactions>(){};
            return (BankTransactions)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Attachments createBankTransactionAttachmentByFileName(UUID bankTransactionID, String fileName, byte[] body) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/BankTransactions/{BankTransactionID}/Attachments/{FileName}";
            String path = "/BankTransactions/{BankTransactionID}/Attachments/{FileName}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("BankTransactionID", bankTransactionID.toString());
            uriVariables.put("FileName", fileName.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.FILE(url, strBody, params, "PUT", body);
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            return (Attachments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public HistoryRecords createBankTransactionHistoryRecord(UUID bankTransactionID, HistoryRecords historyRecords) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/BankTransactions/{BankTransactionID}/History";
            String path = "/BankTransactions/{BankTransactionID}/History";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("BankTransactionID", bankTransactionID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)historyRecords);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public BankTransfers createBankTransfer(BankTransfers bankTransfers) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/BankTransfers";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)bankTransfers);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<BankTransfers> typeRef = new TypeReference<BankTransfers>(){};
            return (BankTransfers)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Attachments createBankTransferAttachmentByFileName(UUID bankTransferID, String fileName, byte[] body) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/BankTransfers/{BankTransferID}/Attachments/{FileName}";
            String path = "/BankTransfers/{BankTransferID}/Attachments/{FileName}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("BankTransferID", bankTransferID.toString());
            uriVariables.put("FileName", fileName.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.FILE(url, strBody, params, "PUT", body);
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            return (Attachments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public HistoryRecords createBankTransferHistoryRecord(UUID bankTransferID, HistoryRecords historyRecords) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/BankTransfers/{BankTransferID}/History";
            String path = "/BankTransfers/{BankTransferID}/History";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("BankTransferID", bankTransferID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)historyRecords);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public BatchPayments createBatchPayment(BatchPayments batchPayments) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/BatchPayments";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)batchPayments);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<BatchPayments> typeRef = new TypeReference<BatchPayments>(){};
            return (BatchPayments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public HistoryRecords createBatchPaymentHistoryRecord(UUID batchPaymentID, HistoryRecords historyRecords) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/BatchPayments/{BatchPaymentID}/History";
            String path = "/BatchPayments/{BatchPaymentID}/History";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("BatchPaymentID", batchPaymentID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)historyRecords);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public PaymentServices createBrandingThemePaymentServices(UUID brandingThemeID, PaymentService paymentService) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/BrandingThemes/{BrandingThemeID}/PaymentServices";
            String path = "/BrandingThemes/{BrandingThemeID}/PaymentServices";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("BrandingThemeID", brandingThemeID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)paymentService);
            String response = this.DATA(url, strBody, params, "POST");
            TypeReference<PaymentServices> typeRef = new TypeReference<PaymentServices>(){};
            return (PaymentServices)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Contacts createContact(Contact contact) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Contacts";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)contact);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<Contacts> typeRef = new TypeReference<Contacts>(){};
            return (Contacts)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Attachments createContactAttachmentByFileName(UUID contactID, String fileName, byte[] body) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Contacts/{ContactID}/Attachments/{FileName}";
            String path = "/Contacts/{ContactID}/Attachments/{FileName}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ContactID", contactID.toString());
            uriVariables.put("FileName", fileName.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.FILE(url, strBody, params, "PUT", body);
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            return (Attachments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ContactGroups createContactGroup(ContactGroups contactGroups) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/ContactGroups";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)contactGroups);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<ContactGroups> typeRef = new TypeReference<ContactGroups>(){};
            return (ContactGroups)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Contacts createContactGroupContacts(UUID contactGroupID, Contacts contacts) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/ContactGroups/{ContactGroupID}/Contacts";
            String path = "/ContactGroups/{ContactGroupID}/Contacts";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ContactGroupID", contactGroupID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)contacts);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<Contacts> typeRef = new TypeReference<Contacts>(){};
            return (Contacts)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public HistoryRecords createContactHistory(UUID contactID, HistoryRecords historyRecords) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Contacts/{ContactID}/History";
            String path = "/Contacts/{ContactID}/History";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ContactID", contactID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)historyRecords);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public CreditNotes createCreditNote(Boolean summarizeErrors, CreditNotes creditNotes) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/CreditNotes";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (summarizeErrors != null) {
                this.addToMapIfNotNull(params, "SummarizeErrors", summarizeErrors);
            }
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)creditNotes);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<CreditNotes> typeRef = new TypeReference<CreditNotes>(){};
            return (CreditNotes)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Allocations createCreditNoteAllocation(UUID creditNoteID, Allocations allocations) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/CreditNotes/{CreditNoteID}/Allocations";
            String path = "/CreditNotes/{CreditNoteID}/Allocations";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("CreditNoteID", creditNoteID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)allocations);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<Allocations> typeRef = new TypeReference<Allocations>(){};
            return (Allocations)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Attachments createCreditNoteAttachmentByFileName(UUID creditNoteID, String fileName, byte[] body) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/CreditNotes/{CreditNoteID}/Attachments/{FileName}";
            String path = "/CreditNotes/{CreditNoteID}/Attachments/{FileName}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("CreditNoteID", creditNoteID.toString());
            uriVariables.put("FileName", fileName.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.FILE(url, strBody, params, "PUT", body);
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            return (Attachments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public HistoryRecords createCreditNoteHistory(UUID creditNoteID, HistoryRecords historyRecords) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/CreditNotes/{CreditNoteID}/History";
            String path = "/CreditNotes/{CreditNoteID}/History";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("CreditNoteID", creditNoteID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)historyRecords);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Currencies createCurrency(Currencies currencies) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Currencies";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)currencies);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<Currencies> typeRef = new TypeReference<Currencies>(){};
            return (Currencies)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Employees createEmployee(Employees employees) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Employees";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)employees);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<Employees> typeRef = new TypeReference<Employees>(){};
            return (Employees)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ExpenseClaims createExpenseClaim(ExpenseClaims expenseClaims, Boolean summarizeErrors) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/ExpenseClaims";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (summarizeErrors != null) {
                this.addToMapIfNotNull(params, "SummarizeErrors", summarizeErrors);
            }
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)expenseClaims);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<ExpenseClaims> typeRef = new TypeReference<ExpenseClaims>(){};
            return (ExpenseClaims)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public HistoryRecords createExpenseClaimHistory(UUID expenseClaimID, HistoryRecords historyRecords) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/ExpenseClaims/{ExpenseClaimID}/History";
            String path = "/ExpenseClaims/{ExpenseClaimID}/History";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ExpenseClaimID", expenseClaimID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)historyRecords);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Invoices createInvoice(Invoices invoices, Boolean summarizeErrors) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/Invoices";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (summarizeErrors != null) {
                this.addToMapIfNotNull(params, "SummarizeErrors", summarizeErrors);
            }
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)invoices);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<Invoices> typeRef = new TypeReference<Invoices>(){};
            return (Invoices)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Attachments createInvoiceAttachmentByFileName(UUID invoiceID, String fileName, byte[] body) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Invoices/{InvoiceID}/Attachments/{FileName}";
            String path = "/Invoices/{InvoiceID}/Attachments/{FileName}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("InvoiceID", invoiceID.toString());
            uriVariables.put("FileName", fileName.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.FILE(url, strBody, params, "PUT", body);
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            return (Attachments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public HistoryRecords createInvoiceHistory(UUID invoiceID, HistoryRecords historyRecords) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Invoices/{InvoiceID}/History";
            String path = "/Invoices/{InvoiceID}/History";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("InvoiceID", invoiceID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)historyRecords);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Items createItem(Items items) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Items";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)items);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<Items> typeRef = new TypeReference<Items>(){};
            return (Items)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public HistoryRecords createItemHistory(UUID itemID, HistoryRecords historyRecords) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Items/{ItemID}/History";
            String path = "/Items/{ItemID}/History";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ItemID", itemID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)historyRecords);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public LinkedTransactions createLinkedTransaction(LinkedTransactions linkedTransactions) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/LinkedTransactions";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)linkedTransactions);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<LinkedTransactions> typeRef = new TypeReference<LinkedTransactions>(){};
            return (LinkedTransactions)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ManualJournals createManualJournal(ManualJournals manualJournals) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/ManualJournals";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)manualJournals);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<ManualJournals> typeRef = new TypeReference<ManualJournals>(){};
            return (ManualJournals)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Attachments createManualJournalAttachmentByFileName(UUID manualJournalID, String fileName, byte[] body) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/ManualJournals/{ManualJournalID}/Attachments/{FileName}";
            String path = "/ManualJournals/{ManualJournalID}/Attachments/{FileName}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ManualJournalID", manualJournalID.toString());
            uriVariables.put("FileName", fileName.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.FILE(url, strBody, params, "PUT", body);
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            return (Attachments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Allocations createOverpaymentAllocation(UUID overpaymentID, Allocations allocations) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Overpayments/{OverpaymentID}/Allocations";
            String path = "/Overpayments/{OverpaymentID}/Allocations";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("OverpaymentID", overpaymentID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)allocations);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<Allocations> typeRef = new TypeReference<Allocations>(){};
            return (Allocations)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public HistoryRecords createOverpaymentHistory(UUID overpaymentID, HistoryRecords historyRecords) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Overpayments/{OverpaymentID}/History";
            String path = "/Overpayments/{OverpaymentID}/History";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("OverpaymentID", overpaymentID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)historyRecords);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Payments createPayment(Payments payments) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Payments";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)payments);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<Payments> typeRef = new TypeReference<Payments>(){};
            return (Payments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public HistoryRecords createPaymentHistory(UUID paymentID, HistoryRecords historyRecords) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Payments/{PaymentID}/History";
            String path = "/Payments/{PaymentID}/History";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("PaymentID", paymentID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)historyRecords);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public PaymentServices createPaymentService(PaymentServices paymentServices) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/PaymentServices";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)paymentServices);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<PaymentServices> typeRef = new TypeReference<PaymentServices>(){};
            return (PaymentServices)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Prepayments createPrepayment(Prepayments prepayments) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Prepayments";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)prepayments);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<Prepayments> typeRef = new TypeReference<Prepayments>(){};
            return (Prepayments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Allocations createPrepaymentAllocation(UUID prepaymentID, Allocations allocations) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Prepayments/{PrepaymentID}/Allocations";
            String path = "/Prepayments/{PrepaymentID}/Allocations";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("PrepaymentID", prepaymentID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)allocations);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<Allocations> typeRef = new TypeReference<Allocations>(){};
            return (Allocations)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public HistoryRecords createPrepaymentHistory(UUID prepaymentID, HistoryRecords historyRecords) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Prepayments/{PrepaymentID}/History";
            String path = "/Prepayments/{PrepaymentID}/History";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("PrepaymentID", prepaymentID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)historyRecords);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public PurchaseOrders createPurchaseOrder(PurchaseOrders purchaseOrders, Boolean summarizeErrors) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/PurchaseOrders";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (summarizeErrors != null) {
                this.addToMapIfNotNull(params, "SummarizeErrors", summarizeErrors);
            }
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)purchaseOrders);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<PurchaseOrders> typeRef = new TypeReference<PurchaseOrders>(){};
            return (PurchaseOrders)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public HistoryRecords createPurchaseOrderHistory(UUID purchaseOrderID, HistoryRecords historyRecords) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/PurchaseOrders/{PurchaseOrderID}/History";
            String path = "/PurchaseOrders/{PurchaseOrderID}/History";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("PurchaseOrderID", purchaseOrderID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)historyRecords);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Receipts createReceipt(Receipts receipts) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Receipts";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)receipts);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<Receipts> typeRef = new TypeReference<Receipts>(){};
            return (Receipts)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Attachments createReceiptAttachmentByFileName(UUID receiptID, String fileName, byte[] body) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Receipts/{ReceiptID}/Attachments/{FileName}";
            String path = "/Receipts/{ReceiptID}/Attachments/{FileName}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ReceiptID", receiptID.toString());
            uriVariables.put("FileName", fileName.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.FILE(url, strBody, params, "PUT", body);
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            return (Attachments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public HistoryRecords createReceiptHistory(UUID receiptID, HistoryRecords historyRecords) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Receipts/{ReceiptID}/History";
            String path = "/Receipts/{ReceiptID}/History";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ReceiptID", receiptID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)historyRecords);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Attachments createRepeatingInvoiceAttachmentByFileName(UUID repeatingInvoiceID, String fileName, byte[] body) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/RepeatingInvoices/{RepeatingInvoiceID}/Attachments/{FileName}";
            String path = "/RepeatingInvoices/{RepeatingInvoiceID}/Attachments/{FileName}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("RepeatingInvoiceID", repeatingInvoiceID.toString());
            uriVariables.put("FileName", fileName.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.FILE(url, strBody, params, "PUT", body);
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            return (Attachments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public HistoryRecords createRepeatingInvoiceHistory(UUID repeatingInvoiceID, HistoryRecords historyRecords) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/RepeatingInvoices/{RepeatingInvoiceID}/History";
            String path = "/RepeatingInvoices/{RepeatingInvoiceID}/History";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("RepeatingInvoiceID", repeatingInvoiceID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)historyRecords);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public TaxRates createTaxRate(TaxRates taxRates) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/TaxRates";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)taxRates);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<TaxRates> typeRef = new TypeReference<TaxRates>(){};
            return (TaxRates)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public TrackingCategories createTrackingCategory(TrackingCategory trackingCategory) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/TrackingCategories";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)trackingCategory);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<TrackingCategories> typeRef = new TypeReference<TrackingCategories>(){};
            return (TrackingCategories)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public TrackingOptions createTrackingOptions(UUID trackingCategoryID, TrackingOption trackingOption) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/TrackingCategories/{TrackingCategoryID}/Options";
            String path = "/TrackingCategories/{TrackingCategoryID}/Options";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("TrackingCategoryID", trackingCategoryID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)trackingOption);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<TrackingOptions> typeRef = new TypeReference<TrackingOptions>(){};
            return (TrackingOptions)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Accounts deleteAccount(UUID accountID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Accounts/{AccountID}";
            String path = "/Accounts/{AccountID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("AccountID", accountID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "DELETE");
            TypeReference<Accounts> typeRef = new TypeReference<Accounts>(){};
            return (Accounts)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Response204 deleteContactGroupContact(UUID contactGroupID, UUID contactID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/ContactGroups/{ContactGroupID}/Contacts/{ContactID}";
            String path = "/ContactGroups/{ContactGroupID}/Contacts/{ContactID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ContactGroupID", contactGroupID.toString());
            uriVariables.put("ContactID", contactID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "DELETE");
            TypeReference<Response204> typeRef = new TypeReference<Response204>(){};
            return (Response204)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Response204 deleteContactGroupContacts(UUID contactGroupID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/ContactGroups/{ContactGroupID}/Contacts";
            String path = "/ContactGroups/{ContactGroupID}/Contacts";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ContactGroupID", contactGroupID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "DELETE");
            TypeReference<Response204> typeRef = new TypeReference<Response204>(){};
            return (Response204)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Response204 deleteItem(UUID itemID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Items/{ItemID}";
            String path = "/Items/{ItemID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ItemID", itemID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "DELETE");
            TypeReference<Response204> typeRef = new TypeReference<Response204>(){};
            return (Response204)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Response204 deleteLinkedTransaction(UUID linkedTransactionID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/LinkedTransactions/{LinkedTransactionID}";
            String path = "/LinkedTransactions/{LinkedTransactionID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("LinkedTransactionID", linkedTransactionID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "DELETE");
            TypeReference<Response204> typeRef = new TypeReference<Response204>(){};
            return (Response204)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public TrackingCategories deleteTrackingCategory(UUID trackingCategoryID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/TrackingCategories/{TrackingCategoryID}";
            String path = "/TrackingCategories/{TrackingCategoryID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("TrackingCategoryID", trackingCategoryID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "DELETE");
            TypeReference<TrackingCategories> typeRef = new TypeReference<TrackingCategories>(){};
            return (TrackingCategories)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public TrackingOptions deleteTrackingOptions(UUID trackingCategoryID, UUID trackingOptionID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/TrackingCategories/{TrackingCategoryID}/Options/{TrackingOptionID}";
            String path = "/TrackingCategories/{TrackingCategoryID}/Options/{TrackingOptionID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("TrackingCategoryID", trackingCategoryID.toString());
            uriVariables.put("TrackingOptionID", trackingOptionID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "DELETE");
            TypeReference<TrackingOptions> typeRef = new TypeReference<TrackingOptions>(){};
            return (TrackingOptions)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Response204 emailInvoice(UUID invoiceID, RequestEmpty requestEmpty) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Invoices/{InvoiceID}/Email";
            String path = "/Invoices/{InvoiceID}/Email";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("InvoiceID", invoiceID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)requestEmpty);
            String response = this.DATA(url, strBody, params, "POST");
            TypeReference<Response204> typeRef = new TypeReference<Response204>(){};
            return (Response204)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Accounts getAccount(UUID accountID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Accounts/{AccountID}";
            String path = "/Accounts/{AccountID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("AccountID", accountID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<Accounts> typeRef = new TypeReference<Accounts>(){};
            return (Accounts)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ByteArrayInputStream getAccountAttachmentByFileName(UUID accountID, String fileName, String contentType) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Accounts/{AccountID}/Attachments/{FileName}";
            String path = "/Accounts/{AccountID}/Attachments/{FileName}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("AccountID", accountID.toString());
            uriVariables.put("FileName", fileName.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            ByteArrayInputStream response = this.FILE(url, strBody, params, "GET", contentType);
            return response;
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ByteArrayInputStream getAccountAttachmentById(UUID accountID, UUID attachmentID, String contentType) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Accounts/{AccountID}/Attachments/{AttachmentID}";
            String path = "/Accounts/{AccountID}/Attachments/{AttachmentID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("AccountID", accountID.toString());
            uriVariables.put("AttachmentID", attachmentID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            ByteArrayInputStream response = this.FILE(url, strBody, params, "GET", contentType);
            return response;
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Attachments getAccountAttachments(UUID accountID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Accounts/{AccountID}/Attachments";
            String path = "/Accounts/{AccountID}/Attachments";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("AccountID", accountID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            return (Attachments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Accounts getAccounts(OffsetDateTime ifModifiedSince, String where, String order) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/Accounts";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (where != null) {
                this.addToMapIfNotNull(params, "where", where);
            }
            if (order != null) {
                this.addToMapIfNotNull(params, "order", order);
            }
            String response = this.DATA(url, strBody, params, "GET", ifModifiedSince);
            TypeReference<Accounts> typeRef = new TypeReference<Accounts>(){};
            return (Accounts)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public BankTransactions getBankTransaction(UUID bankTransactionID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/BankTransactions/{BankTransactionID}";
            String path = "/BankTransactions/{BankTransactionID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("BankTransactionID", bankTransactionID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<BankTransactions> typeRef = new TypeReference<BankTransactions>(){};
            return (BankTransactions)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ByteArrayInputStream getBankTransactionAttachmentByFileName(UUID bankTransactionID, String fileName, String contentType) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/BankTransactions/{BankTransactionID}/Attachments/{FileName}";
            String path = "/BankTransactions/{BankTransactionID}/Attachments/{FileName}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("BankTransactionID", bankTransactionID.toString());
            uriVariables.put("FileName", fileName.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            ByteArrayInputStream response = this.FILE(url, strBody, params, "GET", contentType);
            return response;
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ByteArrayInputStream getBankTransactionAttachmentById(UUID bankTransactionID, UUID attachmentID, String contentType) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/BankTransactions/{BankTransactionID}/Attachments/{AttachmentID}";
            String path = "/BankTransactions/{BankTransactionID}/Attachments/{AttachmentID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("BankTransactionID", bankTransactionID.toString());
            uriVariables.put("AttachmentID", attachmentID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            ByteArrayInputStream response = this.FILE(url, strBody, params, "GET", contentType);
            return response;
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Attachments getBankTransactionAttachments(UUID bankTransactionID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/BankTransactions/{BankTransactionID}/Attachments";
            String path = "/BankTransactions/{BankTransactionID}/Attachments";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("BankTransactionID", bankTransactionID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            return (Attachments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public BankTransactions getBankTransactions(OffsetDateTime ifModifiedSince, String where, String order, Integer page) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/BankTransactions";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (where != null) {
                this.addToMapIfNotNull(params, "where", where);
            }
            if (order != null) {
                this.addToMapIfNotNull(params, "order", order);
            }
            if (page != null) {
                this.addToMapIfNotNull(params, "page", page);
            }
            String response = this.DATA(url, strBody, params, "GET", ifModifiedSince);
            TypeReference<BankTransactions> typeRef = new TypeReference<BankTransactions>(){};
            return (BankTransactions)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public HistoryRecords getBankTransactionsHistory(UUID bankTransactionID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/BankTransactions/{BankTransactionID}/History";
            String path = "/BankTransactions/{BankTransactionID}/History";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("BankTransactionID", bankTransactionID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public BankTransfers getBankTransfer(UUID bankTransferID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/BankTransfers/{BankTransferID}";
            String path = "/BankTransfers/{BankTransferID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("BankTransferID", bankTransferID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<BankTransfers> typeRef = new TypeReference<BankTransfers>(){};
            return (BankTransfers)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ByteArrayInputStream getBankTransferAttachmentByFileName(UUID bankTransferID, String fileName, String contentType) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/BankTransfers/{BankTransferID}/Attachments/{FileName}";
            String path = "/BankTransfers/{BankTransferID}/Attachments/{FileName}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("BankTransferID", bankTransferID.toString());
            uriVariables.put("FileName", fileName.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            ByteArrayInputStream response = this.FILE(url, strBody, params, "GET", contentType);
            return response;
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ByteArrayInputStream getBankTransferAttachmentById(UUID bankTransferID, UUID attachmentID, String contentType) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/BankTransfers/{BankTransferID}/Attachments/{AttachmentID}";
            String path = "/BankTransfers/{BankTransferID}/Attachments/{AttachmentID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("BankTransferID", bankTransferID.toString());
            uriVariables.put("AttachmentID", attachmentID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            ByteArrayInputStream response = this.FILE(url, strBody, params, "GET", contentType);
            return response;
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Attachments getBankTransferAttachments(UUID bankTransferID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/BankTransfers/{BankTransferID}/Attachments";
            String path = "/BankTransfers/{BankTransferID}/Attachments";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("BankTransferID", bankTransferID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            return (Attachments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public HistoryRecords getBankTransferHistory(UUID bankTransferID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/BankTransfers/{BankTransferID}/History";
            String path = "/BankTransfers/{BankTransferID}/History";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("BankTransferID", bankTransferID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public BankTransfers getBankTransfers(OffsetDateTime ifModifiedSince, String where, String order) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/BankTransfers";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (where != null) {
                this.addToMapIfNotNull(params, "where", where);
            }
            if (order != null) {
                this.addToMapIfNotNull(params, "order", order);
            }
            String response = this.DATA(url, strBody, params, "GET", ifModifiedSince);
            TypeReference<BankTransfers> typeRef = new TypeReference<BankTransfers>(){};
            return (BankTransfers)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public HistoryRecords getBatchPaymentHistory(UUID batchPaymentID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/BatchPayments/{BatchPaymentID}/History";
            String path = "/BatchPayments/{BatchPaymentID}/History";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("BatchPaymentID", batchPaymentID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public BatchPayments getBatchPayments(OffsetDateTime ifModifiedSince, String where, String order) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/BatchPayments";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (where != null) {
                this.addToMapIfNotNull(params, "where", where);
            }
            if (order != null) {
                this.addToMapIfNotNull(params, "order", order);
            }
            String response = this.DATA(url, strBody, params, "GET", ifModifiedSince);
            TypeReference<BatchPayments> typeRef = new TypeReference<BatchPayments>(){};
            return (BatchPayments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public BrandingThemes getBrandingTheme(UUID brandingThemeID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/BrandingThemes/{BrandingThemeID}";
            String path = "/BrandingThemes/{BrandingThemeID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("BrandingThemeID", brandingThemeID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<BrandingThemes> typeRef = new TypeReference<BrandingThemes>(){};
            return (BrandingThemes)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public PaymentServices getBrandingThemePaymentServices(UUID brandingThemeID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/BrandingThemes/{BrandingThemeID}/PaymentServices";
            String path = "/BrandingThemes/{BrandingThemeID}/PaymentServices";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("BrandingThemeID", brandingThemeID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<PaymentServices> typeRef = new TypeReference<PaymentServices>(){};
            return (PaymentServices)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public BrandingThemes getBrandingThemes() throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/BrandingThemes";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<BrandingThemes> typeRef = new TypeReference<BrandingThemes>(){};
            return (BrandingThemes)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Contacts getContact(UUID contactID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Contacts/{ContactID}";
            String path = "/Contacts/{ContactID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ContactID", contactID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<Contacts> typeRef = new TypeReference<Contacts>(){};
            return (Contacts)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ByteArrayInputStream getContactAttachmentByFileName(UUID contactID, String fileName, String contentType) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Contacts/{ContactID}/Attachments/{FileName}";
            String path = "/Contacts/{ContactID}/Attachments/{FileName}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ContactID", contactID.toString());
            uriVariables.put("FileName", fileName.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            ByteArrayInputStream response = this.FILE(url, strBody, params, "GET", contentType);
            return response;
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ByteArrayInputStream getContactAttachmentById(UUID contactID, UUID attachmentID, String contentType) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Contacts/{ContactID}/Attachments/{AttachmentID}";
            String path = "/Contacts/{ContactID}/Attachments/{AttachmentID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ContactID", contactID.toString());
            uriVariables.put("AttachmentID", attachmentID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            ByteArrayInputStream response = this.FILE(url, strBody, params, "GET", contentType);
            return response;
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Attachments getContactAttachments(UUID contactID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Contacts/{ContactID}/Attachments";
            String path = "/Contacts/{ContactID}/Attachments";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ContactID", contactID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            return (Attachments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public CISSettings getContactCISSettings(UUID contactID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Contacts/{ContactID}/CISSettings";
            String path = "/Contacts/{ContactID}/CISSettings";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ContactID", contactID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<CISSettings> typeRef = new TypeReference<CISSettings>(){};
            return (CISSettings)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ContactGroups getContactGroup(UUID contactGroupID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/ContactGroups/{ContactGroupID}";
            String path = "/ContactGroups/{ContactGroupID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ContactGroupID", contactGroupID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<ContactGroups> typeRef = new TypeReference<ContactGroups>(){};
            return (ContactGroups)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ContactGroups getContactGroups(String where, String order) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/ContactGroups";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (where != null) {
                this.addToMapIfNotNull(params, "where", where);
            }
            if (order != null) {
                this.addToMapIfNotNull(params, "order", order);
            }
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<ContactGroups> typeRef = new TypeReference<ContactGroups>(){};
            return (ContactGroups)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public HistoryRecords getContactHistory(UUID contactID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Contacts/{ContactID}/History";
            String path = "/Contacts/{ContactID}/History";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ContactID", contactID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Contacts getContacts(OffsetDateTime ifModifiedSince, String where, String order, String ids, Integer page, Boolean includeArchived) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/Contacts";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (where != null) {
                this.addToMapIfNotNull(params, "where", where);
            }
            if (order != null) {
                this.addToMapIfNotNull(params, "order", order);
            }
            if (ids != null) {
                this.addToMapIfNotNull(params, "IDs", ids);
            }
            if (page != null) {
                this.addToMapIfNotNull(params, "page", page);
            }
            if (includeArchived != null) {
                this.addToMapIfNotNull(params, "includeArchived", includeArchived);
            }
            String response = this.DATA(url, strBody, params, "GET", ifModifiedSince);
            TypeReference<Contacts> typeRef = new TypeReference<Contacts>(){};
            return (Contacts)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public CreditNotes getCreditNote(UUID creditNoteID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/CreditNotes/{CreditNoteID}";
            String path = "/CreditNotes/{CreditNoteID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("CreditNoteID", creditNoteID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<CreditNotes> typeRef = new TypeReference<CreditNotes>(){};
            return (CreditNotes)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ByteArrayInputStream getCreditNoteAsPdf(UUID creditNoteID, String contentType) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/CreditNotes/{CreditNoteID}/pdf";
            String path = "/CreditNotes/{CreditNoteID}/pdf";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("CreditNoteID", creditNoteID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            ByteArrayInputStream response = this.FILE(url, strBody, params, "GET", contentType);
            return response;
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ByteArrayInputStream getCreditNoteAttachmentByFileName(UUID creditNoteID, String fileName, String contentType) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/CreditNotes/{CreditNoteID}/Attachments/{FileName}";
            String path = "/CreditNotes/{CreditNoteID}/Attachments/{FileName}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("CreditNoteID", creditNoteID.toString());
            uriVariables.put("FileName", fileName.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            ByteArrayInputStream response = this.FILE(url, strBody, params, "GET", contentType);
            return response;
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ByteArrayInputStream getCreditNoteAttachmentById(UUID creditNoteID, UUID attachmentID, String contentType) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/CreditNotes/{CreditNoteID}/Attachments/{AttachmentID}";
            String path = "/CreditNotes/{CreditNoteID}/Attachments/{AttachmentID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("CreditNoteID", creditNoteID.toString());
            uriVariables.put("AttachmentID", attachmentID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            ByteArrayInputStream response = this.FILE(url, strBody, params, "GET", contentType);
            return response;
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Attachments getCreditNoteAttachments(UUID creditNoteID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/CreditNotes/{CreditNoteID}/Attachments";
            String path = "/CreditNotes/{CreditNoteID}/Attachments";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("CreditNoteID", creditNoteID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            return (Attachments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public HistoryRecords getCreditNoteHistory(UUID creditNoteID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/CreditNotes/{CreditNoteID}/History";
            String path = "/CreditNotes/{CreditNoteID}/History";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("CreditNoteID", creditNoteID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public CreditNotes getCreditNotes(OffsetDateTime ifModifiedSince, String where, String order, Integer page) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/CreditNotes";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (where != null) {
                this.addToMapIfNotNull(params, "where", where);
            }
            if (order != null) {
                this.addToMapIfNotNull(params, "order", order);
            }
            if (page != null) {
                this.addToMapIfNotNull(params, "page", page);
            }
            String response = this.DATA(url, strBody, params, "GET", ifModifiedSince);
            TypeReference<CreditNotes> typeRef = new TypeReference<CreditNotes>(){};
            return (CreditNotes)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Currencies getCurrencies(String where, String order) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/Currencies";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (where != null) {
                this.addToMapIfNotNull(params, "where", where);
            }
            if (order != null) {
                this.addToMapIfNotNull(params, "order", order);
            }
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<Currencies> typeRef = new TypeReference<Currencies>(){};
            return (Currencies)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Employees getEmployee(UUID employeeID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Employees/{EmployeeID}";
            String path = "/Employees/{EmployeeID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("EmployeeID", employeeID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<Employees> typeRef = new TypeReference<Employees>(){};
            return (Employees)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Employees getEmployees(OffsetDateTime ifModifiedSince, String where, String order) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/Employees";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (where != null) {
                this.addToMapIfNotNull(params, "where", where);
            }
            if (order != null) {
                this.addToMapIfNotNull(params, "order", order);
            }
            String response = this.DATA(url, strBody, params, "GET", ifModifiedSince);
            TypeReference<Employees> typeRef = new TypeReference<Employees>(){};
            return (Employees)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ExpenseClaims getExpenseClaim(UUID expenseClaimID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/ExpenseClaims/{ExpenseClaimID}";
            String path = "/ExpenseClaims/{ExpenseClaimID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ExpenseClaimID", expenseClaimID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<ExpenseClaims> typeRef = new TypeReference<ExpenseClaims>(){};
            return (ExpenseClaims)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public HistoryRecords getExpenseClaimHistory(UUID expenseClaimID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/ExpenseClaims/{ExpenseClaimID}/History";
            String path = "/ExpenseClaims/{ExpenseClaimID}/History";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ExpenseClaimID", expenseClaimID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ExpenseClaims getExpenseClaims(OffsetDateTime ifModifiedSince, String where, String order) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/ExpenseClaims";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (where != null) {
                this.addToMapIfNotNull(params, "where", where);
            }
            if (order != null) {
                this.addToMapIfNotNull(params, "order", order);
            }
            String response = this.DATA(url, strBody, params, "GET", ifModifiedSince);
            TypeReference<ExpenseClaims> typeRef = new TypeReference<ExpenseClaims>(){};
            return (ExpenseClaims)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Invoices getInvoice(UUID invoiceID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Invoices/{InvoiceID}";
            String path = "/Invoices/{InvoiceID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("InvoiceID", invoiceID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<Invoices> typeRef = new TypeReference<Invoices>(){};
            return (Invoices)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ByteArrayInputStream getInvoiceAsPdf(UUID invoiceID, String contentType) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Invoices/{InvoiceID}/pdf";
            String path = "/Invoices/{InvoiceID}/pdf";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("InvoiceID", invoiceID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            ByteArrayInputStream response = this.FILE(url, strBody, params, "GET", contentType);
            return response;
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ByteArrayInputStream getInvoiceAttachmentByFileName(UUID invoiceID, String fileName, String contentType) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Invoices/{InvoiceID}/Attachments/{FileName}";
            String path = "/Invoices/{InvoiceID}/Attachments/{FileName}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("InvoiceID", invoiceID.toString());
            uriVariables.put("FileName", fileName.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            ByteArrayInputStream response = this.FILE(url, strBody, params, "GET", contentType);
            return response;
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ByteArrayInputStream getInvoiceAttachmentById(UUID invoiceID, UUID attachmentID, String contentType) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Invoices/{InvoiceID}/Attachments/{AttachmentID}";
            String path = "/Invoices/{InvoiceID}/Attachments/{AttachmentID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("InvoiceID", invoiceID.toString());
            uriVariables.put("AttachmentID", attachmentID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            ByteArrayInputStream response = this.FILE(url, strBody, params, "GET", contentType);
            return response;
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Attachments getInvoiceAttachments(UUID invoiceID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Invoices/{InvoiceID}/Attachments";
            String path = "/Invoices/{InvoiceID}/Attachments";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("InvoiceID", invoiceID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            return (Attachments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public HistoryRecords getInvoiceHistory(UUID invoiceID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Invoices/{InvoiceID}/History";
            String path = "/Invoices/{InvoiceID}/History";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("InvoiceID", invoiceID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public InvoiceReminders getInvoiceReminders() throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/InvoiceReminders/Settings";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<InvoiceReminders> typeRef = new TypeReference<InvoiceReminders>(){};
            return (InvoiceReminders)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Invoices getInvoices(OffsetDateTime ifModifiedSince, String where, String order, String ids, String invoiceNumbers, String contactIDs, String statuses, Integer page, Boolean includeArchived, Boolean createdByMyApp) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/Invoices";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (where != null) {
                this.addToMapIfNotNull(params, "where", where);
            }
            if (order != null) {
                this.addToMapIfNotNull(params, "order", order);
            }
            if (ids != null) {
                this.addToMapIfNotNull(params, "IDs", ids);
            }
            if (invoiceNumbers != null) {
                this.addToMapIfNotNull(params, "InvoiceNumbers", invoiceNumbers);
            }
            if (contactIDs != null) {
                this.addToMapIfNotNull(params, "ContactIDs", contactIDs);
            }
            if (statuses != null) {
                this.addToMapIfNotNull(params, "Statuses", statuses);
            }
            if (page != null) {
                this.addToMapIfNotNull(params, "page", page);
            }
            if (includeArchived != null) {
                this.addToMapIfNotNull(params, "includeArchived", includeArchived);
            }
            if (createdByMyApp != null) {
                this.addToMapIfNotNull(params, "createdByMyApp", createdByMyApp);
            }
            String response = this.DATA(url, strBody, params, "GET", ifModifiedSince);
            TypeReference<Invoices> typeRef = new TypeReference<Invoices>(){};
            return (Invoices)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Items getItem(UUID itemID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Items/{ItemID}";
            String path = "/Items/{ItemID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ItemID", itemID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<Items> typeRef = new TypeReference<Items>(){};
            return (Items)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public HistoryRecords getItemHistory(UUID itemID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Items/{ItemID}/History";
            String path = "/Items/{ItemID}/History";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ItemID", itemID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Items getItems(OffsetDateTime ifModifiedSince, String where, String order) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/Items";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (where != null) {
                this.addToMapIfNotNull(params, "where", where);
            }
            if (order != null) {
                this.addToMapIfNotNull(params, "order", order);
            }
            String response = this.DATA(url, strBody, params, "GET", ifModifiedSince);
            TypeReference<Items> typeRef = new TypeReference<Items>(){};
            return (Items)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Journals getJournal(UUID journalID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Journals/{JournalID}";
            String path = "/Journals/{JournalID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("JournalID", journalID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<Journals> typeRef = new TypeReference<Journals>(){};
            return (Journals)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Journals getJournals(OffsetDateTime ifModifiedSince, Integer offset, Boolean paymentsOnly) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/Journals";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (offset != null) {
                this.addToMapIfNotNull(params, "offset", offset);
            }
            if (paymentsOnly != null) {
                this.addToMapIfNotNull(params, "paymentsOnly", paymentsOnly);
            }
            String response = this.DATA(url, strBody, params, "GET", ifModifiedSince);
            TypeReference<Journals> typeRef = new TypeReference<Journals>(){};
            return (Journals)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public LinkedTransactions getLinkedTransaction(UUID linkedTransactionID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/LinkedTransactions/{LinkedTransactionID}";
            String path = "/LinkedTransactions/{LinkedTransactionID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("LinkedTransactionID", linkedTransactionID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<LinkedTransactions> typeRef = new TypeReference<LinkedTransactions>(){};
            return (LinkedTransactions)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public LinkedTransactions getLinkedTransactions(Integer page, String linkedTransactionID, String sourceTransactionID, String contactID, String status, String targetTransactionID) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/LinkedTransactions";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (page != null) {
                this.addToMapIfNotNull(params, "page", page);
            }
            if (linkedTransactionID != null) {
                this.addToMapIfNotNull(params, "LinkedTransactionID", linkedTransactionID);
            }
            if (sourceTransactionID != null) {
                this.addToMapIfNotNull(params, "SourceTransactionID", sourceTransactionID);
            }
            if (contactID != null) {
                this.addToMapIfNotNull(params, "ContactID", contactID);
            }
            if (status != null) {
                this.addToMapIfNotNull(params, "Status", status);
            }
            if (targetTransactionID != null) {
                this.addToMapIfNotNull(params, "TargetTransactionID", targetTransactionID);
            }
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<LinkedTransactions> typeRef = new TypeReference<LinkedTransactions>(){};
            return (LinkedTransactions)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ManualJournals getManualJournal(UUID manualJournalID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/ManualJournals/{ManualJournalID}";
            String path = "/ManualJournals/{ManualJournalID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ManualJournalID", manualJournalID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<ManualJournals> typeRef = new TypeReference<ManualJournals>(){};
            return (ManualJournals)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ByteArrayInputStream getManualJournalAttachmentByFileName(UUID manualJournalID, String fileName, String contentType) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/ManualJournals/{ManualJournalID}/Attachments/{FileName}";
            String path = "/ManualJournals/{ManualJournalID}/Attachments/{FileName}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ManualJournalID", manualJournalID.toString());
            uriVariables.put("FileName", fileName.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            ByteArrayInputStream response = this.FILE(url, strBody, params, "GET", contentType);
            return response;
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ByteArrayInputStream getManualJournalAttachmentById(UUID manualJournalID, UUID attachmentID, String contentType) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/ManualJournals/{ManualJournalID}/Attachments/{AttachmentID}";
            String path = "/ManualJournals/{ManualJournalID}/Attachments/{AttachmentID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ManualJournalID", manualJournalID.toString());
            uriVariables.put("AttachmentID", attachmentID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            ByteArrayInputStream response = this.FILE(url, strBody, params, "GET", contentType);
            return response;
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Attachments getManualJournalAttachments(UUID manualJournalID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/ManualJournals/{ManualJournalID}/Attachments";
            String path = "/ManualJournals/{ManualJournalID}/Attachments";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ManualJournalID", manualJournalID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            return (Attachments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ManualJournals getManualJournals(OffsetDateTime ifModifiedSince, String where, String order, Integer page) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/ManualJournals";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (where != null) {
                this.addToMapIfNotNull(params, "where", where);
            }
            if (order != null) {
                this.addToMapIfNotNull(params, "order", order);
            }
            if (page != null) {
                this.addToMapIfNotNull(params, "page", page);
            }
            String response = this.DATA(url, strBody, params, "GET", ifModifiedSince);
            TypeReference<ManualJournals> typeRef = new TypeReference<ManualJournals>(){};
            return (ManualJournals)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public OnlineInvoices getOnlineInvoice(UUID invoiceID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Invoices/{InvoiceID}/OnlineInvoice";
            String path = "/Invoices/{InvoiceID}/OnlineInvoice";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("InvoiceID", invoiceID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<OnlineInvoices> typeRef = new TypeReference<OnlineInvoices>(){};
            return (OnlineInvoices)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Organisations getOrganisationByShortCode(UUID shortCode) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Organisation/{ShortCode}";
            String path = "/Organisation/{ShortCode}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ShortCode", shortCode.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<Organisations> typeRef = new TypeReference<Organisations>(){};
            return (Organisations)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Organisations getOrganisations() throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Organisation";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<Organisations> typeRef = new TypeReference<Organisations>(){};
            return (Organisations)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Overpayments getOverpayment(UUID overpaymentID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Overpayments/{OverpaymentID}";
            String path = "/Overpayments/{OverpaymentID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("OverpaymentID", overpaymentID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<Overpayments> typeRef = new TypeReference<Overpayments>(){};
            return (Overpayments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public HistoryRecords getOverpaymentHistory(UUID overpaymentID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Overpayments/{OverpaymentID}/History";
            String path = "/Overpayments/{OverpaymentID}/History";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("OverpaymentID", overpaymentID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Overpayments getOverpayments(OffsetDateTime ifModifiedSince, String where, String order, Integer page) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/Overpayments";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (where != null) {
                this.addToMapIfNotNull(params, "where", where);
            }
            if (order != null) {
                this.addToMapIfNotNull(params, "order", order);
            }
            if (page != null) {
                this.addToMapIfNotNull(params, "page", page);
            }
            String response = this.DATA(url, strBody, params, "GET", ifModifiedSince);
            TypeReference<Overpayments> typeRef = new TypeReference<Overpayments>(){};
            return (Overpayments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Payments getPayment(UUID paymentID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Payments/{PaymentID}";
            String path = "/Payments/{PaymentID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("PaymentID", paymentID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<Payments> typeRef = new TypeReference<Payments>(){};
            return (Payments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public HistoryRecords getPaymentHistory(UUID paymentID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Payments/{PaymentID}/History";
            String path = "/Payments/{PaymentID}/History";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("PaymentID", paymentID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public PaymentServices getPaymentServices() throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/PaymentServices";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<PaymentServices> typeRef = new TypeReference<PaymentServices>(){};
            return (PaymentServices)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Payments getPayments(OffsetDateTime ifModifiedSince, String where, String order) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/Payments";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (where != null) {
                this.addToMapIfNotNull(params, "where", where);
            }
            if (order != null) {
                this.addToMapIfNotNull(params, "order", order);
            }
            String response = this.DATA(url, strBody, params, "GET", ifModifiedSince);
            TypeReference<Payments> typeRef = new TypeReference<Payments>(){};
            return (Payments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Prepayments getPrepayment(UUID prepaymentID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Prepayments/{PrepaymentID}";
            String path = "/Prepayments/{PrepaymentID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("PrepaymentID", prepaymentID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<Prepayments> typeRef = new TypeReference<Prepayments>(){};
            return (Prepayments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public HistoryRecords getPrepaymentHistory(UUID prepaymentID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Prepayments/{PrepaymentID}/History";
            String path = "/Prepayments/{PrepaymentID}/History";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("PrepaymentID", prepaymentID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Prepayments getPrepayments(OffsetDateTime ifModifiedSince, String where, String order, Integer page) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/Prepayments";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (where != null) {
                this.addToMapIfNotNull(params, "where", where);
            }
            if (order != null) {
                this.addToMapIfNotNull(params, "order", order);
            }
            if (page != null) {
                this.addToMapIfNotNull(params, "page", page);
            }
            String response = this.DATA(url, strBody, params, "GET", ifModifiedSince);
            TypeReference<Prepayments> typeRef = new TypeReference<Prepayments>(){};
            return (Prepayments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public PurchaseOrders getPurchaseOrder(UUID purchaseOrderID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/PurchaseOrders/{PurchaseOrderID}";
            String path = "/PurchaseOrders/{PurchaseOrderID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("PurchaseOrderID", purchaseOrderID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<PurchaseOrders> typeRef = new TypeReference<PurchaseOrders>(){};
            return (PurchaseOrders)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public HistoryRecords getPurchaseOrderHistory(UUID purchaseOrderID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/PurchaseOrders/{PurchaseOrderID}/History";
            String path = "/PurchaseOrders/{PurchaseOrderID}/History";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("PurchaseOrderID", purchaseOrderID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public PurchaseOrders getPurchaseOrders(OffsetDateTime ifModifiedSince, String status, String dateFrom, String dateTo, String order, Integer page) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/PurchaseOrders";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (status != null) {
                this.addToMapIfNotNull(params, "Status", status);
            }
            if (dateFrom != null) {
                this.addToMapIfNotNull(params, "DateFrom", dateFrom);
            }
            if (dateTo != null) {
                this.addToMapIfNotNull(params, "DateTo", dateTo);
            }
            if (order != null) {
                this.addToMapIfNotNull(params, "order", order);
            }
            if (page != null) {
                this.addToMapIfNotNull(params, "page", page);
            }
            String response = this.DATA(url, strBody, params, "GET", ifModifiedSince);
            TypeReference<PurchaseOrders> typeRef = new TypeReference<PurchaseOrders>(){};
            return (PurchaseOrders)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Receipts getReceipt(UUID receiptID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Receipts/{ReceiptID}";
            String path = "/Receipts/{ReceiptID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ReceiptID", receiptID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<Receipts> typeRef = new TypeReference<Receipts>(){};
            return (Receipts)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ByteArrayInputStream getReceiptAttachmentByFileName(UUID receiptID, String fileName, String contentType) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Receipts/{ReceiptID}/Attachments/{FileName}";
            String path = "/Receipts/{ReceiptID}/Attachments/{FileName}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ReceiptID", receiptID.toString());
            uriVariables.put("FileName", fileName.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            ByteArrayInputStream response = this.FILE(url, strBody, params, "GET", contentType);
            return response;
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ByteArrayInputStream getReceiptAttachmentById(UUID receiptID, UUID attachmentID, String contentType) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Receipts/{ReceiptID}/Attachments/{AttachmentID}";
            String path = "/Receipts/{ReceiptID}/Attachments/{AttachmentID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ReceiptID", receiptID.toString());
            uriVariables.put("AttachmentID", attachmentID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            ByteArrayInputStream response = this.FILE(url, strBody, params, "GET", contentType);
            return response;
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Attachments getReceiptAttachments(UUID receiptID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Receipts/{ReceiptID}/Attachments";
            String path = "/Receipts/{ReceiptID}/Attachments";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ReceiptID", receiptID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            return (Attachments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public HistoryRecords getReceiptHistory(UUID receiptID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Receipts/{ReceiptID}/History";
            String path = "/Receipts/{ReceiptID}/History";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ReceiptID", receiptID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Receipts getReceipts(OffsetDateTime ifModifiedSince, String where, String order) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/Receipts";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (where != null) {
                this.addToMapIfNotNull(params, "where", where);
            }
            if (order != null) {
                this.addToMapIfNotNull(params, "order", order);
            }
            String response = this.DATA(url, strBody, params, "GET", ifModifiedSince);
            TypeReference<Receipts> typeRef = new TypeReference<Receipts>(){};
            return (Receipts)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public RepeatingInvoices getRepeatingInvoice(UUID repeatingInvoiceID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/RepeatingInvoices/{RepeatingInvoiceID}";
            String path = "/RepeatingInvoices/{RepeatingInvoiceID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("RepeatingInvoiceID", repeatingInvoiceID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<RepeatingInvoices> typeRef = new TypeReference<RepeatingInvoices>(){};
            return (RepeatingInvoices)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ByteArrayInputStream getRepeatingInvoiceAttachmentByFileName(UUID repeatingInvoiceID, String fileName, String contentType) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/RepeatingInvoices/{RepeatingInvoiceID}/Attachments/{FileName}";
            String path = "/RepeatingInvoices/{RepeatingInvoiceID}/Attachments/{FileName}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("RepeatingInvoiceID", repeatingInvoiceID.toString());
            uriVariables.put("FileName", fileName.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            ByteArrayInputStream response = this.FILE(url, strBody, params, "GET", contentType);
            return response;
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ByteArrayInputStream getRepeatingInvoiceAttachmentById(UUID repeatingInvoiceID, UUID attachmentID, String contentType) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/RepeatingInvoices/{RepeatingInvoiceID}/Attachments/{AttachmentID}";
            String path = "/RepeatingInvoices/{RepeatingInvoiceID}/Attachments/{AttachmentID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("RepeatingInvoiceID", repeatingInvoiceID.toString());
            uriVariables.put("AttachmentID", attachmentID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            ByteArrayInputStream response = this.FILE(url, strBody, params, "GET", contentType);
            return response;
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Attachments getRepeatingInvoiceAttachments(UUID repeatingInvoiceID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/RepeatingInvoices/{RepeatingInvoiceID}/Attachments";
            String path = "/RepeatingInvoices/{RepeatingInvoiceID}/Attachments";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("RepeatingInvoiceID", repeatingInvoiceID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            return (Attachments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public HistoryRecords getRepeatingInvoiceHistory(UUID repeatingInvoiceID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/RepeatingInvoices/{RepeatingInvoiceID}/History";
            String path = "/RepeatingInvoices/{RepeatingInvoiceID}/History";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("RepeatingInvoiceID", repeatingInvoiceID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public RepeatingInvoices getRepeatingInvoices(String where, String order) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/RepeatingInvoices";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (where != null) {
                this.addToMapIfNotNull(params, "where", where);
            }
            if (order != null) {
                this.addToMapIfNotNull(params, "order", order);
            }
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<RepeatingInvoices> typeRef = new TypeReference<RepeatingInvoices>(){};
            return (RepeatingInvoices)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ReportWithRows getReportAgedPayablesByContact(UUID contactId, LocalDate date, LocalDate fromDate, LocalDate toDate) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/Reports/AgedPayablesByContact";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (contactId != null) {
                this.addToMapIfNotNull(params, "contactId", contactId);
            }
            if (date != null) {
                this.addToMapIfNotNull(params, "date", date);
            }
            if (fromDate != null) {
                this.addToMapIfNotNull(params, "fromDate", fromDate);
            }
            if (toDate != null) {
                this.addToMapIfNotNull(params, "toDate", toDate);
            }
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<ReportWithRows> typeRef = new TypeReference<ReportWithRows>(){};
            return (ReportWithRows)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ReportWithRows getReportAgedReceivablesByContact(UUID contactId, String date, String fromDate, String toDate) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/Reports/AgedReceivablesByContact";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (contactId != null) {
                this.addToMapIfNotNull(params, "contactId", contactId);
            }
            if (date != null) {
                this.addToMapIfNotNull(params, "date", date);
            }
            if (fromDate != null) {
                this.addToMapIfNotNull(params, "fromDate", fromDate);
            }
            if (toDate != null) {
                this.addToMapIfNotNull(params, "toDate", toDate);
            }
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<ReportWithRows> typeRef = new TypeReference<ReportWithRows>(){};
            return (ReportWithRows)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ReportWithRows getReportBASorGST(String reportID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Reports/{ReportID}";
            String path = "/Reports/{ReportID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ReportID", reportID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<ReportWithRows> typeRef = new TypeReference<ReportWithRows>(){};
            return (ReportWithRows)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ReportWithRows getReportBASorGSTList() throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Reports";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<ReportWithRows> typeRef = new TypeReference<ReportWithRows>(){};
            return (ReportWithRows)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ReportWithRows getReportBalanceSheet(String date, Integer periods, String timeframe, String trackingOptionID1, String trackingOptionID2, Boolean standardLayout, Boolean paymentsOnly) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/Reports/BalanceSheet";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (date != null) {
                this.addToMapIfNotNull(params, "date", date);
            }
            if (periods != null) {
                this.addToMapIfNotNull(params, "periods", periods);
            }
            if (timeframe != null) {
                this.addToMapIfNotNull(params, "timeframe", timeframe);
            }
            if (trackingOptionID1 != null) {
                this.addToMapIfNotNull(params, "trackingOptionID1", trackingOptionID1);
            }
            if (trackingOptionID2 != null) {
                this.addToMapIfNotNull(params, "trackingOptionID2", trackingOptionID2);
            }
            if (standardLayout != null) {
                this.addToMapIfNotNull(params, "standardLayout", standardLayout);
            }
            if (paymentsOnly != null) {
                this.addToMapIfNotNull(params, "paymentsOnly", paymentsOnly);
            }
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<ReportWithRows> typeRef = new TypeReference<ReportWithRows>(){};
            return (ReportWithRows)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ReportWithRows getReportBankSummary(String date, Integer period, Integer timeframe) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/Reports/BankSummary";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (date != null) {
                this.addToMapIfNotNull(params, "date", date);
            }
            if (period != null) {
                this.addToMapIfNotNull(params, "period", period);
            }
            if (timeframe != null) {
                this.addToMapIfNotNull(params, "timeframe", timeframe);
            }
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<ReportWithRows> typeRef = new TypeReference<ReportWithRows>(){};
            return (ReportWithRows)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ReportWithRows getReportBudgetSummary(String date, Integer period, Integer timeframe) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/Reports/BudgetSummary";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (date != null) {
                this.addToMapIfNotNull(params, "date", date);
            }
            if (period != null) {
                this.addToMapIfNotNull(params, "period", period);
            }
            if (timeframe != null) {
                this.addToMapIfNotNull(params, "timeframe", timeframe);
            }
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<ReportWithRows> typeRef = new TypeReference<ReportWithRows>(){};
            return (ReportWithRows)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ReportWithRows getReportExecutiveSummary(String date) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/Reports/ExecutiveSummary";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (date != null) {
                this.addToMapIfNotNull(params, "date", date);
            }
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<ReportWithRows> typeRef = new TypeReference<ReportWithRows>(){};
            return (ReportWithRows)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ReportWithRows getReportProfitAndLoss(String fromDate, String toDate, Integer periods, String timeframe, String trackingCategoryID, String trackingCategoryID2, String trackingOptionID, String trackingOptionID2, Boolean standardLayout, Boolean paymentsOnly) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/Reports/ProfitAndLoss";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (fromDate != null) {
                this.addToMapIfNotNull(params, "fromDate", fromDate);
            }
            if (toDate != null) {
                this.addToMapIfNotNull(params, "toDate", toDate);
            }
            if (periods != null) {
                this.addToMapIfNotNull(params, "periods", periods);
            }
            if (timeframe != null) {
                this.addToMapIfNotNull(params, "timeframe", timeframe);
            }
            if (trackingCategoryID != null) {
                this.addToMapIfNotNull(params, "trackingCategoryID", trackingCategoryID);
            }
            if (trackingCategoryID2 != null) {
                this.addToMapIfNotNull(params, "trackingCategoryID2", trackingCategoryID2);
            }
            if (trackingOptionID != null) {
                this.addToMapIfNotNull(params, "trackingOptionID", trackingOptionID);
            }
            if (trackingOptionID2 != null) {
                this.addToMapIfNotNull(params, "trackingOptionID2", trackingOptionID2);
            }
            if (standardLayout != null) {
                this.addToMapIfNotNull(params, "standardLayout", standardLayout);
            }
            if (paymentsOnly != null) {
                this.addToMapIfNotNull(params, "paymentsOnly", paymentsOnly);
            }
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<ReportWithRows> typeRef = new TypeReference<ReportWithRows>(){};
            return (ReportWithRows)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Reports getReportTenNinetyNine(String reportYear) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/Reports/TenNinetyNine";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (reportYear != null) {
                this.addToMapIfNotNull(params, "reportYear", reportYear);
            }
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<Reports> typeRef = new TypeReference<Reports>(){};
            return (Reports)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ReportWithRows getReportTrialBalance(String date, Boolean paymentsOnly) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/Reports/TrialBalance";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (date != null) {
                this.addToMapIfNotNull(params, "date", date);
            }
            if (paymentsOnly != null) {
                this.addToMapIfNotNull(params, "paymentsOnly", paymentsOnly);
            }
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<ReportWithRows> typeRef = new TypeReference<ReportWithRows>(){};
            return (ReportWithRows)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public TaxRates getTaxRates(String where, String order, String taxType) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/TaxRates";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (where != null) {
                this.addToMapIfNotNull(params, "where", where);
            }
            if (order != null) {
                this.addToMapIfNotNull(params, "order", order);
            }
            if (taxType != null) {
                this.addToMapIfNotNull(params, "TaxType", taxType);
            }
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<TaxRates> typeRef = new TypeReference<TaxRates>(){};
            return (TaxRates)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public TrackingCategories getTrackingCategories(String where, String order, Boolean includeArchived) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/TrackingCategories";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (where != null) {
                this.addToMapIfNotNull(params, "where", where);
            }
            if (order != null) {
                this.addToMapIfNotNull(params, "order", order);
            }
            if (includeArchived != null) {
                this.addToMapIfNotNull(params, "includeArchived", includeArchived);
            }
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<TrackingCategories> typeRef = new TypeReference<TrackingCategories>(){};
            return (TrackingCategories)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public TrackingCategories getTrackingCategory(UUID trackingCategoryID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/TrackingCategories/{TrackingCategoryID}";
            String path = "/TrackingCategories/{TrackingCategoryID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("TrackingCategoryID", trackingCategoryID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<TrackingCategories> typeRef = new TypeReference<TrackingCategories>(){};
            return (TrackingCategories)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Users getUser(UUID userID) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Users/{UserID}";
            String path = "/Users/{UserID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("UserID", userID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<Users> typeRef = new TypeReference<Users>(){};
            return (Users)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Users getUsers(OffsetDateTime ifModifiedSince, String where, String order) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/Users";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (where != null) {
                this.addToMapIfNotNull(params, "where", where);
            }
            if (order != null) {
                this.addToMapIfNotNull(params, "order", order);
            }
            String response = this.DATA(url, strBody, params, "GET", ifModifiedSince);
            TypeReference<Users> typeRef = new TypeReference<Users>(){};
            return (Users)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Accounts updateAccount(UUID accountID, Accounts accounts) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Accounts/{AccountID}";
            String path = "/Accounts/{AccountID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("AccountID", accountID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)accounts);
            String response = this.DATA(url, strBody, params, "POST");
            TypeReference<Accounts> typeRef = new TypeReference<Accounts>(){};
            return (Accounts)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Attachments updateAccountAttachmentByFileName(UUID accountID, String fileName, byte[] body) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Accounts/{AccountID}/Attachments/{FileName}";
            String path = "/Accounts/{AccountID}/Attachments/{FileName}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("AccountID", accountID.toString());
            uriVariables.put("FileName", fileName.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.FILE(url, strBody, params, "POST", body);
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            return (Attachments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public BankTransactions updateBankTransaction(UUID bankTransactionID, BankTransactions bankTransactions) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/BankTransactions/{BankTransactionID}";
            String path = "/BankTransactions/{BankTransactionID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("BankTransactionID", bankTransactionID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)bankTransactions);
            String response = this.DATA(url, strBody, params, "POST");
            TypeReference<BankTransactions> typeRef = new TypeReference<BankTransactions>(){};
            return (BankTransactions)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Attachments updateBankTransactionAttachmentByFileName(UUID bankTransactionID, String fileName, byte[] body) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/BankTransactions/{BankTransactionID}/Attachments/{FileName}";
            String path = "/BankTransactions/{BankTransactionID}/Attachments/{FileName}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("BankTransactionID", bankTransactionID.toString());
            uriVariables.put("FileName", fileName.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.FILE(url, strBody, params, "POST", body);
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            return (Attachments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Attachments updateBankTransferAttachmentByFileName(UUID bankTransferID, String fileName, byte[] body) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/BankTransfers/{BankTransferID}/Attachments/{FileName}";
            String path = "/BankTransfers/{BankTransferID}/Attachments/{FileName}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("BankTransferID", bankTransferID.toString());
            uriVariables.put("FileName", fileName.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.FILE(url, strBody, params, "POST", body);
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            return (Attachments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Contacts updateContact(UUID contactID, Contacts contacts) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Contacts/{ContactID}";
            String path = "/Contacts/{ContactID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ContactID", contactID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)contacts);
            String response = this.DATA(url, strBody, params, "POST");
            TypeReference<Contacts> typeRef = new TypeReference<Contacts>(){};
            return (Contacts)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Attachments updateContactAttachmentByFileName(UUID contactID, UUID fileName, File body) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Contacts/{ContactID}/Attachments/{FileName}";
            String path = "/Contacts/{ContactID}/Attachments/{FileName}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ContactID", contactID.toString());
            uriVariables.put("FileName", fileName.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)body);
            String response = this.DATA(url, strBody, params, "POST");
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            return (Attachments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Attachments updateContactAttachmentById(UUID contactID, UUID attachmentID, File body) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Contacts/{ContactID}/Attachments/{AttachmentID}";
            String path = "/Contacts/{ContactID}/Attachments/{AttachmentID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ContactID", contactID.toString());
            uriVariables.put("AttachmentID", attachmentID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)body);
            String response = this.DATA(url, strBody, params, "POST");
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            return (Attachments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ContactGroups updateContactGroup(UUID contactGroupID, ContactGroups contactGroups) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/ContactGroups/{ContactGroupID}";
            String path = "/ContactGroups/{ContactGroupID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ContactGroupID", contactGroupID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)contactGroups);
            String response = this.DATA(url, strBody, params, "POST");
            TypeReference<ContactGroups> typeRef = new TypeReference<ContactGroups>(){};
            return (ContactGroups)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public CreditNotes updateCreditNote(UUID creditNoteID, CreditNotes creditNotes) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/CreditNotes/{CreditNoteID}";
            String path = "/CreditNotes/{CreditNoteID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("CreditNoteID", creditNoteID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)creditNotes);
            String response = this.DATA(url, strBody, params, "POST");
            TypeReference<CreditNotes> typeRef = new TypeReference<CreditNotes>(){};
            return (CreditNotes)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Attachments updateCreditNoteAttachmentByFileName(UUID creditNoteID, UUID fileName, File body) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/CreditNotes/{CreditNoteID}/Attachments/{FileName}";
            String path = "/CreditNotes/{CreditNoteID}/Attachments/{FileName}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("CreditNoteID", creditNoteID.toString());
            uriVariables.put("FileName", fileName.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)body);
            String response = this.DATA(url, strBody, params, "POST");
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            return (Attachments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Attachments updateCreditNoteAttachmentById(UUID creditNoteID, UUID attachmentID, File body) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/CreditNotes/{CreditNoteID}/Attachments/{AttachmentID}";
            String path = "/CreditNotes/{CreditNoteID}/Attachments/{AttachmentID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("CreditNoteID", creditNoteID.toString());
            uriVariables.put("AttachmentID", attachmentID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)body);
            String response = this.DATA(url, strBody, params, "POST");
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            return (Attachments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Employees updateEmployee(UUID employeeID, Employees employees) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Employees/{EmployeeID}";
            String path = "/Employees/{EmployeeID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("EmployeeID", employeeID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)employees);
            String response = this.DATA(url, strBody, params, "POST");
            TypeReference<Employees> typeRef = new TypeReference<Employees>(){};
            return (Employees)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ExpenseClaims updateExpenseClaim(UUID expenseClaimID, ExpenseClaims expenseClaims) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/ExpenseClaims/{ExpenseClaimID}";
            String path = "/ExpenseClaims/{ExpenseClaimID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ExpenseClaimID", expenseClaimID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)expenseClaims);
            String response = this.DATA(url, strBody, params, "POST");
            TypeReference<ExpenseClaims> typeRef = new TypeReference<ExpenseClaims>(){};
            return (ExpenseClaims)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Invoices updateInvoice(UUID invoiceID, Invoices invoices) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Invoices/{InvoiceID}";
            String path = "/Invoices/{InvoiceID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("InvoiceID", invoiceID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)invoices);
            String response = this.DATA(url, strBody, params, "POST");
            TypeReference<Invoices> typeRef = new TypeReference<Invoices>(){};
            return (Invoices)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Attachments updateInvoiceAttachmentByFileName(UUID invoiceID, UUID fileName, File body) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Invoices/{InvoiceID}/Attachments/{FileName}";
            String path = "/Invoices/{InvoiceID}/Attachments/{FileName}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("InvoiceID", invoiceID.toString());
            uriVariables.put("FileName", fileName.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)body);
            String response = this.DATA(url, strBody, params, "POST");
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            return (Attachments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Attachments updateInvoiceAttachmentById(UUID invoiceID, UUID attachmentID, File body) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Invoices/{InvoiceID}/Attachments/{AttachmentID}";
            String path = "/Invoices/{InvoiceID}/Attachments/{AttachmentID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("InvoiceID", invoiceID.toString());
            uriVariables.put("AttachmentID", attachmentID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)body);
            String response = this.DATA(url, strBody, params, "POST");
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            return (Attachments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Items updateItem(UUID itemID, Items items) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Items/{ItemID}";
            String path = "/Items/{ItemID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ItemID", itemID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)items);
            String response = this.DATA(url, strBody, params, "POST");
            TypeReference<Items> typeRef = new TypeReference<Items>(){};
            return (Items)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public LinkedTransactions updateLinkedTransaction(UUID linkedTransactionID, LinkedTransactions linkedTransactions) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/LinkedTransactions/{LinkedTransactionID}";
            String path = "/LinkedTransactions/{LinkedTransactionID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("LinkedTransactionID", linkedTransactionID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)linkedTransactions);
            String response = this.DATA(url, strBody, params, "POST");
            TypeReference<LinkedTransactions> typeRef = new TypeReference<LinkedTransactions>(){};
            return (LinkedTransactions)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ManualJournals updateManualJournal(UUID manualJournalID, ManualJournals manualJournals) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/ManualJournals/{ManualJournalID}";
            String path = "/ManualJournals/{ManualJournalID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ManualJournalID", manualJournalID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)manualJournals);
            String response = this.DATA(url, strBody, params, "POST");
            TypeReference<ManualJournals> typeRef = new TypeReference<ManualJournals>(){};
            return (ManualJournals)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Attachments updateManualJournalAttachmentByFileName(UUID manualJournalID, UUID fileName, File body) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/ManualJournals/{ManualJournalID}/Attachments/{FileName}";
            String path = "/ManualJournals/{ManualJournalID}/Attachments/{FileName}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ManualJournalID", manualJournalID.toString());
            uriVariables.put("FileName", fileName.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)body);
            String response = this.DATA(url, strBody, params, "POST");
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            return (Attachments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Attachments updateManualJournalAttachmentById(UUID manualJournalID, UUID attachmentID, File body) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/ManualJournals/{ManualJournalID}/Attachments/{AttachmentID}";
            String path = "/ManualJournals/{ManualJournalID}/Attachments/{AttachmentID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ManualJournalID", manualJournalID.toString());
            uriVariables.put("AttachmentID", attachmentID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)body);
            String response = this.DATA(url, strBody, params, "POST");
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            return (Attachments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Payments updatePayment(UUID paymentID, Payments payments) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Payments/{PaymentID}";
            String path = "/Payments/{PaymentID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("PaymentID", paymentID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)payments);
            String response = this.DATA(url, strBody, params, "POST");
            TypeReference<Payments> typeRef = new TypeReference<Payments>(){};
            return (Payments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public PurchaseOrders updatePurchaseOrder(UUID purchaseOrderID, PurchaseOrders purchaseOrders) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/PurchaseOrders/{PurchaseOrderID}";
            String path = "/PurchaseOrders/{PurchaseOrderID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("PurchaseOrderID", purchaseOrderID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)purchaseOrders);
            String response = this.DATA(url, strBody, params, "POST");
            TypeReference<PurchaseOrders> typeRef = new TypeReference<PurchaseOrders>(){};
            return (PurchaseOrders)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Receipts updateReceipt(UUID receiptID, Receipts receipts) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Receipts/{ReceiptID}";
            String path = "/Receipts/{ReceiptID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ReceiptID", receiptID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)receipts);
            String response = this.DATA(url, strBody, params, "POST");
            TypeReference<Receipts> typeRef = new TypeReference<Receipts>(){};
            return (Receipts)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Attachments updateReceiptAttachmentByFileName(UUID receiptID, UUID fileName, File body) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Receipts/{ReceiptID}/Attachments/{FileName}";
            String path = "/Receipts/{ReceiptID}/Attachments/{FileName}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ReceiptID", receiptID.toString());
            uriVariables.put("FileName", fileName.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)body);
            String response = this.DATA(url, strBody, params, "POST");
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            return (Attachments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Attachments updateReceiptAttachmentById(UUID receiptID, UUID attachmentID, File body) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Receipts/{ReceiptID}/Attachments/{AttachmentID}";
            String path = "/Receipts/{ReceiptID}/Attachments/{AttachmentID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ReceiptID", receiptID.toString());
            uriVariables.put("AttachmentID", attachmentID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)body);
            String response = this.DATA(url, strBody, params, "POST");
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            return (Attachments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Attachments updateRepeatingInvoiceAttachmentByFileName(UUID repeatingInvoiceID, UUID fileName, File body) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/RepeatingInvoices/{RepeatingInvoiceID}/Attachments/{FileName}";
            String path = "/RepeatingInvoices/{RepeatingInvoiceID}/Attachments/{FileName}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("RepeatingInvoiceID", repeatingInvoiceID.toString());
            uriVariables.put("FileName", fileName.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)body);
            String response = this.DATA(url, strBody, params, "POST");
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            return (Attachments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Attachments updateRepeatingInvoiceAttachmentById(UUID repeatingInvoiceID, UUID attachmentID, File body) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/RepeatingInvoices/{RepeatingInvoiceID}/Attachments/{AttachmentID}";
            String path = "/RepeatingInvoices/{RepeatingInvoiceID}/Attachments/{AttachmentID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("RepeatingInvoiceID", repeatingInvoiceID.toString());
            uriVariables.put("AttachmentID", attachmentID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)body);
            String response = this.DATA(url, strBody, params, "POST");
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            return (Attachments)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public TaxRates updateTaxRate(TaxRates taxRates) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/TaxRates";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)taxRates);
            String response = this.DATA(url, strBody, params, "POST");
            TypeReference<TaxRates> typeRef = new TypeReference<TaxRates>(){};
            return (TaxRates)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public TrackingCategories updateTrackingCategory(UUID trackingCategoryID, TrackingCategory trackingCategory) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/TrackingCategories/{TrackingCategoryID}";
            String path = "/TrackingCategories/{TrackingCategoryID}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("TrackingCategoryID", trackingCategoryID.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)trackingCategory);
            String response = this.DATA(url, strBody, params, "POST");
            TypeReference<TrackingCategories> typeRef = new TypeReference<TrackingCategories>(){};
            return (TrackingCategories)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    protected void addToMapIfNotNull(Map<String, String> map, String key, Object value) {
        if (value != null) {
            map.put(key, value.toString());
        }
    }

    static {
        utcFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        MESSAGE_PATTERN = Pattern.compile("<Message>(.*)</Message>");
    }
}

