/*
 * Decompiled with CFR 0.152.
 */
package com.xero.api.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xero.api.ApiClient;
import com.xero.api.Config;
import com.xero.api.ConfigBasedSignerFactory;
import com.xero.api.JSONUtils;
import com.xero.api.JsonConfig;
import com.xero.api.OAuthRequestResource;
import com.xero.api.SignerFactory;
import com.xero.api.XeroApiException;
import com.xero.api.XeroClient;
import com.xero.api.exception.XeroExceptionHandler;
import com.xero.model.ObjectFactory;
import com.xero.models.bankfeeds.FeedConnection;
import com.xero.models.bankfeeds.FeedConnections;
import com.xero.models.bankfeeds.Statement;
import com.xero.models.bankfeeds.Statements;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.ws.rs.core.UriBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.threeten.bp.OffsetDateTime;

public class BankFeedsApi {
    private ApiClient apiClient;
    private XeroExceptionHandler xeroExceptionHandler;
    private Config config;
    private SignerFactory signerFactory;
    private String token = null;
    private String tokenSecret = null;
    static final Logger logger = LogManager.getLogger(XeroClient.class);
    protected static final DateFormat utcFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    protected static final Pattern MESSAGE_PATTERN;
    protected final ObjectFactory objFactory = new ObjectFactory();

    public BankFeedsApi(Config config) {
        this(config, new ConfigBasedSignerFactory(config));
        this.xeroExceptionHandler = new XeroExceptionHandler();
    }

    public BankFeedsApi(Config config, SignerFactory signerFactory) {
        this.config = config;
        this.signerFactory = signerFactory;
        this.xeroExceptionHandler = new XeroExceptionHandler();
    }

    public BankFeedsApi(ApiClient apiClient) {
        this(JsonConfig.getInstance());
        this.xeroExceptionHandler = new XeroExceptionHandler();
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void setOAuthToken(String token, String tokenSecret) {
        this.token = token;
        this.tokenSecret = tokenSecret;
    }

    protected String DATA(String url, String body, Map<String, String> params, String method) throws IOException {
        return this.DATA(url, body, params, method, null, "application/json");
    }

    protected String DATA(String url, String body, Map<String, String> params, String method, OffsetDateTime ifModifiedSince) throws IOException {
        return this.DATA(url, body, params, method, ifModifiedSince, "application/json");
    }

    protected String DATA(String url, String body, Map<String, String> params, String method, String contentType) throws IOException {
        return this.DATA(url, body, params, method, null, contentType);
    }

    protected String DATA(String url, String body, Map<String, String> params, String method, OffsetDateTime ifModifiedSince, String contentType) throws IOException {
        OAuthRequestResource req = new OAuthRequestResource(this.config, this.signerFactory, url, method, body, params, contentType, "application/json");
        req.setToken(this.token);
        req.setTokenSecret(this.tokenSecret);
        if (ifModifiedSince != null) {
            req.setIfModifiedSince(ifModifiedSince);
        }
        try {
            Map<String, String> resp = req.execute();
            String r = resp.get("content");
            return r.toString();
        }
        catch (IOException ioe) {
            throw this.xeroExceptionHandler.convertException(ioe);
        }
    }

    protected String DATA(String url, String body, Map<String, String> params, String method, String xeroApplicationId, String xeroTenantId, String xeroUserId) throws IOException {
        OAuthRequestResource req = new OAuthRequestResource(this.config, this.signerFactory, url, method, body, params, null, "application/json");
        req.setToken(this.token);
        req.setTokenSecret(this.tokenSecret);
        try {
            Map<String, String> resp = req.execute();
            String r = resp.get("content");
            return r.toString();
        }
        catch (IOException ioe) {
            throw this.xeroExceptionHandler.convertException(ioe);
        }
    }

    protected ByteArrayInputStream FILE(String url, String body, Map<String, String> params, String method) throws IOException {
        return this.FILE(url, body, params, method, "application/octet-stream");
    }

    protected ByteArrayInputStream FILE(String url, String body, Map<String, String> params, String method, String accept) throws IOException {
        OAuthRequestResource req = new OAuthRequestResource(this.config, this.signerFactory, url, method, body, params, accept, "application/json");
        req.setToken(this.token);
        req.setTokenSecret(this.tokenSecret);
        try {
            ByteArrayInputStream resp = req.executefile();
            return resp;
        }
        catch (IOException ioe) {
            throw this.xeroExceptionHandler.convertException(ioe);
        }
    }

    protected String FILE(String url, String body, Map<String, String> params, String method, byte[] byteBody) throws IOException {
        return this.FILE(url, body, params, method, byteBody, "application/octet-stream");
    }

    protected String FILE(String url, String body, Map<String, String> params, String method, byte[] byteBody, String contentType) throws IOException {
        OAuthRequestResource req = new OAuthRequestResource(this.config, this.signerFactory, url, method, contentType, byteBody, params, "application/json");
        req.setToken(this.token);
        req.setTokenSecret(this.tokenSecret);
        try {
            Map<String, String> resp = req.execute();
            String r = resp.get("content");
            return r.toString();
        }
        catch (IOException ioe) {
            throw this.xeroExceptionHandler.convertException(ioe);
        }
    }

    public FeedConnections createFeedConnections(FeedConnections feedConnections) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/FeedConnections";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)feedConnections);
            String response = this.DATA(url, strBody, params, "POST");
            TypeReference<FeedConnections> typeRef = new TypeReference<FeedConnections>(){};
            return (FeedConnections)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Statements createStatements(Statements statements) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Statements";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)statements);
            String response = this.DATA(url, strBody, params, "POST");
            TypeReference<Statements> typeRef = new TypeReference<Statements>(){};
            return (Statements)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public FeedConnections deleteFeedConnections(FeedConnections feedConnections) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/FeedConnections/DeleteRequests";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)feedConnections);
            String response = this.DATA(url, strBody, params, "POST");
            TypeReference<FeedConnections> typeRef = new TypeReference<FeedConnections>(){};
            return (FeedConnections)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public FeedConnection getFeedConnection(String id) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/FeedConnections/{id}";
            String path = "/FeedConnections/{id}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("id", id.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<FeedConnection> typeRef = new TypeReference<FeedConnection>(){};
            return (FeedConnection)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public FeedConnections getFeedConnections(Integer page, Integer pageSize) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/FeedConnections";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (page != null) {
                this.addToMapIfNotNull(params, "page", page);
            }
            if (pageSize != null) {
                this.addToMapIfNotNull(params, "pageSize", pageSize);
            }
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<FeedConnections> typeRef = new TypeReference<FeedConnections>(){};
            return (FeedConnections)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Statement getStatement(String statementId) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Statements/{statementId}";
            String path = "/Statements/{statementId}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("statementId", statementId.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<Statement> typeRef = new TypeReference<Statement>(){};
            return (Statement)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Statements getStatements(Integer page, Integer pageSize, String xeroApplicationId, String xeroTenantId, String xeroUserId) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/Statements";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (page != null) {
                this.addToMapIfNotNull(params, "page", page);
            }
            if (pageSize != null) {
                this.addToMapIfNotNull(params, "pageSize", pageSize);
            }
            String response = this.DATA(url, strBody, params, "GET", xeroApplicationId, xeroTenantId, xeroUserId);
            TypeReference<Statements> typeRef = new TypeReference<Statements>(){};
            return (Statements)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    protected void addToMapIfNotNull(Map<String, String> map, String key, Object value) {
        if (value != null) {
            map.put(key, value.toString());
        }
    }

    static {
        utcFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        MESSAGE_PATTERN = Pattern.compile("<Message>(.*)</Message>");
    }
}

