/*
 * Decompiled with CFR 0.152.
 */
package com.xero.api.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xero.api.ApiClient;
import com.xero.api.Config;
import com.xero.api.ConfigBasedSignerFactory;
import com.xero.api.JSONUtils;
import com.xero.api.JsonConfig;
import com.xero.api.OAuthRequestResource;
import com.xero.api.SignerFactory;
import com.xero.api.XeroApiException;
import com.xero.api.XeroClient;
import com.xero.api.exception.XeroExceptionHandler;
import com.xero.model.ObjectFactory;
import com.xero.models.files.Association;
import com.xero.models.files.FileObject;
import com.xero.models.files.FileResponse204;
import com.xero.models.files.Files;
import com.xero.models.files.Folder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.ws.rs.core.UriBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.threeten.bp.OffsetDateTime;

public class FilesApi {
    private ApiClient apiClient;
    private XeroExceptionHandler xeroExceptionHandler;
    private Config config;
    private SignerFactory signerFactory;
    private String token = null;
    private String tokenSecret = null;
    static final Logger logger = LogManager.getLogger(XeroClient.class);
    protected static final DateFormat utcFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    protected static final Pattern MESSAGE_PATTERN;
    protected final ObjectFactory objFactory = new ObjectFactory();

    public FilesApi(Config config) {
        this(config, new ConfigBasedSignerFactory(config));
        this.xeroExceptionHandler = new XeroExceptionHandler();
    }

    public FilesApi(Config config, SignerFactory signerFactory) {
        this.config = config;
        this.signerFactory = signerFactory;
        this.xeroExceptionHandler = new XeroExceptionHandler();
    }

    public FilesApi(ApiClient apiClient) {
        this(JsonConfig.getInstance());
        this.xeroExceptionHandler = new XeroExceptionHandler();
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void setOAuthToken(String token, String tokenSecret) {
        this.token = token;
        this.tokenSecret = tokenSecret;
    }

    protected String DATA(String url, String body, Map<String, String> params, String method) throws IOException {
        return this.DATA(url, body, params, method, null, "application/json");
    }

    protected String DATA(String url, String body, Map<String, String> params, String method, OffsetDateTime ifModifiedSince) throws IOException {
        return this.DATA(url, body, params, method, ifModifiedSince, "application/json");
    }

    protected String DATA(String url, String body, Map<String, String> params, String method, String contentType) throws IOException {
        return this.DATA(url, body, params, method, null, contentType);
    }

    protected String DATA(String url, String body, Map<String, String> params, String method, OffsetDateTime ifModifiedSince, String contentType) throws IOException {
        OAuthRequestResource req = new OAuthRequestResource(this.config, this.signerFactory, url, method, body, params, contentType, "application/json");
        req.setToken(this.token);
        req.setTokenSecret(this.tokenSecret);
        if (ifModifiedSince != null) {
            req.setIfModifiedSince(ifModifiedSince);
        }
        try {
            Map<String, String> resp = req.execute();
            String r = resp.get("content");
            return r.toString();
        }
        catch (IOException ioe) {
            throw this.xeroExceptionHandler.convertException(ioe);
        }
    }

    protected String DATA(String url, String body, Map<String, String> params, String method, String xeroApplicationId, String xeroTenantId, String xeroUserId) throws IOException {
        OAuthRequestResource req = new OAuthRequestResource(this.config, this.signerFactory, url, method, body, params, null, "application/json");
        req.setToken(this.token);
        req.setTokenSecret(this.tokenSecret);
        try {
            Map<String, String> resp = req.execute();
            String r = resp.get("content");
            return r.toString();
        }
        catch (IOException ioe) {
            throw this.xeroExceptionHandler.convertException(ioe);
        }
    }

    protected ByteArrayInputStream FILE(String url, String body, Map<String, String> params, String method) throws IOException {
        return this.FILE(url, body, params, method, "application/octet-stream");
    }

    protected ByteArrayInputStream FILE(String url, String body, Map<String, String> params, String method, String accept) throws IOException {
        OAuthRequestResource req = new OAuthRequestResource(this.config, this.signerFactory, url, method, body, params, accept, "application/json");
        req.setToken(this.token);
        req.setTokenSecret(this.tokenSecret);
        try {
            ByteArrayInputStream resp = req.executefile();
            return resp;
        }
        catch (IOException ioe) {
            throw this.xeroExceptionHandler.convertException(ioe);
        }
    }

    protected String FILE(String url, String body, Map<String, String> params, String method, byte[] byteBody) throws IOException {
        return this.FILE(url, body, params, method, byteBody, "application/octet-stream");
    }

    protected String FILE(String url, String body, Map<String, String> params, String method, byte[] byteBody, String contentType) throws IOException {
        OAuthRequestResource req = new OAuthRequestResource(this.config, this.signerFactory, url, method, contentType, byteBody, params, "application/json");
        req.setToken(this.token);
        req.setTokenSecret(this.tokenSecret);
        try {
            Map<String, String> resp = req.execute();
            String r = resp.get("content");
            return r.toString();
        }
        catch (IOException ioe) {
            throw this.xeroExceptionHandler.convertException(ioe);
        }
    }

    public Association createFileAssociation(UUID fileId, Association association) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Files/{FileId}/Associations";
            String path = "/Files/{FileId}/Associations";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("FileId", fileId.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)association);
            String response = this.DATA(url, strBody, params, "POST");
            TypeReference<Association> typeRef = new TypeReference<Association>(){};
            return (Association)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Folder createFolder(Folder folder) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Folders";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)folder);
            String response = this.DATA(url, strBody, params, "POST");
            TypeReference<Folder> typeRef = new TypeReference<Folder>(){};
            return (Folder)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public FileResponse204 deleteFile(UUID fileId) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Files/{FileId}";
            String path = "/Files/{FileId}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("FileId", fileId.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "DELETE");
            TypeReference<FileResponse204> typeRef = new TypeReference<FileResponse204>(){};
            return (FileResponse204)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public FileResponse204 deleteFileAssociation(UUID fileId, UUID objectId) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Files/{FileId}/Associations/{ObjectId}";
            String path = "/Files/{FileId}/Associations/{ObjectId}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("FileId", fileId.toString());
            uriVariables.put("ObjectId", objectId.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "DELETE");
            TypeReference<FileResponse204> typeRef = new TypeReference<FileResponse204>(){};
            return (FileResponse204)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public FileResponse204 deleteFolder(UUID folderId) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Folders/{FolderId}";
            String path = "/Folders/{FolderId}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("FolderId", folderId.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "DELETE");
            TypeReference<FileResponse204> typeRef = new TypeReference<FileResponse204>(){};
            return (FileResponse204)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public List<Association> getAssociationsByObject(UUID objectId) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Associations/{ObjectId}";
            String path = "/Associations/{ObjectId}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("ObjectId", objectId.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<List<Association>> typeRef = new TypeReference<List<Association>>(){};
            return (List)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public FileObject getFile(UUID fileId) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Files/{FileId}";
            String path = "/Files/{FileId}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("FileId", fileId.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<FileObject> typeRef = new TypeReference<FileObject>(){};
            return (FileObject)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public List<Association> getFileAssociations(UUID fileId) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Files/{FileId}/Associations";
            String path = "/Files/{FileId}/Associations";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("FileId", fileId.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<List<Association>> typeRef = new TypeReference<List<Association>>(){};
            return (List)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public ByteArrayInputStream getFileContent(UUID fileId) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Files/{FileId}/Content";
            String path = "/Files/{FileId}/Content";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("FileId", fileId.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            ByteArrayInputStream response = this.FILE(url, strBody, params, "GET");
            return response;
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Files getFiles(Integer pagesize, Integer page, String sort) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/Files";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (pagesize != null) {
                this.addToMapIfNotNull(params, "pagesize", pagesize);
            }
            if (page != null) {
                this.addToMapIfNotNull(params, "page", page);
            }
            if (sort != null) {
                this.addToMapIfNotNull(params, "sort", sort);
            }
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<Files> typeRef = new TypeReference<Files>(){};
            return (Files)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Folder getFolder(UUID folderId) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Folders/{FolderId}";
            String path = "/Folders/{FolderId}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("FolderId", folderId.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<Folder> typeRef = new TypeReference<Folder>(){};
            return (Folder)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public List<Folder> getFolders(String sort) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/Folders";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (sort != null) {
                this.addToMapIfNotNull(params, "sort", sort);
            }
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<List<Folder>> typeRef = new TypeReference<List<Folder>>(){};
            return (List)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Folder getInbox() throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Inbox";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            String response = this.DATA(url, strBody, params, "GET");
            TypeReference<Folder> typeRef = new TypeReference<Folder>(){};
            return (Folder)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public FileObject updateFile(UUID fileId, FileObject fileObject) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Files/{FileId}";
            String path = "/Files/{FileId}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("FileId", fileId.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)fileObject);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<FileObject> typeRef = new TypeReference<FileObject>(){};
            return (FileObject)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public Folder updateFolder(UUID folderId, Folder folder) throws IOException {
        try {
            String strBody = null;
            Map<String, String> params = null;
            String correctPath = "/Folders/{FolderId}";
            String path = "/Folders/{FolderId}";
            String type = "/pdf";
            if (path.toLowerCase().contains(type.toLowerCase())) {
                correctPath = path.replace("/pdf", "");
            }
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("FolderId", folderId.toString());
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.buildFromMap(uriVariables).toString();
            strBody = this.apiClient.getObjectMapper().writeValueAsString((Object)folder);
            String response = this.DATA(url, strBody, params, "PUT");
            TypeReference<Folder> typeRef = new TypeReference<Folder>(){};
            return (Folder)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    public FileObject uploadFile(UUID folderId, byte[] body, String name, String filename, String mimeType) throws IOException {
        try {
            String strBody = null;
            HashMap<String, String> params = null;
            String correctPath = "/Files";
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + correctPath));
            String url = uriBuilder.build(new Object[0]).toString();
            params = new HashMap<String, String>();
            if (folderId != null) {
                this.addToMapIfNotNull(params, "folderId", folderId);
            }
            UUID uuid = UUID.randomUUID();
            String boundary = uuid.toString();
            byte[] head = new String("\r\n--" + boundary + "\r\nContent-Disposition: form-data; name=" + name + ";FileName=" + filename + " \r\nContent-Type: " + mimeType + "\r\n\r\n").getBytes();
            byte[] trailer = new String("\r\n--" + boundary + "--\r\n").getBytes();
            String contentType = "multipart/form-data; boundary=" + boundary;
            byte[] destination = new byte[head.length + body.length + trailer.length];
            System.arraycopy(head, 0, destination, 0, head.length);
            System.arraycopy(body, 0, destination, head.length, body.length);
            System.arraycopy(trailer, 0, destination, head.length + body.length, trailer.length);
            String response = this.FILE(url, strBody, params, "POST", destination, contentType);
            TypeReference<FileObject> typeRef = new TypeReference<FileObject>(){};
            return (FileObject)this.apiClient.getObjectMapper().readValue(response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage());
        }
        catch (XeroApiException e) {
            throw this.xeroExceptionHandler.handleBadRequest(e.getMessage(), e.getResponseCode(), JSONUtils.isJSONValid(e.getMessage()));
        }
    }

    protected void addToMapIfNotNull(Map<String, String> map, String key, Object value) {
        if (value != null) {
            map.put(key, value.toString());
        }
    }

    static {
        utcFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        MESSAGE_PATTERN = Pattern.compile("<Message>(.*)</Message>");
    }
}

