/*
 * Decompiled with CFR 0.152.
 */
package com.xero.api.exception;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.api.client.http.HttpResponseException;
import com.xero.api.ApiClient;
import com.xero.api.XeroApiException;
import com.xero.api.XeroClientException;
import com.xero.api.jaxb.XeroJAXBMarshaller;
import com.xero.model.ApiException;
import com.xero.models.accounting.Error;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XeroExceptionHandler {
    static final Logger logger = LogManager.getLogger(XeroExceptionHandler.class);
    private static final Pattern MESSAGE_PATTERN = Pattern.compile("<Message>(.*)</Message>");
    private XeroJAXBMarshaller xeroJaxbMarshaller;
    private ApiClient apiClient = new ApiClient(null, null, null, null);

    public XeroExceptionHandler() {
        this.xeroJaxbMarshaller = new XeroJAXBMarshaller();
    }

    public XeroApiException handleBadRequest(HttpResponseException httpResponseException) {
        String content = httpResponseException.getContent();
        if (content.contains("ApiException")) {
            try {
                ApiException apiException = this.xeroJaxbMarshaller.unmarshall(content, ApiException.class);
                return new XeroApiException(httpResponseException.getStatusCode(), content, apiException);
            }
            catch (Exception e) {
                logger.error((Object)e);
                return this.convertException((IOException)httpResponseException);
            }
        }
        return this.newApiException(httpResponseException);
    }

    public XeroApiException handleBadRequest(String content) {
        if (content.contains("ApiException")) {
            try {
                ApiException apiException = this.xeroJaxbMarshaller.unmarshall(content, ApiException.class);
                return new XeroApiException(412, content, apiException);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return null;
    }

    public XeroApiException handleBadRequest(String content, int code, boolean isJson) {
        if (isJson) {
            TypeReference<Error> typeRef = new TypeReference<Error>(){};
            try {
                Error error = (Error)this.apiClient.getObjectMapper().readValue(content, (TypeReference)typeRef);
                return new XeroApiException(code, content, error);
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        } else {
            Error error = new Error();
            error.setMessage(content);
            return new XeroApiException(code, content, error);
        }
        return null;
    }

    public XeroApiException handleBadRequest(String content, int code) {
        if (content.contains("ApiException")) {
            try {
                ApiException apiException = this.xeroJaxbMarshaller.unmarshall(content, ApiException.class);
                return new XeroApiException(code, content, apiException);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        } else {
            return this.newApiException(content, code);
        }
        return null;
    }

    public XeroApiException convertException(IOException ioe) {
        if (ioe instanceof HttpResponseException) {
            HttpResponseException httpResponseException = (HttpResponseException)ioe;
            if (httpResponseException.getStatusCode() == 400) {
                return this.handleBadRequest(httpResponseException);
            }
            if (httpResponseException.getStatusCode() == 401 || httpResponseException.getStatusCode() == 404 || httpResponseException.getStatusCode() == 500 || httpResponseException.getStatusCode() == 503) {
                return this.newApiException(httpResponseException);
            }
            return this.newApiException(httpResponseException);
        }
        throw new XeroClientException(ioe.getMessage(), ioe);
    }

    public XeroApiException newApiException(HttpResponseException httpResponseException) {
        Matcher matcher = MESSAGE_PATTERN.matcher(httpResponseException.getContent());
        StringBuilder messages = new StringBuilder();
        while (matcher.find()) {
            if (messages.length() > 0) {
                messages.append(", ");
            }
            messages.append(matcher.group(1));
        }
        if (messages.length() > 0) {
            return new XeroApiException(httpResponseException.getStatusCode(), messages.toString());
        }
        if (httpResponseException.getContent().contains("=")) {
            try {
                String value = URLDecoder.decode(httpResponseException.getContent(), "UTF-8");
                String[] keyValuePairs = value.split("&");
                HashMap<String, String> errorMap = new HashMap<String, String>();
                for (String pair : keyValuePairs) {
                    String[] entry = pair.split("=");
                    errorMap.put(entry[0].trim(), entry[1].trim());
                }
                return new XeroApiException(httpResponseException.getStatusCode(), errorMap);
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)e);
                throw new XeroClientException(e.getMessage(), e);
            }
        }
        return new XeroApiException(httpResponseException.getStatusCode(), httpResponseException.getContent());
    }

    public XeroApiException newApiException(String content, int code) {
        Matcher matcher = MESSAGE_PATTERN.matcher(content);
        StringBuilder messages = new StringBuilder();
        while (matcher.find()) {
            if (messages.length() > 0) {
                messages.append(", ");
            }
            messages.append(matcher.group(1));
        }
        if (messages.length() > 0) {
            return new XeroApiException(code, messages.toString());
        }
        if (content.contains("=")) {
            try {
                String value = URLDecoder.decode(content, "UTF-8");
                String[] keyValuePairs = value.split("&");
                HashMap<String, String> errorMap = new HashMap<String, String>();
                for (String pair : keyValuePairs) {
                    String[] entry = pair.split("=");
                    errorMap.put(entry[0].trim(), entry[1].trim());
                }
                return new XeroApiException(code, errorMap);
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)e);
                throw new XeroClientException(e.getMessage(), e);
            }
        }
        return new XeroApiException(code, content);
    }
}

