/*
 * Decompiled with CFR 0.152.
 */
package com.xero.example;

import com.xero.api.Config;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomJsonConfig
implements Config {
    private String APP_TYPE = "PUBLIC";
    private String USER_AGENT = "Xero-Java-SDK";
    private String ACCEPT = "application/xml";
    private String CONSUMER_KEY = "YOUR_CONSUMER_KEY";
    private String CONSUMER_SECRET = "YOUR_CONSUMER_SECRET";
    private String API_ENDPOINT_URL = "https://api.xero.com/api.xro/2.0/";
    private String FILES_ENDPOINT_URL = "https://api.xero.com/files.xro/1.0/";
    private String ASSETS_ENDPOINT_URL = "https://api.xero.com/assets.xro/1.0/";
    private String BANKFEEDS_ENDPOINT_URL = "https://api.xero.com/bankfeeds.xro/1.0/";
    private String REQUEST_TOKEN_URL = "https://api.xero.com/oauth/RequestToken";
    private String AUTHENTICATE_URL = "https://api.xero.com/oauth/Authorize";
    private String ACCESS_TOKEN_URL = "https://api.xero.com/oauth/AccessToken";
    private String AUTH_CALLBACK_URL = "http://localhost:8080/xero-sdk-demo-7/CallbackServlet";
    private String PATH_TO_PRIVATE_KEY_CERT = "/certs/public_privatekey.pfx";
    private String PRIVATE_KEY_PASSWORD = "1234";
    private String PROXY_HOST;
    private long PROXY_PORT = 80L;
    private boolean PROXY_HTTPS_ENABLED = false;
    private int CONNECT_TIMEOUT = 60;
    private int READ_TIMEOUT = 60;
    private String DECIMAL_PLACES = null;
    private boolean USING_APP_FIREWALL = false;
    private String APP_FIREWALL_HOSTNAME;
    private String APP_FIREWALL_URL_PREFIX;
    private String KEY_STORE_PATH;
    private String KEY_STORE_PASSWORD;
    static final Logger logger = LogManager.getLogger(CustomJsonConfig.class);

    @Override
    public String getAppType() {
        return this.APP_TYPE;
    }

    @Override
    public String getPrivateKeyPassword() {
        return this.PRIVATE_KEY_PASSWORD;
    }

    @Override
    public String getPathToPrivateKey() {
        return this.PATH_TO_PRIVATE_KEY_CERT;
    }

    @Override
    public String getConsumerKey() {
        return this.CONSUMER_KEY;
    }

    @Override
    public String getConsumerSecret() {
        return this.CONSUMER_SECRET;
    }

    @Override
    public String getApiUrl() {
        return this.API_ENDPOINT_URL;
    }

    @Override
    public String getFilesUrl() {
        return this.FILES_ENDPOINT_URL;
    }

    @Override
    public String getAssetsUrl() {
        return this.ASSETS_ENDPOINT_URL;
    }

    @Override
    public String getBankFeedsUrl() {
        return this.BANKFEEDS_ENDPOINT_URL;
    }

    @Override
    public String getRequestTokenUrl() {
        return this.REQUEST_TOKEN_URL;
    }

    @Override
    public String getAuthorizeUrl() {
        return this.AUTHENTICATE_URL;
    }

    @Override
    public String getAccessTokenUrl() {
        return this.ACCESS_TOKEN_URL;
    }

    @Override
    public String getUserAgent() {
        return this.USER_AGENT + " " + this.CONSUMER_KEY + " [Xero-Java-1.0.8]";
    }

    @Override
    public String getAccept() {
        return this.ACCEPT;
    }

    @Override
    public String getRedirectUri() {
        return this.AUTH_CALLBACK_URL;
    }

    @Override
    public String getProxyHost() {
        return this.PROXY_HOST;
    }

    @Override
    public long getProxyPort() {
        return this.PROXY_PORT;
    }

    @Override
    public boolean getProxyHttpsEnabled() {
        return this.PROXY_HTTPS_ENABLED;
    }

    @Override
    public int getConnectTimeout() {
        return this.CONNECT_TIMEOUT;
    }

    @Override
    public int getReadTimeout() {
        return this.READ_TIMEOUT;
    }

    @Override
    public String getDecimalPlaces() {
        return this.DECIMAL_PLACES;
    }

    @Override
    public boolean isUsingAppFirewall() {
        return this.USING_APP_FIREWALL;
    }

    @Override
    public String getAppFirewallHostname() {
        return this.APP_FIREWALL_HOSTNAME;
    }

    @Override
    public String getAppFirewallUrlPrefix() {
        return this.APP_FIREWALL_URL_PREFIX;
    }

    @Override
    public String getKeyStorePath() {
        return this.KEY_STORE_PATH;
    }

    @Override
    public String getKeyStorePassword() {
        return this.KEY_STORE_PASSWORD;
    }

    @Override
    public void setConsumerKey(String consumerKey) {
    }

    @Override
    public void setConsumerSecret(String consumerSecret) {
    }

    @Override
    public void setAppType(String appType) {
    }

    @Override
    public void setAuthCallBackUrl(String authCallbackUrl) {
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
    }

    @Override
    public void setReadTimeout(int readTimeout) {
    }

    @Override
    public void setDecimalPlaces(String decimalPlaces) {
    }

    @Override
    public void setUsingAppFirewall(boolean usingAppFirewall) {
    }

    @Override
    public void setAppFirewallHostname(String appFirewallHostname) {
    }

    @Override
    public void setAppFirewallUrlPrefix(String appFirewallUrlPrefix) {
    }

    @Override
    public void setKeyStorePath(String keyStorePath) {
    }

    @Override
    public void setKeyStorePassword(String keyStorePassword) {
    }
}

