/*
 * Decompiled with CFR 0.152.
 */
package com.xero.example;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xero.api.ApiClient;
import com.xero.api.Config;
import com.xero.api.JsonConfig;
import com.xero.api.OAuthAccessToken;
import com.xero.api.OAuthRequestResource;
import com.xero.api.XeroApiException;
import com.xero.api.client.AccountingApi;
import com.xero.api.client.AssetApi;
import com.xero.api.client.BankFeedsApi;
import com.xero.api.client.FilesApi;
import com.xero.example.SampleData;
import com.xero.example.TokenStorage;
import com.xero.models.accounting.Account;
import com.xero.models.accounting.AccountType;
import com.xero.models.accounting.Accounts;
import com.xero.models.accounting.Allocation;
import com.xero.models.accounting.Allocations;
import com.xero.models.accounting.Attachments;
import com.xero.models.accounting.BankTransaction;
import com.xero.models.accounting.BankTransactions;
import com.xero.models.accounting.BankTransfer;
import com.xero.models.accounting.BankTransfers;
import com.xero.models.accounting.BatchPayment;
import com.xero.models.accounting.BatchPayments;
import com.xero.models.accounting.BrandingThemes;
import com.xero.models.accounting.CISSettings;
import com.xero.models.accounting.Contact;
import com.xero.models.accounting.ContactGroup;
import com.xero.models.accounting.ContactGroups;
import com.xero.models.accounting.Contacts;
import com.xero.models.accounting.CreditNote;
import com.xero.models.accounting.CreditNotes;
import com.xero.models.accounting.Currencies;
import com.xero.models.accounting.Employee;
import com.xero.models.accounting.Employees;
import com.xero.models.accounting.ExpenseClaim;
import com.xero.models.accounting.ExpenseClaims;
import com.xero.models.accounting.ExternalLink;
import com.xero.models.accounting.HistoryRecord;
import com.xero.models.accounting.HistoryRecords;
import com.xero.models.accounting.Invoice;
import com.xero.models.accounting.InvoiceReminders;
import com.xero.models.accounting.Invoices;
import com.xero.models.accounting.Item;
import com.xero.models.accounting.Items;
import com.xero.models.accounting.Journals;
import com.xero.models.accounting.LineAmountTypes;
import com.xero.models.accounting.LineItem;
import com.xero.models.accounting.LinkedTransaction;
import com.xero.models.accounting.LinkedTransactions;
import com.xero.models.accounting.ManualJournal;
import com.xero.models.accounting.ManualJournalLine;
import com.xero.models.accounting.ManualJournals;
import com.xero.models.accounting.OnlineInvoices;
import com.xero.models.accounting.Organisations;
import com.xero.models.accounting.Overpayments;
import com.xero.models.accounting.Payment;
import com.xero.models.accounting.PaymentService;
import com.xero.models.accounting.PaymentServices;
import com.xero.models.accounting.Payments;
import com.xero.models.accounting.Phone;
import com.xero.models.accounting.Prepayments;
import com.xero.models.accounting.PurchaseOrder;
import com.xero.models.accounting.PurchaseOrders;
import com.xero.models.accounting.Receipt;
import com.xero.models.accounting.Receipts;
import com.xero.models.accounting.RepeatingInvoices;
import com.xero.models.accounting.ReportWithRows;
import com.xero.models.accounting.RequestEmpty;
import com.xero.models.accounting.Response204;
import com.xero.models.accounting.TaxComponent;
import com.xero.models.accounting.TaxRate;
import com.xero.models.accounting.TaxRates;
import com.xero.models.accounting.TaxType;
import com.xero.models.accounting.TrackingCategories;
import com.xero.models.accounting.TrackingCategory;
import com.xero.models.accounting.TrackingOption;
import com.xero.models.accounting.TrackingOptions;
import com.xero.models.accounting.User;
import com.xero.models.accounting.Users;
import com.xero.models.assets.Asset;
import com.xero.models.assets.AssetType;
import com.xero.models.assets.Assets;
import com.xero.models.assets.BookDepreciationSetting;
import com.xero.models.assets.Setting;
import com.xero.models.bankfeeds.CreditDebitIndicator;
import com.xero.models.bankfeeds.EndBalance;
import com.xero.models.bankfeeds.Error;
import com.xero.models.bankfeeds.FeedConnection;
import com.xero.models.bankfeeds.FeedConnections;
import com.xero.models.bankfeeds.StartBalance;
import com.xero.models.bankfeeds.Statement;
import com.xero.models.bankfeeds.StatementLine;
import com.xero.models.bankfeeds.StatementLines;
import com.xero.models.bankfeeds.Statements;
import com.xero.models.files.Association;
import com.xero.models.files.FileObject;
import com.xero.models.files.FileResponse204;
import com.xero.models.files.Files;
import com.xero.models.files.Folder;
import com.xero.models.files.ObjectGroup;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.Month;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZoneOffset;

public class RequestResourceServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private Config config = null;
    static final Logger logger = LogManager.getLogger(OAuthRequestResource.class);
    private String htmlString = "<link rel=\"stylesheet\" href=\"https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css\" integrity=\"sha384-1q8mTJOASx8j1Au+a5WDVnPi2lkFfwwEAa8hDDdjZlpLegxhjVME1fgjWPGmkzs7\" crossorigin=\"anonymous\"><link rel=\"stylesheet\" href=\"https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap-theme.min.css\" integrity=\"sha384-fLW2N01lMqjakBkx3l/M9EahuwpSfeNvV63J5ezn3uZzapT0u7EYsXMjQV+0En5r\" crossorigin=\"anonymous\"><script src=\"https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/js/bootstrap.min.js\" integrity=\"sha384-0mSbJDEHialfmuBBQP6A4Qrprq5OVfW37PRR3j5ELqxss1yVqOtnepnHVP9aJ7xS\" crossorigin=\"anonymous\"></script><div class=\"container\"><h1>Xero API - JAVA</h1><div class=\"form-group\"><a href=\"/\" class=\"btn btn-default\" type=\"button\">Logout</a></div><form action=\"./RequestResourceServlet\" method=\"post\"><div class=\"form-group\"><label for=\"object\">Create, Read, Update & Delete</label><select name=\"object\" class=\"form-control\" id=\"object\"><option value=\"Assets\" >Assets</option><option value=\"Accounts\" >Accounts</option><option value=\"CreateAttachments\">Attachments - Create</option><option value=\"GetAttachments\">Attachments - Get</option><option value=\"BankFeedConnections\">Bank Feed Connections</option><option value=\"BankStatements\">Bank Statements</option><option value=\"BankTransactions\" >BankTransactions</option><option value=\"BankTransfers\" >BankTransfers</option><option value=\"BatchPayments\" >BatchPayments</option><option value=\"BrandingThemes\">BrandingThemes</option><option value=\"Contacts\">Contacts</option><option value=\"ContactGroups\" >ContactGroups</option><option value=\"ContactGroupContacts\">ContactGroups Contacts</option><option value=\"CreditNotes\" >CreditNotes</option><option value=\"CreditNotesPDF\" >CreditNote As PDF</option><option value=\"Currencies\">Currencies</option><option value=\"Employees\" >Employees</option><option value=\"ExpenseClaims\">ExpenseClaims</option><option value=\"Files\" >Files</option><option value=\"Folders\" >Folders</option><option value=\"Invoices\" >Invoices</option><option value=\"InvoiceReminders\">InvoiceReminders</option><option value=\"Items\">Items</option><option value=\"Journals\">Journals</option><option value=\"LinkedTransactions\">LinkedTransactions</option><option value=\"ManualJournals\">ManualJournals</option><option value=\"Organisations\" SELECTED>Organisations</option><option value=\"Overpayments\">Overpayments</option><option value=\"Payments\">Payments</option><option value=\"PaymentServices\">PaymentServices</option><option value=\"Prepayments\">Prepayments</option><option value=\"PurchaseOrders\">PurchaseOrders</option><option value=\"Receipts\">Receipts</option><option value=\"RepeatingInvoices\" >RepeatingInvoices</option><option value=\"Reports\" >Reports</option><option value=\"TaxRates\">TaxRates</option><option value=\"TrackingCategories\" >TrackingCategories</option><option value=\"Users\">Users</option><option value=\"Errors\" >Errors</option></select></div><div class=\"form-group\"><input class=\"btn btn-default\" type=\"submit\" value=\"submit\"></div></form></div>";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter respWriter = response.getWriter();
        response.setStatus(200);
        response.setContentType("text/html");
        respWriter.println(this.htmlString);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ArrayList<String> messages;
        PrintWriter respWriter;
        block217: {
            LocalDate currDate;
            Allocation allocation;
            Allocations allocations;
            Invoice inv;
            Invoices allInvoices;
            BankTransactions newBankTransaction;
            BankTransactions bts;
            BankTransaction bt;
            Contact useContact;
            Contacts contacts;
            LocalDate currDate2;
            HistoryRecords history;
            Receipts newReceipts;
            Receipts receipts;
            Contact useContact2;
            LineItem li;
            UUID creditNoteID;
            UUID accountID;
            respWriter = response.getWriter();
            response.setStatus(200);
            response.setContentType("text/html");
            respWriter.println(this.htmlString);
            respWriter.println("<div class=\"container\"><hr>begin processing request<hr><div class=\"form-group\">");
            String object = request.getParameter("object");
            messages = new ArrayList<String>();
            TokenStorage storage = new TokenStorage();
            String token = storage.get(request, "token");
            String tokenSecret = storage.get(request, "tokenSecret");
            if (storage.tokenIsNull(token)) {
                request.getRequestDispatcher("index.jsp").forward((ServletRequest)request, (ServletResponse)response);
            }
            try {
                this.config = JsonConfig.getInstance();
                System.out.println("Your user agent is: " + this.config.getUserAgent());
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            OAuthAccessToken refreshToken = new OAuthAccessToken(this.config);
            String tokenTimestamp = storage.get(request, "tokenTimestamp");
            if (this.config.getAppType().equals("PARTNER") && refreshToken.isStale(tokenTimestamp)) {
                System.out.println("Time to refresh access token");
                refreshToken.setToken(storage.get(request, "token"));
                refreshToken.setTokenSecret(storage.get(request, "tokenSecret"));
                refreshToken.setSessionHandle(storage.get(request, "sessionHandle"));
                boolean success = refreshToken.build().execute();
                if (!success) {
                    try {
                        request.getRequestDispatcher("index.jsp").forward((ServletRequest)request, (ServletResponse)response);
                    }
                    catch (ServletException e) {
                        logger.error((Object)e);
                    }
                }
                storage.save(response, refreshToken.getAll());
                token = refreshToken.getToken();
                tokenSecret = refreshToken.getTokenSecret();
            }
            System.out.println(token);
            System.out.println(tokenSecret);
            ApiClient apiClientForBankFeeds = new ApiClient(this.config.getBankFeedsUrl(), null, null, null);
            BankFeedsApi bankFeedsApi = new BankFeedsApi(this.config);
            bankFeedsApi.setApiClient(apiClientForBankFeeds);
            bankFeedsApi.setOAuthToken(token, tokenSecret);
            ApiClient apiClientForAssets = new ApiClient(this.config.getAssetsUrl(), null, null, null);
            AssetApi assetApi = new AssetApi(this.config);
            assetApi.setApiClient(apiClientForAssets);
            assetApi.setOAuthToken(token, tokenSecret);
            ApiClient apiClientForAccounting = new ApiClient(this.config.getApiUrl(), null, null, null);
            AccountingApi accountingApi = new AccountingApi(this.config);
            accountingApi.setApiClient(apiClientForAccounting);
            accountingApi.setOAuthToken(token, tokenSecret);
            ApiClient apiClientForFiles = new ApiClient(this.config.getFilesUrl(), null, null, null);
            FilesApi filesApi = new FilesApi(this.config);
            filesApi.setApiClient(apiClientForFiles);
            filesApi.setOAuthToken(token, tokenSecret);
            OffsetDateTime ifModifiedSince = null;
            String where = null;
            String order = null;
            boolean summarizeErrors = false;
            String ids = null;
            boolean includeArchived = false;
            String invoiceNumbers = null;
            String contactIDs = null;
            String statuses = null;
            boolean createdByMyApp = false;
            Calendar now = Calendar.getInstance();
            if (object.equals("Files")) {
                try {
                    List<Folder> myFolders = filesApi.getFolders(null);
                    if (myFolders.size() > 1) {
                        System.out.println("My folder : " + myFolders.get(1).getName());
                    }
                    String name = "XeroLogo.png";
                    String fileName = "XeroLogo";
                    String mimeType = URLConnection.guessContentTypeFromName(name);
                    InputStream inputStream = JsonConfig.class.getResourceAsStream("/" + name);
                    byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
                    FileObject newFileObj = filesApi.uploadFile(null, bytes, name, fileName, mimeType);
                    messages.add("Files found: " + newFileObj.getName());
                    inputStream.close();
                    Files myFiles = filesApi.getFiles(null, null, null);
                    if (myFiles.getItems().size() > 0) {
                        UUID fileId = myFiles.getItems().get(0).getId();
                        String myFileName = myFiles.getItems().get(0).getName();
                        messages.add("Files found - total: " + myFiles.getItems().size());
                        messages.add("File Name: " + myFileName);
                        FileObject oneFile = filesApi.getFile(fileId);
                        messages.add("Get one file - name: " + oneFile.getName());
                        FileObject newFileObject = new FileObject();
                        newFileObject.setName("HelloWorld.jpg");
                        FileObject updatedFile = filesApi.updateFile(fileId, newFileObject);
                        messages.add("Get one file - name: " + updatedFile.getName());
                        ByteArrayInputStream input = filesApi.getFileContent(fileId);
                        String saveFilePath = this.saveFile(input, "MyNewFile.jpg");
                        messages.add("Save it here: " + saveFilePath);
                        Association association = new Association();
                        Invoices invoices = accountingApi.getInvoices(null, null, null, null, null, null, "AUTHORISED", null, false, null);
                        UUID invoiceId = invoices.getInvoices().get(0).getInvoiceID();
                        association.setObjectGroup(ObjectGroup.INVOICE);
                        association.setObjectId(invoiceId);
                        Association fileAssociation = filesApi.createFileAssociation(fileId, association);
                        messages.add("file association obj group: " + (Object)((Object)fileAssociation.getObjectGroup()));
                        List<Association> fileAssociations = filesApi.getFileAssociations(fileId);
                        messages.add("Total File associations: " + fileAssociations.size());
                        UUID objectId = fileAssociations.get(0).getObjectId();
                        List<Association> objectAssociations = filesApi.getAssociationsByObject(objectId);
                        messages.add("Total OBJECT associations: " + objectAssociations.size());
                        FileResponse204 deletedAssociation = filesApi.deleteFileAssociation(fileId, objectId);
                        messages.add("Delete file association status: " + deletedAssociation.getStatus());
                        List<Association> fileAssociationsNew = filesApi.getFileAssociations(fileId);
                        messages.add("Total File associations: " + fileAssociationsNew.size());
                        FileResponse204 deletedFile = filesApi.deleteFile(fileId);
                        messages.add("Delete file status: " + deletedFile.getStatus());
                    }
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            } else if (object.equals("Folders")) {
                try {
                    List<Folder> myFolders = filesApi.getFolders(null);
                    if (myFolders.size() > 0) {
                        UUID folderId = myFolders.get(0).getId();
                        messages.add("Folders found - total: " + myFolders.size());
                        Folder oneFolder = filesApi.getFolder(folderId);
                        messages.add("One Folders found - name: " + oneFolder.getName());
                        Folder folder = new Folder();
                        folder.setEmail("foo@bar.com");
                        folder.setName("NewFolder" + SampleData.loadRandomNum());
                        Folder createdFolder = filesApi.createFolder(folder);
                        UUID newFolderId = createdFolder.getId();
                        messages.add("New Folder - name: " + createdFolder.getName());
                        Folder folder2 = new Folder();
                        folder2.setName("UpdatedFolder" + SampleData.loadRandomNum());
                        Folder updatedFolder = filesApi.updateFolder(newFolderId, folder2);
                        messages.add("Updated Folder - name: " + updatedFolder.getName());
                        Folder inboxFolder = filesApi.getInbox();
                        messages.add("Get Inbox Folder - email: " + inboxFolder.getEmail());
                    }
                }
                catch (Exception e) {
                    System.out.println(e.toString());
                }
            } else if (object.equals("Accounts")) {
                try {
                    Accounts accounts = accountingApi.getAccounts(null, null, null);
                    messages.add("Get a all Accounts - total : " + accounts.getAccounts().size());
                    Accounts oneAccount = accountingApi.getAccount(accounts.getAccounts().get(0).getAccountID());
                    messages.add("Get a one Account - name : " + oneAccount.getAccounts().get(0).getName());
                    Account acct = new Account();
                    acct.setName("Bye" + SampleData.loadRandomNum());
                    acct.setCode("Hello" + SampleData.loadRandomNum());
                    acct.setDescription("Foo boo");
                    acct.setType(AccountType.EXPENSE);
                    Accounts newAccount = accountingApi.createAccount(acct);
                    System.out.println("Create a new Account - Name : " + newAccount.getAccounts().get(0).getName() + " Description : " + newAccount.getAccounts().get(0).getDescription() + "");
                    accountID = newAccount.getAccounts().get(0).getAccountID();
                    System.out.println(newAccount.getAccounts().get(0).toString());
                    System.out.println("Bank Account type: " + (Object)((Object)newAccount.getAccounts().get(0).getBankAccountType()));
                    Account bankAcct = new Account();
                    bankAcct.setName("Checking " + SampleData.loadRandomNum());
                    bankAcct.setCode("12" + SampleData.loadRandomNum());
                    bankAcct.setType(AccountType.BANK);
                    bankAcct.setBankAccountNumber("1234" + SampleData.loadRandomNum());
                    Accounts newBankAccount = accountingApi.createAccount(bankAcct);
                    messages.add("Create Bank Account - Name : " + newBankAccount.getAccounts().get(0).getName());
                    System.out.println(newBankAccount.getAccounts().get(0).toString());
                    System.out.println("Bank Account type: " + (Object)((Object)newBankAccount.getAccounts().get(0).getBankAccountType()));
                    where = "Status==\"ACTIVE\"&&Type==\"BANK\"";
                    Accounts accountsWhere = accountingApi.getAccounts(ifModifiedSince, where, order);
                    messages.add("Get a all Accounts - total : " + accountsWhere.getAccounts().size());
                    newAccount.getAccounts().get(0).setDescription("Monsters Inc.");
                    newAccount.getAccounts().get(0).setStatus(null);
                    Accounts updateAccount = accountingApi.updateAccount(accountID, newAccount);
                    messages.add("Update Account - Name : " + updateAccount.getAccounts().get(0).getName() + " Description : " + updateAccount.getAccounts().get(0).getDescription() + "");
                    Accounts archiveAccounts = new Accounts();
                    Account archiveAccount = new Account();
                    archiveAccount.setStatus(Account.StatusEnum.ARCHIVED);
                    archiveAccount.setAccountID(accountID);
                    archiveAccounts.addAccountsItem(archiveAccount);
                    Accounts achivedAccount = accountingApi.updateAccount(accountID, archiveAccounts);
                    messages.add("Archived Account - Name : " + achivedAccount.getAccounts().get(0).getName() + " Status: " + (Object)((Object)achivedAccount.getAccounts().get(0).getStatus()));
                    UUID deleteAccountID = newAccount.getAccounts().get(0).getAccountID();
                    Accounts deleteAccount = accountingApi.deleteAccount(deleteAccountID);
                    messages.add("Delete account - Status? : " + (Object)((Object)deleteAccount.getAccounts().get(0).getStatus()));
                }
                catch (Exception e) {
                    System.out.println(e.toString());
                    e.printStackTrace();
                }
            } else if (object.equals("GetAttachments")) {
                try {
                    UUID RepeatingInvoiceID;
                    Attachments repeatingInvoicesAttachments;
                    RepeatingInvoices repeatingInvoices;
                    UUID ReceiptID;
                    Attachments receiptsAttachments;
                    Receipts receipts2;
                    UUID ManualJournalID;
                    Attachments manualJournalsAttachments;
                    ManualJournals manualJournals;
                    UUID InvoiceID;
                    Attachments invoicesAttachments;
                    Invoices invoices;
                    UUID CreditNoteID;
                    Attachments creditNotesAttachments;
                    CreditNotes creditNotes;
                    UUID ContactID;
                    Attachments contactsAttachments;
                    Contacts contacts2;
                    UUID BankTransferID;
                    Attachments bankTransfersAttachments;
                    BankTransfers bankTransfers;
                    UUID BankTransactionID;
                    Attachments bankTransactionsAttachments;
                    BankTransactions bankTransactions;
                    UUID accountID2;
                    Attachments accountsAttachments;
                    Accounts accounts = accountingApi.getAccounts(ifModifiedSince, where, order);
                    if (accounts.getAccounts().size() > 0 && (accountsAttachments = accountingApi.getAccountAttachments(accountID2 = accounts.getAccounts().get(0).getAccountID())).getAttachments().size() > 0) {
                        UUID attachementId = accountsAttachments.getAttachments().get(0).getAttachmentID();
                        String contentType = accountsAttachments.getAttachments().get(0).getMimeType();
                        ByteArrayInputStream input = accountingApi.getAccountAttachmentById(accountID2, attachementId, contentType);
                        String fileName = "Account_" + accountsAttachments.getAttachments().get(0).getFileName();
                        String saveFilePath = this.saveFile(input, fileName);
                        messages.add("Get Account attachment - save it here: " + saveFilePath);
                    }
                    if ((bankTransactions = accountingApi.getBankTransactions(ifModifiedSince, where, order, null)).getBankTransactions().size() > 0 && (bankTransactionsAttachments = accountingApi.getBankTransactionAttachments(BankTransactionID = bankTransactions.getBankTransactions().get(0).getBankTransactionID())).getAttachments().size() > 0) {
                        UUID BankTransactionAttachementID = bankTransactionsAttachments.getAttachments().get(0).getAttachmentID();
                        String BankTransactionContentType = bankTransactionsAttachments.getAttachments().get(0).getMimeType();
                        ByteArrayInputStream BankTransactionInput = accountingApi.getAccountAttachmentById(BankTransactionID, BankTransactionAttachementID, BankTransactionContentType);
                        String BankTransactionFileName = "BankTransaction_" + bankTransactionsAttachments.getAttachments().get(0).getFileName();
                        String BankTransactionSaveFilePath = this.saveFile(BankTransactionInput, BankTransactionFileName);
                        messages.add("Get BankTransactions attachment - save it here: " + BankTransactionSaveFilePath);
                    }
                    if ((bankTransfers = accountingApi.getBankTransfers(ifModifiedSince, where, order)).getBankTransfers().size() > 0 && (bankTransfersAttachments = accountingApi.getBankTransferAttachments(BankTransferID = bankTransfers.getBankTransfers().get(0).getBankTransferID())).getAttachments().size() > 0) {
                        UUID BankTransferAttachementID = bankTransfersAttachments.getAttachments().get(0).getAttachmentID();
                        String BankTransferContentType = bankTransfersAttachments.getAttachments().get(0).getMimeType();
                        ByteArrayInputStream BankTransferInput = accountingApi.getAccountAttachmentById(BankTransferID, BankTransferAttachementID, BankTransferContentType);
                        String BankTransferFileName = "BankTransfer_" + bankTransfersAttachments.getAttachments().get(0).getFileName();
                        String BankTransferSaveFilePath = this.saveFile(BankTransferInput, BankTransferFileName);
                        messages.add("Get BankTransfers attachment - save it here: " + BankTransferSaveFilePath);
                    }
                    if ((contacts2 = accountingApi.getContacts(ifModifiedSince, where, order, ids, null, includeArchived)).getContacts().size() > 0 && (contactsAttachments = accountingApi.getContactAttachments(ContactID = contacts2.getContacts().get(0).getContactID())).getAttachments().size() > 0) {
                        UUID ContactAttachementID = contactsAttachments.getAttachments().get(0).getAttachmentID();
                        String ContactContentType = contactsAttachments.getAttachments().get(0).getMimeType();
                        ByteArrayInputStream ContactInput = accountingApi.getAccountAttachmentById(ContactID, ContactAttachementID, ContactContentType);
                        String ContactFileName = "Contact_" + contactsAttachments.getAttachments().get(0).getFileName();
                        String ContactSaveFilePath = this.saveFile(ContactInput, ContactFileName);
                        messages.add("Get Contacts attachment - save it here: " + ContactSaveFilePath);
                    }
                    if ((creditNotes = accountingApi.getCreditNotes(ifModifiedSince, where, order, null)).getCreditNotes().size() > 0 && (creditNotesAttachments = accountingApi.getCreditNoteAttachments(CreditNoteID = creditNotes.getCreditNotes().get(0).getCreditNoteID())).getAttachments().size() > 0) {
                        UUID CreditNoteAttachementID = creditNotesAttachments.getAttachments().get(0).getAttachmentID();
                        String CreditNoteContentType = creditNotesAttachments.getAttachments().get(0).getMimeType();
                        ByteArrayInputStream CreditNoteInput = accountingApi.getAccountAttachmentById(CreditNoteID, CreditNoteAttachementID, CreditNoteContentType);
                        String CreditNoteFileName = "CreditNote_" + creditNotesAttachments.getAttachments().get(0).getFileName();
                        String CreditNoteSaveFilePath = this.saveFile(CreditNoteInput, CreditNoteFileName);
                        messages.add("Get CreditNotes attachment - save it here: " + CreditNoteSaveFilePath);
                    }
                    if ((invoices = accountingApi.getInvoices(ifModifiedSince, where, order, ids, invoiceNumbers, contactIDs, statuses, null, includeArchived, createdByMyApp)).getInvoices().size() > 0 && (invoicesAttachments = accountingApi.getInvoiceAttachments(InvoiceID = invoices.getInvoices().get(0).getInvoiceID())).getAttachments().size() > 0) {
                        UUID InvoiceAttachementID = invoicesAttachments.getAttachments().get(0).getAttachmentID();
                        String InvoiceContentType = invoicesAttachments.getAttachments().get(0).getMimeType();
                        ByteArrayInputStream InvoiceInput = accountingApi.getAccountAttachmentById(InvoiceID, InvoiceAttachementID, InvoiceContentType);
                        String InvoiceFileName = "Invoice_" + invoicesAttachments.getAttachments().get(0).getFileName();
                        String InvoiceSaveFilePath = this.saveFile(InvoiceInput, InvoiceFileName);
                        messages.add("Get Invoices attachment - save it here: " + InvoiceSaveFilePath);
                    }
                    if ((manualJournals = accountingApi.getManualJournals(ifModifiedSince, where, order, null)).getManualJournals().size() > 0 && (manualJournalsAttachments = accountingApi.getManualJournalAttachments(ManualJournalID = manualJournals.getManualJournals().get(0).getManualJournalID())).getAttachments().size() > 0) {
                        UUID ManualJournalAttachementID = manualJournalsAttachments.getAttachments().get(0).getAttachmentID();
                        String ManualJournalContentType = manualJournalsAttachments.getAttachments().get(0).getMimeType();
                        ByteArrayInputStream ManualJournalInput = accountingApi.getAccountAttachmentById(ManualJournalID, ManualJournalAttachementID, ManualJournalContentType);
                        String ManualJournalFileName = "ManualJournal_" + manualJournalsAttachments.getAttachments().get(0).getFileName();
                        String ManualJournalSaveFilePath = this.saveFile(ManualJournalInput, ManualJournalFileName);
                        messages.add("Get ManualJournals attachment - save it here: " + ManualJournalSaveFilePath);
                    }
                    if ((receipts2 = accountingApi.getReceipts(ifModifiedSince, where, order)).getReceipts().size() > 0 && (receiptsAttachments = accountingApi.getReceiptAttachments(ReceiptID = receipts2.getReceipts().get(0).getReceiptID())).getAttachments().size() > 0) {
                        UUID ReceiptAttachementID = receiptsAttachments.getAttachments().get(0).getAttachmentID();
                        String ReceiptContentType = receiptsAttachments.getAttachments().get(0).getMimeType();
                        ByteArrayInputStream ReceiptInput = accountingApi.getAccountAttachmentById(ReceiptID, ReceiptAttachementID, ReceiptContentType);
                        String ReceiptFileName = "Receipt_" + receiptsAttachments.getAttachments().get(0).getFileName();
                        String ReceiptSaveFilePath = this.saveFile(ReceiptInput, ReceiptFileName);
                        messages.add("Get Receipts attachment - save it here: " + ReceiptSaveFilePath);
                    }
                    if ((repeatingInvoices = accountingApi.getRepeatingInvoices(where, order)).getRepeatingInvoices().size() > 0 && (repeatingInvoicesAttachments = accountingApi.getRepeatingInvoiceAttachments(RepeatingInvoiceID = repeatingInvoices.getRepeatingInvoices().get(0).getRepeatingInvoiceID())).getAttachments().size() > 0) {
                        UUID RepeatingInvoiceAttachementID = repeatingInvoicesAttachments.getAttachments().get(0).getAttachmentID();
                        String RepeatingInvoiceContentType = repeatingInvoicesAttachments.getAttachments().get(0).getMimeType();
                        ByteArrayInputStream RepeatingInvoiceInput = accountingApi.getAccountAttachmentById(RepeatingInvoiceID, RepeatingInvoiceAttachementID, RepeatingInvoiceContentType);
                        String RepeatingInvoiceFileName = "RepeatingInvoice_" + repeatingInvoicesAttachments.getAttachments().get(0).getFileName();
                        String RepeatingInvoiceSaveFilePath = this.saveFile(RepeatingInvoiceInput, RepeatingInvoiceFileName);
                        messages.add("Get RepeatingInvoices attachment - save it here: " + RepeatingInvoiceSaveFilePath);
                    }
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            } else if (object.equals("CreateAttachments")) {
                try {
                    RepeatingInvoices myRepeatingInvoices;
                    Receipts myReceipts;
                    ManualJournals myManualJournals;
                    Invoices myInvoices;
                    CreditNotes myCreditNotes;
                    Contacts contactsWhere;
                    BankTransfers myBankTransfer;
                    BankTransactions myBanktransactions;
                    InputStream inputStream = JsonConfig.class.getResourceAsStream("/helo-heros.jpg");
                    byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
                    String newFileName = "sample5.jpg";
                    where = "Status==\"ACTIVE\"";
                    Accounts myAccounts = accountingApi.getAccounts(ifModifiedSince, where, order);
                    if (myAccounts.getAccounts().size() > 0) {
                        accountID = myAccounts.getAccounts().get(0).getAccountID();
                        String accountName = myAccounts.getAccounts().get(0).getName();
                        Attachments createdAttachments = accountingApi.createAccountAttachmentByFileName(accountID, newFileName, bytes);
                        messages.add("Attachment to Name: " + accountName + " Account ID: " + accountID + " attachment - ID: " + createdAttachments.getAttachments().get(0).getAttachmentID());
                    }
                    if ((myBanktransactions = accountingApi.getBankTransactions(ifModifiedSince, where, order, null)).getBankTransactions().size() > 0) {
                        UUID banktransactionID = myBanktransactions.getBankTransactions().get(0).getBankTransactionID();
                        Attachments createdBanktransationAttachments = accountingApi.createBankTransactionAttachmentByFileName(banktransactionID, newFileName, bytes);
                        messages.add("Attachment to BankTransaction ID: " + banktransactionID + " attachment - ID: " + createdBanktransationAttachments.getAttachments().get(0).getAttachmentID());
                    }
                    if ((myBankTransfer = accountingApi.getBankTransfers(ifModifiedSince, where = null, order)).getBankTransfers().size() > 0) {
                        UUID bankTransferID = myBankTransfer.getBankTransfers().get(0).getBankTransferID();
                        Attachments createdBankTransferAttachments = accountingApi.createBankTransferAttachmentByFileName(bankTransferID, newFileName, bytes);
                        messages.add("Attachment to BankTransfer ID: " + bankTransferID + " attachment - ID: " + createdBankTransferAttachments.getAttachments().get(0).getAttachmentID());
                    }
                    if ((contactsWhere = accountingApi.getContacts(ifModifiedSince, where = "ContactStatus==\"ACTIVE\"", order, ids, null, includeArchived)).getContacts().size() > 0) {
                        UUID contactID = contactsWhere.getContacts().get(0).getContactID();
                        Attachments createdContactAttachments = accountingApi.createContactAttachmentByFileName(contactID, newFileName, bytes);
                        messages.add("Attachment to Contact ID: " + contactID + " attachment - ID: " + createdContactAttachments.getAttachments().get(0).getAttachmentID());
                    }
                    if ((myCreditNotes = accountingApi.getCreditNotes(ifModifiedSince, where = "Status==\"ACTIVE\"", order, null)).getCreditNotes().size() > 0) {
                        creditNoteID = myCreditNotes.getCreditNotes().get(0).getCreditNoteID();
                        Attachments createdCreditNoteAttachments = accountingApi.createCreditNoteAttachmentByFileName(creditNoteID, newFileName, bytes);
                        messages.add("Attachment to Credit Notes ID: " + creditNoteID + " attachment - ID: " + createdCreditNoteAttachments.getAttachments().get(0).getAttachmentID());
                    }
                    if ((myInvoices = accountingApi.getInvoices(ifModifiedSince, where, order, ids, invoiceNumbers, contactIDs, statuses, null, includeArchived, createdByMyApp)).getInvoices().size() > 0) {
                        UUID invoiceID = myInvoices.getInvoices().get(0).getInvoiceID();
                        Attachments createdInvoiceAttachments = accountingApi.createInvoiceAttachmentByFileName(invoiceID, newFileName, bytes);
                        messages.add("Attachment to Invoice ID: " + invoiceID + " attachment - ID: " + createdInvoiceAttachments.getAttachments().get(0).getAttachmentID());
                    }
                    if ((myManualJournals = accountingApi.getManualJournals(ifModifiedSince, where, order, null)).getManualJournals().size() > 0) {
                        UUID manualJournalID = myManualJournals.getManualJournals().get(0).getManualJournalID();
                        Attachments createdManualJournalAttachments = accountingApi.createManualJournalAttachmentByFileName(manualJournalID, newFileName, bytes);
                        messages.add("Attachment to Manual Journal ID: " + manualJournalID + " attachment - ID: " + createdManualJournalAttachments.getAttachments().get(0).getAttachmentID());
                    }
                    if ((myReceipts = accountingApi.getReceipts(ifModifiedSince, where, order)).getReceipts().size() > 0) {
                        UUID receiptID = myReceipts.getReceipts().get(0).getReceiptID();
                        Attachments createdReceiptsAttachments = accountingApi.createReceiptAttachmentByFileName(receiptID, newFileName, bytes);
                        messages.add("Attachment to Receipt ID: " + receiptID + " attachment - ID: " + createdReceiptsAttachments.getAttachments().get(0).getAttachmentID());
                    }
                    if ((myRepeatingInvoices = accountingApi.getRepeatingInvoices(where, order)).getRepeatingInvoices().size() > 0) {
                        UUID repeatingInvoiceID = myRepeatingInvoices.getRepeatingInvoices().get(0).getRepeatingInvoiceID();
                        Attachments createdRepeatingInvoiceAttachments = accountingApi.createRepeatingInvoiceAttachmentByFileName(repeatingInvoiceID, newFileName, bytes);
                        messages.add("Attachment to Repeating Invoices ID: " + repeatingInvoiceID + " attachment - ID: " + createdRepeatingInvoiceAttachments.getAttachments().get(0).getAttachmentID());
                    }
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            } else if (object.equals("Assets")) {
                try {
                    Asset asset = new Asset();
                    asset.setAssetName("Computer" + SampleData.loadRandomNum());
                    asset.setAssetNumber("1234" + SampleData.loadRandomNum());
                    Asset newAsset = assetApi.createAsset(asset);
                    messages.add("New Asset created: " + newAsset.getAssetName());
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
                try {
                    String orderBy = null;
                    String sortDirection = null;
                    String filterBy = null;
                    String status = "DRAFT";
                    Assets assets = assetApi.getAssets(status, null, null, orderBy, sortDirection, filterBy);
                    messages.add("Assets Found: " + assets.getItems().get(0).getAssetName());
                }
                catch (Exception e) {
                    System.out.println(e.toString());
                }
                try {
                    List<AssetType> assetTypes = assetApi.getAssetTypes();
                    messages.add("AssetType Found: " + assetTypes.get(0).getAssetTypeName());
                }
                catch (Exception e) {
                    System.out.println(e.toString());
                }
                try {
                    where = "Type==\"FIXED\"";
                    Accounts accountFixedAsset = accountingApi.getAccounts(ifModifiedSince, where, order);
                    UUID fixedAssetAccountId = accountFixedAsset.getAccounts().get(0).getAccountID();
                    where = "Type==\"EXPENSE\"";
                    Accounts accountDepreciationExpense = accountingApi.getAccounts(ifModifiedSince, where, order);
                    UUID depreciationExpenseAccountId = accountDepreciationExpense.getAccounts().get(0).getAccountID();
                    where = "Type==\"DEPRECIATN\"";
                    Accounts accountAccumulatedDepreciation = accountingApi.getAccounts(ifModifiedSince, where, order);
                    UUID accumulatedDepreciationAccountId = accountAccumulatedDepreciation.getAccounts().get(0).getAccountID();
                    AssetType assetType = new AssetType();
                    assetType.setAssetTypeName("Machinery" + SampleData.loadRandomNum());
                    assetType.setFixedAssetAccountId(fixedAssetAccountId);
                    assetType.setDepreciationExpenseAccountId(depreciationExpenseAccountId);
                    assetType.setAccumulatedDepreciationAccountId(accumulatedDepreciationAccountId);
                    float depreciationRate = 0.05f;
                    BookDepreciationSetting bookDepreciationSetting = new BookDepreciationSetting();
                    bookDepreciationSetting.setAveragingMethod(BookDepreciationSetting.AveragingMethodEnum.ACTUALDAYS);
                    bookDepreciationSetting.setDepreciationCalculationMethod(BookDepreciationSetting.DepreciationCalculationMethodEnum.NONE);
                    bookDepreciationSetting.setDepreciationRate(Float.valueOf(depreciationRate));
                    bookDepreciationSetting.setDepreciationMethod(BookDepreciationSetting.DepreciationMethodEnum.DIMINISHINGVALUE100);
                    assetType.setBookDepreciationSetting(bookDepreciationSetting);
                    AssetType newAssetType = assetApi.createAssetType(assetType);
                    messages.add("Asset Type Created: " + newAssetType.getAssetTypeName());
                }
                catch (Exception e) {
                    System.out.println(e.toString());
                }
                try {
                    Setting setting = assetApi.getAssetSettings();
                    messages.add("Asset Setting Start date: " + setting.getAssetStartDate());
                }
                catch (Exception e) {
                    System.out.println(e.toString());
                }
            } else if (object.equals("BankFeedConnections")) {
                FeedConnections fc;
                try {
                    FeedConnection newBank = new FeedConnection();
                    newBank.setAccountName("SDK Bank " + SampleData.loadRandomNum());
                    newBank.setAccountNumber("1234" + SampleData.loadRandomNum());
                    newBank.setAccountType(FeedConnection.AccountTypeEnum.BANK);
                    newBank.setAccountToken("foobar" + SampleData.loadRandomNum());
                    newBank.setCurrency("GBP");
                    FeedConnections feedConnections = new FeedConnections();
                    feedConnections.addItemsItem(newBank);
                    FeedConnections fc1 = bankFeedsApi.createFeedConnections(feedConnections);
                    messages.add("New Bank with status: " + (Object)((Object)fc1.getItems().get(0).getStatus()));
                }
                catch (Exception e) {
                    System.out.println(e.toString());
                }
                try {
                    fc = bankFeedsApi.getFeedConnections(null, null);
                    messages.add("Total Banks found: " + fc.getItems().size());
                }
                catch (Exception e) {
                    System.out.println(e.toString());
                }
                try {
                    fc = bankFeedsApi.getFeedConnections(null, null);
                    String id = fc.getItems().get(0).getId();
                    FeedConnection oneFC = bankFeedsApi.getFeedConnection(id);
                    messages.add("One Bank: " + oneFC.getAccountName());
                }
                catch (Exception e) {
                    System.out.println(e.toString());
                }
                try {
                    fc = bankFeedsApi.getFeedConnections(null, null);
                    FeedConnections allFeedConnections = bankFeedsApi.getFeedConnections(null, null);
                    FeedConnections deleteFeedConnections = new FeedConnections();
                    FeedConnection feedConnectionOne = new FeedConnection();
                    feedConnectionOne.setId(allFeedConnections.getItems().get(fc.getItems().size() - 1).getId());
                    deleteFeedConnections.addItemsItem(feedConnectionOne);
                    FeedConnections deletedFeedConnection = bankFeedsApi.deleteFeedConnections(deleteFeedConnections);
                    messages.add("Deleted Bank status: " + (Object)((Object)deletedFeedConnection.getItems().get(0).getStatus()));
                }
                catch (Exception e) {
                    System.out.println(e.toString());
                }
            } else if (object.equals("BankStatements")) {
                Statements statementErrors;
                TypeReference typeRef;
                Statements rStatements;
                StatementLines arrayStatementLines;
                LocalDate postedDate;
                StatementLine newStatementLine;
                FeedConnections fc;
                EndBalance endBalance;
                StartBalance stBalance;
                LocalDate endDate;
                LocalDate stDate;
                Statement newStatement;
                Statements arrayOfStatements;
                int day = now.get(5);
                int year = now.get(1);
                int lastMonth = now.get(2) - 1;
                int nextMonth = now.get(2) + 1;
                if (lastMonth == -1) {
                    lastMonth = 12;
                    --year;
                }
                if (nextMonth == 13) {
                    nextMonth = 1;
                    ++year;
                }
                if (day > 28) {
                    day = 28;
                }
                try {
                    arrayOfStatements = new Statements();
                    newStatement = new Statement();
                    stDate = LocalDate.of((int)year, (int)nextMonth, (int)day);
                    newStatement.setStartDate(stDate);
                    endDate = LocalDate.of((int)year, (int)lastMonth, (int)day);
                    newStatement.endDate(endDate);
                    stBalance = new StartBalance();
                    stBalance.setAmount("100");
                    stBalance.setCreditDebitIndicator(CreditDebitIndicator.CREDIT);
                    newStatement.setStartBalance(stBalance);
                    endBalance = new EndBalance();
                    endBalance.setAmount("300");
                    endBalance.setCreditDebitIndicator(CreditDebitIndicator.CREDIT);
                    newStatement.endBalance(endBalance);
                    fc = bankFeedsApi.getFeedConnections(null, null);
                    newStatement.setFeedConnectionId(fc.getItems().get(2).getId().toString());
                    newStatementLine = new StatementLine();
                    newStatementLine.setAmount("50");
                    newStatementLine.setChequeNumber("123" + SampleData.loadRandomNum());
                    newStatementLine.setDescription("My new line");
                    newStatementLine.setCreditDebitIndicator(CreditDebitIndicator.CREDIT);
                    newStatementLine.setReference("Foobar" + SampleData.loadRandomNum());
                    newStatementLine.setPayeeName("StarLord" + SampleData.loadRandomNum());
                    newStatementLine.setTransactionId("1234" + SampleData.loadRandomNum());
                    postedDate = LocalDate.of((int)year, (int)lastMonth, (int)day);
                    newStatementLine.setPostedDate(postedDate);
                    arrayStatementLines = new StatementLines();
                    arrayStatementLines.add(newStatementLine);
                    newStatement.setStatementLines(arrayStatementLines);
                    arrayOfStatements.addItemsItem(newStatement);
                    rStatements = bankFeedsApi.createStatements(arrayOfStatements);
                    messages.add("New Bank Statement Status: " + (Object)((Object)rStatements.getItems().get(0).getStatus()));
                }
                catch (Exception e) {
                    typeRef = new TypeReference<Statements>(){};
                    statementErrors = (Statements)apiClientForBankFeeds.getObjectMapper().readValue(e.getMessage(), typeRef);
                    System.out.println(statementErrors.getItems().get(0).getErrors().get(0).getDetail());
                }
                try {
                    arrayOfStatements = new Statements();
                    newStatement = new Statement();
                    stDate = LocalDate.of((int)year, (int)lastMonth, (int)1);
                    newStatement.setStartDate(stDate);
                    endDate = LocalDate.of((int)year, (int)lastMonth, (int)15);
                    newStatement.endDate(endDate);
                    stBalance = new StartBalance();
                    stBalance.setAmount("100");
                    stBalance.setCreditDebitIndicator(CreditDebitIndicator.CREDIT);
                    newStatement.setStartBalance(stBalance);
                    endBalance = new EndBalance();
                    endBalance.setAmount("300");
                    endBalance.setCreditDebitIndicator(CreditDebitIndicator.CREDIT);
                    newStatement.endBalance(endBalance);
                    fc = bankFeedsApi.getFeedConnections(null, null);
                    newStatement.setFeedConnectionId(fc.getItems().get(2).getId().toString());
                    newStatementLine = new StatementLine();
                    newStatementLine.setAmount("50");
                    newStatementLine.setChequeNumber("123" + SampleData.loadRandomNum());
                    newStatementLine.setDescription("My new line");
                    newStatementLine.setCreditDebitIndicator(CreditDebitIndicator.CREDIT);
                    newStatementLine.setReference("Foobar" + SampleData.loadRandomNum());
                    newStatementLine.setPayeeName("StarLord" + SampleData.loadRandomNum());
                    newStatementLine.setTransactionId("1234" + SampleData.loadRandomNum());
                    postedDate = LocalDate.of((int)year, (int)lastMonth, (int)5);
                    newStatementLine.setPostedDate(postedDate);
                    arrayStatementLines = new StatementLines();
                    arrayStatementLines.add(newStatementLine);
                    newStatement.setStatementLines(arrayStatementLines);
                    arrayOfStatements.addItemsItem(newStatement);
                    rStatements = bankFeedsApi.createStatements(arrayOfStatements);
                    String statementId = rStatements.getItems().get(0).getId();
                    Statement oneStatement = bankFeedsApi.getStatement(statementId);
                    messages.add("New Bank Statement Status: " + oneStatement.getStatementLineCount());
                }
                catch (Exception e) {
                    System.out.println(e.toString());
                }
                try {
                    arrayOfStatements = new Statements();
                    newStatement = new Statement();
                    stDate = LocalDate.of((int)year, (int)lastMonth, (int)1);
                    newStatement.setStartDate(stDate);
                    endDate = LocalDate.of((int)year, (int)lastMonth, (int)15);
                    newStatement.endDate(endDate);
                    stBalance = new StartBalance();
                    stBalance.setAmount("100");
                    stBalance.setCreditDebitIndicator(CreditDebitIndicator.CREDIT);
                    newStatement.setStartBalance(stBalance);
                    endBalance = new EndBalance();
                    endBalance.setAmount("300");
                    endBalance.setCreditDebitIndicator(CreditDebitIndicator.CREDIT);
                    newStatement.endBalance(endBalance);
                    fc = bankFeedsApi.getFeedConnections(null, null);
                    newStatement.setFeedConnectionId(fc.getItems().get(2).getId().toString());
                    newStatementLine = new StatementLine();
                    newStatementLine.setAmount("50");
                    newStatementLine.setChequeNumber("123");
                    newStatementLine.setDescription("My new line");
                    newStatementLine.setCreditDebitIndicator(CreditDebitIndicator.CREDIT);
                    newStatementLine.setReference("Foobar");
                    newStatementLine.setPayeeName("StarLord");
                    newStatementLine.setTransactionId("1234");
                    postedDate = LocalDate.of((int)year, (int)lastMonth, (int)5);
                    newStatementLine.setPostedDate(postedDate);
                    arrayStatementLines = new StatementLines();
                    arrayStatementLines.add(newStatementLine);
                    newStatement.setStatementLines(arrayStatementLines);
                    arrayOfStatements.addItemsItem(newStatement);
                    Statements rStatements2 = bankFeedsApi.createStatements(arrayOfStatements);
                    messages.add("New Bank Statement Status: " + (Object)((Object)rStatements2.getItems().get(0).getStatus()));
                    Statements rStatements3 = bankFeedsApi.createStatements(arrayOfStatements);
                    messages.add("New Bank Statement Status: " + (Object)((Object)rStatements3.getItems().get(0).getStatus()));
                }
                catch (Exception e) {
                    typeRef = new TypeReference<Statements>(){};
                    statementErrors = (Statements)apiClientForBankFeeds.getObjectMapper().readValue(e.getMessage(), typeRef);
                    System.out.println(statementErrors.getItems().get(0).getErrors().get(0).getDetail());
                    System.out.println(statementErrors.getItems().get(0).getErrors().get(0).getStatus());
                }
                try {
                    Statements allStatements = bankFeedsApi.getStatements(null, null, null, null, null);
                    messages.add("Statement total: " + allStatements.getItems().size());
                }
                catch (Exception e) {
                    typeRef = new TypeReference<Statements>(){};
                    statementErrors = (Statements)apiClientForBankFeeds.getObjectMapper().readValue(e.getMessage(), typeRef);
                    System.out.println(statementErrors.getItems().get(0).getErrors().get(0).getDetail());
                }
                try {
                    arrayOfStatements = new Statements();
                    newStatement = new Statement();
                    stDate = LocalDate.of((int)year, (int)lastMonth, (int)day);
                    newStatement.setStartDate(stDate);
                    endDate = LocalDate.of((int)year, (int)lastMonth, (int)day);
                    newStatement.endDate(endDate);
                    stBalance = new StartBalance();
                    stBalance.setAmount("100");
                    stBalance.setCreditDebitIndicator(CreditDebitIndicator.CREDIT);
                    newStatement.setStartBalance(stBalance);
                    endBalance = new EndBalance();
                    endBalance.setAmount("150");
                    endBalance.setCreditDebitIndicator(CreditDebitIndicator.CREDIT);
                    newStatement.endBalance(endBalance);
                    fc = bankFeedsApi.getFeedConnections(null, null);
                    if (fc.getItems().size() > 2) {
                        newStatement.setFeedConnectionId(fc.getItems().get(0).getId().toString());
                        newStatementLine = new StatementLine();
                        newStatementLine.setAmount("50");
                        newStatementLine.setChequeNumber("123" + SampleData.loadRandomNum());
                        newStatementLine.setDescription("My new line");
                        newStatementLine.setCreditDebitIndicator(CreditDebitIndicator.CREDIT);
                        newStatementLine.setReference("Foobar" + SampleData.loadRandomNum());
                        newStatementLine.setPayeeName("StarLord" + SampleData.loadRandomNum());
                        newStatementLine.setTransactionId("1234" + SampleData.loadRandomNum());
                        postedDate = LocalDate.of((int)year, (int)lastMonth, (int)day);
                        newStatementLine.setPostedDate(postedDate);
                        arrayStatementLines = new StatementLines();
                        arrayStatementLines.add(newStatementLine);
                        newStatement.setStatementLines(arrayStatementLines);
                        arrayOfStatements.addItemsItem(newStatement);
                        Statement newStatement2 = new Statement();
                        LocalDate stDate2 = LocalDate.of((int)year, (int)lastMonth, (int)day);
                        newStatement2.setStartDate(stDate2);
                        LocalDate endDate2 = LocalDate.of((int)year, (int)lastMonth, (int)day);
                        newStatement2.endDate(endDate2);
                        StartBalance stBalance2 = new StartBalance();
                        stBalance2.setAmount("100");
                        stBalance2.setCreditDebitIndicator(CreditDebitIndicator.CREDIT);
                        newStatement2.setStartBalance(stBalance2);
                        EndBalance endBalance2 = new EndBalance();
                        endBalance2.setAmount("150");
                        endBalance2.setCreditDebitIndicator(CreditDebitIndicator.CREDIT);
                        newStatement2.endBalance(endBalance2);
                        newStatement2.setFeedConnectionId(fc.getItems().get(1).getId().toString());
                        StatementLine newStatementLine2 = new StatementLine();
                        newStatementLine2.setAmount("50");
                        newStatementLine2.setChequeNumber("123" + SampleData.loadRandomNum());
                        newStatementLine2.setDescription("My new line");
                        newStatementLine2.setCreditDebitIndicator(CreditDebitIndicator.CREDIT);
                        newStatementLine2.setReference("Foobar" + SampleData.loadRandomNum());
                        newStatementLine2.setPayeeName("StarLord" + SampleData.loadRandomNum());
                        newStatementLine2.setTransactionId("1234" + SampleData.loadRandomNum());
                        LocalDate postedDate2 = LocalDate.of((int)year, (int)lastMonth, (int)day);
                        newStatementLine2.setPostedDate(postedDate2);
                        StatementLines arrayStatementLines2 = new StatementLines();
                        arrayStatementLines2.add(newStatementLine2);
                        newStatement2.setStatementLines(arrayStatementLines2);
                        arrayOfStatements.addItemsItem(newStatement2);
                        Statements rStatements2 = bankFeedsApi.createStatements(arrayOfStatements);
                        messages.add("Statement Status: " + (Object)((Object)rStatements2.getItems().get(0).getStatus()));
                        break block217;
                    }
                    messages.add("Need at least 2 feed connections to perform this test");
                }
                catch (XeroApiException e) {
                    try {
                        typeRef = new TypeReference<Error>(){};
                        Error error = (Error)apiClientForBankFeeds.getObjectMapper().readValue(e.getMessage(), typeRef);
                        messages.add(error.getDetail());
                    }
                    catch (IOException ioe) {
                        System.out.println("IO:" + ioe.toString());
                    }
                }
                catch (Exception e) {
                    messages.add("Generic Exception " + e.toString());
                }
            } else if (object.equals("BankTransactions")) {
                try {
                    where = "Status==\"ACTIVE\"&&Type==\"BANK\"";
                    Accounts accountsWhere = accountingApi.getAccounts(ifModifiedSince, where, order);
                    Account bankAcct = new Account();
                    bankAcct.setCode(accountsWhere.getAccounts().get(0).getCode());
                    where = null;
                    Contacts contacts3 = accountingApi.getContacts(ifModifiedSince, where, order, ids, null, includeArchived);
                    Contact useContact3 = new Contact();
                    useContact3.setContactID(contacts3.getContacts().get(0).getContactID());
                    if (accountsWhere.getAccounts().size() > 0) {
                        ArrayList<LineItem> lineItems = new ArrayList<LineItem>();
                        li = new LineItem();
                        li.setAccountCode("400");
                        li.setDescription("Foobar");
                        li.setQuantity(Float.valueOf(1.0f));
                        li.setUnitAmount(Float.valueOf(20.0f));
                        lineItems.add(li);
                        BankTransaction bt2 = new BankTransaction();
                        bt2.setBankAccount(bankAcct);
                        bt2.setContact(useContact3);
                        bt2.setLineitems(lineItems);
                        bt2.setType(BankTransaction.TypeEnum.SPEND);
                        BankTransactions bts2 = new BankTransactions();
                        bts2.addBankTransactionsItem(bt2);
                        BankTransactions newBankTransaction2 = accountingApi.createBankTransaction(bts2, summarizeErrors);
                        messages.add("Create new BankTransaction : amount:" + newBankTransaction2.getBankTransactions().get(0).getTotal());
                        BankTransactions bankTransactions = accountingApi.getBankTransactions(ifModifiedSince, where, order, null);
                        messages.add("Get a all Bank Transactions - total : " + bankTransactions.getBankTransactions().size());
                        BankTransactions oneBankTransaction = accountingApi.getBankTransaction(bankTransactions.getBankTransactions().get(0).getBankTransactionID());
                        messages.add("Get a one Bank Transaction : amount:" + oneBankTransaction.getBankTransactions().get(0).getTotal());
                        newBankTransaction2.getBankTransactions().get(0).setSubTotal(null);
                        newBankTransaction2.getBankTransactions().get(0).setTotal(null);
                        newBankTransaction2.getBankTransactions().get(0).setReference("You just updated");
                        BankTransactions updateBankTransaction = accountingApi.updateBankTransaction(newBankTransaction2.getBankTransactions().get(0).getBankTransactionID(), newBankTransaction2);
                        messages.add("Update new BankTransaction : reference:" + updateBankTransaction.getBankTransactions().get(0).getReference());
                        newBankTransaction2.getBankTransactions().get(0).setStatus(BankTransaction.StatusEnum.DELETED);
                        BankTransactions deletedBankTransaction = accountingApi.updateBankTransaction(newBankTransaction2.getBankTransactions().get(0).getBankTransactionID(), newBankTransaction2);
                        messages.add("Deleted new Bank Transaction : Status:" + (Object)((Object)deletedBankTransaction.getBankTransactions().get(0).getStatus()));
                        HistoryRecords hr = accountingApi.getBankTransactionsHistory(oneBankTransaction.getBankTransactions().get(0).getBankTransactionID());
                        messages.add("Get a one Bank Transaction History Record - details :" + hr.getHistoryRecords().get(0).getDetails());
                    }
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            } else if (object.equals("BankTransfers")) {
                try {
                    where = "Status==\"ACTIVE\"&&Type==\"BANK\"";
                    Accounts accountsWhere = accountingApi.getAccounts(ifModifiedSince, where, order);
                    where = null;
                    if (accountsWhere.getAccounts().size() > 1) {
                        BankTransfer bankTransfer = new BankTransfer();
                        bankTransfer.setFromBankAccount(accountsWhere.getAccounts().get(1));
                        bankTransfer.setToBankAccount(accountsWhere.getAccounts().get(0));
                        bankTransfer.setAmount("50.00");
                        BankTransfers newBTs = new BankTransfers();
                        newBTs.addBankTransfersItem(bankTransfer);
                        BankTransfers newBankTranfer = accountingApi.createBankTransfer(newBTs);
                        messages.add("Get a one Bank Transfer - amount : " + newBankTranfer.getBankTransfers().get(0).getAmount());
                        BankTransfers bankTranfers = accountingApi.getBankTransfers(ifModifiedSince, where, order);
                        messages.add("Get a all Bank Transfers - total : " + bankTranfers.getBankTransfers().size());
                        UUID bankTransferId = bankTranfers.getBankTransfers().get(0).getBankTransferID();
                        BankTransfers oneBankTranfer = accountingApi.getBankTransfer(bankTransferId);
                        messages.add("Get a one Bank Transfer - amount : " + oneBankTranfer.getBankTransfers().get(0).getAmount());
                        HistoryRecords hr = accountingApi.getBankTransferHistory(bankTransferId);
                        messages.add("Get a one Bank Transfer History Record - details :" + hr.getHistoryRecords().get(0).getDetails());
                    }
                }
                catch (Exception e) {
                    System.out.println(e.toString());
                }
            } else if (object.equals("BatchPayments")) {
                try {
                    where = "Status==\"AUTHORISED\"&&Type==\"ACCREC\"";
                    Invoices allInvoices2 = accountingApi.getInvoices(ifModifiedSince, where, order, ids, invoiceNumbers, contactIDs, statuses, null, includeArchived, createdByMyApp);
                    Invoice inv2 = new Invoice();
                    inv2.setInvoiceID(allInvoices2.getInvoices().get(0).getInvoiceID());
                    Invoice inv22 = new Invoice();
                    inv22.setInvoiceID(allInvoices2.getInvoices().get(1).getInvoiceID());
                    Invoice inv3 = new Invoice();
                    inv3.setInvoiceID(allInvoices2.getInvoices().get(3).getInvoiceID());
                    where = null;
                    where = "EnablePaymentsToAccount==true";
                    Accounts accountsWhere = accountingApi.getAccounts(ifModifiedSince, where, order);
                    Account paymentAccount = new Account();
                    paymentAccount.setAccountID(accountsWhere.getAccounts().get(0).getAccountID());
                    where = null;
                    BatchPayments createBatchPayments = new BatchPayments();
                    BatchPayment createBatchPayment = new BatchPayment();
                    createBatchPayment.setAccount(paymentAccount);
                    createBatchPayment.setAmount(Float.valueOf(3.0f));
                    LocalDate currDate3 = LocalDate.now();
                    createBatchPayment.setDate(currDate3);
                    createBatchPayment.setReference("Foobar" + SampleData.loadRandomNum());
                    Payment payment01 = new Payment();
                    payment01.setAccount(paymentAccount);
                    payment01.setInvoice(inv2);
                    payment01.setAmount(Float.valueOf(1.0f));
                    payment01.setDate(currDate3);
                    Payment payment02 = new Payment();
                    payment02.setAccount(paymentAccount);
                    payment02.setInvoice(inv22);
                    payment02.setAmount(Float.valueOf(1.0f));
                    payment02.setDate(currDate3);
                    Payment payment03 = new Payment();
                    payment03.setAccount(paymentAccount);
                    payment03.setInvoice(inv3);
                    payment03.setAmount(Float.valueOf(1.0f));
                    payment03.setDate(currDate3);
                    createBatchPayment.addPaymentsItem(payment01);
                    createBatchPayment.addPaymentsItem(payment02);
                    createBatchPayment.addPaymentsItem(payment03);
                    createBatchPayments.addBatchPaymentsItem(createBatchPayment);
                    BatchPayments newBatchPayments = accountingApi.createBatchPayment(createBatchPayments);
                    messages.add("Create BatchPayments - ID : " + newBatchPayments.getBatchPayments().get(0).getTotalAmount());
                    BatchPayments allBatchPayments = accountingApi.getBatchPayments(ifModifiedSince, where, order);
                    messages.add("Get BatchPayments - Total : " + allBatchPayments.getBatchPayments().size());
                }
                catch (XeroApiException e) {
                    System.out.println(e.getResponseCode());
                    System.out.println(e.getMessage());
                }
            } else if (object.equals("BrandingThemes")) {
                try {
                    BrandingThemes bt3 = accountingApi.getBrandingThemes();
                    messages.add("Get a All Branding Themes - total : " + bt3.getBrandingThemes().size());
                    UUID btID = bt3.getBrandingThemes().get(0).getBrandingThemeID();
                    BrandingThemes oneBt = accountingApi.getBrandingTheme(btID);
                    messages.add("Get a one Branding Themes - name : " + oneBt.getBrandingThemes().get(0).getName());
                    PaymentServices paymentServices = accountingApi.getPaymentServices();
                    UUID paymentServiceID = paymentServices.getPaymentServices().get(0).getPaymentServiceID();
                    PaymentService btPaymentService = new PaymentService();
                    btPaymentService.setPaymentServiceID(paymentServiceID);
                    PaymentServices createdPaymentService = accountingApi.createBrandingThemePaymentServices(btID, btPaymentService);
                    messages.add("Created payment services for Branding Themes - name : " + createdPaymentService.getPaymentServices().get(0).getPaymentServiceName());
                    PaymentServices paymentServicesForBrandingTheme = accountingApi.getBrandingThemePaymentServices(btID);
                    messages.add("Get payment services for Branding Themes - name : " + paymentServicesForBrandingTheme.getPaymentServices().get(0).getPaymentServiceName());
                }
                catch (XeroApiException e) {
                    System.out.println(e.getResponseCode());
                    System.out.println(e.getMessage());
                }
            } else if (object.equals("Contacts")) {
                try {
                    Contact contact = new Contact();
                    contact.setName("Foo" + SampleData.loadRandomNum());
                    contact.setEmailAddress("sid" + SampleData.loadRandomNum() + "@blah.com");
                    ArrayList<Phone> phones = new ArrayList<Phone>();
                    Phone phone = new Phone();
                    phone.setPhoneType(Phone.PhoneTypeEnum.MOBILE);
                    phone.setPhoneNumber("555-1212");
                    phone.setPhoneAreaCode("415");
                    phones.add(phone);
                    contact.setPhones(phones);
                    Contacts newContact = accountingApi.createContact(contact);
                    messages.add("Create new Contact - Name : " + newContact.getContacts().get(0).getName());
                    newContact.getContacts().get(0).setName("Bar" + SampleData.loadRandomNum());
                    UUID contactID = newContact.getContacts().get(0).getContactID();
                    Contacts updatedContact = accountingApi.updateContact(contactID, newContact);
                    messages.add("Update new Contact - Name : " + updatedContact.getContacts().get(0).getName());
                    Contacts contacts4 = accountingApi.getContacts(ifModifiedSince, where, order, ids, null, includeArchived);
                    messages.add("Get a All Contacts - Total : " + contacts4.getContacts().size());
                    UUID oneContactID = contacts4.getContacts().get(0).getContactID();
                    Contacts oneContact = accountingApi.getContact(oneContactID);
                    messages.add("Get a One Contact - Name : " + oneContact.getContacts().get(0).getName());
                    where = "Name==\"sidney\"";
                    Contacts cisContact = accountingApi.getContacts(ifModifiedSince, where, order, ids, null, includeArchived);
                    if (cisContact.getContacts().size() > 0) {
                        CISSettings cisSettings = accountingApi.getContactCISSettings(cisContact.getContacts().get(0).getContactID());
                        messages.add("Get a Contact cisSettings - Enabled? : " + cisSettings.getCiSSettings().get(0).getCiSEnabled());
                    }
                    where = null;
                    where = "ContactStatus==\"ACTIVE\"";
                    Contacts contactsWhere = accountingApi.getContacts(ifModifiedSince, where, order, ids, null, includeArchived);
                    messages.add("Get a all ACTIVE Contacts - Total : " + contactsWhere.getContacts().size());
                    where = null;
                    HistoryRecords contactHistory = accountingApi.getContactHistory(contactID);
                    messages.add("Contact History - count : " + contactHistory.getHistoryRecords().size());
                    HistoryRecords newHistoryRecords = new HistoryRecords();
                    HistoryRecord newHistoryRecord = new HistoryRecord();
                    newHistoryRecord.setDetails("Hello World");
                    newHistoryRecords.addHistoryRecordsItem(newHistoryRecord);
                    HistoryRecords newInvoiceHistory = accountingApi.createContactHistory(contactID, newHistoryRecords);
                    messages.add("Contact History - note added to  : " + newInvoiceHistory.getHistoryRecords().get(0).getDetails());
                }
                catch (XeroApiException e) {
                    System.out.println(e.getResponseCode());
                    System.out.println(e.getMessage());
                }
            } else if (object.equals("ContactGroups")) {
                try {
                    ContactGroups newCGs = new ContactGroups();
                    ContactGroup cg = new ContactGroup();
                    cg.setName("NewGroup" + SampleData.loadRandomNum());
                    newCGs.addContactGroupsItem(cg);
                    ContactGroups newContactGroup = accountingApi.createContactGroup(newCGs);
                    messages.add("Create a ContactGroup - Name : " + newContactGroup.getContactGroups().get(0).getName());
                    newCGs.getContactGroups().get(0).setName("Old Group" + SampleData.loadRandomNum());
                    UUID newContactGroupID = newContactGroup.getContactGroups().get(0).getContactGroupID();
                    ContactGroups updateContactGroup = accountingApi.updateContactGroup(newContactGroupID, newCGs);
                    messages.add("Update a ContactGroup - Name : " + updateContactGroup.getContactGroups().get(0).getName());
                    ContactGroups contactGroups = accountingApi.getContactGroups(where, order);
                    messages.add("Get all ContactGroups - Total : " + contactGroups.getContactGroups().size());
                    UUID contactGroupId = contactGroups.getContactGroups().get(0).getContactGroupID();
                    ContactGroups oneCg = accountingApi.getContactGroup(contactGroupId);
                    messages.add("Get one ContactGroups - Name : " + oneCg.getContactGroups().get(0).getName());
                    newCGs.getContactGroups().get(0).setStatus(ContactGroup.StatusEnum.DELETED);
                    UUID contactGroupID = newContactGroup.getContactGroups().get(0).getContactGroupID();
                    ContactGroups deletedContactGroup = accountingApi.updateContactGroup(contactGroupID, contactGroups);
                    messages.add("Delete a ContactGroup - Name : " + deletedContactGroup.getContactGroups().get(0).getName());
                }
                catch (XeroApiException e) {
                    System.out.println(e.getResponseCode());
                    System.out.println(e.getMessage());
                }
            } else if (object.equals("ContactGroupContacts")) {
                try {
                    ContactGroups newCGs = new ContactGroups();
                    ContactGroup cg = new ContactGroup();
                    cg.setName("NewGroup" + SampleData.loadRandomNum());
                    newCGs.addContactGroupsItem(cg);
                    ContactGroups newContactGroup = accountingApi.createContactGroup(newCGs);
                    Contacts allContacts = accountingApi.getContacts(ifModifiedSince, where, order, ids, null, includeArchived);
                    Contacts contactList = new Contacts();
                    contactList.addContactsItem(allContacts.getContacts().get(0));
                    contactList.addContactsItem(allContacts.getContacts().get(1));
                    UUID contactGroupID = newContactGroup.getContactGroups().get(0).getContactGroupID();
                    Contacts addContacts = accountingApi.createContactGroupContacts(contactGroupID, contactList);
                    messages.add("Add 2 Contacts to Contact Group - Total : " + addContacts.getContacts().size());
                    Response204 deleteContacts = accountingApi.deleteContactGroupContacts(newContactGroup.getContactGroups().get(0).getContactGroupID());
                    messages.add("Delete All Contacts  to Contact Group - Status? : " + deleteContacts.getStatus());
                    ContactGroups oneCg = accountingApi.getContactGroup(newContactGroup.getContactGroups().get(0).getContactGroupID());
                    messages.add("Get ContactGroups - Total Contacts : " + oneCg.getContactGroups().get(0).getContacts().size());
                    Contacts contactList2 = new Contacts();
                    contactList2.addContactsItem(allContacts.getContacts().get(3));
                    contactList2.addContactsItem(allContacts.getContacts().get(4));
                    UUID newContactGroupID = newContactGroup.getContactGroups().get(0).getContactGroupID();
                    Contacts addContacts2 = accountingApi.createContactGroupContacts(newContactGroupID, contactList2);
                    messages.add("Add 2 Contacts to Contact Group - Total : " + addContacts2.getContacts().size());
                    Response204 deleteContacts2 = accountingApi.deleteContactGroupContact(newContactGroup.getContactGroups().get(0).getContactGroupID(), allContacts.getContacts().get(3).getContactID());
                    messages.add("Delete 1 contact from Contact Group - Status? : " + deleteContacts2.getStatus());
                    ContactGroups oneCg2 = accountingApi.getContactGroup(newContactGroup.getContactGroups().get(0).getContactGroupID());
                    messages.add("Get ContactGroups - Total Contacts : " + oneCg2.getContactGroups().get(0).getContacts().size());
                }
                catch (XeroApiException e) {
                    System.out.println(e.getMessage());
                }
            } else if (object.equals("CreditNotesPDF")) {
                CreditNotes creditNotes = accountingApi.getCreditNotes(ifModifiedSince, where, order, null);
                UUID creditNoteId = creditNotes.getCreditNotes().get(0).getCreditNoteID();
                ByteArrayInputStream CreditNoteInput = accountingApi.getCreditNoteAsPdf(creditNoteId, "application/pdf");
                String CreditNoteFileName = "CreditNoteAsPDF.pdf";
                String CreditNoteSaveFilePath = this.saveFile(CreditNoteInput, CreditNoteFileName);
                messages.add("Get CreditNote attachment - save it here: " + CreditNoteSaveFilePath);
            } else if (object.equals("CreditNotes")) {
                try {
                    Contacts contacts5 = accountingApi.getContacts(ifModifiedSince, where, order, ids, null, includeArchived);
                    ArrayList<LineItem> lineItems = new ArrayList<LineItem>();
                    LineItem li2 = new LineItem();
                    li2.setAccountCode("400");
                    li2.setDescription("Foobar");
                    li2.setQuantity(Float.valueOf(2.0f));
                    li2.setUnitAmount(Float.valueOf(20.0f));
                    lineItems.add(li2);
                    CreditNotes newCNs = new CreditNotes();
                    CreditNote cn = new CreditNote();
                    cn.setContact(contacts5.getContacts().get(0));
                    cn.setLineItems(lineItems);
                    cn.setType(CreditNote.TypeEnum.ACCPAYCREDIT);
                    newCNs.addCreditNotesItem(cn);
                    CreditNotes newCreditNote = accountingApi.createCreditNote(summarizeErrors, newCNs);
                    messages.add("Create a CreditNote - Amount : " + newCreditNote.getCreditNotes().get(0).getTotal());
                    UUID newCreditNoteId = newCreditNote.getCreditNotes().get(0).getCreditNoteID();
                    CreditNotes creditNotes = accountingApi.getCreditNotes(ifModifiedSince, where, order, null);
                    messages.add("Get all CreditNotes - Total : " + creditNotes.getCreditNotes().size());
                    creditNoteID = creditNotes.getCreditNotes().get(0).getCreditNoteID();
                    CreditNotes oneCreditNote = accountingApi.getCreditNote(creditNoteID);
                    messages.add("Get a CreditNote - Amount : " + oneCreditNote.getCreditNotes().get(0).getTotal());
                    newCNs.getCreditNotes().get(0).setStatus(CreditNote.StatusEnum.AUTHORISED);
                    CreditNotes updatedCreditNote = accountingApi.updateCreditNote(newCreditNoteId, newCNs);
                    messages.add("Update a CreditNote - Ref : " + updatedCreditNote.getCreditNotes().get(0).getReference());
                    Allocations allocations2 = new Allocations();
                    Allocation allocation2 = new Allocation();
                    where = "Status==\"AUTHORISED\"&&Type==\"ACCPAY\"";
                    Invoices allInvoices3 = accountingApi.getInvoices(ifModifiedSince, where, order, ids, invoiceNumbers, contactIDs, statuses, null, includeArchived, createdByMyApp);
                    Invoice inv3 = new Invoice();
                    inv3.setInvoiceID(allInvoices3.getInvoices().get(0).getInvoiceID());
                    allocation2.setInvoice(inv3);
                    allocation2.setAmount(Float.valueOf(1.0f));
                    LocalDate currDate4 = LocalDate.now();
                    allocation2.setDate(currDate4);
                    allocations2.addAllocationsItem(allocation2);
                    where = null;
                    Allocations allocatedCreditNote = accountingApi.createCreditNoteAllocation(newCreditNoteId, allocations2);
                    messages.add("Update CreditNote Allocation - Amount : " + allocatedCreditNote.getAllocations().get(0).getAmount());
                    HistoryRecords history2 = accountingApi.getCreditNoteHistory(creditNoteID);
                    messages.add("History - count : " + history2.getHistoryRecords().size());
                    HistoryRecords newHistoryRecords = new HistoryRecords();
                    HistoryRecord newHistoryRecord = new HistoryRecord();
                    newHistoryRecord.setDetails("Hello World");
                    newHistoryRecords.addHistoryRecordsItem(newHistoryRecord);
                    HistoryRecords newHistory = accountingApi.createCreditNoteHistory(creditNoteID, newHistoryRecords);
                    messages.add("History - note added to  : " + newHistory.getHistoryRecords().get(0).getDetails());
                }
                catch (XeroApiException e) {
                    System.out.println(e.getMessage());
                }
            } else if (object.equals("Currencies")) {
                try {
                    Currencies currencies = accountingApi.getCurrencies(where, order);
                    messages.add("Get all Currencies - Total : " + currencies.getCurrencies().size());
                }
                catch (XeroApiException e) {
                    System.out.println(e.getMessage());
                }
            } else if (object.equals("Employees")) {
                try {
                    Employee employee = new Employee();
                    employee.setFirstName("Sam");
                    employee.setLastName("Jackson" + SampleData.loadRandomNum());
                    ExternalLink extLink = new ExternalLink();
                    extLink.setUrl("http://twitter.com/#!/search/Homer+Simpson");
                    employee.setExternalLink(extLink);
                    Employees emps = new Employees();
                    emps.addEmployeesItem(employee);
                    Employees newEmployee = accountingApi.createEmployee(emps);
                    messages.add("Create an Employee - Last Name : " + newEmployee.getEmployees().get(0).getLastName());
                    newEmployee.getEmployees().get(0).setLastName("Anderson" + SampleData.loadRandomNum());
                    Employees updateEmployee = accountingApi.updateEmployee(newEmployee.getEmployees().get(0).getEmployeeID(), newEmployee);
                    messages.add("Update an Employee - Last Name : " + updateEmployee.getEmployees().get(0).getLastName());
                    Employees employees = accountingApi.getEmployees(ifModifiedSince, where, order);
                    messages.add("Get all Employees - Total : " + employees.getEmployees().size());
                    Employees oneEmployee = accountingApi.getEmployee(employees.getEmployees().get(0).getEmployeeID());
                    messages.add("Get one Employees - Name : " + oneEmployee.getEmployees().get(0).getFirstName());
                }
                catch (XeroApiException e) {
                    System.out.println(e.getMessage());
                }
            } else if (object.equals("ExpenseClaims")) {
                where = "IsSubscriber==true";
                Users users = accountingApi.getUsers(ifModifiedSince, where, order);
                where = null;
                where = "ShowInExpenseClaims==true&&Status==\"ACTIVE\"";
                Accounts accounts = accountingApi.getAccounts(ifModifiedSince, where, order);
                where = null;
                if (users.getUsers().size() > 0) {
                    User user = new User();
                    user.setUserID(users.getUsers().get(0).getUserID());
                    Contacts contacts6 = accountingApi.getContacts(ifModifiedSince, where, order, ids, null, includeArchived);
                    useContact2 = new Contact();
                    useContact2.setContactID(contacts6.getContacts().get(0).getContactID());
                    receipts = new Receipts();
                    Receipt receipt = new Receipt();
                    LineItem li3 = new LineItem();
                    li3.setAccountCode(accounts.getAccounts().get(0).getCode());
                    li3.setDescription("Foobar");
                    li3.setQuantity(Float.valueOf(2.0f));
                    li3.setUnitAmount(Float.valueOf(20.0f));
                    li3.setLineAmount(Float.valueOf(40.0f));
                    li3.setTaxType(TaxType.NONE);
                    receipt.addLineitemsItem(li3);
                    receipt.setUser(user);
                    receipt.lineAmountTypes(LineAmountTypes.NOTAX);
                    receipt.contact(useContact2);
                    receipt.setStatus(Receipt.StatusEnum.DRAFT);
                    receipts.addReceiptsItem(receipt);
                    newReceipts = accountingApi.createReceipt(receipts);
                    ExpenseClaims createExpenseClaims = new ExpenseClaims();
                    ExpenseClaim expenseClaim = new ExpenseClaim();
                    expenseClaim.setUser(user);
                    Receipts myReceipts = new Receipts();
                    Receipt myReceipt = new Receipt();
                    myReceipt.setReceiptID(newReceipts.getReceipts().get(0).getReceiptID());
                    myReceipts.addReceiptsItem(myReceipt);
                    expenseClaim.setReceipts(myReceipts.getReceipts());
                    expenseClaim.setStatus(ExpenseClaim.StatusEnum.SUBMITTED);
                    createExpenseClaims.addExpenseClaimsItem(expenseClaim);
                    ExpenseClaims newExpenseClaims = accountingApi.createExpenseClaim(createExpenseClaims, summarizeErrors);
                    messages.add("Create new Expense Claim - Status : " + (Object)((Object)newExpenseClaims.getExpenseClaims().get(0).getStatus()));
                    createExpenseClaims.getExpenseClaims().get(0).setStatus(ExpenseClaim.StatusEnum.AUTHORISED);
                    UUID expenseClaimID = newExpenseClaims.getExpenseClaims().get(0).getExpenseClaimID();
                    ExpenseClaims updateExpenseClaims = accountingApi.updateExpenseClaim(expenseClaimID, createExpenseClaims);
                    messages.add("Update new Expense Claim - Status : " + (Object)((Object)updateExpenseClaims.getExpenseClaims().get(0).getStatus()));
                    ExpenseClaims expenseClaims = accountingApi.getExpenseClaims(ifModifiedSince, where, order);
                    messages.add("Get all Expense Claim - Total : " + expenseClaims.getExpenseClaims().size());
                    ExpenseClaims oneExpenseClaim = accountingApi.getExpenseClaim(expenseClaims.getExpenseClaims().get(0).getExpenseClaimID());
                    messages.add("Get one Expense Claim - Total : " + (Object)((Object)oneExpenseClaim.getExpenseClaims().get(0).getStatus()));
                    createExpenseClaims.getExpenseClaims().get(0).setStatus(ExpenseClaim.StatusEnum.VOIDED);
                    ExpenseClaims voidExpenseClaims = accountingApi.updateExpenseClaim(expenseClaimID, createExpenseClaims);
                    messages.add("Void new Expense Claim - Status : " + (Object)((Object)voidExpenseClaims.getExpenseClaims().get(0).getStatus()));
                    history = accountingApi.getExpenseClaimHistory(expenseClaimID);
                    messages.add("History - count : " + history.getHistoryRecords().size());
                } else {
                    System.out.println("No User Found");
                }
            } else if (object.equals("Invoices")) {
                Invoices myInvoicesForPDF = accountingApi.getInvoices(ifModifiedSince, where, order, ids, invoiceNumbers, contactIDs, statuses, null, includeArchived, createdByMyApp);
                UUID invoiceIDForPDF = myInvoicesForPDF.getInvoices().get(0).getInvoiceID();
                ByteArrayInputStream InvoiceNoteInput = accountingApi.getInvoiceAsPdf(invoiceIDForPDF, "application/pdf");
                String InvoiceFileName = "InvoiceAsPDF.pdf";
                String InvoiceSaveFilePath = this.saveFile(InvoiceNoteInput, InvoiceFileName);
                messages.add("Get Invoice attachment - save it here: " + InvoiceSaveFilePath);
                where = "Type==\"REVENUE\"";
                Accounts accounts = accountingApi.getAccounts(ifModifiedSince, where, order);
                String accountCodeForInvoice = accounts.getAccounts().get(0).getCode();
                where = null;
                Contacts contacts7 = accountingApi.getContacts(ifModifiedSince, where, order, ids, null, includeArchived);
                UUID contactIDForInvoice = contacts7.getContacts().get(0).getContactID();
                Contact useContact4 = new Contact();
                useContact4.setContactID(contactIDForInvoice);
                Invoices newInvoices = new Invoices();
                Invoice myInvoice = new Invoice();
                LineItem li4 = new LineItem();
                li4.setAccountCode(accountCodeForInvoice);
                li4.setDescription("Acme Tires");
                li4.setQuantity(Float.valueOf(2.0f));
                li4.setUnitAmount(Float.valueOf(20.0f));
                li4.setLineAmount(Float.valueOf(40.0f));
                li4.setTaxType(TaxType.NONE);
                myInvoice.addLineItemsItem(li4);
                myInvoice.setContact(useContact4);
                LocalDate dueDate = LocalDate.of((int)2018, (Month)Month.DECEMBER, (int)10);
                myInvoice.setDueDate(dueDate);
                LocalDate todayDate = LocalDate.now();
                myInvoice.setDate(todayDate);
                myInvoice.setType(Invoice.TypeEnum.ACCREC);
                myInvoice.setReference("One Fish, Two Fish");
                myInvoice.setStatus(Invoice.StatusEnum.AUTHORISED);
                newInvoices.addInvoicesItem(myInvoice);
                Invoices newInvoice = accountingApi.createInvoice(newInvoices, summarizeErrors);
                messages.add("Create invoice - Reference : " + newInvoice.getInvoices().get(0).getReference());
                UUID newInvoiceID = newInvoice.getInvoices().get(0).getInvoiceID();
                Invoices updateInvoices = new Invoices();
                Invoice updateInvoice = new Invoice();
                updateInvoice.setInvoiceID(newInvoiceID);
                updateInvoice.setReference("Red Fish, Blue Fish");
                updateInvoices.addInvoicesItem(updateInvoice);
                Invoices updatedInvoice = accountingApi.updateInvoice(newInvoiceID, updateInvoices);
                messages.add("Update invoice - Reference : " + updatedInvoice.getInvoices().get(0).getReference());
                Invoices invoices = accountingApi.getInvoices(ifModifiedSince, where, order, ids, invoiceNumbers, contactIDs, statuses, null, includeArchived, createdByMyApp);
                messages.add("Get all invoices - Total : " + invoices.getInvoices().size());
                OffsetDateTime invModified = OffsetDateTime.of((LocalDateTime)LocalDateTime.of((int)2018, (int)12, (int)6, (int)15, (int)0), (ZoneOffset)ZoneOffset.UTC);
                System.out.println(invModified.toString());
                Invoices invoicesSince = accountingApi.getInvoices(invModified, where, order, ids, invoiceNumbers, contactIDs, statuses, null, includeArchived, createdByMyApp);
                messages.add("Get all invoices - Since Modfied Date - Total : " + invoicesSince.getInvoices().size());
                Invoices oneInvoice = accountingApi.getInvoice(invoices.getInvoices().get(0).getInvoiceID());
                messages.add("Get one invoice - total : " + oneInvoice.getInvoices().get(0).getTotal());
                LocalDate myDate = oneInvoice.getInvoices().get(0).getDate();
                OffsetDateTime myUTC = oneInvoice.getInvoices().get(0).getUpdatedDateUTC();
                OnlineInvoices onlineInvoice = accountingApi.getOnlineInvoice(newInvoiceID);
                messages.add("Get Online invoice - URL : " + onlineInvoice.getOnlineInvoices().get(0).getOnlineInvoiceUrl());
                RequestEmpty empty = new RequestEmpty();
                Response204 emailInvoice = accountingApi.emailInvoice(newInvoiceID, empty);
                messages.add("Email invoice - response : " + emailInvoice.toString());
                HistoryRecords history3 = accountingApi.getInvoiceHistory(newInvoiceID);
                messages.add("History - count : " + history3.getHistoryRecords().size());
                HistoryRecords newHistoryRecords = new HistoryRecords();
                HistoryRecord newHistoryRecord = new HistoryRecord();
                newHistoryRecord.setDetails("Hello World");
                newHistoryRecords.addHistoryRecordsItem(newHistoryRecord);
                HistoryRecords newHistory = accountingApi.createInvoiceHistory(newInvoiceID, newHistoryRecords);
                messages.add("History - note added to  : " + newHistory);
                Invoices myInvoices = accountingApi.getInvoices(ifModifiedSince, where, order, ids, invoiceNumbers, contactIDs, statuses, null, includeArchived, createdByMyApp);
                UUID invoiceID = myInvoices.getInvoices().get(0).getInvoiceID();
                InputStream inputStream = JsonConfig.class.getResourceAsStream("/helo-heros.jpg");
                byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
                String newFileName = "sample2.jpg";
                Attachments createdAttachments = accountingApi.createInvoiceAttachmentByFileName(invoiceID, newFileName, bytes);
                messages.add("Attachment to Invoice complete - ID: " + createdAttachments.getAttachments().get(0).getAttachmentID());
                Attachments attachments = accountingApi.getInvoiceAttachments(invoiceID);
                System.out.println(attachments.getAttachments().get(0).getFileName());
                UUID attachementId = attachments.getAttachments().get(0).getAttachmentID();
                String contentType = attachments.getAttachments().get(0).getMimeType();
                ByteArrayInputStream InvoiceAttachmentInput = accountingApi.getInvoiceAttachmentById(invoiceID, attachementId, contentType);
                String InvoiceAttachmentFileName = attachments.getAttachments().get(0).getFileName();
                String InvoiceAttachmentSaveFilePath = this.saveFile(InvoiceAttachmentInput, InvoiceAttachmentFileName);
                messages.add("Get Invoice attachment - save it here: " + InvoiceAttachmentSaveFilePath);
            } else if (object.equals("InvoiceReminders")) {
                try {
                    InvoiceReminders invReminders = accountingApi.getInvoiceReminders();
                    messages.add("Get a Invoice Reminder - Is Enabled: " + invReminders.getInvoiceReminders().get(0).getEnabled());
                }
                catch (XeroApiException e) {
                    System.out.println(e.getMessage());
                }
            } else if (object.equals("Items")) {
                try {
                    Items myItems = new Items();
                    Item myItem = new Item();
                    myItem.setCode("abc" + SampleData.loadRandomNum());
                    myItem.setDescription("foobar");
                    myItem.setName("Hello" + SampleData.loadRandomNum());
                    myItems.addItemsItem(myItem);
                    Items newItems = accountingApi.createItem(myItems);
                    messages.add("Create new item - Description : " + newItems.getItems().get(0).getDescription());
                    UUID newItemId = newItems.getItems().get(0).getItemID();
                    newItems.getItems().get(0).setDescription("Barfoo");
                    Items updateItem = accountingApi.updateItem(newItemId, newItems);
                    messages.add("Update item - Description : " + updateItem.getItems().get(0).getDescription());
                    Items items = accountingApi.getItems(ifModifiedSince, where, order);
                    messages.add("Get all items - Total : " + items.getItems().size());
                    UUID itemId = items.getItems().get(0).getItemID();
                    Items oneItem = accountingApi.getItem(itemId);
                    messages.add("Get one item - Description : " + oneItem.getItems().get(0).getDescription());
                    HistoryRecords history4 = accountingApi.getItemHistory(itemId);
                    messages.add("History - count : " + history4.getHistoryRecords().size());
                    Response204 deleteItem = accountingApi.deleteItem(newItemId);
                    messages.add("Delete one item - status : " + deleteItem.getStatus());
                }
                catch (XeroApiException e) {
                    System.out.println(e.getMessage());
                }
            } else if (object.equals("Journals")) {
                try {
                    boolean paymentsOnly = false;
                    Journals journals = accountingApi.getJournals(ifModifiedSince, null, paymentsOnly);
                    messages.add("Get Journals - total : " + journals.getJournals().size());
                    Journals journalsOffset = accountingApi.getJournals(ifModifiedSince, null, paymentsOnly);
                    messages.add("Get Journals offset - total : " + journalsOffset.getJournals().size());
                    UUID journalId = journals.getJournals().get(0).getJournalID();
                    Journals oneJournal = accountingApi.getJournal(journalId);
                    messages.add("Get one Journal - number : " + oneJournal.getJournals().get(0).getJournalNumber());
                }
                catch (XeroApiException e) {
                    System.out.println(e.getMessage());
                }
            } else if (object.equals("LinkedTransactions")) {
                try {
                    where = "Type==\"EXPENSE\"";
                    Accounts accounts = accountingApi.getAccounts(ifModifiedSince, where, order);
                    where = null;
                    Contacts contacts8 = accountingApi.getContacts(ifModifiedSince, where, order, ids, null, includeArchived);
                    Contact useContact5 = new Contact();
                    useContact5.setContactID(contacts8.getContacts().get(0).getContactID());
                    Invoices newInvoices = new Invoices();
                    Invoice myInvoice = new Invoice();
                    li = new LineItem();
                    li.setAccountCode(accounts.getAccounts().get(0).getCode());
                    li.setDescription("Acme Tires");
                    li.setQuantity(Float.valueOf(2.0f));
                    li.setUnitAmount(Float.valueOf(20.0f));
                    li.setLineAmount(Float.valueOf(40.0f));
                    li.setTaxType(TaxType.NONE);
                    myInvoice.addLineItemsItem(li);
                    myInvoice.setContact(useContact5);
                    LocalDate dueDate = LocalDate.of((int)2018, (Month)Month.OCTOBER, (int)10);
                    myInvoice.setDueDate(dueDate);
                    LocalDate todayDate = LocalDate.now();
                    myInvoice.setDate(todayDate);
                    myInvoice.setType(Invoice.TypeEnum.ACCPAY);
                    myInvoice.setReference("One Fish, Two Fish");
                    myInvoice.setStatus(Invoice.StatusEnum.AUTHORISED);
                    newInvoices.addInvoicesItem(myInvoice);
                    Invoices newInvoice = accountingApi.createInvoice(newInvoices, summarizeErrors);
                    UUID sourceTransactionID1 = newInvoice.getInvoices().get(0).getInvoiceID();
                    UUID sourceLineItemID1 = newInvoice.getInvoices().get(0).getLineItems().get(0).getLineItemID();
                    LinkedTransactions newLinkedTransactions = new LinkedTransactions();
                    LinkedTransaction newLinkedTransaction = new LinkedTransaction();
                    newLinkedTransaction.setSourceTransactionID(sourceTransactionID1);
                    newLinkedTransaction.setSourceLineItemID(sourceLineItemID1);
                    newLinkedTransactions.addLinkedTransactionsItem(newLinkedTransaction);
                    LinkedTransactions createdLinkedTransaction = accountingApi.createLinkedTransaction(newLinkedTransactions);
                    messages.add("Create LinkedTransaction - Status : " + (Object)((Object)createdLinkedTransaction.getLinkedTransactions().get(0).getStatus()));
                    Contact contact = new Contact();
                    contact.setName("Foo" + SampleData.loadRandomNum());
                    contact.setEmailAddress("sid" + SampleData.loadRandomNum() + "@blah.com");
                    Contacts newContact = accountingApi.createContact(contact);
                    UUID newContactID = newContact.getContacts().get(0).getContactID();
                    Invoices newInvoice2 = accountingApi.createInvoice(newInvoices, summarizeErrors);
                    UUID sourceTransactionID2 = newInvoice2.getInvoices().get(0).getInvoiceID();
                    UUID sourceLineItemID2 = newInvoice2.getInvoices().get(0).getLineItems().get(0).getLineItemID();
                    LinkedTransactions newLinkedTransactions2 = new LinkedTransactions();
                    LinkedTransaction newLinkedTransaction2 = new LinkedTransaction();
                    newLinkedTransaction2.setSourceTransactionID(sourceTransactionID2);
                    newLinkedTransaction2.setSourceLineItemID(sourceLineItemID2);
                    newLinkedTransaction2.setContactID(newContactID);
                    newLinkedTransactions2.addLinkedTransactionsItem(newLinkedTransaction2);
                    LinkedTransactions createdLinkedTransaction2 = accountingApi.createLinkedTransaction(newLinkedTransactions2);
                    messages.add("Create LinkedTransaction 2 - Status : " + (Object)((Object)createdLinkedTransaction2.getLinkedTransactions().get(0).getStatus()));
                    Invoices newInvoicesAccRec = new Invoices();
                    Invoice myInvoiceAccRec = new Invoice();
                    myInvoiceAccRec.addLineItemsItem(li);
                    myInvoiceAccRec.setContact(useContact5);
                    myInvoiceAccRec.setDueDate(dueDate);
                    myInvoiceAccRec.setDate(todayDate);
                    myInvoiceAccRec.setType(Invoice.TypeEnum.ACCREC);
                    myInvoiceAccRec.setStatus(Invoice.StatusEnum.AUTHORISED);
                    newInvoicesAccRec.addInvoicesItem(myInvoiceAccRec);
                    Invoices newInvoiceAccRec = accountingApi.createInvoice(newInvoicesAccRec, summarizeErrors);
                    UUID sourceTransactionID4 = newInvoiceAccRec.getInvoices().get(0).getInvoiceID();
                    UUID sourceLineItemID4 = newInvoiceAccRec.getInvoices().get(0).getLineItems().get(0).getLineItemID();
                    Invoices newInvoice3 = accountingApi.createInvoice(newInvoices, summarizeErrors);
                    UUID sourceTransactionID3 = newInvoice3.getInvoices().get(0).getInvoiceID();
                    UUID sourceLineItemID3 = newInvoice3.getInvoices().get(0).getLineItems().get(0).getLineItemID();
                    LinkedTransactions newLinkedTransactions3 = new LinkedTransactions();
                    LinkedTransaction newLinkedTransaction3 = new LinkedTransaction();
                    newLinkedTransaction3.setSourceTransactionID(sourceTransactionID3);
                    newLinkedTransaction3.setSourceLineItemID(sourceLineItemID3);
                    newLinkedTransaction3.setContactID(useContact5.getContactID());
                    newLinkedTransaction3.setTargetTransactionID(sourceTransactionID4);
                    newLinkedTransaction3.setTargetLineItemID(sourceLineItemID4);
                    newLinkedTransactions3.addLinkedTransactionsItem(newLinkedTransaction3);
                    LinkedTransactions createdLinkedTransaction3 = accountingApi.createLinkedTransaction(newLinkedTransactions3);
                    messages.add("Create LinkedTransaction 3 - Status : " + (Object)((Object)createdLinkedTransaction3.getLinkedTransactions().get(0).getStatus()));
                    int page = 1;
                    String linkedTransactionID = null;
                    String sourceTransactionID = null;
                    String targetTransactionID = null;
                    String status = null;
                    String contactID = null;
                    LinkedTransactions linkTransactions = accountingApi.getLinkedTransactions(page, linkedTransactionID, sourceTransactionID, contactID, status, targetTransactionID);
                    messages.add("Get Link Transactions - total : " + linkTransactions.getLinkedTransactions().size());
                    UUID linkedTransactionID2 = linkTransactions.getLinkedTransactions().get(0).getLinkedTransactionID();
                    LinkedTransactions oneLinkTransaction = accountingApi.getLinkedTransaction(linkedTransactionID2);
                    messages.add("Get one Link Transaction - Status : " + (Object)((Object)oneLinkTransaction.getLinkedTransactions().get(0).getStatus()));
                    UUID newLinkedTransactionID = createdLinkedTransaction.getLinkedTransactions().get(0).getLinkedTransactionID();
                    Response204 deleteLinkedTransaction = accountingApi.deleteLinkedTransaction(newLinkedTransactionID);
                    messages.add("Delete LinkedTransaction - Status : " + deleteLinkedTransaction.getStatus());
                }
                catch (XeroApiException e) {
                    System.out.println(e.getMessage());
                }
            } else if (object.equals("ManualJournals")) {
                try {
                    where = "Type==\"EXPENSE\" && Status ==\"ACTIVE\"";
                    Accounts accounts = accountingApi.getAccounts(ifModifiedSince, where, order);
                    String accountCode = accounts.getAccounts().get(0).getCode();
                    where = null;
                    ManualJournals manualJournals = new ManualJournals();
                    ManualJournal manualJournal = new ManualJournal();
                    currDate2 = LocalDate.now();
                    manualJournal.setDate(currDate2);
                    manualJournal.setNarration("Foo bar");
                    ManualJournalLine credit = new ManualJournalLine();
                    credit.setDescription("Hello there");
                    credit.setAccountCode(accountCode);
                    credit.setLineAmount(Float.valueOf(100.0f));
                    manualJournal.addJournalLinesItem(credit);
                    ManualJournalLine debit = new ManualJournalLine();
                    debit.setDescription("Goodbye");
                    debit.setAccountCode(accountCode);
                    debit.setLineAmount(Float.valueOf(-100.0f));
                    manualJournal.addJournalLinesItem(debit);
                    manualJournals.addManualJournalsItem(manualJournal);
                    ManualJournals createdManualJournals = accountingApi.createManualJournal(manualJournals);
                    UUID newManualJournalId = createdManualJournals.getManualJournals().get(0).getManualJournalID();
                    messages.add("Create Manual Journal - Narration : " + createdManualJournals.getManualJournals().get(0).getNarration());
                    ManualJournals getManualJournals = accountingApi.getManualJournals(ifModifiedSince, where, order, null);
                    messages.add("Get Manual Journal - total : " + getManualJournals.getManualJournals().size());
                    UUID manualJournalId = getManualJournals.getManualJournals().get(0).getManualJournalID();
                    ManualJournals oneManualJournal = accountingApi.getManualJournal(manualJournalId);
                    messages.add("Get one Manual Journal - Narration : " + oneManualJournal.getManualJournals().get(0).getNarration());
                    ManualJournals updateManualJournals = new ManualJournals();
                    ManualJournal updateManualJournal = new ManualJournal();
                    updateManualJournal.setManualJournalID(newManualJournalId);
                    updateManualJournal.setNarration("Hello Xero");
                    updateManualJournals.addManualJournalsItem(updateManualJournal);
                    ManualJournals updatedManualJournal = accountingApi.updateManualJournal(newManualJournalId, updateManualJournals);
                    messages.add("Update Manual Journal - Narration : " + updatedManualJournal.getManualJournals().get(0).getNarration());
                }
                catch (XeroApiException e) {
                    System.out.println(e.getMessage());
                }
            } else if (object.equals("Organisations")) {
                try {
                    Organisations organisations = accountingApi.getOrganisations();
                    messages.add("Get a Organisation - Name : " + organisations.getOrganisations().get(0).getName());
                }
                catch (XeroApiException e) {
                    System.out.println(e.getMessage());
                }
            } else if (object.equals("Overpayments")) {
                where = "Status==\"ACTIVE\"&&Type==\"BANK\"";
                Accounts accountsWhere = accountingApi.getAccounts(ifModifiedSince, where, order);
                Account bankAccount = new Account();
                bankAccount.setAccountID(accountsWhere.getAccounts().get(0).getAccountID());
                where = null;
                where = "SystemAccount==\"DEBTORS\"";
                Accounts arAccounts = accountingApi.getAccounts(ifModifiedSince, where, order);
                Account arAccount = arAccounts.getAccounts().get(0);
                where = null;
                contacts = accountingApi.getContacts(ifModifiedSince, where, order, ids, null, includeArchived);
                useContact = new Contact();
                useContact.setContactID(contacts.getContacts().get(0).getContactID());
                if (accountsWhere.getAccounts().size() > 0) {
                    ArrayList<LineItem> lineItems = new ArrayList<LineItem>();
                    LineItem li5 = new LineItem();
                    li5.setAccountCode(arAccount.getCode());
                    li5.setDescription("Foobar");
                    li5.setQuantity(Float.valueOf(1.0f));
                    li5.setUnitAmount(Float.valueOf(20.0f));
                    lineItems.add(li5);
                    bt = new BankTransaction();
                    bt.setBankAccount(bankAccount);
                    bt.setContact(useContact);
                    bt.setLineitems(lineItems);
                    bt.setType(BankTransaction.TypeEnum.RECEIVE_OVERPAYMENT);
                    bts = new BankTransactions();
                    bts.addBankTransactionsItem(bt);
                    newBankTransaction = accountingApi.createBankTransaction(bts, summarizeErrors);
                    Overpayments overpayments = accountingApi.getOverpayments(ifModifiedSince, where, order, null);
                    messages.add("Get a Overpayments - Count : " + overpayments.getOverpayments().size());
                    if (overpayments.getOverpayments().size() > 0) {
                        UUID overpaymentId = overpayments.getOverpayments().get(2).getOverpaymentID();
                        Overpayments oneOverpayment = accountingApi.getOverpayment(overpaymentId);
                        messages.add("Get one Overpayment - Total : " + oneOverpayment.getOverpayments().get(0).getTotal());
                        where = "Status==\"AUTHORISED\"&&Type==\"ACCREC\"";
                        allInvoices = accountingApi.getInvoices(ifModifiedSince, where, order, ids, invoiceNumbers, contactIDs, statuses, null, includeArchived, createdByMyApp);
                        inv = new Invoice();
                        inv.setInvoiceID(allInvoices.getInvoices().get(0).getInvoiceID());
                        where = null;
                        allocations = new Allocations();
                        allocation = new Allocation();
                        allocation.setAmount(Float.valueOf(1.0f));
                        currDate = LocalDate.now();
                        allocation.setDate(currDate);
                        allocation.setInvoice(inv);
                        allocations.addAllocationsItem(allocation);
                        Allocations newAllocation = accountingApi.createOverpaymentAllocation(overpaymentId, allocations);
                        messages.add("Create OverPayment allocation - Amt : " + newAllocation.getAllocations().get(0).getAmount());
                        HistoryRecords history5 = accountingApi.getOverpaymentHistory(overpaymentId);
                        messages.add("History - count : " + history5.getHistoryRecords().size());
                    }
                }
            } else if (object.equals("Payments")) {
                where = "Status==\"AUTHORISED\"&&Type==\"ACCREC\"";
                Invoices allInvoices4 = accountingApi.getInvoices(ifModifiedSince, where, order, ids, invoiceNumbers, contactIDs, statuses, null, includeArchived, createdByMyApp);
                Invoice inv4 = new Invoice();
                inv4.setInvoiceID(allInvoices4.getInvoices().get(0).getInvoiceID());
                where = null;
                where = "EnablePaymentsToAccount==true";
                Accounts accountsWhere = accountingApi.getAccounts(ifModifiedSince, where, order);
                Account paymentAccount = new Account();
                paymentAccount.setCode(accountsWhere.getAccounts().get(0).getCode());
                where = null;
                Payments createPayments = new Payments();
                Payment createPayment = new Payment();
                createPayment.setAccount(paymentAccount);
                createPayment.setInvoice(inv4);
                createPayment.setAmount(Float.valueOf(1.0f));
                LocalDate currDate5 = LocalDate.now();
                createPayment.setDate(currDate5);
                createPayments.addPaymentsItem(createPayment);
                Payments newPayments = accountingApi.createPayment(createPayments);
                messages.add("Create Payments - Amt : " + newPayments.getPayments().get(0).getAmount());
                Payments payments = accountingApi.getPayments(ifModifiedSince, where, order);
                messages.add("Get Payments - Total : " + payments.getPayments().size());
                UUID paymentID = payments.getPayments().get(0).getPaymentID();
                Payments onePayment = accountingApi.getPayment(paymentID);
                messages.add("Get Payments - Amount : " + onePayment.getPayments().get(0).getAmount());
                HistoryRecords allHistory = accountingApi.getPaymentHistory(paymentID);
                messages.add("History - count : " + allHistory.getHistoryRecords().size());
            } else if (object.equals("PaymentServices")) {
                try {
                    PaymentServices newPaymentServices = new PaymentServices();
                    PaymentService newPaymentService = new PaymentService();
                    newPaymentService.setPaymentServiceName("PayUp" + SampleData.loadRandomNum());
                    newPaymentService.setPaymentServiceUrl("https://www.payupnow.com/");
                    newPaymentService.setPayNowText("Time To PayUp");
                    newPaymentServices.addPaymentServicesItem(newPaymentService);
                    PaymentServices createdPaymentService = accountingApi.createPaymentService(newPaymentServices);
                    messages.add("Create PaymentServices - name : " + createdPaymentService.getPaymentServices().get(0).getPaymentServiceName());
                    PaymentServices paymentServices = accountingApi.getPaymentServices();
                    messages.add("Get PaymentServices - Total : " + paymentServices.getPaymentServices().size());
                }
                catch (XeroApiException e) {
                    System.out.println(e.getMessage());
                }
            } else if (object.equals("Prepayments")) {
                where = "Status==\"ACTIVE\"&&Type==\"BANK\"";
                Accounts accountsWhere = accountingApi.getAccounts(ifModifiedSince, where, order);
                Account bankAccount = new Account();
                bankAccount.setAccountID(accountsWhere.getAccounts().get(0).getAccountID());
                where = null;
                where = "Type==\"EXPENSE\"";
                Accounts arAccounts = accountingApi.getAccounts(ifModifiedSince, where, order);
                Account arAccount = arAccounts.getAccounts().get(0);
                where = null;
                contacts = accountingApi.getContacts(ifModifiedSince, where, order, ids, null, includeArchived);
                useContact = new Contact();
                useContact.setContactID(contacts.getContacts().get(0).getContactID());
                if (accountsWhere.getAccounts().size() > 0) {
                    ArrayList<LineItem> lineItems = new ArrayList<LineItem>();
                    LineItem li6 = new LineItem();
                    li6.setAccountCode(arAccount.getCode());
                    li6.setDescription("Foobar");
                    li6.setQuantity(Float.valueOf(1.0f));
                    li6.setTaxType(TaxType.NONE);
                    li6.setUnitAmount(Float.valueOf(20.0f));
                    lineItems.add(li6);
                    bt = new BankTransaction();
                    bt.setBankAccount(bankAccount);
                    bt.setContact(useContact);
                    bt.setLineitems(lineItems);
                    bt.setType(BankTransaction.TypeEnum.RECEIVE_PREPAYMENT);
                    bts = new BankTransactions();
                    bts.addBankTransactionsItem(bt);
                    newBankTransaction = accountingApi.createBankTransaction(bts, summarizeErrors);
                    where = "Status==\"AUTHORISED\" && TYPE==\"RECEIVE-PREPAYMENT\"";
                    Prepayments prepayments = accountingApi.getPrepayments(ifModifiedSince, where, order, null);
                    messages.add("Get a Prepayments - Count : " + prepayments.getPrepayments().size());
                    where = null;
                    if (prepayments.getPrepayments().size() > 0) {
                        UUID prepaymentId = prepayments.getPrepayments().get(0).getPrepaymentID();
                        Prepayments onePrepayment = accountingApi.getPrepayment(prepaymentId);
                        messages.add("Get one Prepayment - Total : " + onePrepayment.getPrepayments().get(0).getTotal());
                        where = "Status==\"AUTHORISED\"&&Type==\"ACCREC\"";
                        allInvoices = accountingApi.getInvoices(ifModifiedSince, where, order, ids, invoiceNumbers, contactIDs, statuses, null, includeArchived, createdByMyApp);
                        inv = new Invoice();
                        inv.setInvoiceID(allInvoices.getInvoices().get(0).getInvoiceID());
                        where = null;
                        allocations = new Allocations();
                        allocation = new Allocation();
                        allocation.setAmount(Float.valueOf(1.0f));
                        currDate = LocalDate.now();
                        allocation.setDate(currDate);
                        allocation.setInvoice(inv);
                        allocations.addAllocationsItem(allocation);
                        history = accountingApi.getPrepaymentHistory(prepaymentId);
                        messages.add("History - count : " + history.getHistoryRecords().size());
                    }
                }
            } else if (object.equals("PurchaseOrders")) {
                try {
                    where = "Type==\"EXPENSE\"";
                    Accounts arAccounts = accountingApi.getAccounts(ifModifiedSince, where, order);
                    Account arAccount = arAccounts.getAccounts().get(0);
                    where = null;
                    PurchaseOrders purchaseOrders = new PurchaseOrders();
                    PurchaseOrder purchaseOrder = new PurchaseOrder();
                    currDate2 = LocalDate.now();
                    purchaseOrder.setDate(currDate2);
                    Contacts contacts9 = accountingApi.getContacts(ifModifiedSince, where, order, ids, null, includeArchived);
                    Contact useContact6 = new Contact();
                    useContact6.setContactID(contacts9.getContacts().get(0).getContactID());
                    purchaseOrder.setContact(useContact6);
                    ArrayList<LineItem> lineItems = new ArrayList<LineItem>();
                    LineItem li7 = new LineItem();
                    li7.setAccountCode(arAccount.getCode());
                    li7.setDescription("Foobar");
                    li7.setQuantity(Float.valueOf(1.0f));
                    li7.setUnitAmount(Float.valueOf(20.0f));
                    lineItems.add(li7);
                    purchaseOrder.setLineItems(lineItems);
                    purchaseOrders.addPurchaseOrdersItem(purchaseOrder);
                    PurchaseOrders createdPurchaseOrders = accountingApi.createPurchaseOrder(purchaseOrders, summarizeErrors);
                    messages.add("Create Purchase order - total : " + createdPurchaseOrders.getPurchaseOrders().get(0).getTotal());
                    UUID newPurchaseOrderID = createdPurchaseOrders.getPurchaseOrders().get(0).getPurchaseOrderID();
                    createdPurchaseOrders.getPurchaseOrders().get(0).setAttentionTo("Jimmy");
                    PurchaseOrders updatePurchaseOrders = accountingApi.updatePurchaseOrder(newPurchaseOrderID, createdPurchaseOrders);
                    messages.add("Update Purchase order - attn : " + updatePurchaseOrders.getPurchaseOrders().get(0).getAttentionTo());
                    String status = null;
                    String dateFrom = null;
                    String dateTo = null;
                    PurchaseOrders allPurchaseOrders = accountingApi.getPurchaseOrders(ifModifiedSince, status, dateFrom, dateTo, order, null);
                    messages.add("Get Purchase orders - Count : " + allPurchaseOrders.getPurchaseOrders().size());
                    UUID purchaseOrderID = allPurchaseOrders.getPurchaseOrders().get(0).getPurchaseOrderID();
                    PurchaseOrders onePurchaseOrder = accountingApi.getPurchaseOrder(purchaseOrderID);
                    messages.add("Get one Purchase order - Total : " + onePurchaseOrder.getPurchaseOrders().get(0).getTotal());
                    createdPurchaseOrders.getPurchaseOrders().get(0).setStatus(PurchaseOrder.StatusEnum.DELETED);
                    PurchaseOrders deletePurchaseOrders = accountingApi.updatePurchaseOrder(newPurchaseOrderID, createdPurchaseOrders);
                    messages.add("Delete Purchase order - Status : " + (Object)((Object)deletePurchaseOrders.getPurchaseOrders().get(0).getStatus()));
                    history = accountingApi.getInvoiceHistory(purchaseOrderID);
                    messages.add("History - count : " + history.getHistoryRecords().size());
                    HistoryRecords newHistoryRecords = new HistoryRecords();
                    HistoryRecord newHistoryRecord = new HistoryRecord();
                    newHistoryRecord.setDetails("Hello World");
                    newHistoryRecords.addHistoryRecordsItem(newHistoryRecord);
                    HistoryRecords newHistory = accountingApi.createPurchaseOrderHistory(purchaseOrderID, newHistoryRecords);
                    messages.add("History - note added to  : " + newHistory.getHistoryRecords().get(0).getDetails());
                }
                catch (XeroApiException e) {
                    System.out.println(e.getMessage());
                }
            } else if (object.equals("Receipts")) {
                try {
                    where = "IsSubscriber==true";
                    Users users = accountingApi.getUsers(ifModifiedSince, where, order);
                    where = null;
                    where = "ShowInExpenseClaims==true && Status==\"ACTIVE\"";
                    Accounts accounts = accountingApi.getAccounts(ifModifiedSince, where, order);
                    where = null;
                    User useUser = new User();
                    useUser.setUserID(users.getUsers().get(0).getUserID());
                    Contacts contacts10 = accountingApi.getContacts(ifModifiedSince, where, order, ids, null, includeArchived);
                    useContact2 = new Contact();
                    useContact2.setContactID(contacts10.getContacts().get(0).getContactID());
                    receipts = new Receipts();
                    Receipt receipt = new Receipt();
                    LineItem li8 = new LineItem();
                    li8.setAccountCode(accounts.getAccounts().get(0).getCode());
                    li8.setDescription("Foobar");
                    li8.setQuantity(Float.valueOf(2.0f));
                    li8.setUnitAmount(Float.valueOf(20.0f));
                    li8.setLineAmount(Float.valueOf(40.0f));
                    li8.setTaxType(TaxType.NONE);
                    receipt.addLineitemsItem(li8);
                    receipt.setUser(useUser);
                    receipt.lineAmountTypes(LineAmountTypes.NOTAX);
                    receipt.contact(useContact2);
                    receipt.setStatus(Receipt.StatusEnum.DRAFT);
                    receipts.addReceiptsItem(receipt);
                    newReceipts = accountingApi.createReceipt(receipts);
                    messages.add("Create Receipts - Total : " + newReceipts.getReceipts().get(0).getTotal());
                    UUID newReceiptId = newReceipts.getReceipts().get(0).getReceiptID();
                    newReceipts.getReceipts().get(0).setReference("Foobar");
                    Receipts updateReceipts = accountingApi.updateReceipt(newReceiptId, newReceipts);
                    messages.add("Create Receipts - Ref : " + updateReceipts.getReceipts().get(0).getReference());
                    Receipts allReceipts = accountingApi.getReceipts(ifModifiedSince, where, order);
                    messages.add("Create Receipts - Count : " + allReceipts.getReceipts().size());
                    UUID receiptID = allReceipts.getReceipts().get(0).getReceiptID();
                    Receipts oneReceipts = accountingApi.getReceipt(receiptID);
                    messages.add("Create Receipts - Total : " + oneReceipts.getReceipts().get(0).getTotal());
                    HistoryRecords history6 = accountingApi.getReceiptHistory(receiptID);
                    messages.add("History - count : " + history6.getHistoryRecords().size());
                }
                catch (XeroApiException e) {
                    System.out.println(e.getMessage());
                }
            } else if (object.equals("RepeatingInvoices")) {
                try {
                    RepeatingInvoices repeatingInvoices = accountingApi.getRepeatingInvoices(where, order);
                    if (repeatingInvoices.getRepeatingInvoices().size() > 0) {
                        messages.add("Repeating Invoice - count : " + repeatingInvoices.getRepeatingInvoices().size());
                        UUID repeatingInvoiceID = repeatingInvoices.getRepeatingInvoices().get(0).getRepeatingInvoiceID();
                        RepeatingInvoices repeatingInvoice = accountingApi.getRepeatingInvoice(repeatingInvoiceID);
                        messages.add("Repeating Invoice - total : " + repeatingInvoice.getRepeatingInvoices().get(0).getTotal());
                        HistoryRecords history7 = accountingApi.getRepeatingInvoiceHistory(repeatingInvoiceID);
                        messages.add("History - count : " + history7.getHistoryRecords().size());
                        break block217;
                    }
                    messages.add("Zero repeating Invoices found");
                }
                catch (XeroApiException e) {
                    System.out.println(e.getMessage());
                }
            } else if (object.equals("Reports")) {
                String date = null;
                String fromDate = null;
                String toDate = null;
                String profitLossTimeframe = null;
                String trackingOptionID1 = null;
                String trackingOptionID2 = null;
                boolean standardLayout = false;
                boolean paymentsOnly = false;
                String trackingCategoryID = null;
                String trackingCategoryID2 = null;
                String trackingOptionID = null;
                Contacts contacts11 = accountingApi.getContacts(ifModifiedSince, where, order, ids, null, includeArchived);
                UUID contactId = contacts11.getContacts().get(0).getContactID();
                LocalDate xDate = LocalDate.now();
                LocalDate xFromDate = LocalDate.now();
                LocalDate xToDate = LocalDate.now();
                ReportWithRows reportAgedPayablesByContact = accountingApi.getReportAgedPayablesByContact(contactId, xDate, xFromDate, xToDate);
                messages.add("Get a Reports - Name:" + reportAgedPayablesByContact.getReports().get(0).getReportName());
                ReportWithRows reportAgedReceivablesByContact = accountingApi.getReportAgedReceivablesByContact(contactId, date, fromDate, toDate);
                messages.add("Get a Reports - Name:" + reportAgedReceivablesByContact.getReports().get(0).getReportName());
                ReportWithRows reportBalanceSheet = accountingApi.getReportBalanceSheet(toDate, null, null, trackingOptionID1, trackingOptionID2, standardLayout, paymentsOnly);
                messages.add("Get a Reports - Name:" + reportBalanceSheet.getReports().get(0).getReportName());
                ReportWithRows reportBankSummary = accountingApi.getReportBankSummary(toDate, null, null);
                messages.add("Get a Reports - Name:" + reportBankSummary.getReports().get(0).getReportName());
                ReportWithRows reportTax = accountingApi.getReportBASorGSTList();
                System.out.println(reportTax.toString());
                ReportWithRows reportExecutiveSummary = accountingApi.getReportExecutiveSummary(toDate);
                messages.add("Get a Reports - Name:" + reportExecutiveSummary.getReports().get(0).getReportName());
                fromDate = "2018-01-01";
                toDate = "2018-12-31";
                profitLossTimeframe = "MONTH";
                standardLayout = true;
                paymentsOnly = false;
                ReportWithRows reportProfitLoss = accountingApi.getReportProfitAndLoss(fromDate, toDate, null, profitLossTimeframe, trackingCategoryID, trackingCategoryID2, trackingOptionID, trackingOptionID2, standardLayout, paymentsOnly);
                messages.add("Get a Reports - Name:" + reportProfitLoss.getReports().get(0).getReportName());
                fromDate = null;
                toDate = null;
                ReportWithRows reportTrialBalance = accountingApi.getReportTrialBalance(toDate, paymentsOnly);
                messages.add("Get a Reports - Name:" + reportTrialBalance.getReports().get(0).getReportName());
            } else if (object.equals("TaxRates")) {
                try {
                    TaxRates newTaxRates = new TaxRates();
                    TaxRate newTaxRate = new TaxRate();
                    TaxComponent rate01 = new TaxComponent();
                    rate01.setName("State Tax");
                    rate01.setRate(Float.valueOf(2.25f));
                    newTaxRate.setReportTaxType(TaxRate.ReportTaxTypeEnum.INPUT);
                    newTaxRate.setName("SDKTax" + SampleData.loadRandomNum());
                    newTaxRate.addTaxComponentsItem(rate01);
                    newTaxRates.addTaxRatesItem(newTaxRate);
                    TaxRates createdTaxRate = accountingApi.createTaxRate(newTaxRates);
                    messages.add("CREATE TaxRate - name : " + createdTaxRate.getTaxRates().get(0).getName());
                    newTaxRates.getTaxRates().get(0).setStatus(TaxRate.StatusEnum.DELETED);
                    TaxRates updatedTaxRate = accountingApi.updateTaxRate(newTaxRates);
                    messages.add("UPDATED TaxRate - status : " + (Object)((Object)updatedTaxRate.getTaxRates().get(0).getStatus()));
                    String taxType = null;
                    TaxRates taxRates = accountingApi.getTaxRates(where, order, taxType);
                    messages.add("GET TaxRate - cnt : " + taxRates.getTaxRates().size());
                    taxType = "CAPEXINPUT2";
                    TaxRates taxRatesByType = accountingApi.getTaxRates(where, order, taxType);
                    messages.add("GET TaxRate by Cap Purchase Type : " + taxRatesByType.getTaxRates().size());
                }
                catch (XeroApiException e) {
                    System.out.println(e.getMessage());
                }
            } else if (object.equals("TrackingCategories")) {
                try {
                    TrackingCategories trackingCategories = accountingApi.getTrackingCategories(where, order, includeArchived);
                    int count = trackingCategories.getTrackingCategories().size();
                    if (count == 2) {
                        UUID trackingCategoryID = trackingCategories.getTrackingCategories().get(0).getTrackingCategoryID();
                        TrackingCategories deletedTrackingCategories = accountingApi.deleteTrackingCategory(trackingCategoryID);
                        messages.add("DELETED tracking categories - status : " + (Object)((Object)deletedTrackingCategories.getTrackingCategories().get(0).getStatus()));
                    }
                    TrackingCategory newTrackingCategory = new TrackingCategory();
                    newTrackingCategory.setName("Foo" + SampleData.loadRandomNum());
                    TrackingCategories createdTrackingCategories = accountingApi.createTrackingCategory(newTrackingCategory);
                    messages.add("CREATED tracking categories - name : " + createdTrackingCategories.getTrackingCategories().get(0).getName());
                    UUID newTrackingCategoryID = createdTrackingCategories.getTrackingCategories().get(0).getTrackingCategoryID();
                    newTrackingCategory.setName("Foo" + SampleData.loadRandomNum());
                    TrackingCategories updatedTrackingCategories = accountingApi.updateTrackingCategory(newTrackingCategoryID, newTrackingCategory);
                    messages.add("UPDATED tracking categories - name : " + updatedTrackingCategories.getTrackingCategories().get(0).getName());
                    UUID oneTrackingCategoryID = trackingCategories.getTrackingCategories().get(0).getTrackingCategoryID();
                    TrackingCategories oneTrackingCategories = accountingApi.getTrackingCategory(oneTrackingCategoryID);
                    messages.add("GET ONE tracking categories - name : " + oneTrackingCategories.getTrackingCategories().get(0).getName());
                    TrackingOption option = new TrackingOption();
                    option.setName("Bar" + SampleData.loadRandomNum());
                    TrackingOptions newTrackingOptions = accountingApi.createTrackingOptions(oneTrackingCategoryID, option);
                    messages.add("CREATE option - name : " + newTrackingOptions.getOptions().get(0).getName());
                    UUID newOptionId = newTrackingOptions.getOptions().get(0).getTrackingOptionID();
                    TrackingOptions deleteOptions = accountingApi.deleteTrackingOptions(oneTrackingCategoryID, newOptionId);
                    messages.add("DELETE one option - Status : " + (Object)((Object)deleteOptions.getOptions().get(0).getStatus()));
                }
                catch (XeroApiException e) {
                    System.out.println(e.getMessage());
                }
            } else if (object.equals("Users")) {
                try {
                    Users users = accountingApi.getUsers(ifModifiedSince, where, order);
                    messages.add("GET Users - cnt : " + users.getUsers().size());
                    UUID userID = users.getUsers().get(0).getUserID();
                    Users user = accountingApi.getUser(userID);
                    messages.add("GET Users - First Name : " + user.getUsers().get(0).getFirstName());
                }
                catch (XeroApiException e) {
                    System.out.println(e.getMessage());
                }
            } else if (object.equals("Errors")) {
                block220: {
                    Object useContact7;
                    block219: {
                        block218: {
                            try {
                                Contact contact = new Contact();
                                contact.setName("Sidney Maestre");
                                Contacts createContact1 = accountingApi.createContact(contact);
                                Contacts user = accountingApi.createContact(contact);
                            }
                            catch (XeroApiException e) {
                                System.out.println("Response Code: " + e.getResponseCode());
                                System.out.println("Error Type: " + e.getError().getType());
                                System.out.println("Error Number: " + e.getError().getErrorNumber());
                                System.out.println("Error Message: " + e.getError().getMessage());
                                if (e.getResponseCode() != 400) break block218;
                                System.out.println("Validation Message: " + e.getError().getElements().get(0).getValidationErrors().get(0).getMessage());
                            }
                        }
                        try {
                            Contacts contacts12 = accountingApi.getContacts(ifModifiedSince, where, order, ids, null, includeArchived);
                            useContact7 = new Contact();
                            ((Contact)useContact7).setContactID(contacts12.getContacts().get(0).getContactID());
                            Invoices newInvoices = new Invoices();
                            Invoice myInvoice = new Invoice();
                            LineItem li9 = new LineItem();
                            li9.setAccountCode("123456789");
                            li9.setDescription("Acme Tires");
                            li9.setQuantity(Float.valueOf(2.0f));
                            li9.setUnitAmount(Float.valueOf(20.0f));
                            li9.setLineAmount(Float.valueOf(40.0f));
                            li9.setTaxType(TaxType.NONE);
                            myInvoice.addLineItemsItem(li9);
                            myInvoice.setContact((Contact)useContact7);
                            LocalDate dueDate = LocalDate.of((int)2018, (Month)Month.OCTOBER, (int)10);
                            myInvoice.setDueDate(dueDate);
                            LocalDate todayDate = LocalDate.now();
                            myInvoice.setDate(todayDate);
                            myInvoice.setType(Invoice.TypeEnum.ACCREC);
                            myInvoice.setReference("One Fish, Two Fish");
                            myInvoice.setStatus(Invoice.StatusEnum.AUTHORISED);
                            newInvoices.addInvoicesItem(myInvoice);
                            Invoices newInvoice = accountingApi.createInvoice(newInvoices, summarizeErrors);
                            messages.add("Create invoice - Reference : " + newInvoice.getInvoices().get(0).getReference());
                        }
                        catch (XeroApiException e) {
                            System.out.println("Response Code: " + e.getResponseCode());
                            System.out.println("Error Type: " + e.getError().getType());
                            System.out.println("Error Number: " + e.getError().getErrorNumber());
                            System.out.println("Error Message: " + e.getError().getMessage());
                            if (e.getResponseCode() != 400) break block219;
                            System.out.println("Validation Message: " + e.getError().getElements().get(0).getValidationErrors().get(0).getMessage());
                        }
                    }
                    try {
                        UUID badContactId = UUID.fromString("bd2270c3-0000-4c11-9cfb-000b551c3f51");
                        useContact7 = accountingApi.getContact(badContactId);
                    }
                    catch (XeroApiException e) {
                        System.out.println("Response Code: " + e.getResponseCode());
                        System.out.println("Error Type: " + e.getError().getType());
                        System.out.println("Error Number: " + e.getError().getErrorNumber());
                        System.out.println("Error Message: " + e.getError().getMessage());
                        if (e.getResponseCode() != 400) break block220;
                        System.out.println("Validation Message: " + e.getError().getElements().get(0).getValidationErrors().get(0).getMessage());
                    }
                }
                Contacts ContactList = accountingApi.getContacts(ifModifiedSince, where, order, ids, null, includeArchived);
                int num4 = SampleData.findRandomNum(ContactList.getContacts().size());
                UUID contactId = ContactList.getContacts().get(num4).getContactID();
                try {
                    for (int i = 65; i > 1; --i) {
                        Contacts contacts13 = accountingApi.getContact(contactId);
                    }
                    messages.add("Congrats - you made over 60 calls without hitting rate limit");
                }
                catch (XeroApiException e) {
                    System.out.println(e.getResponseCode());
                    System.out.println(e.getMessage());
                    messages.add("Error Code : " + e.getResponseCode() + " Message: " + e.getMessage());
                }
            }
        }
        for (int i = 0; i < messages.size(); ++i) {
            System.out.println((String)messages.get(i));
            respWriter.println("<p>" + (String)messages.get(i) + "</p>");
        }
        respWriter.println("<hr>end processing request<hr><div class=\"form-group\">");
        respWriter.println("</div></div>");
    }

    protected void addToMapIfNotNull(Map<String, String> map, String key, Object value) {
        if (value != null) {
            map.put(key, value.toString());
        }
    }

    protected String saveFile(ByteArrayInputStream input, String fileName) {
        String saveFilePath = null;
        File f = new File("./");
        try {
            String dirPath = f.getCanonicalPath();
            FileOutputStream output = new FileOutputStream(fileName);
            int DEFAULT_BUFFER_SIZE = 1024;
            byte[] buffer = new byte[DEFAULT_BUFFER_SIZE];
            int n = 0;
            n = input.read(buffer, 0, DEFAULT_BUFFER_SIZE);
            while (n >= 0) {
                output.write(buffer, 0, n);
                n = input.read(buffer, 0, DEFAULT_BUFFER_SIZE);
            }
            input.close();
            output.close();
            saveFilePath = dirPath + File.separator + fileName;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return saveFilePath;
    }
}

