/*
 * Decompiled with CFR 0.152.
 */
package com.xero.example;

import com.xero.api.Config;
import com.xero.api.JsonConfig;
import com.xero.api.OAuthAuthorizeToken;
import com.xero.api.OAuthRequestToken;
import com.xero.api.XeroApiException;
import com.xero.api.XeroClientException;
import com.xero.example.TokenStorage;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestTokenServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private Config config = null;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter respWriter = response.getWriter();
        response.setStatus(200);
        response.setContentType("text/html");
        try {
            this.config = JsonConfig.getInstance();
            if (this.config.getAppType().equals("PRIVATE")) {
                response.sendRedirect("./callback.jsp");
            } else {
                OAuthRequestToken requestToken = new OAuthRequestToken(this.config);
                try {
                    requestToken.execute();
                    TokenStorage storage = new TokenStorage();
                    storage.save(response, requestToken.getAll());
                    OAuthAuthorizeToken authToken = new OAuthAuthorizeToken(this.config, requestToken.getTempToken());
                    response.sendRedirect(authToken.getAuthUrl());
                }
                catch (XeroApiException e) {
                    String message = URLDecoder.decode(e.getMessage(), "UTF-8");
                    respWriter.println("Error code:" + e.getResponseCode() + " Message:" + message);
                }
            }
        }
        catch (XeroClientException e) {
            String message = URLDecoder.decode(e.getMessage(), "UTF-8");
            respWriter.println("Error: " + message);
        }
    }
}

