/*
 * Decompiled with CFR 0.152.
 */
package com.xero.example;

import com.xero.api.XeroClient;
import com.xero.model.Account;
import com.xero.model.AccountType;
import com.xero.model.Address;
import com.xero.model.AddressType;
import com.xero.model.Allocation;
import com.xero.model.ArrayOfAccount;
import com.xero.model.ArrayOfAddress;
import com.xero.model.ArrayOfAllocation;
import com.xero.model.ArrayOfBankTransaction;
import com.xero.model.ArrayOfBankTransfer;
import com.xero.model.ArrayOfContact;
import com.xero.model.ArrayOfContactGroup;
import com.xero.model.ArrayOfCreditNote;
import com.xero.model.ArrayOfCurrency;
import com.xero.model.ArrayOfEmployee;
import com.xero.model.ArrayOfExpenseClaim;
import com.xero.model.ArrayOfInvoice;
import com.xero.model.ArrayOfItem;
import com.xero.model.ArrayOfLineItem;
import com.xero.model.ArrayOfLinkedTransaction;
import com.xero.model.ArrayOfManualJournal;
import com.xero.model.ArrayOfManualJournalLine;
import com.xero.model.ArrayOfPayment;
import com.xero.model.ArrayOfPhone;
import com.xero.model.ArrayOfPurchaseOrder;
import com.xero.model.ArrayOfReceipt;
import com.xero.model.ArrayOfTaxComponent;
import com.xero.model.ArrayOfTaxRate;
import com.xero.model.ArrayOfTrackingCategory;
import com.xero.model.ArrayOfTrackingCategoryOption;
import com.xero.model.BankAccount;
import com.xero.model.BankTransaction;
import com.xero.model.BankTransactionStatus;
import com.xero.model.BankTransactionType;
import com.xero.model.BankTransfer;
import com.xero.model.Contact;
import com.xero.model.ContactGroup;
import com.xero.model.CreditNote;
import com.xero.model.CreditNoteType;
import com.xero.model.Currency;
import com.xero.model.CurrencyCode;
import com.xero.model.Employee;
import com.xero.model.ExpenseClaim;
import com.xero.model.Hyperlink;
import com.xero.model.Invoice;
import com.xero.model.InvoiceStatus;
import com.xero.model.InvoiceType;
import com.xero.model.Item;
import com.xero.model.LineAmountType;
import com.xero.model.LineItem;
import com.xero.model.LinkedTransaction;
import com.xero.model.ManualJournal;
import com.xero.model.ManualJournalLine;
import com.xero.model.ManualJournalStatus;
import com.xero.model.Payment;
import com.xero.model.Phone;
import com.xero.model.PurchaseOrder;
import com.xero.model.PurchaseOrderStatus;
import com.xero.model.Receipt;
import com.xero.model.ReceiptStatus;
import com.xero.model.TaxComponent;
import com.xero.model.TaxRate;
import com.xero.model.TrackingCategory;
import com.xero.model.TrackingCategoryOption;
import com.xero.model.User;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Random;

public class SampleData {
    public static XeroClient client = null;

    public SampleData(XeroClient client) {
        SampleData.client = client;
    }

    public static ArrayOfAccount loadAccount() {
        ArrayOfAccount array = new ArrayOfAccount();
        Account account = new Account();
        int ranNum = SampleData.loadRandomNum();
        account.setCode(Integer.toString(ranNum));
        account.setName("My Expense " + Integer.toString(ranNum));
        account.setDescription("Finding Nemo");
        account.setType(AccountType.EXPENSE);
        array.getAccount().add(account);
        return array;
    }

    public static Account loadAccountFixedAsset() throws IOException {
        ArrayOfAccount array = new ArrayOfAccount();
        Account account = new Account();
        int ranNum = SampleData.loadRandomNum();
        account.setCode(Integer.toString(ranNum));
        account.setName("FixedAsset " + Integer.toString(ranNum));
        account.setDescription("New Fixed Asset via SDK");
        account.setType(AccountType.FIXED);
        array.getAccount().add(account);
        List<Account> newAccount = client.createAccounts(array.getAccount());
        return newAccount.get(0);
    }

    public static Account loadAccountExpenses() throws IOException {
        ArrayOfAccount array = new ArrayOfAccount();
        Account account = new Account();
        int ranNum = SampleData.loadRandomNum();
        account.setCode(Integer.toString(ranNum));
        account.setName("Expense " + Integer.toString(ranNum));
        account.setDescription("New Expense via SDK");
        account.setType(AccountType.EXPENSE);
        array.getAccount().add(account);
        List<Account> newAccount = client.createAccounts(array.getAccount());
        return newAccount.get(0);
    }

    public static Account loadAccountDepreciation() throws IOException {
        ArrayOfAccount array = new ArrayOfAccount();
        Account account = new Account();
        int ranNum = SampleData.loadRandomNum();
        account.setCode(Integer.toString(ranNum));
        account.setName("Depreciation " + Integer.toString(ranNum));
        account.setDescription("New Depreciation via SDK");
        account.setType(AccountType.DEPRECIATN);
        array.getAccount().add(account);
        List<Account> newAccount = client.createAccounts(array.getAccount());
        return newAccount.get(0);
    }

    public static ArrayOfBankTransaction loadBankTransaction() throws IOException {
        ArrayOfBankTransaction array = new ArrayOfBankTransaction();
        BankTransaction bt = new BankTransaction();
        bt.setDate(SampleData.loadDate());
        bt.setStatus(BankTransactionStatus.AUTHORISED);
        bt.setType(BankTransactionType.SPEND);
        bt.setUrl("http://mycompany.org/transactions/230498239");
        bt.setLineItems(SampleData.loadLineItem());
        bt.setSubTotal(new BigDecimal(20.0));
        bt.setTotalTax(new BigDecimal(0));
        bt.setTotal(new BigDecimal("20.00"));
        bt.setCurrencyRate(new BigDecimal(1.0));
        bt.setContact((Contact)SampleData.loadContact().getContact().get(0));
        bt.setLineAmountTypes(LineAmountType.INCLUSIVE);
        Account acct = SampleData.loadBankAccount();
        bt.setBankAccount(acct);
        array.getBankTransaction().add(bt);
        return array;
    }

    public static ArrayOfBankTransfer loadBankTransfer() throws IOException {
        ArrayOfBankTransfer array = new ArrayOfBankTransfer();
        BankTransfer bt = new BankTransfer();
        List<Account> accountWhere = client.getAccounts(null, "Type==\"BANK\"", null);
        if (accountWhere.size() > 2) {
            BankAccount fromAccount = new BankAccount();
            fromAccount.setAccountID(accountWhere.get(0).getAccountID());
            BankAccount toAccount = new BankAccount();
            toAccount.setAccountID(accountWhere.get(1).getAccountID());
            bt.setAmount(new BigDecimal(20.0));
            bt.setDate(SampleData.loadDate());
            bt.setFromBankAccount(fromAccount);
            bt.setToBankAccount(toAccount);
            bt.setCurrencyRate(new BigDecimal(1.0));
            array.getBankTransfer().add(bt);
        }
        return array;
    }

    public static ArrayOfContact loadContact() {
        ArrayOfContact array = new ArrayOfContact();
        Contact contact = new Contact();
        contact.setName("Barney Rubble-" + SampleData.loadRandomNum());
        contact.setEmailAddress("barney@bedrock.com");
        contact.setFirstName("B");
        contact.setLastName("Rubble");
        ArrayOfAddress arrayOfAddress = new ArrayOfAddress();
        Address address = new Address();
        address.setAddressLine1("100 Green Street");
        address.setCity("San Francisco");
        address.setPostalCode("94111");
        address.setAddressType(AddressType.STREET);
        arrayOfAddress.getAddress().add(address);
        contact.setAddresses(arrayOfAddress);
        ArrayOfPhone arrayOfPhone = new ArrayOfPhone();
        Phone phone = new Phone();
        phone.setPhoneAreaCode("415");
        phone.setPhoneNumber("5551212");
        arrayOfPhone.getPhone().add(phone);
        contact.setPhones(arrayOfPhone);
        array.getContact().add(contact);
        return array;
    }

    public static ArrayOfContactGroup loadContactGroup() {
        ArrayOfContactGroup array = new ArrayOfContactGroup();
        ContactGroup cg = new ContactGroup();
        cg.setName("Fancy Cats-" + SampleData.loadRandomNum());
        cg.setContacts(SampleData.loadContact());
        array.getContactGroup().add(cg);
        return array;
    }

    public static ArrayOfCreditNote loadCreditNote() throws IOException {
        ArrayOfCreditNote array = new ArrayOfCreditNote();
        CreditNote cn = new CreditNote();
        cn.setType(CreditNoteType.ACCPAYCREDIT);
        cn.setDate(SampleData.loadDate());
        cn.setLineAmountTypes(LineAmountType.INCLUSIVE);
        cn.setLineItems(SampleData.loadLineItem());
        cn.setContact(SampleData.loadSingleContact());
        array.getCreditNote().add(cn);
        return array;
    }

    public static ArrayOfCreditNote loadCreditNote4dp() throws IOException {
        ArrayOfCreditNote array = new ArrayOfCreditNote();
        CreditNote cn = new CreditNote();
        cn.setType(CreditNoteType.ACCPAYCREDIT);
        cn.setDate(SampleData.loadDate());
        cn.setLineAmountTypes(LineAmountType.INCLUSIVE);
        cn.setLineItems(SampleData.loadLineItem4dp());
        cn.setContact(SampleData.loadSingleContact());
        array.getCreditNote().add(cn);
        return array;
    }

    public static ArrayOfCurrency loadCurrency() {
        ArrayOfCurrency array = new ArrayOfCurrency();
        Currency currency = new Currency();
        currency.setCode(CurrencyCode.CAD);
        array.getCurrency().add(currency);
        return array;
    }

    public static ArrayOfEmployee loadEmployee() {
        ArrayOfEmployee array = new ArrayOfEmployee();
        Hyperlink link = new Hyperlink();
        link.setUrl("http://www.sfmoma.org");
        link.setDescription("SF Mueseum of Modern Art");
        Employee e = new Employee();
        e.setFirstName("Jackson");
        e.setLastName("Pollock-" + SampleData.loadRandomNum());
        e.setExternalLink(link);
        array.getEmployee().add(e);
        return array;
    }

    public static ArrayOfExpenseClaim loadExpenseClaim() throws IOException {
        ArrayOfExpenseClaim array = new ArrayOfExpenseClaim();
        ExpenseClaim e = new ExpenseClaim();
        e.setAmountDue(new BigDecimal(10.0));
        List<User> UserWhere = client.getUsers(null, "IsSubscriber==true", null);
        if (UserWhere.size() == 0) {
            UserWhere = client.getUsers();
        }
        e.setUser(UserWhere.get(0));
        List receipt = SampleData.loadReceipt().getReceipt();
        List<Receipt> newReceipt = client.createReceipts(receipt);
        ArrayOfReceipt arrayReceipts = new ArrayOfReceipt();
        arrayReceipts.getReceipt().add(newReceipt.get(0));
        e.setReceipts(arrayReceipts);
        array.getExpenseClaim().add(e);
        return array;
    }

    public static ArrayOfInvoice loadInvoice() throws IOException {
        ArrayOfInvoice array = new ArrayOfInvoice();
        Invoice inv = new Invoice();
        inv.setContact(SampleData.loadSingleContact());
        inv.setCurrencyCode(CurrencyCode.USD);
        inv.setLineItems(SampleData.loadLineItem());
        inv.setDate(SampleData.loadDate());
        inv.setDueDate(SampleData.loadDate());
        inv.setInvoiceNumber(Integer.toString(SampleData.loadRandomNum()));
        inv.setType(InvoiceType.ACCREC);
        inv.setStatus(InvoiceStatus.DRAFT);
        array.getInvoice().add(inv);
        return array;
    }

    public static ArrayOfInvoice loadBadInvoice() throws IOException {
        ArrayOfInvoice array = new ArrayOfInvoice();
        Invoice inv = new Invoice();
        inv.setContact(SampleData.loadSingleContact());
        inv.setCurrencyCode(CurrencyCode.AUD);
        inv.setLineItems(SampleData.loadLineItem());
        inv.setDate(SampleData.loadDate());
        inv.setDueDate(SampleData.loadDate());
        inv.setInvoiceNumber(Integer.toString(SampleData.loadRandomNum()));
        inv.setType(InvoiceType.ACCREC);
        inv.setStatus(InvoiceStatus.DRAFT);
        array.getInvoice().add(inv);
        return array;
    }

    public static ArrayOfInvoice loadBadInvoice2() throws IOException {
        ArrayOfInvoice array = new ArrayOfInvoice();
        Invoice inv = new Invoice();
        inv.setContact(SampleData.loadSingleContact());
        inv.setCurrencyCode(CurrencyCode.NZD);
        inv.setLineItems(SampleData.loadLineItem());
        inv.setDate(SampleData.loadDate());
        inv.setDueDate(SampleData.loadDate());
        inv.setInvoiceNumber(Integer.toString(SampleData.loadRandomNum()));
        inv.setType(InvoiceType.ACCREC);
        inv.setStatus(InvoiceStatus.DRAFT);
        array.getInvoice().add(inv);
        return array;
    }

    public static ArrayOfItem loadItem() {
        ArrayOfItem array = new ArrayOfItem();
        String rand = Integer.toString(SampleData.loadRandomNum());
        Item item = new Item();
        item.setCode(rand);
        item.setDescription("ACME hammer-" + rand);
        item.setName("ACME hammer-" + rand);
        item.setIsSold(Boolean.valueOf(true));
        array.getItem().add(item);
        return array;
    }

    public static ArrayOfLinkedTransaction loadLinkedTransaction() throws IOException {
        ArrayOfLinkedTransaction array = new ArrayOfLinkedTransaction();
        Invoice newBill = SampleData.loadNewBill();
        Invoice newSalesInvoice = SampleData.loadNewSalesInvoice();
        LinkedTransaction lt = new LinkedTransaction();
        lt.setContactID(SampleData.loadSingleContact().getContactID());
        lt.setSourceTransactionID(newBill.getInvoiceID());
        lt.setSourceLineItemID(((LineItem)newBill.getLineItems().getLineItem().get(0)).getLineItemID());
        array.getLinkedTransaction().add(lt);
        return array;
    }

    public static ArrayOfManualJournal loadManualJournal() throws IOException {
        ArrayOfManualJournal array = new ArrayOfManualJournal();
        ArrayOfManualJournalLine arrayOfMJLine = new ArrayOfManualJournalLine();
        List<Account> accountSales = client.getAccounts(null, "Type==\"REVENUE\"", null);
        List<Account> accountDirectCosts = client.getAccounts(null, "Type==\"DIRECTCOSTS\"", null);
        if (accountSales.size() == 0) {
            System.out.println("no revenue accounts");
        }
        if (accountDirectCosts.size() == 0) {
            System.out.println("no direct cost accounts");
        }
        List<TrackingCategory> TrackingCategoryList = client.getTrackingCategories();
        ArrayOfTrackingCategory arrayTracking = new ArrayOfTrackingCategory();
        if (TrackingCategoryList.size() > 0) {
            ArrayOfTrackingCategoryOption options1 = TrackingCategoryList.get(0).getOptions();
            List optionList1 = options1.getOption();
            TrackingCategory category1 = new TrackingCategory();
            category1.setName(TrackingCategoryList.get(0).getName());
            category1.setOption(((TrackingCategoryOption)optionList1.get(0)).getName());
            arrayTracking.getTrackingCategory().add(category1);
        }
        if (TrackingCategoryList.size() > 1) {
            ArrayOfTrackingCategoryOption options2 = TrackingCategoryList.get(1).getOptions();
            List optionList2 = options2.getOption();
            TrackingCategory category2 = new TrackingCategory();
            category2.setName(TrackingCategoryList.get(1).getName());
            category2.setOption(((TrackingCategoryOption)optionList2.get(1)).getName());
            arrayTracking.getTrackingCategory().add(category2);
        }
        ManualJournalLine debit = new ManualJournalLine();
        debit.setDescription("My MJ Debit");
        debit.setAccountCode("400");
        debit.setLineAmount(new BigDecimal(10.0));
        debit.setTracking(arrayTracking);
        arrayOfMJLine.getJournalLine().add(debit);
        ManualJournalLine credit = new ManualJournalLine();
        credit.setDescription("My MJ Credit");
        credit.setAccountCode("500");
        credit.setLineAmount(new BigDecimal(-10.0));
        credit.setTracking(arrayTracking);
        arrayOfMJLine.getJournalLine().add(credit);
        ManualJournal mj = new ManualJournal();
        mj.setJournalLines(arrayOfMJLine);
        mj.setDate(SampleData.loadDate());
        mj.setNarration("My Fake Journal");
        mj.setStatus(ManualJournalStatus.DRAFT);
        array.getManualJournal().add(mj);
        return array;
    }

    public static ArrayOfAllocation loadAllocation() throws IOException {
        ArrayOfAllocation array = new ArrayOfAllocation();
        Allocation allocation = new Allocation();
        allocation.setDate(SampleData.loadDate());
        allocation.setAppliedAmount(new BigDecimal("1.00"));
        Invoice inv = SampleData.loadNewSalesInvoice();
        allocation.setInvoice(inv);
        array.getAllocation().add(allocation);
        return array;
    }

    public static ArrayOfAllocation loadCreditNoteAllocation() throws IOException {
        ArrayOfAllocation array = new ArrayOfAllocation();
        Allocation allocation = new Allocation();
        allocation.setDate(SampleData.loadDate());
        allocation.setAppliedAmount(new BigDecimal("1.00"));
        Invoice inv = SampleData.loadNewBill();
        Invoice useInv = new Invoice();
        useInv.setInvoiceID(inv.getInvoiceID());
        allocation.setInvoice(useInv);
        array.getAllocation().add(allocation);
        return array;
    }

    public static BankTransaction loadNewlyCreatedOverpayment() throws IOException {
        ArrayOfBankTransaction array = new ArrayOfBankTransaction();
        BankTransaction bt = new BankTransaction();
        bt.setDate(SampleData.loadDate());
        bt.setStatus(BankTransactionStatus.AUTHORISED);
        bt.setType(BankTransactionType.RECEIVE_OVERPAYMENT);
        bt.setUrl("http://mycompany.org/transactions/230498239");
        bt.setLineItems(SampleData.loadLineItemForOverpayment());
        bt.setSubTotal(new BigDecimal(20.0));
        bt.setTotalTax(new BigDecimal(0));
        bt.setTotal(new BigDecimal("20.00"));
        bt.setCurrencyRate(new BigDecimal(1.0));
        bt.setContact((Contact)SampleData.loadContact().getContact().get(0));
        bt.setLineAmountTypes(LineAmountType.NO_TAX);
        Account acct = SampleData.loadBankAccount();
        bt.setBankAccount(acct);
        array.getBankTransaction().add(bt);
        List<BankTransaction> newBankTransaction = client.createBankTransactions(array.getBankTransaction());
        return newBankTransaction.get(0);
    }

    public static ArrayOfPayment loadPayment() throws IOException {
        ArrayOfPayment array = new ArrayOfPayment();
        Payment pay = new Payment();
        pay.setDate(SampleData.loadDate());
        Account acct = SampleData.loadBankAccount();
        pay.setAccount(acct);
        pay.setAmount(new BigDecimal(".99"));
        Invoice inv = SampleData.loadNewSalesInvoice();
        pay.setInvoice(inv);
        array.getPayment().add(pay);
        return array;
    }

    public static BankTransaction loadNewlyCreatedPrepayment() throws IOException {
        ArrayOfBankTransaction array = new ArrayOfBankTransaction();
        BankTransaction bt = new BankTransaction();
        bt.setDate(SampleData.loadDate());
        bt.setStatus(BankTransactionStatus.AUTHORISED);
        bt.setType(BankTransactionType.RECEIVE_PREPAYMENT);
        bt.setUrl("http://mycompany.org/transactions/230498239");
        bt.setLineItems(SampleData.loadLineItemForPrepayment());
        bt.setSubTotal(new BigDecimal(20.0));
        bt.setTotalTax(new BigDecimal(0));
        bt.setTotal(new BigDecimal("20.00"));
        bt.setCurrencyRate(new BigDecimal(1.0));
        bt.setContact((Contact)SampleData.loadContact().getContact().get(0));
        bt.setLineAmountTypes(LineAmountType.NO_TAX);
        Account acct = SampleData.loadBankAccount();
        bt.setBankAccount(acct);
        array.getBankTransaction().add(bt);
        List<BankTransaction> newBankTransaction = client.createBankTransactions(array.getBankTransaction());
        return newBankTransaction.get(0);
    }

    public static ArrayOfPurchaseOrder loadPurchaseOrder() throws IOException {
        ArrayOfPurchaseOrder array = new ArrayOfPurchaseOrder();
        PurchaseOrder po = new PurchaseOrder();
        po.setDate(SampleData.loadDate());
        po.setAttentionTo("Sid Maestre");
        po.setContact(SampleData.loadSingleContact());
        po.setDate(SampleData.loadDate());
        po.setStatus(PurchaseOrderStatus.DRAFT);
        po.setReference("What is the Matrix?");
        po.setLineItems(SampleData.loadLineItem());
        po.setPurchaseOrderNumber("XRO-" + SampleData.loadRandomNum());
        array.getPurchaseOrder().add(po);
        return array;
    }

    public static ArrayOfReceipt loadReceipt() throws IOException {
        ArrayOfReceipt array = new ArrayOfReceipt();
        Receipt r = new Receipt();
        r.setContact(SampleData.loadSingleContact());
        List<User> UserWhere = client.getUsers(null, "IsSubscriber==true", null);
        if (UserWhere.size() == 0) {
            UserWhere = client.getUsers();
        }
        r.setUser(UserWhere.get(0));
        r.setLineItems(SampleData.loadExpenseClaimLineItem());
        r.setDate(SampleData.loadDate());
        r.setReference("Does Barry Manilow know you raid his wardrobe?");
        r.setStatus(ReceiptStatus.DRAFT);
        r.setLineAmountTypes(LineAmountType.INCLUSIVE);
        array.getReceipt().add(r);
        return array;
    }

    public static ArrayOfTaxRate loadTaxRate() {
        ArrayOfTaxRate array = new ArrayOfTaxRate();
        ArrayOfTaxComponent arrayOfTaxComponent = new ArrayOfTaxComponent();
        TaxComponent taxComponent = new TaxComponent();
        taxComponent.setName("Little One-" + SampleData.loadRandomNum());
        taxComponent.setRate("2");
        taxComponent.setIsCompound(false);
        arrayOfTaxComponent.getTaxComponent().add(taxComponent);
        TaxComponent taxComponent2 = new TaxComponent();
        taxComponent2.setName("Big One-" + SampleData.loadRandomNum());
        taxComponent2.setRate("5");
        taxComponent2.setIsCompound(true);
        arrayOfTaxComponent.getTaxComponent().add(taxComponent2);
        TaxRate taxrate = new TaxRate();
        taxrate.setTaxComponents(arrayOfTaxComponent);
        taxrate.setName("CA Big fat tax-" + SampleData.loadRandomNum());
        array.getTaxRate().add(taxrate);
        return array;
    }

    public static ArrayOfTrackingCategory loadTrackingCategory() {
        ArrayOfTrackingCategory array = new ArrayOfTrackingCategory();
        TrackingCategory tc = new TrackingCategory();
        tc.setName("Star Wars-" + SampleData.loadRandomNum());
        array.getTrackingCategory().add(tc);
        return array;
    }

    public static ArrayOfTrackingCategoryOption loadTrackingCategoryOption() {
        ArrayOfTrackingCategoryOption array = new ArrayOfTrackingCategoryOption();
        TrackingCategoryOption tc = new TrackingCategoryOption();
        tc.setName("The Empire Strikes Back-" + SampleData.loadRandomNum());
        array.getOption().add(tc);
        return array;
    }

    public static ArrayOfTrackingCategoryOption loadTrackingCategoryOptionMulti() {
        ArrayOfTrackingCategoryOption array = new ArrayOfTrackingCategoryOption();
        TrackingCategoryOption tc = new TrackingCategoryOption();
        tc.setName("The Empire Strikes Back-" + SampleData.loadRandomNum());
        TrackingCategoryOption tc2 = new TrackingCategoryOption();
        tc2.setName("Return of the Jedi");
        TrackingCategoryOption tc3 = new TrackingCategoryOption();
        tc3.setName("Return of the Jedi");
        array.getOption().add(tc);
        array.getOption().add(tc2);
        array.getOption().add(tc3);
        return array;
    }

    public static int findRandomNum(int total) {
        Random randomGenerator = new Random();
        int randomInt = randomGenerator.nextInt(total);
        return randomInt;
    }

    private static Calendar loadDate() {
        GregorianCalendar calendar = new GregorianCalendar(2016, 9, 19, 13, 10, 0);
        return calendar;
    }

    public static Contact loadSingleContact() throws IOException {
        List<Contact> contacts = client.getContacts();
        return contacts.get(0);
    }

    private static Receipt loadSingleReceipt() throws IOException {
        List<Receipt> r = client.getReceipts();
        return r.get(0);
    }

    private static User loadSingleUser() throws IOException {
        List<User> users = client.getUsers();
        return users.get(0);
    }

    public static int loadRandomNum() {
        Random randomGenerator = new Random();
        int randomInt = randomGenerator.nextInt(100000);
        return randomInt;
    }

    public static Account loadBankAccount() throws IOException {
        List<Account> accountWhere = client.getAccounts(null, "Type==\"BANK\"", null);
        return accountWhere.get(0);
    }

    private static Invoice loadNewBill() throws IOException {
        ArrayOfInvoice array = new ArrayOfInvoice();
        Invoice inv = new Invoice();
        Contact contact = SampleData.loadSingleContact();
        Contact useContact = new Contact();
        useContact.setContactID(contact.getContactID());
        inv.setContact(useContact);
        inv.setLineItems(SampleData.loadLineItem());
        inv.setDate(SampleData.loadDate());
        inv.setDueDate(SampleData.loadDate());
        inv.setInvoiceNumber(Integer.toString(SampleData.loadRandomNum()));
        inv.setType(InvoiceType.ACCPAY);
        inv.setStatus(InvoiceStatus.AUTHORISED);
        array.getInvoice().add(inv);
        List<Invoice> newInvoice = client.createInvoices(array.getInvoice());
        return newInvoice.get(0);
    }

    private static Invoice loadNewSalesInvoice() throws IOException {
        ArrayOfInvoice array = new ArrayOfInvoice();
        Invoice inv = new Invoice();
        inv.setContact(SampleData.loadSingleContact());
        inv.setCurrencyCode(CurrencyCode.USD);
        inv.setLineItems(SampleData.loadEmptyLineItem());
        inv.setDate(SampleData.loadDate());
        inv.setDueDate(SampleData.loadDate());
        inv.setType(InvoiceType.ACCREC);
        inv.setStatus(InvoiceStatus.AUTHORISED);
        array.getInvoice().add(inv);
        List<Invoice> newInvoice = client.createInvoices(array.getInvoice());
        return newInvoice.get(0);
    }

    private static ArrayOfLineItem loadLineItem() throws IOException {
        List<Account> accountDirectCosts = client.getAccounts(null, "Type==\"DIRECTCOSTS\"", null);
        ArrayOfLineItem array = new ArrayOfLineItem();
        LineItem line = new LineItem();
        line.setDescription("Yearly Bank Account Fee");
        line.setQuantity(new BigDecimal("1.00"));
        line.setUnitAmount(new BigDecimal("20.00"));
        line.setLineAmount(new BigDecimal("20.00"));
        line.setAccountCode(accountDirectCosts.get(0).getCode());
        List<TrackingCategory> TrackingCategoryList = client.getTrackingCategories();
        if (TrackingCategoryList.size() > 0) {
            int num10 = SampleData.findRandomNum(TrackingCategoryList.size());
            ArrayOfTrackingCategory trackingCategories = new ArrayOfTrackingCategory();
            TrackingCategory trackingCategory = new TrackingCategory();
            trackingCategory.setTrackingCategoryID(TrackingCategoryList.get(num10).getTrackingCategoryID());
            trackingCategory.setName(TrackingCategoryList.get(num10).getName());
            trackingCategory.setOption(((TrackingCategoryOption)TrackingCategoryList.get(num10).getOptions().getOption().get(0)).getName());
            trackingCategories.getTrackingCategory().add(trackingCategory);
            line.setTracking(trackingCategories);
        }
        array.getLineItem().add(line);
        return array;
    }

    private static ArrayOfLineItem loadLineItem4dp() throws IOException {
        List<Account> accountDirectCosts = client.getAccounts(null, "Type==\"DIRECTCOSTS\"", null);
        ArrayOfLineItem array = new ArrayOfLineItem();
        LineItem line = new LineItem();
        line.setDescription("Yearly Bank Account Fee");
        line.setQuantity(new BigDecimal("1.00"));
        line.setUnitAmount(new BigDecimal("20.0344"));
        line.setLineAmount(new BigDecimal("20.0344"));
        line.setAccountCode(accountDirectCosts.get(0).getCode());
        List<TrackingCategory> TrackingCategoryList = client.getTrackingCategories();
        if (TrackingCategoryList.size() > 0) {
            int num10 = SampleData.findRandomNum(TrackingCategoryList.size());
            ArrayOfTrackingCategory trackingCategories = new ArrayOfTrackingCategory();
            TrackingCategory trackingCategory = new TrackingCategory();
            trackingCategory.setTrackingCategoryID(TrackingCategoryList.get(num10).getTrackingCategoryID());
            trackingCategory.setName(TrackingCategoryList.get(num10).getName());
            trackingCategory.setOption(((TrackingCategoryOption)TrackingCategoryList.get(num10).getOptions().getOption().get(0)).getName());
            trackingCategories.getTrackingCategory().add(trackingCategory);
            line.setTracking(trackingCategories);
        }
        array.getLineItem().add(line);
        return array;
    }

    private static ArrayOfLineItem loadLineItemForOverpayment() throws IOException {
        List<Account> accountDebtors = client.getAccounts(null, "SystemAccount==\"DEBTORS\"", null);
        ArrayOfLineItem array = new ArrayOfLineItem();
        LineItem line = new LineItem();
        line.setDescription("My Overpayment for Subscription");
        line.setQuantity(new BigDecimal("1.00"));
        line.setUnitAmount(new BigDecimal("20.00"));
        line.setLineAmount(new BigDecimal("20.00"));
        line.setAccountCode(accountDebtors.get(0).getCode());
        array.getLineItem().add(line);
        return array;
    }

    private static ArrayOfLineItem loadLineItemForPrepayment() {
        ArrayOfLineItem array = new ArrayOfLineItem();
        LineItem line = new LineItem();
        line.setDescription("My Prepayment for legal services");
        line.setQuantity(new BigDecimal("1.00"));
        line.setUnitAmount(new BigDecimal("20.00"));
        line.setLineAmount(new BigDecimal("20.00"));
        line.setAccountCode("400");
        array.getLineItem().add(line);
        return array;
    }

    private static ArrayOfLineItem loadEmptyLineItem() throws IOException {
        List<Account> accountSales = client.getAccounts(null, "Type==\"REVENUE\"", null);
        ArrayOfLineItem array = new ArrayOfLineItem();
        LineItem line = new LineItem();
        line.setDescription("Yearly Bank Account Fee");
        line.setQuantity(new BigDecimal("1.00"));
        line.setUnitAmount(new BigDecimal("30.00"));
        line.setLineAmount(new BigDecimal("30.00"));
        line.setAccountCode(accountSales.get(0).getCode());
        array.getLineItem().add(line);
        return array;
    }

    private static ArrayOfLineItem loadExpenseLineItem() throws IOException {
        List<Account> accountExpense = client.getAccounts(null, "Type==\"EXPENSE\"", null);
        ArrayOfLineItem array = new ArrayOfLineItem();
        LineItem line = new LineItem();
        line.setDescription("Coffee and Bagel");
        line.setQuantity(new BigDecimal("1.00"));
        line.setUnitAmount(new BigDecimal("7.50"));
        line.setLineAmount(new BigDecimal("7.50"));
        line.setAccountCode(accountExpense.get(0).getCode());
        array.getLineItem().add(line);
        return array;
    }

    private static ArrayOfLineItem loadExpenseClaimLineItem() throws IOException {
        List<Account> accountExpense = client.getAccounts(null, "Type==\"EXPENSE\" and ShowInExpenseClaims==TRUE", null);
        ArrayOfLineItem array = new ArrayOfLineItem();
        LineItem line = new LineItem();
        line.setDescription("Coffee and Bagel");
        line.setQuantity(new BigDecimal("1.00"));
        line.setUnitAmount(new BigDecimal("7.50"));
        line.setLineAmount(new BigDecimal("7.50"));
        line.setAccountCode(accountExpense.get(0).getCode());
        array.getLineItem().add(line);
        return array;
    }
}

