/*
 * Decompiled with CFR 0.152.
 */
package com.xero.example;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TokenStorage {
    public String get(HttpServletRequest request, String key) {
        String item = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals(key)) continue;
                item = cookies[i].getValue();
            }
        }
        return item;
    }

    public boolean tokenIsNull(String token) {
        return token == null || token.isEmpty();
    }

    public void clear(HttpServletResponse response) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tempToken", "");
        map.put("tempTokenSecret", "");
        map.put("sessionHandle", "");
        map.put("tokenTimestamp", "");
        this.save(response, map);
    }

    public void save(HttpServletResponse response, HashMap<String, String> map) {
        Set<Map.Entry<String, String>> set = map.entrySet();
        for (Map.Entry<String, String> mentry : set) {
            String key = mentry.getKey();
            String value = mentry.getValue();
            Cookie t = new Cookie(key, value);
            response.addCookie(t);
        }
    }
}

