/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.xero.api.CustomOffsetDateTimeDeserializer;
import com.xero.models.accounting.AccountType;
import com.xero.models.accounting.CurrencyCode;
import com.xero.models.accounting.TaxType;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.OffsetDateTime;

public class Account {
    @JsonProperty(value="Code")
    private String code;
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="AccountID")
    private UUID accountID;
    @JsonProperty(value="Type")
    private AccountType type = null;
    @JsonProperty(value="BankAccountNumber")
    private String bankAccountNumber;
    @JsonProperty(value="Status")
    private StatusEnum status;
    @JsonProperty(value="Description")
    private String description;
    @JsonProperty(value="BankAccountType")
    private BankAccountTypeEnum bankAccountType;
    @JsonProperty(value="CurrencyCode")
    private CurrencyCode currencyCode = null;
    @JsonProperty(value="TaxType")
    private TaxType taxType = null;
    @JsonProperty(value="EnablePaymentsToAccount")
    private Boolean enablePaymentsToAccount;
    @JsonProperty(value="ShowInExpenseClaims")
    private Boolean showInExpenseClaims;
    @JsonProperty(value="Class")
    private PropertyClassEnum propertyClass;
    @JsonProperty(value="SystemAccount")
    private SystemAccountEnum systemAccount;
    @JsonProperty(value="ReportingCode")
    private String reportingCode;
    @JsonProperty(value="ReportingCodeName")
    private String reportingCodeName;
    @JsonProperty(value="HasAttachments")
    private Boolean hasAttachments;
    @JsonDeserialize(using=CustomOffsetDateTimeDeserializer.class)
    @JsonProperty(value="UpdatedDateUTC")
    private OffsetDateTime updatedDateUTC;

    public Account code(String code) {
        this.code = code;
        return this;
    }

    @ApiModelProperty(example="4400", value="Customer defined alpha numeric account code e.g 200 or SALES (max length = 10)")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Account name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Food Sales", value="Name of account (max length = 150)")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Account accountID(UUID accountID) {
        this.accountID = accountID;
        return this;
    }

    @ApiModelProperty(value="The Xero identifier for an account \u2013 specified as a string following  the endpoint name   e.g. /297c2dc5-cc47-4afd-8ec8-74990b8761e9")
    public UUID getAccountID() {
        return this.accountID;
    }

    public void setAccountID(UUID accountID) {
        this.accountID = accountID;
    }

    public Account type(AccountType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="")
    public AccountType getType() {
        return this.type;
    }

    public void setType(AccountType type) {
        this.type = type;
    }

    public Account bankAccountNumber(String bankAccountNumber) {
        this.bankAccountNumber = bankAccountNumber;
        return this;
    }

    @ApiModelProperty(value="For bank accounts only (Account Type BANK)")
    public String getBankAccountNumber() {
        return this.bankAccountNumber;
    }

    public void setBankAccountNumber(String bankAccountNumber) {
        this.bankAccountNumber = bankAccountNumber;
    }

    public Account status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="Accounts with a status of ACTIVE can be updated to ARCHIVED. See Account Status Codes")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Account description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description of the Account. Valid for all types of accounts except bank accounts (max length = 4000)")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Account bankAccountType(BankAccountTypeEnum bankAccountType) {
        this.bankAccountType = bankAccountType;
        return this;
    }

    @ApiModelProperty(value="For bank accounts only. See Bank Account types")
    public BankAccountTypeEnum getBankAccountType() {
        return this.bankAccountType;
    }

    public void setBankAccountType(BankAccountTypeEnum bankAccountType) {
        this.bankAccountType = bankAccountType;
    }

    public Account currencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @ApiModelProperty(value="")
    public CurrencyCode getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
    }

    public Account taxType(TaxType taxType) {
        this.taxType = taxType;
        return this;
    }

    @ApiModelProperty(value="")
    public TaxType getTaxType() {
        return this.taxType;
    }

    public void setTaxType(TaxType taxType) {
        this.taxType = taxType;
    }

    public Account enablePaymentsToAccount(Boolean enablePaymentsToAccount) {
        this.enablePaymentsToAccount = enablePaymentsToAccount;
        return this;
    }

    @ApiModelProperty(value="Boolean \u2013 describes whether account can have payments applied to it")
    public Boolean getEnablePaymentsToAccount() {
        return this.enablePaymentsToAccount;
    }

    public void setEnablePaymentsToAccount(Boolean enablePaymentsToAccount) {
        this.enablePaymentsToAccount = enablePaymentsToAccount;
    }

    public Account showInExpenseClaims(Boolean showInExpenseClaims) {
        this.showInExpenseClaims = showInExpenseClaims;
        return this;
    }

    @ApiModelProperty(value="Boolean \u2013 describes whether account code is available for use with expense claims")
    public Boolean getShowInExpenseClaims() {
        return this.showInExpenseClaims;
    }

    public void setShowInExpenseClaims(Boolean showInExpenseClaims) {
        this.showInExpenseClaims = showInExpenseClaims;
    }

    @ApiModelProperty(value="See Account Class Types")
    public PropertyClassEnum getPropertyClass() {
        return this.propertyClass;
    }

    @ApiModelProperty(value="If this is a system account then this element is returned. See System Account types. Note that non-system accounts may have this element set as either \u201c\u201d or null.")
    public SystemAccountEnum getSystemAccount() {
        return this.systemAccount;
    }

    @ApiModelProperty(value="Shown if set")
    public String getReportingCode() {
        return this.reportingCode;
    }

    @ApiModelProperty(value="Shown if set")
    public String getReportingCodeName() {
        return this.reportingCodeName;
    }

    @ApiModelProperty(value="boolean to indicate if an account has an attachment (read only)")
    public Boolean getHasAttachments() {
        return this.hasAttachments;
    }

    @ApiModelProperty(value="Last modified date UTC format")
    public OffsetDateTime getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Account account = (Account)o;
        return Objects.equals(this.code, account.code) && Objects.equals(this.name, account.name) && Objects.equals(this.accountID, account.accountID) && Objects.equals((Object)this.type, (Object)account.type) && Objects.equals(this.bankAccountNumber, account.bankAccountNumber) && Objects.equals((Object)this.status, (Object)account.status) && Objects.equals(this.description, account.description) && Objects.equals((Object)this.bankAccountType, (Object)account.bankAccountType) && Objects.equals((Object)this.currencyCode, (Object)account.currencyCode) && Objects.equals((Object)this.taxType, (Object)account.taxType) && Objects.equals(this.enablePaymentsToAccount, account.enablePaymentsToAccount) && Objects.equals(this.showInExpenseClaims, account.showInExpenseClaims) && Objects.equals((Object)this.propertyClass, (Object)account.propertyClass) && Objects.equals((Object)this.systemAccount, (Object)account.systemAccount) && Objects.equals(this.reportingCode, account.reportingCode) && Objects.equals(this.reportingCodeName, account.reportingCodeName) && Objects.equals(this.hasAttachments, account.hasAttachments) && Objects.equals(this.updatedDateUTC, account.updatedDateUTC);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.code, this.name, this.accountID, this.type, this.bankAccountNumber, this.status, this.description, this.bankAccountType, this.currencyCode, this.taxType, this.enablePaymentsToAccount, this.showInExpenseClaims, this.propertyClass, this.systemAccount, this.reportingCode, this.reportingCodeName, this.hasAttachments, this.updatedDateUTC});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Account {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    accountID: ").append(this.toIndentedString(this.accountID)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    bankAccountNumber: ").append(this.toIndentedString(this.bankAccountNumber)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    bankAccountType: ").append(this.toIndentedString((Object)this.bankAccountType)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString((Object)this.currencyCode)).append("\n");
        sb.append("    taxType: ").append(this.toIndentedString((Object)this.taxType)).append("\n");
        sb.append("    enablePaymentsToAccount: ").append(this.toIndentedString(this.enablePaymentsToAccount)).append("\n");
        sb.append("    showInExpenseClaims: ").append(this.toIndentedString(this.showInExpenseClaims)).append("\n");
        sb.append("    propertyClass: ").append(this.toIndentedString((Object)this.propertyClass)).append("\n");
        sb.append("    systemAccount: ").append(this.toIndentedString((Object)this.systemAccount)).append("\n");
        sb.append("    reportingCode: ").append(this.toIndentedString(this.reportingCode)).append("\n");
        sb.append("    reportingCodeName: ").append(this.toIndentedString(this.reportingCodeName)).append("\n");
        sb.append("    hasAttachments: ").append(this.toIndentedString(this.hasAttachments)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SystemAccountEnum {
        DEBTORS("DEBTORS"),
        CREDITORS("CREDITORS"),
        BANKCURRENCYGAIN("BANKCURRENCYGAIN"),
        GST("GST"),
        GSTONIMPORTS("GSTONIMPORTS"),
        HISTORICAL("HISTORICAL"),
        REALISEDCURRENCYGAIN("REALISEDCURRENCYGAIN"),
        RETAINEDEARNINGS("RETAINEDEARNINGS"),
        ROUNDING("ROUNDING"),
        TRACKINGTRANSFERS("TRACKINGTRANSFERS"),
        UNPAIDEXPCLM("UNPAIDEXPCLM"),
        UNREALISEDCURRENCYGAIN("UNREALISEDCURRENCYGAIN"),
        WAGEPAYABLES("WAGEPAYABLES"),
        EMPTY("");

        private String value;

        private SystemAccountEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SystemAccountEnum fromValue(String text) {
            for (SystemAccountEnum b : SystemAccountEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + text + "'");
        }
    }

    public static enum PropertyClassEnum {
        ASSET("ASSET"),
        EQUITY("EQUITY"),
        EXPENSE("EXPENSE"),
        LIABILITY("LIABILITY"),
        REVENUE("REVENUE");

        private String value;

        private PropertyClassEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PropertyClassEnum fromValue(String text) {
            for (PropertyClassEnum b : PropertyClassEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + text + "'");
        }
    }

    public static enum BankAccountTypeEnum {
        BANK("BANK"),
        CREDITCARD("CREDITCARD"),
        PAYPAL("PAYPAL"),
        EMPTY("");

        private String value;

        private BankAccountTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static BankAccountTypeEnum fromValue(String text) {
            for (BankAccountTypeEnum b : BankAccountTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + text + "'");
        }
    }

    public static enum StatusEnum {
        ACTIVE("ACTIVE"),
        ARCHIVED("ARCHIVED"),
        DELETED("DELETED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + text + "'");
        }
    }
}

