/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.xero.api.CustomDateDeserializer;
import com.xero.models.accounting.Invoice;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.threeten.bp.LocalDate;

public class Allocation {
    @JsonProperty(value="Invoice")
    private Invoice invoice = null;
    @JsonProperty(value="Amount")
    private Float amount;
    @JsonDeserialize(using=CustomDateDeserializer.class)
    @JsonProperty(value="Date")
    private LocalDate date;

    public Allocation invoice(Invoice invoice) {
        this.invoice = invoice;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Invoice getInvoice() {
        return this.invoice;
    }

    public void setInvoice(Invoice invoice) {
        this.invoice = invoice;
    }

    public Allocation amount(Float amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="the amount being applied to the invoice")
    public Float getAmount() {
        return this.amount;
    }

    public void setAmount(Float amount) {
        this.amount = amount;
    }

    public Allocation date(LocalDate date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(required=true, value="the date the allocation is applied YYYY-MM-DD.")
    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Allocation allocation = (Allocation)o;
        return Objects.equals(this.invoice, allocation.invoice) && Objects.equals(this.amount, allocation.amount) && Objects.equals(this.date, allocation.date);
    }

    public int hashCode() {
        return Objects.hash(this.invoice, this.amount, this.date);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Allocation {\n");
        sb.append("    invoice: ").append(this.toIndentedString(this.invoice)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

